/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.StructuredConfigKey;
import org.apache.brooklyn.core.config.internal.AbstractCollectionConfigKey;
import org.apache.brooklyn.util.collections.MutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetConfigKey<V>
extends AbstractCollectionConfigKey<Set<V>, Set<Object>, V> {
    private static final long serialVersionUID = 751024268729803210L;
    private static final Logger log = LoggerFactory.getLogger(SetConfigKey.class);

    public SetConfigKey(Builder<V> builder) {
        super(builder, builder.subType);
    }

    public SetConfigKey(Class<V> subType, String name) {
        this(subType, name, name, null);
    }

    public SetConfigKey(Class<V> subType, String name, String description) {
        this(subType, name, description, null);
    }

    public SetConfigKey(Class<V> subType, String name, String description, Set<? extends V> defaultValue) {
        super(Set.class, subType, name, description, defaultValue);
    }

    @Override
    public String toString() {
        return String.format("%s[SetConfigKey:%s]", this.name, this.getTypeName());
    }

    @Override
    protected Set<Object> merge(boolean unmodifiable, Iterable<?> ... sets) {
        MutableSet result = MutableSet.of();
        for (Iterable<?> set : sets) {
            result.addAll(set);
        }
        if (unmodifiable) {
            return result.asUnmodifiable();
        }
        return result;
    }

    public static class SetModificationBase<T>
    extends LinkedHashSet<T>
    implements SetModification<T> {
        private static final long serialVersionUID = 2715025591272457705L;
        private final boolean clearFirst;

        public SetModificationBase(Collection<T> delegate, boolean clearFirst) {
            super(delegate);
            this.clearFirst = clearFirst;
        }

        @Override
        public Object applyToKeyInMap(SetConfigKey<T> key, Map target) {
            if (this.clearFirst) {
                SetConfigKey<T> clearing = StructuredConfigKey.StructuredModifications.clearing();
                clearing.applyToKeyInMap(key, target);
            }
            for (Object o : this) {
                target.put(key.subKey(), o);
            }
            return null;
        }
    }

    public static class SetModifications
    extends StructuredConfigKey.StructuredModifications {
        public static final <T> SetModification<T> add(T o1, T o2, T ... oo) {
            LinkedHashSet<T> l = new LinkedHashSet<T>();
            l.add(o1);
            l.add(o2);
            for (T o : oo) {
                l.add(o);
            }
            return new SetModificationBase(l, false);
        }

        public static final <T> SetModification<T> addAll(Collection<T> items) {
            return new SetModificationBase<T>(items, false);
        }

        public static final <T> SetModification<T> addItem(T item) {
            return new SetModificationBase<T>(Collections.singleton(item), false);
        }

        public static final <T> SetModification<T> set(Collection<T> items) {
            return new SetModificationBase<T>(items, true);
        }
    }

    public static interface SetModification<T>
    extends StructuredConfigKey.StructuredModification<SetConfigKey<T>>,
    Set<T> {
    }

    public static class Builder<V>
    extends BasicConfigKey.Builder<Set<V>, Builder<V>> {
        protected Class<V> subType;

        public Builder(TypeToken<V> subType, String name) {
            super(new TypeToken<Set<V>>(){}, name);
            this.subType = subType.getRawType();
        }

        public Builder(Class<V> subType, String name) {
            super(new TypeToken<Set<V>>(){}, name);
            this.subType = (Class)Preconditions.checkNotNull(subType, (Object)"subType");
        }

        public Builder(SetConfigKey<V> key) {
            this(key.getName(), key);
        }

        public Builder(String newName, SetConfigKey<V> key) {
            super(newName, key);
            this.subType = ((SetConfigKey)key).subType;
        }

        @Override
        public Builder<V> self() {
            return this;
        }

        @Override
        @Deprecated
        public Builder<V> name(String val) {
            throw new UnsupportedOperationException("Builder must be constructed with name");
        }

        @Override
        @Deprecated
        public Builder<V> type(Class<Set<V>> val) {
            throw new UnsupportedOperationException("Builder must be constructed with type");
        }

        @Override
        @Deprecated
        public Builder<V> type(TypeToken<Set<V>> val) {
            throw new UnsupportedOperationException("Builder must be constructed with type");
        }

        @Override
        public SetConfigKey<V> build() {
            return new SetConfigKey(this);
        }
    }
}

