/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.catalog.CatalogPredicates;
import org.apache.brooklyn.core.catalog.internal.CatalogBundleDto;
import org.apache.brooklyn.core.catalog.internal.CatalogClasspathDo;
import org.apache.brooklyn.core.catalog.internal.CatalogDo;
import org.apache.brooklyn.core.catalog.internal.CatalogDto;
import org.apache.brooklyn.core.catalog.internal.CatalogItemBuilder;
import org.apache.brooklyn.core.catalog.internal.CatalogItemComparator;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDo;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDtoAbstract;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.CampYamlParser;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.plan.PlanToSpecFactory;
import org.apache.brooklyn.core.plan.PlanToSpecTransformer;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.core.typereg.BasicRegisteredType;
import org.apache.brooklyn.core.typereg.BasicTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.osgi.BundleMaker;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.AggregateClassLoader;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.LoadedClassLoader;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.brooklyn.util.yaml.Yamls;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class BasicBrooklynCatalog
implements BrooklynCatalog {
    public static final String POLICIES_KEY = "brooklyn.policies";
    public static final String ENRICHERS_KEY = "brooklyn.enrichers";
    public static final String LOCATIONS_KEY = "brooklyn.locations";
    public static final String NO_VERSION = "0.0.0-SNAPSHOT";
    public static final String CATALOG_BOM = "catalog.bom";
    public static final String OSGI_MANIFEST_VERSION_VALUE = "1.0";
    public static final String BROOKLYN_WRAPPED_BOM_BUNDLE = "Brooklyn-Wrapped-BOM";
    @VisibleForTesting
    public static final boolean AUTO_WRAP_CATALOG_YAML_AS_BUNDLE = true;
    private static final Logger log = LoggerFactory.getLogger(BasicBrooklynCatalog.class);
    private final ManagementContext mgmt;
    private CatalogDo catalog;
    private volatile CatalogDo manualAdditionsCatalog;
    private volatile LoadedClassLoader manualAdditionsClasses;
    private final AggregateClassLoader rootClassLoader = AggregateClassLoader.newInstanceWithNoLoaders();
    private final SpecCache specCache;
    private static ThreadLocal<Boolean> deletingCatalogItem = new ThreadLocal();
    private Object uninstallingEmptyLock = new Object();

    public BasicBrooklynCatalog(ManagementContext mgmt) {
        this(mgmt, CatalogDto.newNamedInstance("empty catalog", "empty catalog", "empty catalog, expected to be reset later"));
    }

    public BasicBrooklynCatalog(ManagementContext mgmt, CatalogDto dto) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"managementContext");
        this.catalog = new CatalogDo(mgmt, dto);
        this.specCache = new SpecCache();
    }

    public boolean blockIfNotLoaded(Duration timeout) {
        try {
            return this.getCatalog().blockIfNotLoaded(timeout);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void reset(CatalogDto dto) {
        this.reset(dto, true);
    }

    public void reset(CatalogDto dto, boolean failOnLoadError) {
        this.specCache.invalidate();
        for (CatalogItem toRemove : this.getCatalogItems()) {
            if (log.isTraceEnabled()) {
                log.trace("Scheduling item for persistence removal: {}", (Object)toRemove.getId());
            }
            this.mgmt.getRebindManager().getChangeListener().onUnmanaged(toRemove);
        }
        CatalogDo catalog = new CatalogDo(this.mgmt, dto);
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Resetting " + this + " catalog to " + dto, new Object[0]);
        catalog.load(this.mgmt, null, failOnLoadError);
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Reloaded catalog for " + this + ", now switching", new Object[0]);
        this.catalog = catalog;
        this.resetRootClassLoader();
        this.manualAdditionsCatalog = null;
        for (CatalogItem entry : this.getCatalogItems()) {
            CatalogItemDo cid;
            boolean setManagementContext = false;
            if (entry instanceof CatalogItemDo && (cid = (CatalogItemDo)CatalogItemDo.class.cast(entry)).getDto() instanceof CatalogItemDtoAbstract) {
                CatalogItemDtoAbstract cdto = (CatalogItemDtoAbstract)CatalogItemDtoAbstract.class.cast(cid.getDto());
                if (cdto.getManagementContext() == null) {
                    cdto.setManagementContext((ManagementContextInternal)this.mgmt);
                }
                setManagementContext = true;
                this.onAdditionUpdateOtherRegistries(cdto);
            }
            if (!setManagementContext) {
                log.warn("Can't set management context on entry with unexpected type in catalog. type={}, expected={}", entry, CatalogItemDo.class);
            }
            if (log.isTraceEnabled()) {
                log.trace("Scheduling item for persistence addition: {}", (Object)entry.getId());
            }
            this.mgmt.getRebindManager().getChangeListener().onManaged(entry);
        }
    }

    public void reset(Collection<CatalogItem<?, ?>> entries) {
        CatalogDto newDto = CatalogDto.newDtoFromCatalogItems(entries, "explicit-catalog-reset");
        this.reset(newDto);
    }

    public CatalogDo getCatalog() {
        return this.catalog;
    }

    protected CatalogItemDo<?, ?> getCatalogItemDo(String symbolicName, String version) {
        String fixedVersionId = this.getFixedVersionId(symbolicName, version);
        if (fixedVersionId == null) {
            return null;
        }
        return this.catalog.getIdCache().get(CatalogUtils.getVersionedId(symbolicName, fixedVersionId));
    }

    private String getFixedVersionId(String symbolicName, String version) {
        if (version != null && !"0.0.0_DEFAULT_VERSION".equals(version)) {
            return version;
        }
        return this.getBestVersion(symbolicName);
    }

    private String getBestVersion(String symbolicName) {
        Iterable versions = this.getCatalogItems(Predicates.and(CatalogPredicates.disabled(false), CatalogPredicates.symbolicName((Predicate<? super String>)Predicates.equalTo((Object)symbolicName))));
        Collection orderedVersions = this.sortVersionsDesc(versions);
        if (!orderedVersions.isEmpty()) {
            return orderedVersions.iterator().next().getVersion();
        }
        return null;
    }

    private <T, SpecT> Collection<CatalogItem<T, SpecT>> sortVersionsDesc(Iterable<CatalogItem<T, SpecT>> versions) {
        return ImmutableSortedSet.orderedBy(CatalogItemComparator.getInstance()).addAll(versions).build();
    }

    @Deprecated
    public CatalogItem<?, ?> getCatalogItem(String symbolicName, String version) {
        CatalogItem<?, ?> legacy = this.getCatalogItemLegacy(symbolicName, version);
        if (legacy != null) {
            return legacy;
        }
        RegisteredType rt = this.mgmt.getTypeRegistry().get(symbolicName, version);
        if (rt != null) {
            return RegisteredTypes.toPartialCatalogItem(rt);
        }
        return null;
    }

    @Deprecated
    public CatalogItem<?, ?> getCatalogItemLegacy(String symbolicName, String version) {
        if (symbolicName == null) {
            return null;
        }
        CatalogItemDo<?, ?> itemDo = this.getCatalogItemDo(symbolicName, version);
        if (itemDo == null) {
            return null;
        }
        return itemDo.getDto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCatalogItem(String symbolicName, String version) {
        if (!Boolean.TRUE.equals(deletingCatalogItem.get())) {
            deletingCatalogItem.set(true);
            try {
                RegisteredType item = this.mgmt.getTypeRegistry().get(symbolicName, version);
                if (item == null) {
                    log.debug("Request to delete " + symbolicName + ":" + version + " but nothing matching found; ignoring");
                } else {
                    ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).delete(item);
                }
                return;
            }
            finally {
                deletingCatalogItem.remove();
            }
        }
        log.debug("Deleting manual catalog item from " + this.mgmt + ": " + symbolicName + ":" + version);
        Preconditions.checkNotNull((Object)symbolicName, (Object)"id");
        Preconditions.checkNotNull((Object)version, (Object)"version");
        if ("0.0.0_DEFAULT_VERSION".equals(version)) {
            throw new IllegalStateException("Deleting items with unspecified version (argument DEFAULT_VERSION) not supported.");
        }
        CatalogItem<?, ?> item = this.getCatalogItem(symbolicName, version);
        CatalogItemDtoAbstract<?, ?> itemDto = this.getAbstractCatalogItem(item);
        if (itemDto == null) {
            throw new NoSuchElementException("No catalog item found with id " + symbolicName);
        }
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.deleteEntry(itemDto);
        this.specCache.invalidate();
        this.getCatalog().deleteEntry(itemDto);
        if (log.isTraceEnabled()) {
            log.trace("Scheduling item for persistence removal: {}", (Object)itemDto.getId());
        }
        this.mgmt.getRebindManager().getChangeListener().onUnmanaged(itemDto);
    }

    public <T, SpecT> CatalogItem<T, SpecT> getCatalogItem(Class<T> type, String id, String version) {
        CatalogItem<T, SpecT> item = this.getCatalogItemLegacy(type, id, version);
        if (item != null) {
            return item;
        }
        RegisteredType rt = this.mgmt.getTypeRegistry().get(id, version);
        if (rt != null && (rt.getSuperTypes().contains(type) || rt.getSuperTypes().contains(type.getName()))) {
            return RegisteredTypes.toPartialCatalogItem(rt);
        }
        return null;
    }

    public <T, SpecT> CatalogItem<T, SpecT> getCatalogItemLegacy(Class<T> type, String id, String version) {
        if (id == null || version == null) {
            return null;
        }
        CatalogItem<?, ?> result = this.getCatalogItem(id, version);
        if (result == null) {
            return null;
        }
        if (type == null || type.isAssignableFrom(result.getCatalogItemJavaType())) {
            return result;
        }
        return null;
    }

    public void persist(CatalogItem<?, ?> catalogItem) {
        Preconditions.checkArgument((this.getCatalogItem(catalogItem.getSymbolicName(), catalogItem.getVersion()) != null ? 1 : 0) != 0, (String)"Unknown catalog item %s", (Object[])new Object[]{catalogItem});
        this.mgmt.getRebindManager().getChangeListener().onChanged(catalogItem);
    }

    public ClassLoader getRootClassLoader() {
        if (this.rootClassLoader.isEmpty() && this.catalog != null) {
            this.resetRootClassLoader();
        }
        return this.rootClassLoader;
    }

    private void resetRootClassLoader() {
        this.specCache.invalidate();
        this.rootClassLoader.reset((Collection)ImmutableList.of((Object)this.catalog.getRootClassLoader()));
    }

    public void load() {
        log.debug("Loading catalog for " + this.mgmt);
        this.getCatalog().load(this.mgmt, null);
        if (log.isDebugEnabled()) {
            log.debug("Loaded catalog for " + this.mgmt + ": " + this.catalog + "; search classpath is " + this.catalog.getRootClassLoader());
        }
    }

    public AbstractBrooklynObjectSpec<?, ?> peekSpec(CatalogItem<?, ?> item) {
        if (item == null) {
            return null;
        }
        CatalogItemDo<?, ?> loadedItem = this.getCatalogItemDo(item.getSymbolicName(), item.getVersion());
        if (loadedItem == null) {
            throw new RuntimeException(item + " not in catalog; cannot create spec");
        }
        if (loadedItem.getSpecType() == null) {
            return null;
        }
        String itemId = item.getCatalogItemId();
        Optional<AbstractBrooklynObjectSpec<?, ?>> cachedSpec = this.specCache.getSpec(itemId);
        if (cachedSpec.isPresent()) {
            return (AbstractBrooklynObjectSpec)cachedSpec.get();
        }
        Object spec = BasicBrooklynCatalog.internalCreateSpecLegacy(this.mgmt, loadedItem, (Set<String>)MutableSet.of(), true);
        if (spec != null) {
            this.specCache.addSpec(itemId, (AbstractBrooklynObjectSpec<?, ?>)spec);
            return spec;
        }
        throw new IllegalStateException("No known mechanism to create instance of " + item);
    }

    @Deprecated
    public <T, SpecT extends AbstractBrooklynObjectSpec<? extends T, SpecT>> SpecT createSpec(CatalogItem<T, SpecT> item) {
        if (item == null) {
            return null;
        }
        CatalogItemDo<?, ?> loadedItem = this.getCatalogItemDo(item.getSymbolicName(), item.getVersion());
        if (loadedItem == null) {
            throw new RuntimeException(item + " not in catalog; cannot create spec");
        }
        if (loadedItem.getSpecType() == null) {
            return null;
        }
        Object spec = BasicBrooklynCatalog.internalCreateSpecLegacy(this.mgmt, loadedItem, (Set<String>)MutableSet.of(), true);
        if (spec != null) {
            return (SpecT)spec;
        }
        throw new IllegalStateException("No known mechanism to create instance of " + item);
    }

    @Deprecated
    public static <T, SpecT extends AbstractBrooklynObjectSpec<? extends T, SpecT>> SpecT internalCreateSpecLegacy(ManagementContext mgmt, final CatalogItem<T, SpecT> item, final Set<String> encounteredTypes, boolean includeDeprecatedTransformers) {
        if (encounteredTypes.contains(item.getSymbolicName())) {
            throw new IllegalStateException("Type being resolved '" + item.getSymbolicName() + "' has already been encountered in " + encounteredTypes + "; recursive cycle detected");
        }
        Maybe specMaybe = PlanToSpecFactory.attemptWithLoaders(mgmt, includeDeprecatedTransformers, new Function<PlanToSpecTransformer, SpecT>(){

            public SpecT apply(PlanToSpecTransformer input) {
                return input.createCatalogSpec(item, encounteredTypes);
            }
        });
        return (SpecT)((AbstractBrooklynObjectSpec)specMaybe.get());
    }

    @Deprecated
    private <T, SpecT> CatalogItemDtoAbstract<T, SpecT> getAbstractCatalogItem(CatalogItem<T, SpecT> item) {
        while (item instanceof CatalogItemDo) {
            item = ((CatalogItemDo)item).itemDto;
        }
        if (item == null) {
            return null;
        }
        if (item instanceof CatalogItemDtoAbstract) {
            return (CatalogItemDtoAbstract)item;
        }
        throw new IllegalStateException("Cannot unwrap catalog item '" + item + "' (type " + item.getClass() + ") to restore DTO");
    }

    private static <T> Maybe<T> getFirstAs(Map<?, ?> map, Class<T> type, String firstKey, String ... otherKeys) {
        if (map == null) {
            return Maybe.absent((String)"No map available");
        }
        String foundKey = null;
        Object value = null;
        if (map.containsKey(firstKey)) {
            foundKey = firstKey;
        } else {
            for (String key : otherKeys) {
                if (!map.containsKey(key)) continue;
                foundKey = key;
                break;
            }
        }
        if (foundKey == null) {
            return Maybe.absent((String)("Missing entry '" + firstKey + "'"));
        }
        value = map.get(foundKey);
        if (type.equals(String.class) && Number.class.isInstance(value)) {
            value = value.toString();
        }
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException("Entry for '" + firstKey + "' should be of type " + type + ", not " + (value == null ? "null" : value.getClass()));
        }
        return Maybe.of((Object)value);
    }

    private static Maybe<Map<?, ?>> getFirstAsMap(Map<?, ?> map, String firstKey, String ... otherKeys) {
        return BasicBrooklynCatalog.getFirstAs(map, Map.class, firstKey, otherKeys);
    }

    public static Map<?, ?> getCatalogMetadata(String yaml) {
        Map itemDef = (Map)Yamls.getAs((Object)Yamls.parseAll((String)yaml), Map.class);
        return (Map)BasicBrooklynCatalog.getFirstAsMap(itemDef, "brooklyn.catalog", new String[0]).orNull();
    }

    @Deprecated
    public static VersionedName getVersionedName(Map<?, ?> catalogMetadata) {
        return BasicBrooklynCatalog.getVersionedName(catalogMetadata, true);
    }

    public static VersionedName getVersionedName(Map<?, ?> catalogMetadata, boolean required) {
        String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
        String bundle = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "bundle", new String[0]).orNull();
        if (Strings.isBlank((CharSequence)bundle) && Strings.isBlank((CharSequence)version)) {
            if (!required) {
                return null;
            }
            throw new IllegalStateException("Catalog BOM must define bundle and version");
        }
        if (Strings.isBlank((CharSequence)bundle)) {
            if (!required) {
                return null;
            }
            throw new IllegalStateException("Catalog BOM must define bundle");
        }
        if (Strings.isBlank((CharSequence)version)) {
            throw new IllegalStateException("Catalog BOM must define version if bundle is defined");
        }
        return new VersionedName(bundle, version);
    }

    private void collectCatalogItemsFromCatalogBomRoot(String yaml, ManagedBundle containingBundle, List<CatalogItemDtoAbstract<?, ?>> resultLegacyFormat, Map<RegisteredType, RegisteredType> resultNewFormat, boolean requireValidation, Map<?, ?> parentMeta, int depth, boolean force) {
        Map itemDef = (Map)Yamls.getAs((Object)Yamls.parseAll((String)yaml), Map.class);
        Map catalogMetadata = (Map)BasicBrooklynCatalog.getFirstAsMap(itemDef, "brooklyn.catalog", new String[0]).orNull();
        if (catalogMetadata == null) {
            log.warn("No `brooklyn.catalog` supplied in catalog request; using legacy mode for " + itemDef);
        }
        catalogMetadata = MutableMap.copyOf((Map)catalogMetadata);
        this.collectCatalogItemsFromItemMetadataBlock(Yamls.getTextOfYamlAtPath((String)yaml, (Object[])new Object[]{"brooklyn.catalog"}).getMatchedYamlTextOrWarn(), containingBundle, catalogMetadata, resultLegacyFormat, resultNewFormat, requireValidation, parentMeta, 0, force);
        itemDef.remove("brooklyn.catalog");
        catalogMetadata.remove("item");
        catalogMetadata.remove("items");
        if (!itemDef.isEmpty()) {
            log.warn("Deprecated read of catalog item from sibling keys of `brooklyn.catalog` section, instead of the more common appraoch of putting inside an `item` within it. Rewrite to use nested/reference syntax instead or contact the community for assistance or feedback.");
            MutableMap rootItem = MutableMap.of((Object)"item", (Object)itemDef);
            String rootItemYaml = yaml;
            Yamls.YamlExtract yamlExtract = Yamls.getTextOfYamlAtPath((String)rootItemYaml, (Object[])new Object[]{"brooklyn.catalog"});
            String match = yamlExtract.withOriginalIndentation(true).withKeyIncluded(true).getMatchedYamlTextOrWarn();
            if (match != null) {
                rootItemYaml = rootItemYaml.startsWith(match) ? Strings.removeFromStart((String)rootItemYaml, (String)match) : Strings.replaceAllNonRegex((String)rootItemYaml, (String)("\n" + match), (String)"");
            }
            this.collectCatalogItemsFromItemMetadataBlock("item:\n" + this.makeAsIndentedObject(rootItemYaml), containingBundle, (Map<?, ?>)rootItem, resultLegacyFormat, resultNewFormat, requireValidation, catalogMetadata, 1, force);
        }
    }

    private void collectCatalogItemsFromItemMetadataBlock(String sourceYaml, ManagedBundle containingBundle, Map<?, ?> itemMetadata, List<CatalogItemDtoAbstract<?, ?>> resultLegacyFormat, Map<RegisteredType, RegisteredType> resultNewFormat, boolean requireValidation, Map<?, ?> parentMetadata, int depth, boolean force) {
        if (sourceYaml == null) {
            sourceYaml = new Yaml().dump(itemMetadata);
        }
        Object itemMetadataWithoutItemDef = MutableMap.builder().putAll(itemMetadata).remove((Object)"item").remove((Object)"items").build();
        CampYamlParser parser = (CampYamlParser)this.mgmt.getScratchpad().get(CampYamlParser.YAML_PARSER_KEY);
        if (parser != null) {
            itemMetadataWithoutItemDef = parser.parse((Map<String, Object>)itemMetadataWithoutItemDef);
            try {
                itemMetadataWithoutItemDef = (Map)Tasks.resolveDeepValue(itemMetadataWithoutItemDef, Object.class, this.mgmt.getServerExecutionContext());
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            log.info("No Camp-YAML parser registered for parsing catalog item DSL; skipping DSL-parsing");
        }
        MutableMap catalogMetadata = MutableMap.builder().putAll(parentMetadata).putAll((Map)itemMetadataWithoutItemDef).putIfNotNull((Object)"item", itemMetadata.get("item")).putIfNotNull((Object)"items", itemMetadata.get("items")).build();
        MutableList librariesAddedHereNames = MutableList.copyOf((Iterable)((Iterable)BasicBrooklynCatalog.getFirstAs(itemMetadataWithoutItemDef, List.class, "brooklyn.libraries", new String[]{"libraries"}).orNull()));
        Collection<CatalogItem.CatalogBundle> librariesAddedHereBundles = CatalogItemDtoAbstract.parseLibraries(librariesAddedHereNames);
        MutableSet librariesCombinedNames = MutableSet.of();
        if (!BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.mgmt, containingBundle)) {
            librariesCombinedNames.add((Object)containingBundle.getVersionedName().toOsgiString());
        }
        librariesCombinedNames.putAll((Iterable)librariesAddedHereNames);
        librariesCombinedNames.putAll((Iterable)BasicBrooklynCatalog.getFirstAs(parentMetadata, Collection.class, "brooklyn.libraries", "libraries").orNull());
        if (!librariesCombinedNames.isEmpty()) {
            catalogMetadata.put("brooklyn.libraries", librariesCombinedNames);
        }
        Collection<CatalogItem.CatalogBundle> libraryBundles = CatalogItemDtoAbstract.parseLibraries(librariesCombinedNames);
        CatalogUtils.installLibraries(this.mgmt, librariesAddedHereBundles);
        librariesAddedHereBundles = BasicBrooklynCatalog.resolveWherePossible(this.mgmt, librariesAddedHereBundles);
        libraryBundles = BasicBrooklynCatalog.resolveWherePossible(this.mgmt, libraryBundles);
        Boolean scanJavaAnnotations = (Boolean)BasicBrooklynCatalog.getFirstAs(itemMetadataWithoutItemDef, Boolean.class, "scanJavaAnnotations", new String[]{"scan_java_annotations"}).orNull();
        if (scanJavaAnnotations != null && scanJavaAnnotations.booleanValue()) {
            if (BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.mgmt, containingBundle)) {
                Collection<CatalogItemDtoAbstract<?, ?>> scanResult;
                if (BasicBrooklynCatalog.isLibrariesMoreThanJustContainingBundle(librariesAddedHereBundles, containingBundle)) {
                    log.warn("Deprecated use of scanJavaAnnotations to scan other libraries (" + librariesAddedHereBundles + "); libraries should declare they scan themselves");
                    scanResult = this.scanAnnotationsLegacyInListOfLibraries(this.mgmt, (Collection<? extends OsgiBundleWithUrl>)librariesAddedHereBundles, (Map<?, ?>)catalogMetadata, containingBundle);
                } else if (!BasicBrooklynCatalog.isLibrariesMoreThanJustContainingBundle(libraryBundles, containingBundle)) {
                    if (containingBundle != null && !containingBundle.getSymbolicName().contains("brooklyn-default-catalog")) {
                        log.warn("Deprecated use of scanJavaAnnotations in non-Java BOM outwith the default catalog setup");
                    } else if (depth > 0) {
                        log.warn("Deprecated use of scanJavaAnnotations declared in item; should be declared at the top level of the BOM");
                    }
                    scanResult = this.scanAnnotationsFromLocalNonBundleClasspath(this.mgmt, (Map<?, ?>)catalogMetadata, containingBundle);
                } else {
                    throw new IllegalStateException("Cannot scan for Java catalog items when libraries declared on an ancestor; scanJavaAnnotations should be specified alongside brooklyn.libraries (or ideally those libraries should specify to scan)");
                }
                if (scanResult != null && !scanResult.isEmpty()) {
                    if (resultLegacyFormat != null) {
                        resultLegacyFormat.addAll(scanResult);
                    } else {
                        for (CatalogItem catalogItem : scanResult) {
                            RegisteredType replacedInstance = this.mgmt.getTypeRegistry().get(catalogItem.getSymbolicName(), catalogItem.getVersion());
                            this.mgmt.getCatalog().addItem(catalogItem);
                            RegisteredType newInstance = this.mgmt.getTypeRegistry().get(catalogItem.getSymbolicName(), catalogItem.getVersion());
                            this.updateResultNewFormat(resultNewFormat, replacedInstance, newInstance);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Scanning for Java annotations is not supported in BOMs in bundles; entries should be listed explicitly in the catalog.bom");
            }
        }
        Object items = catalogMetadata.remove("items");
        Object item = catalogMetadata.remove("item");
        Object v = catalogMetadata.remove("include");
        if (items != null) {
            int count = 0;
            for (Object ii : this.checkType(items, "items", List.class)) {
                if (ii instanceof String) {
                    this.collectUrlReferencedCatalogItems((String)ii, containingBundle, resultLegacyFormat, resultNewFormat, requireValidation, (Map<Object, Object>)catalogMetadata, depth + 1, force);
                } else {
                    Map i = this.checkType(ii, "entry in items list", Map.class);
                    this.collectCatalogItemsFromItemMetadataBlock(Yamls.getTextOfYamlAtPath((String)sourceYaml, (Object[])new Object[]{"items", count}).getMatchedYamlTextOrWarn(), containingBundle, i, resultLegacyFormat, resultNewFormat, requireValidation, (Map<?, ?>)catalogMetadata, depth + 1, force);
                }
                ++count;
            }
        }
        if (v != null) {
            this.collectUrlReferencedCatalogItems(this.checkType(v, "include in catalog meta", String.class), containingBundle, resultLegacyFormat, resultNewFormat, requireValidation, (Map<Object, Object>)catalogMetadata, depth + 1, force);
        }
        if (item == null) {
            return;
        }
        String itemYaml = Yamls.getTextOfYamlAtPath((String)sourceYaml, (Object[])new Object[]{"item"}).getMatchedYamlTextOrWarn();
        sourceYaml = itemYaml != null ? itemYaml : new Yaml().dump(item);
        CatalogItem.CatalogItemType itemType = TypeCoercions.coerce(BasicBrooklynCatalog.getFirstAs(catalogMetadata, Object.class, "itemType", new String[]{"item_type"}).orNull(), CatalogItem.CatalogItemType.class);
        String id = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "id", new String[0]).orNull();
        String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
        String symbolicName = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "symbolicName", new String[0]).orNull();
        String displayName = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "displayName", new String[0]).orNull();
        String name = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "name", new String[0]).orNull();
        if ((Strings.isNonBlank((CharSequence)id) || Strings.isNonBlank((CharSequence)symbolicName)) && Strings.isNonBlank((CharSequence)displayName) && Strings.isNonBlank((CharSequence)name) && !name.equals(displayName)) {
            log.warn("Name property will be ignored due to the existence of displayName and at least one of id, symbolicName");
        }
        PlanInterpreterGuessingType planInterpreter = new PlanInterpreterGuessingType(null, item, sourceYaml, itemType, libraryBundles, resultLegacyFormat).reconstruct();
        RuntimeException resolutionError = null;
        if (!planInterpreter.isResolved()) {
            resolutionError = Exceptions.create((String)("Could not resolve definition of item" + (Strings.isNonBlank((CharSequence)id) ? " '" + id + "'" : (Strings.isNonBlank((CharSequence)symbolicName) ? " '" + symbolicName + "'" : (Strings.isNonBlank((CharSequence)name) ? " '" + name + "'" : "")))), planInterpreter.getErrors());
        }
        itemType = planInterpreter.getCatalogItemType();
        Map<?, ?> itemAsMap = planInterpreter.getItem();
        if (Strings.isBlank((CharSequence)symbolicName)) {
            if (Strings.isNonBlank((CharSequence)id)) {
                if (RegisteredTypeNaming.isGoodBrooklynTypeColonVersion(id)) {
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(id);
                } else if (RegisteredTypeNaming.isValidOsgiTypeColonVersion(id)) {
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(id);
                    log.warn("Discouraged version syntax in id '" + id + "'; version should comply with brooklyn recommendation (#.#.#-qualifier or portion) or specify symbolic name and version explicitly, not OSGi version syntax");
                } else if (CatalogUtils.looksLikeVersionedId(id)) {
                    log.warn("Discouraged version syntax in id '" + id + "'; version should comply with brooklyn recommendation (#.#.#-qualifier or portion) or specify symbolic name and version explicitly");
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(id);
                } else if (RegisteredTypeNaming.isUsableTypeColonVersion(id)) {
                    log.warn("Deprecated type naming syntax in id '" + id + "'; colons not allowed in type name as it is used to indicate version");
                    symbolicName = id;
                } else {
                    symbolicName = id;
                }
            } else if (Strings.isNonBlank((CharSequence)name)) {
                if (RegisteredTypeNaming.isGoodBrooklynTypeColonVersion(name) || RegisteredTypeNaming.isValidOsgiTypeColonVersion(name)) {
                    log.warn("Deprecated use of 'name' key to define '" + name + "'; version should be specified within 'id' key or with 'version' key, not this tag");
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(name);
                } else if (CatalogUtils.looksLikeVersionedId(name)) {
                    log.warn("Deprecated use of 'name' key to define '" + name + "'; version should be specified within 'id' key or with 'version' key, not this tag");
                    symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(name);
                } else if (RegisteredTypeNaming.isUsableTypeColonVersion(name)) {
                    log.warn("Deprecated type naming syntax in id '" + id + "'; colons not allowed in type name as it is used to indicate version");
                    symbolicName = name;
                } else {
                    symbolicName = name;
                }
            } else {
                symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "id");
                symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "name");
                if (Strings.isBlank((CharSequence)(symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "template_name")))) {
                    log.error("Can't infer catalog item symbolicName from the following plan:\n" + sourceYaml);
                    throw new IllegalStateException("Can't infer catalog item symbolicName from catalog item metadata");
                }
            }
        }
        String versionFromId = null;
        if (RegisteredTypeNaming.isGoodBrooklynTypeColonVersion(id)) {
            versionFromId = CatalogUtils.getVersionFromVersionedId(id);
        } else if (RegisteredTypeNaming.isValidOsgiTypeColonVersion(id)) {
            versionFromId = CatalogUtils.getVersionFromVersionedId(id);
            log.warn("Discouraged version syntax in id '" + id + "'; version should comply with Brooklyn recommended version syntax (#.#.#-qualifier or portion) or specify symbolic name and version explicitly, not OSGi");
        } else if (CatalogUtils.looksLikeVersionedId(id)) {
            log.warn("Discouraged version syntax in id '" + id + "'; version should comply with Brooklyn recommended version syntax (#.#.#-qualifier or portion) or specify symbolic name and version explicitly");
            versionFromId = CatalogUtils.getVersionFromVersionedId(id);
        } else if (RegisteredTypeNaming.isUsableTypeColonVersion(id)) {
            // empty if block
        }
        if (versionFromId != null) {
            if (Strings.isNonBlank((CharSequence)version) && !versionFromId.equals(version)) {
                throw new IllegalArgumentException("Discrepency between version set in id " + versionFromId + " and version property " + version);
            }
            version = versionFromId;
        }
        if (Strings.isBlank((CharSequence)version)) {
            if (CatalogUtils.looksLikeVersionedId(name)) {
                log.warn("Deprecated use of 'name' key to define '" + name + "'; version should be specified within 'id' key or with 'version' key, not this tag");
                version = CatalogUtils.getVersionFromVersionedId(name);
            }
            if (Strings.isBlank((CharSequence)version)) {
                version = this.setFromItemIfUnset(version, itemAsMap, "version");
                if ((version = this.setFromItemIfUnset(version, itemAsMap, "template_version")) == null) {
                    log.debug("No version specified for catalog item " + symbolicName + ". Using default value.");
                    version = null;
                }
            }
        }
        if (Strings.isBlank((CharSequence)id)) {
            if (Strings.isNonBlank((CharSequence)symbolicName) && Strings.isNonBlank((CharSequence)version)) {
                id = symbolicName + ":" + version;
            }
            if (Strings.isBlank((CharSequence)(id = this.setFromItemIfUnset(id, itemAsMap, "id")))) {
                if (Strings.isNonBlank((CharSequence)symbolicName)) {
                    id = symbolicName;
                } else {
                    log.error("Can't infer catalog item id from the following plan:\n" + sourceYaml);
                    throw new IllegalStateException("Can't infer catalog item id from catalog item metadata");
                }
            }
        }
        if (Strings.isBlank((CharSequence)displayName)) {
            if (Strings.isNonBlank((CharSequence)name)) {
                displayName = name;
            }
            displayName = this.setFromItemIfUnset(displayName, itemAsMap, "name");
        }
        String description = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "description", new String[0]).orNull();
        description = this.setFromItemIfUnset(description, itemAsMap, "description");
        String catalogIconUrl = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "iconUrl", new String[]{"icon_url", "icon.url"}).orNull();
        String deprecated = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "deprecated", new String[0]).orNull();
        Boolean catalogDeprecated = Boolean.valueOf(deprecated);
        planInterpreter = new PlanInterpreterGuessingType(id, item, sourceYaml, itemType, libraryBundles, resultLegacyFormat).reconstruct();
        if (resolutionError == null && !planInterpreter.isResolved()) {
            resolutionError = new IllegalStateException("Plan resolution for " + id + " breaks after id and itemType are set; is there a recursive reference or other type inconsistency?\n" + sourceYaml);
        }
        String sourcePlanYaml = planInterpreter.getPlanYaml();
        if (resultLegacyFormat == null) {
            MutableList aliases = MutableList.of();
            MutableList tags = MutableList.of();
            Boolean catalogDisabled = null;
            MutableList superTypes = MutableList.of();
            if (itemType == CatalogItem.CatalogItemType.TEMPLATE) {
                tags.add(BrooklynTags.CATALOG_TEMPLATE);
                itemType = CatalogItem.CatalogItemType.ENTITY;
                superTypes.add(Application.class);
            }
            if (resolutionError != null && !tags.contains(BrooklynTags.CATALOG_TEMPLATE) && requireValidation) {
                throw Exceptions.propagate((Throwable)resolutionError);
            }
            String format = null;
            if (itemType != null) {
                superTypes.appendIfNotNull((Object)BrooklynObjectType.of((CatalogItem.CatalogItemType)itemType).getInterfaceType());
            }
            if (version == null) {
                version = NO_VERSION;
            }
            if (sourcePlanYaml == null) {
                sourcePlanYaml = planInterpreter.itemYaml;
            }
            BasicTypeImplementationPlan plan = new BasicTypeImplementationPlan(format, sourcePlanYaml);
            BasicRegisteredType type = (BasicRegisteredType)RegisteredTypes.newInstance(BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED, symbolicName, version, plan, (Iterable<Object>)superTypes, (Iterable<String>)aliases, (Iterable<Object>)tags, containingBundle == null ? null : containingBundle.getVersionedName().toString(), (Iterable<OsgiBundleWithUrl>)MutableList.copyOf(libraryBundles), displayName, description, catalogIconUrl, catalogDeprecated, catalogDisabled);
            RegisteredTypes.notePlanEquivalentToThis(type, plan);
            RegisteredTypes.notePlanEquivalentToThis(type, new BasicTypeImplementationPlan(format, sourceYaml));
            RegisteredType replacedInstance = this.mgmt.getTypeRegistry().get(type.getSymbolicName(), type.getVersion());
            ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).addToLocalUnpersistedTypeRegistry(type, force);
            this.updateResultNewFormat(resultNewFormat, replacedInstance, type);
        } else {
            if (resolutionError != null) {
                throw Exceptions.propagate((Throwable)resolutionError);
            }
            Object dto = BasicBrooklynCatalog.createItemBuilder(itemType, symbolicName, version).libraries(libraryBundles).displayName(displayName).description(description).deprecated(catalogDeprecated).iconUrl(catalogIconUrl).plan(sourcePlanYaml).build();
            ((AbstractBrooklynObject)dto).setManagementContext((ManagementContextInternal)this.mgmt);
            resultLegacyFormat.add((CatalogItemDtoAbstract<?, ?>)dto);
        }
    }

    private void updateResultNewFormat(Map<RegisteredType, RegisteredType> resultNewFormat, RegisteredType replacedInstance, RegisteredType newInstance) {
        if (resultNewFormat != null) {
            if (resultNewFormat.containsKey(newInstance)) {
                log.debug("Multiple definitions for " + newInstance + " in BOM; only recording one");
            } else {
                resultNewFormat.put(newInstance, replacedInstance);
            }
        }
    }

    protected static Collection<CatalogItem.CatalogBundle> resolveWherePossible(ManagementContext mgmt, Collection<CatalogItem.CatalogBundle> libraryBundles) {
        MutableSet libraryBundlesResolved = MutableSet.of();
        for (CatalogItem.CatalogBundle b : libraryBundles) {
            libraryBundlesResolved.add(CatalogBundleDto.resolve(mgmt, b).or((Object)b));
        }
        return libraryBundlesResolved;
    }

    private static boolean isLibrariesMoreThanJustContainingBundle(Collection<CatalogItem.CatalogBundle> library, ManagedBundle containingBundle) {
        if (library == null || library.isEmpty()) {
            return false;
        }
        if (containingBundle == null) {
            return !library.isEmpty();
        }
        if (library.size() > 1) {
            return true;
        }
        CatalogItem.CatalogBundle li = (CatalogItem.CatalogBundle)Iterables.getOnlyElement(library);
        return !containingBundle.getVersionedName().equalsOsgi((Object)li.getVersionedName());
    }

    @Beta
    public static boolean isNoBundleOrSimpleWrappingBundle(ManagementContext mgmt, ManagedBundle b) {
        if (b == null) {
            return true;
        }
        Maybe<OsgiManager> osgi = ((ManagementContextInternal)mgmt).getOsgiManager();
        if (osgi.isAbsent()) {
            throw new IllegalStateException("OSGi not being used but installing a bundle");
        }
        Maybe<Bundle> bb = ((OsgiManager)osgi.get()).findBundle((OsgiBundleWithUrl)b);
        if (bb.isAbsent()) {
            throw new IllegalStateException("Loading from a bundle which is not installed");
        }
        String wrapped = (String)((Bundle)bb.get()).getHeaders().get(BROOKLYN_WRAPPED_BOM_BUNDLE);
        return wrapped != null && wrapped.equalsIgnoreCase("true");
    }

    private void collectUrlReferencedCatalogItems(String url, ManagedBundle containingBundle, List<CatalogItemDtoAbstract<?, ?>> resultLegacyFormat, Map<RegisteredType, RegisteredType> resultNewFormat, boolean requireValidation, Map<Object, Object> parentMeta, int depth, boolean force) {
        String yaml;
        MutableList parentLibrariesRaw = MutableList.copyOf((Iterable)((Iterable)BasicBrooklynCatalog.getFirstAs(parentMeta, Iterable.class, "brooklyn.libraries", "libraries").orNull()));
        Collection<CatalogItem.CatalogBundle> parentLibraries = CatalogItemDtoAbstract.parseLibraries(parentLibrariesRaw);
        BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext(this.mgmt, "<catalog url reference loader>:0.0.0", parentLibraries);
        log.debug("Catalog load, loading referenced BOM at " + url + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()) + " (" + (resultNewFormat != null ? Integer.valueOf(resultNewFormat.size()) : (resultLegacyFormat != null ? Integer.valueOf(resultLegacyFormat.size()) : "(unknown)")) + " items before load)");
        if (url.startsWith("http")) {
            log.info("Loading external referenced BOM at " + url + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()));
        }
        try {
            yaml = ResourceUtils.create(loader).getResourceAsString(url);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Remote catalog url " + url + " in " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()) + " can't be fetched.", e);
        }
        this.collectCatalogItemsFromCatalogBomRoot(yaml, containingBundle, resultLegacyFormat, resultNewFormat, requireValidation, parentMeta, depth, force);
        log.debug("Catalog load, loaded referenced BOM at " + url + " as part of " + (containingBundle == null ? "non-bundled load" : containingBundle.getVersionedName()) + ", now have " + (resultNewFormat != null ? Integer.valueOf(resultNewFormat.size()) : (resultLegacyFormat != null ? Integer.valueOf(resultLegacyFormat.size()) : "(unknown)")) + " items");
    }

    private <T> T checkType(Object x, String description, Class<T> type) {
        if (type.isInstance(x)) {
            return (T)x;
        }
        throw new UserFacingException("Expected " + JavaClassNames.superSimpleClassName(type) + " for " + description + ", not " + JavaClassNames.superSimpleClassName((Object)x));
    }

    private String setFromItemIfUnset(String oldValue, Map<?, ?> item, String fieldAttr) {
        Object newValue;
        if (Strings.isNonBlank((CharSequence)oldValue)) {
            return oldValue;
        }
        if (item != null && (newValue = item.get(fieldAttr)) instanceof String && Strings.isNonBlank((CharSequence)((String)newValue))) {
            return (String)newValue;
        }
        return oldValue;
    }

    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsFromLocalNonBundleClasspath(ManagementContext mgmt, Map<?, ?> catalogMetadata, ManagedBundle containingBundle) {
        CatalogDto dto = CatalogDto.newNamedInstance("Local Scanned Catalog", "All annotated Brooklyn entities detected in the classpath", "scanning-local-classpath");
        return this.scanAnnotationsInternal(mgmt, new CatalogDo(dto), catalogMetadata, containingBundle);
    }

    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsLegacyInListOfLibraries(ManagementContext mgmt, Collection<? extends OsgiBundleWithUrl> libraries, Map<?, ?> catalogMetadata, ManagedBundle containingBundle) {
        CatalogDto dto = CatalogDto.newNamedInstance("Bundles Scanned Catalog", "All annotated Brooklyn entities detected in bundles", "scanning-bundles-classpath-" + libraries.hashCode());
        MutableList urls = MutableList.of();
        for (OsgiBundleWithUrl osgiBundleWithUrl : libraries) {
            if (Strings.isNonBlank((CharSequence)osgiBundleWithUrl.getUrl())) {
                urls.add(osgiBundleWithUrl.getUrl());
                continue;
            }
            log.warn("scanJavaAnnotations does not apply to pre-installed bundles; skipping " + osgiBundleWithUrl);
        }
        if (urls.isEmpty()) {
            log.warn("No bundles to scan: scanJavaAnnotations currently only applies to OSGi bundles provided by URL");
            return MutableList.of();
        }
        CatalogDo subCatalog = new CatalogDo(dto);
        subCatalog.addToClasspath(urls.toArray(new String[0]));
        return this.scanAnnotationsInternal(mgmt, subCatalog, catalogMetadata, containingBundle);
    }

    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsInBundle(ManagementContext mgmt, ManagedBundle containingBundle) {
        CatalogDto dto = CatalogDto.newNamedInstance("Bundle " + containingBundle.getVersionedName().toOsgiString() + " Scanned Catalog", "All annotated Brooklyn entities detected in bundles", "scanning-bundle-" + containingBundle.getVersionedName().toOsgiString());
        CatalogDo subCatalog = new CatalogDo(dto);
        String url = null;
        File f = ((OsgiManager)((ManagementContextInternal)mgmt).getOsgiManager().get()).getBundleFile(containingBundle);
        if (f != null) {
            url = "file//:" + f.getAbsolutePath();
        }
        if (url == null) {
            url = containingBundle.getUrl();
        }
        if (url == null) {
            throw new IllegalArgumentException("Error preparing to scan " + containingBundle.getVersionedName() + ": no URL available");
        }
        File fJar = Os.newTempFile((String)containingBundle.getVersionedName().toOsgiString(), (String)".jar");
        try {
            Collection<CatalogItemDtoAbstract<?, ?>> result;
            Streams.copy((InputStream)ResourceUtils.create().getResourceFromUrl(url), (OutputStream)new FileOutputStream(fJar));
            subCatalog.addToClasspath("file:" + fJar.getAbsolutePath());
            Collection<CatalogItemDtoAbstract<?, ?>> collection = result = this.scanAnnotationsInternal(mgmt, subCatalog, (Map<?, ?>)MutableMap.of((Object)"version", (Object)containingBundle.getSuppliedVersionString()), containingBundle);
            return collection;
        }
        catch (FileNotFoundException e) {
            throw Exceptions.propagateAnnotated((String)("Error extracting " + url + " to scan " + containingBundle.getVersionedName()), (Throwable)e);
        }
        finally {
            fJar.delete();
        }
    }

    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsInternal(ManagementContext mgmt, CatalogDo subCatalog, Map<?, ?> catalogMetadata, ManagedBundle containingBundle) {
        subCatalog.mgmt = mgmt;
        subCatalog.setClasspathScanForEntities(CatalogClasspathDo.CatalogScanningModes.ANNOTATIONS);
        subCatalog.load();
        Collection result = Collections2.transform(subCatalog.getIdCache().values(), BasicBrooklynCatalog.itemDoToDtoAddingSelectedMetadataDuringScan(mgmt, catalogMetadata, containingBundle));
        return result;
    }

    private String makeAsIndentedList(String yaml) {
        Object[] lines = yaml.split("\n");
        lines[0] = "- " + lines[0];
        for (int i = 1; i < lines.length; ++i) {
            lines[i] = "  " + (String)lines[i];
        }
        return Strings.join((Object[])lines, (String)"\n");
    }

    private String makeAsIndentedObject(String yaml) {
        Object[] lines = yaml.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = "  " + (String)lines[i];
        }
        return Strings.join((Object[])lines, (String)"\n");
    }

    static CatalogItemBuilder<?> createItemBuilder(CatalogItem.CatalogItemType itemType, String symbolicName, String version) {
        return CatalogItemBuilder.newItem(itemType, symbolicName, version);
    }

    public CatalogItem<?, ?> addItem(String yaml) {
        return this.addItem(yaml, false);
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml) {
        return this.addItems(yaml, false);
    }

    public CatalogItem<?, ?> addItem(String yaml, boolean forceUpdate) {
        return (CatalogItem)Iterables.getOnlyElement((Iterable)this.addItems(yaml, forceUpdate));
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml, boolean forceUpdate) {
        Maybe<OsgiManager> osgiManager = ((ManagementContextInternal)this.mgmt).getOsgiManager();
        if (osgiManager.isPresent()) {
            Map<?, ?> cm = BasicBrooklynCatalog.getCatalogMetadata(yaml);
            VersionedName vn = BasicBrooklynCatalog.getVersionedName(cm, false);
            if (vn == null) {
                String id = (String)cm.get("id");
                if (Strings.isNonBlank((CharSequence)id)) {
                    vn = VersionedName.fromString((String)id);
                }
                vn = new VersionedName(vn != null && Strings.isNonBlank((CharSequence)vn.getSymbolicName()) ? vn.getSymbolicName() : "brooklyn-catalog-bom-" + Identifiers.makeRandomId((int)8), vn != null && vn.getVersionString() != null ? vn.getVersionString() : (String)BasicBrooklynCatalog.getFirstAs(cm, String.class, "version", new String[0]).or((Object)NO_VERSION));
            }
            log.debug("Wrapping supplied BOM as " + vn);
            Manifest mf = new Manifest();
            mf.getMainAttributes().putValue("Bundle-SymbolicName", vn.getSymbolicName());
            mf.getMainAttributes().putValue("Bundle-Version", vn.getOsgiVersionString());
            mf.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
            mf.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), OSGI_MANIFEST_VERSION_VALUE);
            mf.getMainAttributes().putValue(BROOKLYN_WRAPPED_BOM_BUNDLE, Boolean.TRUE.toString());
            BundleMaker bm = new BundleMaker(this.mgmt);
            File bf = bm.createTempBundle(vn.getSymbolicName(), mf, (Map<ZipEntry, InputStream>)MutableMap.of((Object)new ZipEntry(CATALOG_BOM), (Object)new ByteArrayInputStream(yaml.getBytes())));
            OsgiBundleInstallationResult result = null;
            try {
                result = (OsgiBundleInstallationResult)((OsgiManager)osgiManager.get()).install(null, new FileInputStream(bf), true, true, forceUpdate).get();
            }
            catch (FileNotFoundException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            finally {
                bf.delete();
            }
            if (result.getCode().isError()) {
                throw new IllegalStateException(result.getMessage());
            }
            this.uninstallEmptyWrapperBundles();
            return this.toLegacyCatalogItems(result.getCatalogItemsInstalled());
        }
        return this.addItems(yaml, null, forceUpdate);
    }

    private List<CatalogItem<?, ?>> toLegacyCatalogItems(Iterable<String> itemIds) {
        MutableList result = MutableList.of();
        for (String id : itemIds) {
            CatalogItem<?, ?> item = CatalogUtils.getCatalogItemOptionalVersion(this.mgmt, id);
            if (item == null) {
                result.add(RegisteredTypes.toPartialCatalogItem(this.mgmt.getTypeRegistry().get(id)));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml, ManagedBundle bundle) {
        return this.addItems(yaml, bundle, false);
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml, ManagedBundle bundle, boolean forceUpdate) {
        log.debug("Adding catalog item to " + this.mgmt + ": " + yaml);
        Preconditions.checkNotNull((Object)yaml, (Object)"yaml");
        MutableList result = MutableList.of();
        this.collectCatalogItemsFromCatalogBomRoot(yaml, bundle, (List<CatalogItemDtoAbstract<?, ?>>)result, null, true, (Map<?, ?>)ImmutableMap.of(), 0, forceUpdate);
        for (CatalogItemDtoAbstract item : result) {
            if (bundle != null && bundle.getVersionedName() != null) {
                item.setContainingBundle(bundle.getVersionedName());
            }
            this.addItemDto(item, forceUpdate);
        }
        return result;
    }

    @Beta
    public void addTypesFromBundleBom(String yaml, ManagedBundle bundle, boolean forceUpdate, Map<RegisteredType, RegisteredType> result) {
        log.debug("Catalog load, adding catalog item to " + this.mgmt + ": " + yaml);
        Preconditions.checkNotNull((Object)yaml, (Object)"yaml");
        if (result == null) {
            result = MutableMap.of();
        }
        this.collectCatalogItemsFromCatalogBomRoot(yaml, bundle, null, (Map<RegisteredType, RegisteredType>)result, false, (Map<?, ?>)MutableMap.of(), 0, forceUpdate);
    }

    @Beta
    public Map<RegisteredType, Collection<Throwable>> validateTypes(Iterable<RegisteredType> typesToValidate) {
        MutableList typesRemainingToValidate = MutableList.copyOf(typesToValidate);
        while (true) {
            log.debug("Catalog load, starting validation cycle, " + typesRemainingToValidate.size() + " to validate");
            MutableMap result = MutableMap.of();
            for (RegisteredType t : typesRemainingToValidate) {
                Collection<Throwable> tr = this.validateType(t, null);
                if (tr.isEmpty()) continue;
                result.put(t, tr);
            }
            log.debug("Catalog load, finished validation cycle, " + typesRemainingToValidate.size() + " unvalidated");
            if (result.isEmpty() || result.size() == typesRemainingToValidate.size()) {
                return result;
            }
            typesRemainingToValidate = MutableList.copyOf(result.keySet());
        }
    }

    @Beta
    public Collection<Throwable> validateType(RegisteredType typeToValidate, RegisteredTypeLoadingContext constraint) {
        ReferenceWithError<RegisteredType> result = this.resolve(typeToValidate, constraint);
        if (result.hasError()) {
            if (RegisteredTypes.isTemplate(typeToValidate)) {
                return Collections.emptySet();
            }
            if (result.getError() instanceof CompoundRuntimeException) {
                return ((CompoundRuntimeException)result.getError()).getAllCauses();
            }
            return Collections.singleton(result.getError());
        }
        ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).addToLocalUnpersistedTypeRegistry((RegisteredType)result.get(), true);
        return Collections.emptySet();
    }

    @Beta
    public ReferenceWithError<RegisteredType> resolve(RegisteredType typeToValidate, RegisteredTypeLoadingContext constraint) {
        Object resultO;
        RegisteredType resultT;
        Set supers;
        MutableList guesserErrors;
        Exception beanError;
        Exception specError;
        IllegalStateException inconsistentSuperTypesError;
        block28: {
            inconsistentSuperTypesError = null;
            specError = null;
            beanError = null;
            guesserErrors = MutableList.of();
            supers = typeToValidate.getSuperTypes();
            BrooklynObjectType boType = null;
            for (Object superI : supers) {
                BrooklynObjectType boTypeI = null;
                if (superI instanceof BrooklynObject) {
                    boTypeI = BrooklynObjectType.of((BrooklynObject)((BrooklynObject)superI));
                } else if (superI instanceof Class) {
                    boTypeI = BrooklynObjectType.of((Class)((Class)superI));
                }
                if (boTypeI == null || boTypeI == BrooklynObjectType.UNKNOWN) continue;
                if (boType == null) {
                    boType = boTypeI;
                    continue;
                }
                if (boTypeI == boType) continue;
                inconsistentSuperTypesError = new IllegalStateException("Inconsistent supertypes for " + typeToValidate + "; indicates " + boType + " and " + boTypeI);
            }
            Class superJ = null;
            for (Object superI : supers) {
                if (!(superI instanceof Class)) continue;
                if (superJ == null) {
                    superJ = (Class)superI;
                    continue;
                }
                if (!superJ.isAssignableFrom((Class)superI)) continue;
                superJ = (Class)superI;
            }
            resultT = null;
            resultO = null;
            if (resultO == null && boType != null) {
                try {
                    resultT = RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, typeToValidate);
                    try {
                        resultO = ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).createSpec(resultT, constraint, boType.getSpecType());
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        specError = e;
                        resultT = null;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
            }
            if (resultO == null) {
                try {
                    resultT = RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.BEAN, typeToValidate);
                    try {
                        resultO = ((BasicBrooklynTypeRegistry)this.mgmt.getTypeRegistry()).createBean(resultT, constraint, superJ);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        beanError = e;
                        resultT = null;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
            }
            if (resultO == null && (constraint == null || constraint.getAlreadyEncounteredTypes().isEmpty())) {
                try {
                    String yaml = RegisteredTypes.getImplementationDataStringForSpec(typeToValidate);
                    PlanInterpreterGuessingType guesser = new PlanInterpreterGuessingType(typeToValidate.getSymbolicName(), Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)yaml)), yaml, null, CatalogItemDtoAbstract.parseLibraries(typeToValidate.getLibraries()), null);
                    guesser.reconstruct();
                    guesserErrors.addAll(guesser.getErrors());
                    if (guesser.isResolved()) {
                        CatalogItem.CatalogItemType ciType = guesser.getCatalogItemType();
                        boolean changedSomething = false;
                        resultT = typeToValidate;
                        if (boType == null && (boType = BrooklynObjectType.of((CatalogItem.CatalogItemType)ciType)) != null) {
                            supers = MutableSet.copyOf((Iterable)supers);
                            supers.add(boType.getInterfaceType());
                            resultT = RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, resultT);
                            RegisteredTypes.addSuperTypes(resultT, supers);
                            changedSomething = true;
                        }
                        if (!Objects.equal((Object)guesser.getPlanYaml(), (Object)yaml)) {
                            RegisteredTypes.changePlanNotingEquivalent(resultT, new BasicTypeImplementationPlan(null, guesser.getPlanYaml()));
                            changedSomething = true;
                        }
                        if (changedSomething) {
                            return this.resolve(resultT, constraint);
                        }
                        if (Objects.equal((Object)boType, (Object)BrooklynObjectType.of((CatalogItem.CatalogItemType)ciType))) {
                            if (specError == null) {
                                throw new IllegalStateException("Guesser resolved but TypeRegistry couldn't create");
                            }
                            break block28;
                        }
                        throw new IllegalStateException("Guesser resolved as " + ciType + " but we expected " + boType);
                    }
                    throw new IllegalStateException("Guesser could not resolve");
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    guesserErrors.add(e);
                    resultT = null;
                }
            }
        }
        if (resultO != null && resultT != null) {
            if (resultO instanceof BrooklynObject) {
                return this.resolve(RegisteredTypes.copyResolved(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, typeToValidate), constraint);
            }
            RegisteredTypes.cacheActualJavaType(resultT, resultO.getClass());
            supers = MutableSet.copyOf((Iterable)supers);
            supers.add(resultO.getClass());
            supers.add(BrooklynObjectType.of(resultO.getClass()).getInterfaceType());
            RegisteredTypes.addSuperTypes(resultT, supers);
            return ReferenceWithError.newInstanceWithoutError((Object)resultT);
        }
        MutableList errors = MutableList.of().appendIfNotNull(inconsistentSuperTypesError).appendAll((Iterable)guesserErrors).appendIfNotNull(beanError).appendIfNotNull((Object)specError);
        return ReferenceWithError.newInstanceThrowingError(null, (Throwable)Exceptions.create((String)("Could not resolve " + typeToValidate), (Iterable)errors));
    }

    private CatalogItem<?, ?> addItemDto(CatalogItemDtoAbstract<?, ?> itemDto, boolean forceUpdate) {
        CatalogItem<?, ?> existingDto = this.checkItemAllowedAndIfSoReturnAnyDuplicate(itemDto, true, forceUpdate);
        if (existingDto != null) {
            log.trace("Using existing duplicate for catalog item {}", (Object)itemDto.getId());
            return existingDto;
        }
        this.specCache.invalidate();
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.addEntry(itemDto);
        this.getCatalog().addEntry(itemDto);
        if (log.isTraceEnabled()) {
            log.trace("Scheduling item for persistence addition: {}", (Object)itemDto.getId());
        }
        this.onAdditionUpdateOtherRegistries(itemDto);
        this.mgmt.getRebindManager().getChangeListener().onManaged(itemDto);
        return itemDto;
    }

    private void onAdditionUpdateOtherRegistries(CatalogItemDtoAbstract<?, ?> itemDto) {
    }

    private CatalogItem<?, ?> checkItemAllowedAndIfSoReturnAnyDuplicate(CatalogItem<?, ?> itemDto, boolean allowDuplicates, boolean forceUpdate) {
        if (forceUpdate) {
            return null;
        }
        if (itemDto.getVersion().contains("SNAPSHOT")) {
            return null;
        }
        CatalogItemDo<?, ?> existingItem = this.getCatalogItemDo(itemDto.getSymbolicName(), itemDto.getVersion());
        if (existingItem == null) {
            return null;
        }
        CatalogItem<?, ?> existingDto = existingItem.getDto();
        if (existingDto.equals(itemDto)) {
            if (allowDuplicates) {
                return existingItem;
            }
            throw new IllegalStateException("Not allowed to update existing catalog entries, even with the same content: " + itemDto.getSymbolicName() + ":" + itemDto.getVersion());
        }
        throw new IllegalStateException("Cannot add " + itemDto.getSymbolicName() + ":" + itemDto.getVersion() + " to catalog; a different definition is already present");
    }

    @Deprecated
    public void addItem(CatalogItem<?, ?> item) {
        this.specCache.invalidate();
        log.debug("Adding manual catalog item to " + this.mgmt + ": " + item);
        Preconditions.checkNotNull(item, (Object)"item");
        CatalogUtils.installLibraries(this.mgmt, item.getLibraries());
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.addEntry(this.getAbstractCatalogItem(item));
    }

    @Deprecated
    public CatalogItem<?, ?> addItem(Class<?> type) {
        log.debug("Adding manual catalog item to " + this.mgmt + ": " + type);
        Preconditions.checkNotNull(type, (Object)"type");
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsClasses.registerClass(type);
        CatalogItem<?, ?> result = this.manualAdditionsCatalog.classpath.addCatalogEntry(type);
        this.specCache.invalidate();
        return result;
    }

    private synchronized void loadManualAdditionsCatalog() {
        if (this.manualAdditionsCatalog != null) {
            return;
        }
        CatalogDto manualAdditionsCatalogDto = CatalogDto.newNamedInstance("Manual Catalog Additions", "User-additions to the catalog while Brooklyn is running, created " + Time.makeDateString(), "manual-additions");
        CatalogDo manualAdditionsCatalog = this.catalog.addCatalog(manualAdditionsCatalogDto);
        if (manualAdditionsCatalog == null) {
            log.warn("Blocking until catalog is loaded before changing it");
            boolean loaded = this.blockIfNotLoaded(Duration.TEN_SECONDS);
            if (!loaded) {
                log.warn("Catalog still not loaded after delay; subsequent operations may fail");
            }
            if ((manualAdditionsCatalog = this.catalog.addCatalog(manualAdditionsCatalogDto)) == null) {
                throw new UnsupportedOperationException("Catalogs cannot be added until the base catalog is loaded, and catalog is taking a while to load!");
            }
        }
        log.debug("Creating manual additions catalog for " + this.mgmt + ": " + manualAdditionsCatalog);
        this.manualAdditionsClasses = new LoadedClassLoader();
        ((AggregateClassLoader)manualAdditionsCatalog.classpath.getLocalClassLoader()).addFirst((ClassLoader)this.manualAdditionsClasses);
        this.manualAdditionsCatalog = manualAdditionsCatalog;
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItems() {
        MutableMap result = MutableMap.of();
        if (!this.getCatalog().isLoaded()) {
            log.debug("Forcing catalog load on access of catalog items");
            this.load();
        }
        for (RegisteredType rt : this.mgmt.getTypeRegistry().getAll()) {
            result.put(rt.getId(), RegisteredTypes.toPartialCatalogItem(rt));
        }
        result.putAll(this.catalog.getIdCache());
        return result.values();
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItemsLegacy() {
        if (!this.getCatalog().isLoaded()) {
            log.debug("Forcing catalog load on access of catalog items");
            this.load();
        }
        return ImmutableList.copyOf(this.catalog.getIdCache().values());
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItems(Predicate<? super CatalogItem<T, SpecT>> filter) {
        Iterable filtered = Iterables.filter(this.getCatalogItems(), filter);
        return Iterables.transform((Iterable)filtered, BasicBrooklynCatalog.itemDoToDto());
    }

    @Deprecated
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItemsLegacy(Predicate<? super CatalogItem<T, SpecT>> filter) {
        Iterable filtered = Iterables.filter(this.catalog.getIdCache().values(), filter);
        return Iterables.transform((Iterable)filtered, BasicBrooklynCatalog.itemDoToDto());
    }

    private static <T, SpecT> Function<CatalogItem<T, SpecT>, CatalogItem<T, SpecT>> itemDoToDto() {
        return new Function<CatalogItem<T, SpecT>, CatalogItem<T, SpecT>>(){

            public CatalogItem<T, SpecT> apply(@Nullable CatalogItem<T, SpecT> item) {
                if (!(item instanceof CatalogItemDo)) {
                    return item;
                }
                return ((CatalogItemDo)item).getDto();
            }
        };
    }

    private static <T, SpecT> Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>> itemDoToDtoAddingSelectedMetadataDuringScan(final ManagementContext mgmt, final Map<?, ?> catalogMetadata, final ManagedBundle containingBundle) {
        return new Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>>(){

            public CatalogItem<T, SpecT> apply(@Nullable CatalogItemDo<T, SpecT> item) {
                if (item == null) {
                    return null;
                }
                CatalogItemDtoAbstract dto = (CatalogItemDtoAbstract)item.getDto();
                String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
                if (Strings.isNonBlank((CharSequence)version)) {
                    dto.setVersion(version);
                }
                MutableSet libraryBundles = MutableSet.of();
                if (!BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(mgmt, containingBundle)) {
                    libraryBundles.add(new CatalogBundleDto(containingBundle.getSymbolicName(), containingBundle.getSuppliedVersionString(), null));
                }
                libraryBundles.addAll(dto.getLibraries());
                Object librariesInherited = catalogMetadata.get("brooklyn.libraries");
                if (librariesInherited instanceof Collection) {
                    libraryBundles.addAll(BasicBrooklynCatalog.resolveWherePossible(mgmt, CatalogItemDtoAbstract.parseLibraries((Collection)librariesInherited)));
                }
                if ((librariesInherited = catalogMetadata.get("libraries")) instanceof Collection) {
                    log.warn("Legacy 'libraries' encountered; use 'brooklyn.libraries'");
                    libraryBundles.addAll(BasicBrooklynCatalog.resolveWherePossible(mgmt, CatalogItemDtoAbstract.parseLibraries((Collection)librariesInherited)));
                }
                dto.setLibraries((Collection<CatalogItem.CatalogBundle>)libraryBundles);
                if (containingBundle != null && dto.getContainingBundle() == null) {
                    dto.setContainingBundle(containingBundle.getVersionedName());
                }
                dto.setSymbolicName(dto.getJavaType());
                switch (dto.getCatalogItemType()) {
                    case TEMPLATE: 
                    case ENTITY: {
                        dto.setPlanYaml("services: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case POLICY: {
                        dto.setPlanYaml("brooklyn.policies: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case ENRICHER: {
                        dto.setPlanYaml("brooklyn.enrichers: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case LOCATION: {
                        dto.setPlanYaml("brooklyn.locations: [{ type: " + dto.getJavaType() + " }]");
                    }
                }
                dto.setJavaType(null);
                return dto;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallEmptyWrapperBundles() {
        log.debug("uninstalling empty wrapper bundles");
        Object object = this.uninstallingEmptyLock;
        synchronized (object) {
            Maybe<OsgiManager> osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager();
            if (osgi.isAbsent()) {
                return;
            }
            for (ManagedBundle b : ((OsgiManager)osgi.get()).getInstalledWrapperBundles()) {
                Iterable<RegisteredType> typesInBundle;
                if (!BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.mgmt, b) || !Iterables.isEmpty(typesInBundle = ((OsgiManager)osgi.get()).getTypesFromBundle(b.getVersionedName()))) continue;
                log.info("Uninstalling now-empty BOM wrapper bundle " + b.getVersionedName() + " (" + b.getOsgiUniqueUrl() + ")");
                ((OsgiManager)osgi.get()).uninstallUploadedBundle(b);
            }
        }
    }

    private static class SpecCache {
        private final Map<String, AbstractBrooklynObjectSpec<?, ?>> cache = Collections.synchronizedMap(Maps.newLinkedHashMap());

        private SpecCache() {
        }

        public void invalidate() {
            this.cache.clear();
        }

        public Optional<AbstractBrooklynObjectSpec<?, ?>> getSpec(String itemId) {
            return Optional.fromNullable(this.cache.get(itemId));
        }

        public void addSpec(String itemId, AbstractBrooklynObjectSpec<?, ?> spec) {
            this.cache.put(itemId, spec);
        }
    }

    private class PlanInterpreterGuessingType {
        final String idAsSymbolicNameWithoutVersion;
        final Map<?, ?> item;
        final String itemYaml;
        final Collection<CatalogItem.CatalogBundle> libraryBundles;
        final List<CatalogItemDtoAbstract<?, ?>> itemsDefinedSoFar;
        CatalogItem.CatalogItemType catalogItemType;
        String planYaml;
        boolean resolved = false;
        List<Exception> errors = MutableList.of();
        List<Exception> entityErrors = MutableList.of();

        public PlanInterpreterGuessingType(String idAsSymbolicNameWithoutVersion, Object itemDefinitionParsedToStringOrMap, @Nullable String itemYaml, CatalogItem.CatalogItemType optionalCiType, Collection<CatalogItem.CatalogBundle> libraryBundles, List<CatalogItemDtoAbstract<?, ?>> itemsDefinedSoFar) {
            this.idAsSymbolicNameWithoutVersion = idAsSymbolicNameWithoutVersion;
            if (itemDefinitionParsedToStringOrMap instanceof String) {
                this.item = MutableMap.of((Object)"type", (Object)itemDefinitionParsedToStringOrMap);
                this.itemYaml = "type:\n" + BasicBrooklynCatalog.this.makeAsIndentedObject(itemYaml);
            } else if (itemDefinitionParsedToStringOrMap instanceof Map) {
                this.item = (Map)itemDefinitionParsedToStringOrMap;
                this.itemYaml = itemYaml;
            } else {
                throw new IllegalArgumentException("Item definition should be a string or map to use the guesser");
            }
            this.catalogItemType = optionalCiType;
            this.libraryBundles = libraryBundles;
            this.itemsDefinedSoFar = itemsDefinedSoFar;
        }

        public PlanInterpreterGuessingType reconstruct() {
            if (this.catalogItemType == CatalogItem.CatalogItemType.TEMPLATE) {
                this.attemptType(null, CatalogItem.CatalogItemType.TEMPLATE);
            } else {
                this.attemptType(null, CatalogItem.CatalogItemType.ENTITY);
                MutableList oldEntityErrors = MutableList.copyOf(this.entityErrors);
                this.attemptType("services", CatalogItem.CatalogItemType.ENTITY);
                this.entityErrors.removeAll((Collection<?>)oldEntityErrors);
                this.entityErrors.addAll((Collection<Exception>)oldEntityErrors);
                this.attemptType(BasicBrooklynCatalog.POLICIES_KEY, CatalogItem.CatalogItemType.POLICY);
                this.attemptType(BasicBrooklynCatalog.ENRICHERS_KEY, CatalogItem.CatalogItemType.ENRICHER);
                this.attemptType(BasicBrooklynCatalog.LOCATIONS_KEY, CatalogItem.CatalogItemType.LOCATION);
            }
            if (!this.resolved && this.catalogItemType == CatalogItem.CatalogItemType.TEMPLATE) {
                this.planYaml = this.itemYaml;
                this.resolved = true;
            }
            return this;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public List<Exception> getErrors() {
            if (this.errors.isEmpty()) {
                return this.entityErrors;
            }
            return this.errors;
        }

        public CatalogItem.CatalogItemType getCatalogItemType() {
            return this.catalogItemType;
        }

        public String getPlanYaml() {
            return this.planYaml;
        }

        private boolean attemptType(String key, CatalogItem.CatalogItemType candidateCiType) {
            if (this.resolved) {
                return false;
            }
            if (this.catalogItemType != null && this.catalogItemType != candidateCiType) {
                return false;
            }
            String candidateYaml = key == null ? this.itemYaml : (this.item.containsKey(key) ? this.itemYaml : key + ":\n" + BasicBrooklynCatalog.this.makeAsIndentedList(this.itemYaml));
            String type = (String)this.item.get("type");
            if (this.itemsDefinedSoFar != null) {
                if (type != null && key != null) {
                    for (CatalogItemDtoAbstract<?, ?> candidate : this.itemsDefinedSoFar) {
                        if (candidateCiType != candidate.getCatalogItemType() || !type.equals(candidate.getSymbolicName()) && !type.equals(candidate.getId())) continue;
                        this.catalogItemType = candidateCiType;
                        this.planYaml = candidateYaml;
                        this.resolved = true;
                        return true;
                    }
                }
                String typeWithId = type;
                String version = null;
                if (CatalogUtils.looksLikeVersionedId(type)) {
                    version = CatalogUtils.getVersionFromVersionedId(type);
                    type = CatalogUtils.getSymbolicNameFromVersionedId(type);
                }
                if (type != null && key != null) {
                    for (CatalogItemDtoAbstract<?, ?> candidate : this.itemsDefinedSoFar) {
                        if (candidateCiType != candidate.getCatalogItemType() || !type.equals(candidate.getSymbolicName()) && !type.equals(candidate.getId()) || version != null && !version.equals(candidate.getVersion())) continue;
                        log.error("Lookup of '" + type + "' version '" + version + "' only worked using legacy routines; please advise Brooklyn community so they understand why");
                        this.catalogItemType = candidateCiType;
                        this.planYaml = candidateYaml;
                        this.resolved = true;
                        return true;
                    }
                }
                type = typeWithId;
            }
            try {
                Object itemToAttempt = BasicBrooklynCatalog.createItemBuilder(candidateCiType, this.getIdWithRandomDefault(), "0.0.0_DEFAULT_VERSION").plan(candidateYaml).libraries(this.libraryBundles).build();
                Object spec = BasicBrooklynCatalog.internalCreateSpecLegacy(BasicBrooklynCatalog.this.mgmt, itemToAttempt, (Set<String>)MutableSet.of(), true);
                if (spec != null) {
                    this.catalogItemType = candidateCiType;
                    this.planYaml = candidateYaml;
                    this.resolved = true;
                }
                return true;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (this.item.containsKey("services") && (candidateCiType == CatalogItem.CatalogItemType.ENTITY || candidateCiType == CatalogItem.CatalogItemType.TEMPLATE)) {
                    this.errors.add(e);
                } else if (this.catalogItemType != null && key != null) {
                    this.errors.add(e);
                } else {
                    if (candidateCiType == CatalogItem.CatalogItemType.ENTITY) {
                        this.entityErrors.add(e);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Guessing type of plan, it looks like it isn't " + candidateCiType + "/" + key + ": " + e);
                    }
                }
                if (type != null && key != null) {
                    try {
                        String cutDownYaml = key + ":\n" + BasicBrooklynCatalog.this.makeAsIndentedList("type: " + type);
                        Object itemToAttempt = BasicBrooklynCatalog.createItemBuilder(candidateCiType, this.getIdWithRandomDefault(), "0.0.0_DEFAULT_VERSION").plan(cutDownYaml).libraries(this.libraryBundles).build();
                        Object cutdownSpec = BasicBrooklynCatalog.internalCreateSpecLegacy(BasicBrooklynCatalog.this.mgmt, itemToAttempt, (Set<String>)MutableSet.of(), true);
                        if (cutdownSpec != null) {
                            this.catalogItemType = candidateCiType;
                            this.planYaml = candidateYaml;
                            this.resolved = true;
                        }
                        return true;
                    }
                    catch (Exception e2) {
                        Exceptions.propagateIfFatal((Throwable)e2);
                    }
                }
                return false;
            }
        }

        private String getIdWithRandomDefault() {
            return this.idAsSymbolicNameWithoutVersion != null ? this.idAsSymbolicNameWithoutVersion : Strings.makeRandomId((int)10);
        }

        public Map<?, ?> getItem() {
            return this.item;
        }
    }

    public static class BrooklynLoaderTracker {
        public static final ThreadLocal<BrooklynClassLoadingContext> loader = new ThreadLocal();

        public static void setLoader(BrooklynClassLoadingContext val) {
            loader.set(val);
        }

        public static void unsetLoader(BrooklynClassLoadingContext val) {
            loader.set(null);
        }

        public static BrooklynClassLoadingContext getLoader() {
            return loader.get();
        }
    }
}

