/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

final class OSGiCredentialsProvider
implements CredentialsProvider {
    private final BundleContext bundleContext;
    private final Map<String, ServiceRegistration> registeredConfigurations;

    public OSGiCredentialsProvider(BundleContext bundleContext, Map<String, ServiceRegistration> registeredConfigurations) {
        this.bundleContext = bundleContext;
        this.registeredConfigurations = registeredConfigurations;
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
    }

    @Override
    public Credentials getCredentials(AuthScope authscope) {
        for (ServiceRegistration registration : this.registeredConfigurations.values()) {
            AuthScope actual;
            ProxyConfiguration proxyConfiguration;
            Object proxyConfigurationObject = this.bundleContext.getService(registration.getReference());
            if (proxyConfigurationObject == null || !(proxyConfiguration = (ProxyConfiguration)proxyConfigurationObject).isEnabled() || authscope.match(actual = new AuthScope(proxyConfiguration.getHostname(), proxyConfiguration.getPort())) < 12) continue;
            return new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword());
        }
        return null;
    }

    @Override
    public void clear() {
    }
}

