/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.osgi;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class VersionedName {
    private final String name;
    private final String v;
    @Deprecated
    private final String symbolicName;
    @Deprecated
    private final Version version = null;
    private transient Version cachedOsgiVersion;

    private Object readResolve() {
        if (this.symbolicName != null || this.version != null) {
            return new VersionedName(this.symbolicName, BrooklynVersionSyntax.toGoodBrooklynVersion(this.version.toString()));
        }
        return this;
    }

    public VersionedName(Bundle b) {
        this(b.getSymbolicName(), b.getVersion().toString());
    }

    public VersionedName(String name, String v) {
        this.symbolicName = null;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.v = v;
    }

    public VersionedName(String name, @Nullable Version v) {
        this.symbolicName = null;
        this.name = ((String)Preconditions.checkNotNull((Object)name, (Object)"name")).toString();
        this.v = v == null ? null : v.toString();
    }

    public String toString() {
        return this.name + ":" + this.v;
    }

    public String toOsgiString() {
        return this.name + ":" + this.getOsgiVersion();
    }

    public boolean equals(String sn, String v) {
        return this.name.equals(sn) && Objects.equal((Object)this.v, (Object)v);
    }

    public boolean equals(String sn, Version v) {
        return this.name.equals(sn) && Objects.equal((Object)this.getOsgiVersion(), (Object)v);
    }

    public String getSymbolicName() {
        return this.name;
    }

    @Nullable
    public Version getOsgiVersion() {
        if (this.cachedOsgiVersion == null && this.v != null) {
            this.cachedOsgiVersion = this.v == null ? null : Version.parseVersion((String)BrooklynVersionSyntax.toValidOsgiVersion(this.v));
        }
        return this.cachedOsgiVersion;
    }

    @Nullable
    public String getOsgiVersionString() {
        Version ov = this.getOsgiVersion();
        if (ov == null) {
            return null;
        }
        return ov.toString();
    }

    @Nullable
    public String getVersionString() {
        return this.v;
    }

    @Deprecated
    public Version getVersion() {
        return this.getOsgiVersion();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.v});
    }

    public boolean equals(Object other) {
        if (!(other instanceof VersionedName)) {
            return false;
        }
        VersionedName o = (VersionedName)other;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal((Object)this.v, (Object)o.v);
    }

    public boolean equalsOsgi(Object other) {
        if (other instanceof String) {
            other = VersionedName.fromString((String)other);
        }
        if (!(other instanceof VersionedName)) {
            return false;
        }
        VersionedName o = (VersionedName)other;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal((Object)this.getOsgiVersion(), (Object)o.getOsgiVersion());
    }

    public static VersionedName toOsgiVersionedName(VersionedName vn) {
        if (vn == null) {
            return null;
        }
        return new VersionedName(vn.getSymbolicName(), vn.getOsgiVersion());
    }

    public static VersionedName fromString(String vn) {
        return VersionedName.parseMaybe(vn, false).get();
    }

    public static Maybe<VersionedName> parseMaybe(String symbolicNameWithVersion, boolean versionRequired) {
        if (Strings.isBlank(symbolicNameWithVersion)) {
            return Maybe.absent("Identifier is blank");
        }
        String[] parts = symbolicNameWithVersion.split(":");
        if (versionRequired && parts.length != 2) {
            return Maybe.absent("Identifier '" + symbolicNameWithVersion + "' must be of 'name:version' syntax");
        }
        if (parts.length > 2) {
            return Maybe.absent("Identifier '" + symbolicNameWithVersion + "' has too many parts; max one ':' symbol");
        }
        return Maybe.of(new VersionedName(parts[0], parts.length == 2 ? parts[1] : null));
    }
}

