/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AggregateClassLoader
extends ClassLoader {
    private final CopyOnWriteArrayList<ClassLoader> classLoaders = new CopyOnWriteArrayList();

    private AggregateClassLoader() {
        super(null);
    }

    public static AggregateClassLoader newInstanceWithDefaultLoaders() {
        AggregateClassLoader cl = new AggregateClassLoader();
        cl.addFirst(AggregateClassLoader.class.getClassLoader());
        cl.addFirst(Object.class.getClassLoader());
        return cl;
    }

    public static AggregateClassLoader newInstanceWithNoLoaders() {
        return new AggregateClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(ClassLoader classLoader) {
        if (classLoader != null) {
            CopyOnWriteArrayList<ClassLoader> copyOnWriteArrayList = this.classLoaders;
            synchronized (copyOnWriteArrayList) {
                this.classLoaders.add(0, classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(ClassLoader classLoader) {
        if (classLoader != null) {
            CopyOnWriteArrayList<ClassLoader> copyOnWriteArrayList = this.classLoaders;
            synchronized (copyOnWriteArrayList) {
                this.classLoaders.add(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, ClassLoader classLoader) {
        if (classLoader != null) {
            CopyOnWriteArrayList<ClassLoader> copyOnWriteArrayList = this.classLoaders;
            synchronized (copyOnWriteArrayList) {
                this.classLoaders.add(index, classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Collection<? extends ClassLoader> newClassLoaders) {
        CopyOnWriteArrayList<ClassLoader> copyOnWriteArrayList = this.classLoaders;
        synchronized (copyOnWriteArrayList) {
            int count = this.classLoaders.size();
            this.classLoaders.addAll(newClassLoaders);
            for (int i = 0; i < count; ++i) {
                this.classLoaders.remove(0);
            }
        }
    }

    public boolean isEmpty() {
        return this.classLoaders.isEmpty();
    }

    @Deprecated
    public List<ClassLoader> getList() {
        return this.classLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ClassLoader> iterator() {
        CopyOnWriteArrayList<ClassLoader> copyOnWriteArrayList = this.classLoaders;
        synchronized (copyOnWriteArrayList) {
            return this.classLoaders.iterator();
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader.loadClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    public String toString() {
        return "AggregateClassLoader" + this.classLoaders;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        Iterator<ClassLoader> cli = this.iterator();
        while (cli.hasNext()) {
            ClassLoader classLoader = cli.next();
            result = classLoader.getResource(name);
            if (result == null) continue;
            return result;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader.getResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet resources = Sets.newLinkedHashSet();
        Iterator<ClassLoader> cli = this.iterator();
        while (cli.hasNext()) {
            ClassLoader classLoader = cli.next();
            resources.addAll(Collections.list(classLoader.getResources(name)));
        }
        return Collections.enumeration(resources);
    }
}

