/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.TimestampedValue;
import org.apache.brooklyn.util.time.Duration;

public class TimeWindowedList<T> {
    private final LinkedList<TimestampedValue<T>> values = new LinkedList();
    private volatile Duration timePeriod;
    private final int minVals;
    private final int minExpiredVals;

    public TimeWindowedList(Duration timePeriod) {
        this.timePeriod = timePeriod;
        this.minVals = 0;
        this.minExpiredVals = 0;
    }

    @Deprecated
    public TimeWindowedList(long timePeriod) {
        this(Duration.millis(timePeriod));
    }

    public TimeWindowedList(Map<String, ?> flags) {
        if (!flags.containsKey("timePeriod")) {
            throw new IllegalArgumentException("Must define timePeriod");
        }
        this.timePeriod = Duration.of(flags.get("timePeriod"));
        this.minVals = flags.containsKey("minVals") ? ((Number)flags.get("minVals")).intValue() : 0;
        this.minExpiredVals = flags.containsKey("minExpiredVals") ? ((Number)flags.get("minExpiredVals")).intValue() : 0;
    }

    public void setTimePeriod(Duration newTimePeriod) {
        this.timePeriod = newTimePeriod;
    }

    public synchronized T getLatestValue() {
        return this.values.isEmpty() ? null : (T)this.values.get(this.values.size() - 1).getValue();
    }

    public List<TimestampedValue<T>> getValues() {
        return this.getValues(System.currentTimeMillis());
    }

    public synchronized List<TimestampedValue<T>> getValues(long now) {
        this.pruneValues(now);
        return ImmutableList.copyOf(this.values);
    }

    public synchronized List<TimestampedValue<T>> getValuesInWindow(long now, Duration subTimePeriod) {
        long startTime = now - subTimePeriod.toMilliseconds();
        LinkedList<TimestampedValue<T>> result = new LinkedList<TimestampedValue<T>>();
        TimestampedValue mostRecentExpired = null;
        for (TimestampedValue timestampedValue : this.values) {
            if (timestampedValue.getTimestamp() < startTime) {
                mostRecentExpired = timestampedValue;
                continue;
            }
            result.add(timestampedValue);
        }
        if (this.minExpiredVals > 0 && mostRecentExpired != null) {
            result.add(0, mostRecentExpired);
        }
        if (result.size() < this.minVals) {
            int minIndex = Math.max(0, this.values.size() - this.minVals);
            return ImmutableList.copyOf(this.values.subList(minIndex, this.values.size()));
        }
        return result;
    }

    public void add(T val) {
        this.add(val, System.currentTimeMillis());
    }

    public synchronized void add(T val, long timestamp) {
        this.values.add(this.values.size(), new TimestampedValue<T>(val, timestamp));
        this.pruneValues(timestamp);
    }

    public synchronized void pruneValues(long now) {
        long startTime = now - this.timePeriod.toMilliseconds();
        int expiredValsCount = 0;
        if (this.timePeriod.equals(Duration.ZERO)) {
            expiredValsCount = this.values.size();
        } else {
            TimestampedValue val;
            Iterator iterator = this.values.iterator();
            while (iterator.hasNext() && (val = (TimestampedValue)iterator.next()).getTimestamp() < startTime) {
                ++expiredValsCount;
            }
        }
        int numToPrune = Math.min(expiredValsCount - this.minExpiredVals, this.values.size() - this.minVals);
        for (int i = 0; i < numToPrune; ++i) {
            this.values.removeFirst();
        }
    }

    public String toString() {
        return "timePeriod=" + this.timePeriod + ", vals=" + this.values;
    }
}

