/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base.lifecycle;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.software.base.lifecycle.NaiveScriptRunner;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptPart;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.groovy.GroovyJavaMethods;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptHelper {
    public static final Logger log = LoggerFactory.getLogger(ScriptHelper.class);
    protected final NaiveScriptRunner runner;
    public final String summary;
    public final ScriptPart header = new ScriptPart(this);
    public final ScriptPart body = new ScriptPart(this);
    public final ScriptPart footer = new ScriptPart(this);
    protected final Map flags = new LinkedHashMap();
    protected Predicate<? super Integer> resultCodeCheck = Predicates.alwaysTrue();
    protected Predicate<? super ScriptHelper> executionCheck = Predicates.alwaysTrue();
    protected boolean isTransient = false;
    protected boolean isInessential = false;
    protected boolean closeSshConnection = false;
    protected boolean gatherOutput = false;
    protected boolean noExtraOutput = false;
    protected ByteArrayOutputStream stdout;
    protected ByteArrayOutputStream stderr;
    protected Task<Integer> task;
    protected Runnable mutexAcquire = new Runnable(){

        @Override
        public void run() {
        }
    };
    protected Runnable mutexRelease = new Runnable(){

        @Override
        public void run() {
        }
    };

    public ScriptHelper(NaiveScriptRunner runner, String summary) {
        this.runner = runner;
        this.summary = summary;
    }

    @Deprecated
    public ScriptHelper executeIf(Closure c) {
        Predicate predicate = GroovyJavaMethods.predicateFromClosure((Closure)c);
        return this.executeIf((Predicate<? super ScriptHelper>)predicate);
    }

    public ScriptHelper executeIf(Predicate<? super ScriptHelper> c) {
        this.executionCheck = c;
        return this;
    }

    public ScriptHelper skipIfBodyEmpty() {
        Predicate<ScriptHelper> p = new Predicate<ScriptHelper>(){

            public boolean apply(ScriptHelper input) {
                return !input.body.isEmpty();
            }
        };
        return this.executeIf((Predicate<? super ScriptHelper>)p);
    }

    public ScriptHelper failIfBodyEmpty() {
        Predicate<ScriptHelper> p = new Predicate<ScriptHelper>(){

            public boolean apply(ScriptHelper input) {
                if (input.body.isEmpty()) {
                    throw new IllegalStateException("body empty for " + ScriptHelper.this.summary);
                }
                return true;
            }
        };
        return this.executeIf((Predicate<? super ScriptHelper>)p);
    }

    public ScriptHelper failOnNonZeroResultCode(boolean val) {
        if (val) {
            this.failOnNonZeroResultCode();
        } else {
            this.requireResultCode((Predicate<? super Integer>)Predicates.alwaysTrue());
        }
        return this;
    }

    public ScriptHelper failOnNonZeroResultCode() {
        return this.updateTaskAndFailOnNonZeroResultCode();
    }

    public ScriptHelper failOnNonZeroResultCodeWithoutUpdatingTask() {
        this.requireResultCode((Predicate<? super Integer>)Predicates.equalTo((Object)0));
        return this;
    }

    public ScriptHelper updateTaskAndFailOnNonZeroResultCode() {
        this.gatherOutput();
        this.resultCodeCheck = new Predicate<Integer>(){

            public boolean apply(@Nullable Integer input) {
                if (input == 0) {
                    return true;
                }
                try {
                    String notes = "";
                    if (!ScriptHelper.this.getResultStderr().isEmpty()) {
                        notes = notes + "STDERR\n" + ScriptHelper.this.getResultStderr() + "\n";
                    }
                    if (!ScriptHelper.this.getResultStdout().isEmpty()) {
                        notes = notes + "\nSTDOUT\n" + ScriptHelper.this.getResultStdout() + "\n";
                    }
                    Tasks.setExtraStatusDetails((String)notes.trim());
                }
                catch (Exception e) {
                    log.warn("Unable to collect additional metadata on failure of " + ScriptHelper.this.summary + ": " + e);
                }
                return false;
            }
        };
        return this;
    }

    @Deprecated
    public ScriptHelper requireResultCode(Closure integerFilter) {
        Predicate objectPredicate = GroovyJavaMethods.predicateFromClosure((Closure)integerFilter);
        return this.requireResultCode((Predicate<? super Integer>)objectPredicate);
    }

    public ScriptHelper requireResultCode(Predicate<? super Integer> integerFilter) {
        this.resultCodeCheck = integerFilter;
        return this;
    }

    public ScriptHelper useMutex(final WithMutexes mutexSupport, final String mutexId, final String description) {
        this.mutexAcquire = new Runnable(){

            @Override
            public void run() {
                try {
                    mutexSupport.acquireMutex(mutexId, description);
                }
                catch (InterruptedException e) {
                    throw new RuntimeInterruptedException(e);
                }
            }
        };
        this.mutexRelease = new Runnable(){

            @Override
            public void run() {
                mutexSupport.releaseMutex(mutexId);
            }
        };
        return this;
    }

    public ScriptHelper gatherOutput() {
        return this.gatherOutput(true);
    }

    public ScriptHelper gatherOutput(boolean gather) {
        this.gatherOutput = gather;
        return this;
    }

    public ScriptHelper noExtraOutput() {
        return this.noExtraOutput(true);
    }

    private ScriptHelper noExtraOutput(boolean output) {
        this.noExtraOutput = output;
        return this;
    }

    public ScriptHelper closeSshConnection() {
        this.closeSshConnection = true;
        return this;
    }

    public ScriptHelper uniqueSshConnection() {
        this.setFlag(SshMachineLocation.UNIQUE_ID, Identifiers.makeRandomBase64Id((int)32));
        return this;
    }

    public void setTransient() {
        this.isTransient = true;
    }

    public void setInessential() {
        this.isInessential = true;
    }

    public ScriptHelper inessential() {
        this.isInessential = true;
        return this;
    }

    public synchronized Task<Integer> newTask() {
        if (this.task != null) {
            throw new IllegalStateException("task can only be generated once");
        }
        TaskBuilder tb = Tasks.builder().displayName("ssh: " + this.summary).body((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ScriptHelper.this.executeInternal();
            }
        });
        try {
            ByteArrayOutputStream stdin = new ByteArrayOutputStream();
            for (String line : this.getLines()) {
                stdin.write(line.getBytes());
                stdin.write("\n".getBytes());
            }
            tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdin", (ByteArrayOutputStream)stdin));
        }
        catch (IOException e) {
            log.warn("Error registering stream stdin on " + tb + ": " + e, (Throwable)e);
        }
        Map env = (Map)this.flags.get("env");
        if (env != null) {
            tb.tag((Object)BrooklynTaskTags.tagForEnvStream((String)"env", (Map)env));
        }
        if (this.gatherOutput) {
            this.stdout = new ByteArrayOutputStream();
            tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)this.stdout));
            this.stderr = new ByteArrayOutputStream();
            tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)this.stderr));
        }
        this.task = tb.build();
        if (this.isTransient) {
            BrooklynTaskTags.setTransient(this.task);
        }
        if (this.isInessential) {
            BrooklynTaskTags.setInessential(this.task);
        }
        return this.task;
    }

    public Task<Integer> peekTask() {
        return this.task;
    }

    @Beta
    public Task<Integer> queue() {
        return DynamicTasks.queueIfPossible(this.newTask()).orSubmitAndBlock().getTask();
    }

    public int execute() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            return (Integer)this.queue().getUnchecked();
        }
        return this.executeInternal();
    }

    public int executeInternal() {
        int result;
        if (!this.executionCheck.apply((Object)this)) {
            return 0;
        }
        List<String> lines = this.getLines();
        if (log.isTraceEnabled()) {
            log.trace("executing: {} - {}", (Object)this.summary, lines);
        }
        try {
            this.mutexAcquire.run();
            Map flags = this.getFlags();
            if (this.closeSshConnection) {
                flags.put("close", true);
            }
            if (this.gatherOutput) {
                if (this.stdout == null) {
                    this.stdout = new ByteArrayOutputStream();
                }
                if (this.stderr == null) {
                    this.stderr = new ByteArrayOutputStream();
                }
                flags.put("out", this.stdout);
                flags.put("err", this.stderr);
            }
            flags.put(ShellTool.PROP_NO_EXTRA_OUTPUT.getName(), this.noExtraOutput);
            result = this.runner.execute(flags, lines, this.summary);
        }
        catch (RuntimeInterruptedException e) {
            throw this.logWithDetailsAndThrow(String.format("Execution failed, invocation error for %s: %s", this.summary, e.getMessage()), e);
        }
        catch (Exception e) {
            throw this.logWithDetailsAndThrow(String.format("Execution failed, invocation error for %s: %s", this.summary, e.getMessage()), e);
        }
        finally {
            this.mutexRelease.run();
        }
        if (log.isTraceEnabled()) {
            log.trace("finished executing: {} - result code {}", (Object)this.summary, (Object)result);
        }
        if (!this.resultCodeCheck.apply((Object)result)) {
            throw this.logWithDetailsAndThrow(String.format("Execution failed, invalid result %s for %s", result, this.summary), null);
        }
        return result;
    }

    protected RuntimeException logWithDetailsAndThrow(String message, Throwable optionalCause) {
        log.warn(message + " (throwing)");
        Streams.logStreamTail((Logger)log, (String)("STDERR of problem in " + Tasks.current()), (ByteArrayOutputStream)this.stderr, (int)1024);
        Streams.logStreamTail((Logger)log, (String)("STDOUT of problem in " + Tasks.current()), (ByteArrayOutputStream)this.stdout, (int)1024);
        Streams.logStreamTail((Logger)log, (String)("STDIN of problem in " + Tasks.current()), (ByteArrayOutputStream)Streams.byteArrayOfString((String)Strings.join(this.getLines(), (String)"\n")), (int)4096);
        if (optionalCause != null) {
            throw new IllegalStateException(message, optionalCause);
        }
        throw new IllegalStateException(message);
    }

    public Map getFlags() {
        return this.flags;
    }

    public ScriptHelper setFlag(String flag, Object value) {
        this.flags.put(flag, value);
        return this;
    }

    public <T> ScriptHelper setFlag(ConfigKey<T> flag, T value) {
        return this.setFlag(flag.getName(), value);
    }

    public ScriptHelper environmentVariablesReset() {
        return this.environmentVariablesReset((Map<?, ?>)MutableMap.of());
    }

    public ScriptHelper environmentVariablesReset(Map<?, ?> envVarsToSet) {
        this.setFlag("env", envVarsToSet);
        return this;
    }

    public List<String> getLines() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.header.lines);
        result.addAll(this.body.lines);
        result.addAll(this.footer.lines);
        return result;
    }

    public String getResultStdout() {
        if (this.stdout == null) {
            throw new IllegalStateException("stdout not available on " + this + "; ensure task has completed and gatherOutput(true) is set");
        }
        return this.stdout.toString();
    }

    public String getResultStderr() {
        if (this.stderr == null) {
            throw new IllegalStateException("stderr not available on " + this + "; ensure task has completed and gatherOutput(true) is set");
        }
        return this.stderr.toString();
    }
}

