/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessWinRmDriver;
import org.apache.brooklyn.entity.software.base.VanillaWindowsProcess;
import org.apache.brooklyn.entity.software.base.VanillaWindowsProcessDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.WinRmExecuteHelper;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.net.UserAndHostAndPort;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWindowsProcessWinRmDriver
extends AbstractSoftwareProcessWinRmDriver
implements VanillaWindowsProcessDriver {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWindowsProcessWinRmDriver.class);

    public VanillaWindowsProcessWinRmDriver(EntityLocal entity, WinRmMachineLocation location) {
        super(entity, location);
    }

    @Override
    public void start() {
        WinRmMachineLocation machine = (WinRmMachineLocation)this.location;
        UserAndHostAndPort winrmAddress = UserAndHostAndPort.fromParts((String)machine.getUser(), (String)machine.getAddress().getHostName(), (int)((Integer)this.entity.getAttribute(VanillaWindowsProcess.WINRM_PORT)));
        this.getEntity().sensors().set(Attributes.WINRM_ADDRESS, (Object)winrmAddress);
        super.start();
    }

    @Override
    public void install() {
        String hostname = null;
        if (((Boolean)this.entity.getConfig(VanillaWindowsProcess.INSTALL_REBOOT_REQUIRED)).booleanValue()) {
            WinRmExecuteHelper checkHostnameTask = this.newScript("Checking hostname").setCommand("hostname").failOnNonZeroResultCode().gatherOutput();
            checkHostnameTask.execute();
            hostname = Strings.trimEnd((String)checkHostnameTask.getResultStdout());
        }
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.INSTALL_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.INSTALL_POWERSHELL_COMMAND)))) {
            this.executeCommandInTask((String)this.getEntity().getConfig(VanillaWindowsProcess.INSTALL_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.INSTALL_POWERSHELL_COMMAND), "install-command", hostname);
        }
        if (((Boolean)this.entity.getConfig(VanillaWindowsProcess.INSTALL_REBOOT_REQUIRED)).booleanValue()) {
            this.rebootAndWait(hostname);
        }
    }

    @Override
    public void customize() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.CUSTOMIZE_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.CUSTOMIZE_POWERSHELL_COMMAND)))) {
            this.executeCommandInTask((String)this.getEntity().getConfig(VanillaWindowsProcess.CUSTOMIZE_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.CUSTOMIZE_POWERSHELL_COMMAND), "customize-command");
        }
        if (((Boolean)this.entity.getConfig(VanillaWindowsProcess.CUSTOMIZE_REBOOT_REQUIRED)).booleanValue()) {
            this.rebootAndWait();
        }
    }

    @Override
    public void launch() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.LAUNCH_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.LAUNCH_POWERSHELL_COMMAND)))) {
            this.executeCommandInTask((String)this.getEntity().getConfig(VanillaWindowsProcess.LAUNCH_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.LAUNCH_POWERSHELL_COMMAND), "launch-command");
        }
    }

    @Override
    public boolean isRunning() {
        int exitCode = 1;
        try {
            exitCode = this.executeCommandInTask((String)this.getEntity().getConfig(VanillaWindowsProcess.CHECK_RUNNING_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.CHECK_RUNNING_POWERSHELL_COMMAND), "is-running-command");
        }
        catch (Exception e) {
            Throwable interestingCause = this.findExceptionCausedByWindowsRestart(e);
            if (interestingCause != null) {
                LOG.warn(this.getEntity() + " isRunning check failed. Executing WinRM command failed.", (Throwable)e);
                return false;
            }
            throw e;
        }
        if (exitCode != 0) {
            LOG.info(this.getEntity() + " isRunning check failed: exit code " + exitCode);
        }
        return exitCode == 0;
    }

    @Override
    public void stop() {
        this.executeCommandInTask((String)this.getEntity().getConfig(VanillaWindowsProcess.STOP_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.STOP_POWERSHELL_COMMAND), "stop-command");
    }
}

