/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.AbstractVanillaProcess;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.VanillaSoftwareProcess;
import org.apache.brooklyn.entity.software.base.VanillaWindowsProcessImpl;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Vanilla Windows Process", description="A basic Windows entity configured with scripts, e.g. for launch, check-running and stop")
@ImplementedBy(value=VanillaWindowsProcessImpl.class)
public interface VanillaWindowsProcess
extends AbstractVanillaProcess {
    public static final ConfigKey<Collection<Integer>> REQUIRED_OPEN_LOGIN_PORTS = ConfigKeys.newConfigKeyWithDefault(SoftwareProcess.REQUIRED_OPEN_LOGIN_PORTS, (Object)ImmutableSet.of((Object)5986, (Object)5985, (Object)3389));
    @CatalogConfig(label="Install PowerShell command", priority=5.5)
    public static final ConfigKey<String> INSTALL_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"install.powershell.command").description("powershell command to run during the install phase").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Install Command", priority=5.0)
    public static final ConfigKey<String> INSTALL_COMMAND = VanillaSoftwareProcess.INSTALL_COMMAND;
    @CatalogConfig(label="Customize PowerShell command", priority=4.5)
    public static final ConfigKey<String> CUSTOMIZE_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"customize.powershell.command").description("powershell command to run during the customization phase").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Customize command", priority=4.0)
    public static final ConfigKey<String> CUSTOMIZE_COMMAND = VanillaSoftwareProcess.CUSTOMIZE_COMMAND;
    @CatalogConfig(label="Launch PowerShell command", priority=3.5)
    public static final ConfigKey<String> LAUNCH_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"launch.powershell.command").description("command to run to launch the process").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Launch Command", priority=3.0)
    public static final ConfigKey<String> LAUNCH_COMMAND = ConfigKeys.newConfigKeyWithDefault((ConfigKey)VanillaSoftwareProcess.LAUNCH_COMMAND, null);
    @CatalogConfig(label="Check-running PowerShell Command", priority=2.5)
    public static final ConfigKey<String> CHECK_RUNNING_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"checkRunning.powershell.command").description("command to determine whether the process is running").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Check-running Command", priority=2.0)
    public static final ConfigKey<String> CHECK_RUNNING_COMMAND = VanillaSoftwareProcess.CHECK_RUNNING_COMMAND;
    @CatalogConfig(label="Stop PowerShell Command", priority=1.5)
    public static final ConfigKey<String> STOP_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"stop.powershell.command").description("command to run to stop the process").runtimeInheritance(ConfigInheritance.NONE).build();
    @CatalogConfig(label="Stop Command", priority=1.0)
    public static final ConfigKey<String> STOP_COMMAND = VanillaSoftwareProcess.STOP_COMMAND;
    public static final ConfigKey<String> PRE_INSTALL_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"pre.install.powershell.command").description("powershell command to run during the pre-install phase").runtimeInheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<String> POST_INSTALL_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"post.install.powershell.command").description("powershell command to run during the post-install phase").runtimeInheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<String> PRE_CUSTOMIZE_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"pre.customize.powershell.command").description("powershell command to run during the pre-customize phase").runtimeInheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<String> POST_CUSTOMIZE_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"post.customize.powershell.command").description("powershell command to run during the post-customize phase").runtimeInheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<String> PRE_LAUNCH_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"pre.launch.powershell.command").description("powershell command to run during the pre-launch phase").runtimeInheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<String> POST_LAUNCH_POWERSHELL_COMMAND = ConfigKeys.builder(String.class, (String)"post.launch.powershell.command").description("powershell command to run during the post-launch phase").runtimeInheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<Boolean> PRE_INSTALL_REBOOT_REQUIRED = ConfigKeys.newBooleanConfigKey((String)"pre.install.reboot.required", (String)"indicates that a reboot should be performed after the pre-install command is run", (Boolean)false);
    @Beta
    public static final ConfigKey<Boolean> INSTALL_REBOOT_REQUIRED = ConfigKeys.newBooleanConfigKey((String)"install.reboot.required", (String)"indicates that a reboot should be performed after the install command is run.When running the install command and the reboot command this parameter adds computername when authenticating.", (Boolean)false);
    public static final ConfigKey<Boolean> CUSTOMIZE_REBOOT_REQUIRED = ConfigKeys.newBooleanConfigKey((String)"customize.reboot.required", (String)"indicates that a reboot should be performed after the customize command is run", (Boolean)false);
    public static final ConfigKey<Duration> REBOOT_BEGUN_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"reboot.begun.timeout", (String)"duration to wait whilst waiting for a machine to begin rebooting, and thus become unavailable", (Duration)Duration.TWO_MINUTES);
    public static final ConfigKey<Duration> REBOOT_COMPLETED_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"reboot.completed.timeout", (String)"duration to wait whilst waiting for a machine to finish rebooting, and thus to become available again", (Duration)Duration.minutes((Number)30));
    public static final AttributeSensor<Integer> RDP_PORT = Sensors.newIntegerSensor((String)"rdp.port", (String)"RDP port used by the machine of this entity.");
    public static final AttributeSensor<Integer> WINRM_PORT = Sensors.newIntegerSensor((String)"winrm.port", (String)"WinRM port used by the machine of this entity.");
    @Deprecated
    public static final AttributeSensor<Integer> RDP_PORT_CAMEL_CASE = Sensors.newIntegerSensor((String)"rdpPort", (String)"[DEPRECATED] instead use 'rdp.port'");
    @Deprecated
    public static final AttributeSensor<Integer> WINRM_PORT_CAMEL_CASE = Sensors.newIntegerSensor((String)"winrmPort", (String)"[DEPRECATED] instead use 'winrm.port'");
    @Deprecated
    public static final AttributeSensor<Integer> WINRM_PORT_SHORTEN = Sensors.newIntegerSensor((String)"port", (String)"[DEPRECATED] instead use 'winrm.port'");
}

