/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.entity.software.base.InboundPortsUtils;
import org.apache.brooklyn.entity.software.base.SameServerEntity;
import org.apache.brooklyn.entity.software.base.SameServerEntityImpl;
import org.apache.brooklyn.entity.software.base.lifecycle.MachineLifecycleEffectorTasks;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameServerDriverLifecycleEffectorTasks
extends MachineLifecycleEffectorTasks {
    private static final Logger LOG = LoggerFactory.getLogger(SameServerDriverLifecycleEffectorTasks.class);

    protected SameServerEntityImpl entity() {
        return (SameServerEntityImpl)super.entity();
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.getRequiredOpenPorts(this.entity()));
        LOG.debug("getRequiredOpenPorts detected aggregated default {} for {}", (Object)result, (Object)this);
        return result;
    }

    protected Collection<Integer> getRequiredOpenPorts(Entity entity) {
        MutableSet ports = MutableSet.of();
        this.addRequiredOpenPortsRecursively(entity, (Set<Integer>)ports);
        return ports;
    }

    private void addRequiredOpenPortsRecursively(Entity entity, Set<Integer> ports) {
        ports.addAll((Collection)entity.getConfig(SameServerEntity.REQUIRED_OPEN_LOGIN_PORTS));
        Boolean portsAutoInfer = (Boolean)entity.getConfig(SameServerEntity.INBOUND_PORTS_AUTO_INFER);
        String portsRegex = (String)entity.getConfig(SameServerEntity.INBOUND_PORTS_CONFIG_REGEX);
        ports.addAll(InboundPortsUtils.getRequiredOpenPorts(entity, portsAutoInfer, portsRegex));
        LOG.debug("getRequiredOpenPorts detected default {} for {}", ports, (Object)entity);
        for (Entity child : entity.getChildren()) {
            this.addRequiredOpenPortsRecursively(child, ports);
        }
    }

    @Override
    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation<?> location) {
        Map<String, Object> result = super.obtainProvisioningFlags(location);
        result.putAll(this.obtainProvisioningFlags(this.entity(), location));
        Collection<Integer> ports = this.getRequiredOpenPorts();
        if (result.containsKey("inboundPorts")) {
            ports.addAll((Collection)result.get("inboundPorts"));
        }
        if (!ports.isEmpty()) {
            result.put("inboundPorts", ports);
        }
        result.put(LocationConfigKeys.CALLER_CONTEXT.getName(), this.entity());
        return result;
    }

    protected Map<String, Object> obtainProvisioningFlags(Entity entity, MachineProvisioningLocation location) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.putAll(Maps.newLinkedHashMap((Map)location.getProvisioningFlags((Collection)ImmutableList.of((Object)entity.getEntityType().getName()))));
        result.putAll((Map)entity.getConfig(SameServerEntity.PROVISIONING_PROPERTIES));
        for (Entity child : entity.getChildren()) {
            result.putAll(this.obtainProvisioningFlags(child, location));
        }
        return result;
    }

    @Override
    protected String startProcessesAtMachine(Supplier<MachineLocation> machineS) {
        DynamicTasks.queueIfPossible((TaskAdaptable)StartableMethods.startingChildren((Entity)this.entity(), (Location)((Location)machineS.get()))).orSubmitAsync((Entity)this.entity()).getTask().getUnchecked();
        DynamicTasks.waitForLast();
        return "children started";
    }

    @Override
    protected String stopProcessesAtMachine() {
        TaskAdaptable children = StartableMethods.stoppingChildren((Entity)this.entity());
        DynamicTasks.queue((TaskAdaptable)children);
        Exception childException = null;
        try {
            DynamicTasks.waitForLast();
        }
        catch (Exception e) {
            childException = e;
        }
        try {
            children.asTask().get();
        }
        catch (Exception e) {
            childException = e;
            LOG.debug("Error stopping children; continuing and will rethrow if no other errors", (Throwable)e);
        }
        if (childException != null) {
            throw new IllegalStateException("error stopping child", childException);
        }
        return "children stopped";
    }
}

