/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolver;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.lifecycle.NaiveScriptRunner;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoftwareProcessSshDriver
extends AbstractSoftwareProcessDriver
implements NaiveScriptRunner {
    public static final Logger log = LoggerFactory.getLogger(AbstractSoftwareProcessSshDriver.class);
    public static final Logger logSsh = LoggerFactory.getLogger((String)"brooklyn.SSH");
    private volatile String installDir;
    private volatile String runDir;
    private volatile String expandedInstallDir;
    private final Object installDirSetupMutex = new Object();
    protected volatile DownloadResolver resolver;
    public static final String IGNORE_ENTITY_SSH_FLAGS = SshEffectorTasks.IGNORE_ENTITY_SSH_FLAGS.getName();
    public static final String INSTALLING = "installing";
    public static final String CUSTOMIZING = "customizing";
    public static final String LAUNCHING = "launching";
    public static final String CHECK_RUNNING = "check-running";
    public static final String STOPPING = "stopping";
    public static final String KILLING = "killing";
    public static final String RESTARTING = "restarting";
    public static final String PID_FILENAME = "pid.txt";
    public static final String USE_PID_FILE = "usePidFile";
    public static final String PROCESS_OWNER = "processOwner";
    public static final String NON_STANDARD_LAYOUT = "nonStandardLayout";
    public static final String INSTALL_INCOMPLETE = "installIncomplete";
    public static final String DEBUG = "debug";
    public static final List<String> VALID_FLAGS = ImmutableList.of((Object)"usePidFile", (Object)"processOwner", (Object)"nonStandardLayout", (Object)"installIncomplete", (Object)"debug");

    @Override
    public void prepare() {
        String downloadUrl = (String)this.getEntity().config().get(SoftwareProcess.DOWNLOAD_URL);
        if (Strings.isNonEmpty((CharSequence)downloadUrl)) {
            this.resolver = Entities.newDownloader((EntityDriver)this);
            String formatString = this.getArchiveNameFormat();
            if (Strings.isNonEmpty((CharSequence)formatString)) {
                this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format(formatString, this.getVersion()))}));
            } else {
                this.setExpandedInstallDir(this.getInstallDir());
            }
        }
    }

    public AbstractSoftwareProcessSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, (Location)machine);
        if (this.getSshFlags() != null && !this.getSshFlags().isEmpty()) {
            machine.configure(this.getSshFlags());
        }
        this.getInstallDir();
        this.getRunDir();
    }

    public SshMachineLocation getLocation() {
        return (SshMachineLocation)super.getLocation();
    }

    protected void setInstallDir(String installDir) {
        this.installDir = installDir;
        this.entity.sensors().set(SoftwareProcess.INSTALL_DIR, (Object)installDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstallDir() {
        if (this.installDir != null) {
            return this.installDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.installDir = existingVal;
            return this.installDir;
        }
        Object object = this.installDirSetupMutex;
        synchronized (object) {
            this.setInstallLabel();
            this.setInstallDir(null);
            this.setInstallDir(Os.tidyPath((String)((String)ConfigToAttributes.apply((Entity)this.getEntity(), SoftwareProcess.INSTALL_DIR))));
            return this.installDir;
        }
    }

    protected void setInstallLabel() {
        if (((EntityInternal)this.getEntity()).config().getLocalRaw(SoftwareProcess.INSTALL_UNIQUE_LABEL).isPresentAndNonNull()) {
            return;
        }
        this.getEntity().config().set(SoftwareProcess.INSTALL_UNIQUE_LABEL, (Object)(this.getEntity().getEntityType().getSimpleName() + (Strings.isNonBlank((CharSequence)this.getVersion()) ? "_" + this.getVersion() : "") + (Strings.isNonBlank((CharSequence)this.getInstallLabelExtraSalt()) ? "_" + this.getInstallLabelExtraSalt() : "")));
    }

    protected String getInstallLabelExtraSalt() {
        return null;
    }

    protected void setRunDir(String runDir) {
        this.runDir = runDir;
        this.entity.sensors().set(SoftwareProcess.RUN_DIR, (Object)runDir);
    }

    @Override
    public String getRunDir() {
        if (this.runDir != null) {
            return this.runDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.RUN_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.runDir = existingVal;
            return this.runDir;
        }
        this.setRunDir(Os.tidyPath((String)((String)ConfigToAttributes.apply((Entity)this.getEntity(), SoftwareProcess.RUN_DIR))));
        return this.runDir;
    }

    public void setExpandedInstallDir(String val) {
        String oldVal = (String)this.getEntity().getAttribute(SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)oldVal) && !oldVal.equals(val)) {
            log.info("Resetting expandedInstallDir (to " + val + " from " + oldVal + ") for " + this.getEntity());
        }
        this.expandedInstallDir = val;
        this.getEntity().sensors().set(SoftwareProcess.EXPANDED_INSTALL_DIR, (Object)val);
    }

    public String getExpandedInstallDir() {
        if (this.expandedInstallDir != null) {
            return this.expandedInstallDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.expandedInstallDir = existingVal;
            return this.expandedInstallDir;
        }
        String untidiedVal = (String)ConfigToAttributes.apply((Entity)this.getEntity(), SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)untidiedVal)) {
            this.setExpandedInstallDir(Os.tidyPath((String)untidiedVal));
            return this.expandedInstallDir;
        }
        throw new IllegalStateException("expandedInstallDir is null; most likely install was not called for " + this.getEntity());
    }

    public SshMachineLocation getMachine() {
        return this.getLocation();
    }

    public String getHostname() {
        return (String)this.entity.getAttribute(Attributes.HOSTNAME);
    }

    public String getAddress() {
        return (String)this.entity.getAttribute(Attributes.ADDRESS);
    }

    public String getSubnetHostname() {
        return (String)this.entity.getAttribute(Attributes.SUBNET_HOSTNAME);
    }

    public String getSubnetAddress() {
        return (String)this.entity.getAttribute(Attributes.SUBNET_ADDRESS);
    }

    protected Map<String, Object> getSshFlags() {
        return SshEffectorTasks.getSshFlags((Entity)this.getEntity(), (Location)this.getMachine());
    }

    @Deprecated
    public int execute(String command, String summaryForLogging) {
        return this.execute((List<String>)ImmutableList.of((Object)command), summaryForLogging);
    }

    @Override
    @Deprecated
    public int execute(List<String> script, String summaryForLogging) {
        return this.execute(Maps.newLinkedHashMap(), script, summaryForLogging);
    }

    @Override
    @Deprecated
    public int execute(Map flags2, List<String> script, String summaryForLogging) {
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!flags2.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(flags2);
        Map<String, String> environment = (Map<String, String>)flags.get("env");
        if (environment == null) {
            environment = this.getShellEnvironment();
        }
        if (Tasks.current() != null) {
            if (environment != null) {
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForEnvStream((String)"env", environment));
            }
            if (BrooklynTaskTags.stream((Task)Tasks.current(), (String)"stdin") == null) {
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdin", (ByteArrayOutputStream)Streams.byteArrayOfString((String)Strings.join(script, (String)"\n"))));
            }
            if (BrooklynTaskTags.stream((Task)Tasks.current(), (String)"stdout") == null) {
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)stdout));
                ByteArrayOutputStream stderr = new ByteArrayOutputStream();
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)stderr));
                flags.put("out", stdout);
                flags.put("err", stderr);
            }
        }
        if (!flags.containsKey("logPrefix")) {
            flags.put("logPrefix", "" + this.entity.getId() + "@" + this.getLocation().getDisplayName());
        }
        return this.getMachine().execScript((Map)flags, summaryForLogging, script, environment);
    }

    @Override
    public void copyInstallResources() {
        this.getLocation().acquireMutex("installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this), "installation lock at host for files and templates");
        try {
            super.copyInstallResources();
        }
        catch (Exception e) {
            log.warn("Error copying install resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.getLocation().releaseMutex("installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        }
    }

    @Override
    public void copyCustomizeResources() {
        this.getLocation().acquireMutex("customizing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this), "installation lock at host for files and templates");
        try {
            super.copyCustomizeResources();
        }
        catch (Exception e) {
            log.warn("Error copying customize resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.getLocation().releaseMutex("customizing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        }
    }

    private void executeSuccessfully(ConfigKey<String> configKey, String label) {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(configKey)))) {
            log.debug("Executing {} on entity {}", (Object)label, (Object)this.entity.getDisplayName());
            int result = this.execute((List<String>)ImmutableList.of((Object)this.getEntity().getConfig(configKey)), label);
            if (0 != result) {
                log.debug("Executing {} failed with return code {}", (Object)label, (Object)result);
                throw new IllegalStateException("commands for " + configKey.getName() + " failed with return code " + result);
            }
        }
    }

    @Override
    public void runPreInstallCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.PRE_INSTALL_COMMAND, "running pre-install commands");
    }

    @Override
    public void runPostInstallCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.POST_INSTALL_COMMAND, "running post-install commands");
    }

    @Override
    public void runPreCustomizeCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.PRE_CUSTOMIZE_COMMAND, "running pre-customize commands");
    }

    @Override
    public void runPostCustomizeCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.POST_CUSTOMIZE_COMMAND, "running post-customize commands");
    }

    @Override
    public void runPreLaunchCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.PRE_LAUNCH_COMMAND, "running pre-launch commands");
    }

    @Override
    public void runPostLaunchCommand() {
        this.executeSuccessfully((ConfigKey<String>)BrooklynConfigKeys.POST_LAUNCH_COMMAND, "running post-launch commands");
    }

    public Map<String, String> getShellEnvironment() {
        Map env = (Map)this.entity.getConfig(SoftwareProcess.SHELL_ENVIRONMENT);
        ShellEnvironmentSerializer envSerializer = new ShellEnvironmentSerializer(((EntityInternal)this.entity).getManagementContext());
        return envSerializer.serialize(env);
    }

    @Override
    public int copyResource(Map<Object, Object> sshFlags, String source, String target, boolean createParentDir) {
        int result;
        String destination;
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!sshFlags.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(sshFlags);
        String string = destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
        if (createParentDir) {
            String parent;
            int lastSlashIndex = destination.lastIndexOf("/");
            String string2 = parent = lastSlashIndex > 0 ? destination.substring(0, lastSlashIndex) : null;
            if (parent != null) {
                this.getMachine().execCommands("createParentDir", (List)ImmutableList.of((Object)("mkdir -p " + parent)));
            }
        }
        if ((result = this.getMachine().installTo(this.resource, (Map)flags, source, destination)) == 0 && log.isDebugEnabled()) {
            log.debug("Copied file for {}: {} to {} - result {}", new Object[]{this.entity, source, destination, result});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyResource(Map<Object, Object> sshFlags, InputStream source, String target, boolean createParentDir) {
        int result;
        String destination;
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!sshFlags.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(sshFlags);
        String string = destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
        if (createParentDir) {
            String parent;
            int lastSlashIndex = destination.lastIndexOf("/");
            String string2 = parent = lastSlashIndex > 0 ? destination.substring(0, lastSlashIndex) : null;
            if (parent != null) {
                this.getMachine().execCommands("createParentDir", (List)ImmutableList.of((Object)("mkdir -p " + parent)));
            }
        }
        String prevBlockingDetails = Tasks.setBlockingDetails((String)("copying resource to server at " + destination));
        try {
            result = this.getMachine().copyTo((Map)flags, source, destination);
        }
        finally {
            Tasks.setBlockingDetails((String)prevBlockingDetails);
        }
        if (result == 0) {
            log.debug("copying stream complete; {} on {}", new Object[]{destination, this.getMachine()});
        } else {
            log.warn("copying stream failed; {} on {}: {}", new Object[]{destination, this.getMachine(), result});
        }
        return result;
    }

    public void checkNoHostnameBug() {
        try {
            ProcessTaskWrapper hostnameTask = ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"echo FOREMARKER; hostname; echo AFTMARKER"}))).block();
            String stdout = Strings.getFragmentBetween((String)hostnameTask.getStdout(), (String)"FOREMARKER", (String)"AFTMARKER");
            if (hostnameTask.getExitCode() == 0 && Strings.isNonBlank((CharSequence)stdout)) {
                String hostname = stdout.trim();
                if (hostname.equals("(none)")) {
                    String newHostname = "br-" + this.getEntity().getId().toLowerCase();
                    log.info("Detected no-hostname bug with hostname " + hostname + " for " + this.getEntity() + "; renaming " + this.getMachine() + "  to hostname " + newHostname);
                    ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((List)BashCommands.setHostname((String)newHostname, null)))).block();
                }
            } else {
                log.debug("Hostname could not be determined for location " + EffectorTasks.findSshMachine() + "; not doing no-hostname bug check");
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error checking/fixing no-hostname bug (continuing): " + e, (Throwable)e);
        }
    }

    protected ScriptHelper newScript(String phase) {
        return this.newScript(Maps.newLinkedHashMap(), phase);
    }

    protected ScriptHelper newScript(Map<String, ?> flags, String phase) {
        if (!Entities.isManaged((Entity)this.getEntity())) {
            throw new IllegalStateException(this.getEntity() + " is no longer managed; cannot create script to run here (" + phase + ")");
        }
        if (!Iterables.all(flags.keySet(), (Predicate)StringPredicates.equalToAny(VALID_FLAGS))) {
            throw new IllegalArgumentException("Invalid flags passed: " + flags);
        }
        ScriptHelper s = new ScriptHelper(this, phase + " " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        if (!JavaGroovyEquivalents.groovyTruth(flags.get(NON_STANDARD_LAYOUT))) {
            if (JavaGroovyEquivalents.groovyTruth(flags.get(DEBUG))) {
                s.header.prepend((CharSequence)"set -x");
            }
            if (INSTALLING.equals(phase)) {
                s.useMutex((WithMutexes)this.getLocation(), "installation lock at host", "installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
                s.header.append("export INSTALL_DIR=\"" + this.getInstallDir() + "\"", "mkdir -p $INSTALL_DIR", "cd $INSTALL_DIR", "test -f BROOKLYN && exit 0");
                if (!JavaGroovyEquivalents.groovyTruth(flags.get(INSTALL_INCOMPLETE))) {
                    s.footer.append((CharSequence)"date > $INSTALL_DIR/BROOKLYN");
                }
                s.environmentVariablesReset();
            }
            if (ImmutableSet.of((Object)CUSTOMIZING, (Object)LAUNCHING, (Object)CHECK_RUNNING, (Object)STOPPING, (Object)KILLING, (Object)RESTARTING, (Object[])new String[0]).contains((Object)phase)) {
                s.header.append("export INSTALL_DIR=\"" + this.getInstallDir() + "\"", "export RUN_DIR=\"" + this.getRunDir() + "\"", "mkdir -p $RUN_DIR", "cd $RUN_DIR");
            }
        }
        if (ImmutableSet.of((Object)LAUNCHING, (Object)RESTARTING).contains((Object)phase)) {
            s.failIfBodyEmpty();
        }
        if (ImmutableSet.of((Object)STOPPING, (Object)KILLING).contains((Object)phase) && !JavaGroovyEquivalents.groovyTruth(flags.get(USE_PID_FILE))) {
            s.failIfBodyEmpty();
        }
        if (ImmutableSet.of((Object)INSTALLING, (Object)LAUNCHING).contains((Object)phase)) {
            s.updateTaskAndFailOnNonZeroResultCode();
        }
        if (phase.equalsIgnoreCase(CHECK_RUNNING)) {
            s.setInessential();
            s.setTransient();
            s.setFlag(SshTool.PROP_CONNECT_TIMEOUT, Duration.TEN_SECONDS.toMilliseconds());
            s.setFlag(SshTool.PROP_SESSION_TIMEOUT, Duration.THIRTY_SECONDS.toMilliseconds());
            s.setFlag(SshTool.PROP_SSH_TRIES, 1);
        }
        if (JavaGroovyEquivalents.groovyTruth(flags.get(USE_PID_FILE))) {
            Object usePidFile = flags.get(USE_PID_FILE);
            String pidFile = (usePidFile instanceof CharSequence ? usePidFile : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), PID_FILENAME})).toString();
            String processOwner = (String)flags.get(PROCESS_OWNER);
            if (LAUNCHING.equals(phase)) {
                this.entity.sensors().set(SoftwareProcess.PID_FILE, (Object)pidFile);
                s.footer.prepend((CharSequence)("echo $! > " + pidFile));
            } else if (CHECK_RUNNING.equals(phase)) {
                if (processOwner != null) {
                    s.body.append(BashCommands.sudoAsUser((String)processOwner, (String)("test -f " + pidFile)) + " || exit 1", "ps -p $(" + BashCommands.sudoAsUser((String)processOwner, (String)("cat " + pidFile)) + ")");
                } else {
                    s.body.append("test -f " + pidFile + " || exit 1", "ps -p `cat " + pidFile + "`");
                }
                s.requireResultCode((Predicate<? super Integer>)Predicates.or((Predicate)Predicates.equalTo((Object)0), (Predicate)Predicates.equalTo((Object)1)));
            } else if (STOPPING.equals(phase)) {
                String stopCommand = Joiner.on((char)'\n').join((Object)("PID=$(cat " + pidFile + ")"), (Object)"test -n \"$PID\" || exit 0", new Object[]{"SIGTERM_USED=\"\"", "for i in $(seq 1 16); do", "  if ps -p $PID > /dev/null ; then", "     kill $PID", "     echo Attempted to stop PID $PID by sending SIGTERM.", "  else", "     echo Process $PID stopped successfully.", "     SIGTERM_USED=\"true\"", "     break", "  fi", "  sleep 1", "done", "if test -z $SIGTERM_USED; then", "  kill -9 $PID", "  echo Sent SIGKILL to $PID", "fi", "rm -f " + pidFile});
                if (processOwner != null) {
                    s.body.append((CharSequence)BashCommands.sudoAsUser((String)processOwner, (String)stopCommand));
                } else {
                    s.body.append((CharSequence)stopCommand);
                }
            } else if (KILLING.equals(phase)) {
                if (processOwner != null) {
                    s.body.append("export PID=$(" + BashCommands.sudoAsUser((String)processOwner, (String)("cat " + pidFile)) + ")", "test -n \"$PID\" || exit 0", BashCommands.sudoAsUser((String)processOwner, (String)"kill -9 $PID"), BashCommands.sudoAsUser((String)processOwner, (String)("rm -f " + pidFile)));
                } else {
                    s.body.append("export PID=$(cat " + pidFile + ")", "test -n \"$PID\" || exit 0", "kill -9 $PID", "rm -f " + pidFile);
                }
            } else if (RESTARTING.equals(phase)) {
                if (processOwner != null) {
                    s.footer.prepend(BashCommands.sudoAsUser((String)processOwner, (String)("test -f " + pidFile)) + " || exit 1", "ps -p $(" + BashCommands.sudoAsUser((String)processOwner, (String)("cat " + pidFile)) + ") || exit 1");
                } else {
                    s.footer.prepend("test -f " + pidFile + " || exit 1", "ps -p $(cat " + pidFile + ") || exit 1");
                }
            } else {
                log.warn("usePidFile: script option not valid for " + s.summary);
            }
        }
        return s;
    }

    @Override
    protected void createDirectory(String directoryName, String summaryForLogging) {
        ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"mkdir -p " + directoryName}).summary(summaryForLogging)).requiringExitCodeZero())).get();
    }

    public Set<Integer> getPortsUsed() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.add(22);
        return result;
    }

    @Override
    public void setup() {
    }
}

