/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine;

import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.entity.machine.AddMachineMetrics;
import org.apache.brooklyn.entity.machine.MachineEntity;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.EmptySoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.EmptySoftwareProcessImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineEntityImpl
extends EmptySoftwareProcessImpl
implements MachineEntity {
    private static final Logger LOG = LoggerFactory.getLogger(MachineEntityImpl.class);
    private transient Feed machineMetrics;

    @Override
    protected void initEnrichers() {
        LOG.info("Adding machine metrics enrichers");
        AddMachineMetrics.addMachineMetricsEnrichers(this);
        super.initEnrichers();
    }

    @Override
    protected void connectSensors() {
        super.connectSensors();
        Maybe location = Machines.findUniqueMachineLocation((Iterable)this.getLocations(), SshMachineLocation.class);
        if (location.isPresent() && ((SshMachineLocation)location.get()).getOsDetails().isLinux()) {
            LOG.info("Adding machine metrics feed");
            this.machineMetrics = AddMachineMetrics.createMachineMetricsFeed(this);
        } else {
            LOG.warn("Not adding machine metrics feed as no suitable location available on entity");
        }
    }

    @Override
    protected void disconnectSensors() {
        if (this.machineMetrics != null) {
            this.machineMetrics.stop();
        }
        super.disconnectSensors();
    }

    @Override
    public Class<?> getDriverInterface() {
        return EmptySoftwareProcessDriver.class;
    }

    public SshMachineLocation getMachine() {
        return (SshMachineLocation)Machines.findUniqueMachineLocation((Iterable)this.getLocations(), SshMachineLocation.class).get();
    }

    @Override
    public String execCommand(String command) {
        return this.execCommandTimeout(command, Duration.ONE_MINUTE);
    }

    @Override
    public String execCommandTimeout(String command, Duration timeout) {
        AbstractSoftwareProcessSshDriver driver = (AbstractSoftwareProcessSshDriver)this.getDriver();
        if (driver == null) {
            throw new NullPointerException("No driver for " + this);
        }
        ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{command}).environmentVariables(driver.getShellEnvironment())).requiringZeroAndReturningStdout().machine(this.getMachine())).summary(command)).newTask();
        try {
            String result = (String)DynamicTasks.queueIfPossible((TaskAdaptable)task).executionContext((Entity)this).orSubmitAsync().asTask().get(timeout);
            return result;
        }
        catch (TimeoutException te) {
            throw new IllegalStateException("Timed out running command: " + command);
        }
        catch (Exception e) {
            Integer exitCode = task.getExitCode();
            LOG.warn("Command failed, return code {}: {}", (Object)(exitCode == null ? -1 : exitCode), (Object)task.getStderr());
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

