/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine;

import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.math.MathFunctions;
import org.apache.brooklyn.util.text.ByteSizeStrings;
import org.apache.brooklyn.util.time.Duration;

public class MachineAttributes {
    public static final AttributeSensor<Duration> UPTIME = Sensors.newSensor(Duration.class, (String)"machine.uptime", (String)"Current uptime");
    public static final AttributeSensor<Double> LOAD_AVERAGE = Sensors.newDoubleSensor((String)"machine.loadAverage", (String)"Current load average");
    public static final AttributeSensor<Double> CPU_USAGE = Sensors.newDoubleSensor((String)"machine.cpu", (String)"Current CPU usage");
    public static final AttributeSensor<Double> AVERAGE_CPU_USAGE = Sensors.newDoubleSensor((String)"cpu.average", (String)"Average CPU usage across the cluster");
    public static final AttributeSensor<Long> FREE_MEMORY = Sensors.newLongSensor((String)"machine.memory.free", (String)"Current free memory");
    public static final AttributeSensor<Long> TOTAL_MEMORY = Sensors.newLongSensor((String)"machine.memory.total", (String)"Total memory");
    public static final AttributeSensor<Long> USED_MEMORY = Sensors.newLongSensor((String)"machine.memory.used", (String)"Current memory usage");
    public static final AttributeSensor<Double> USED_MEMORY_DELTA_PER_SECOND_LAST = Sensors.newDoubleSensor((String)"memory.used.delta", (String)"Change in memory usage per second");
    public static final AttributeSensor<Double> USED_MEMORY_DELTA_PER_SECOND_IN_WINDOW = Sensors.newDoubleSensor((String)"memory.used.windowed", (String)"Average change in memory usage over 30s");
    public static final AttributeSensor<Double> USED_MEMORY_PERCENT = Sensors.newDoubleSensor((String)"memory.used.percent", (String)"The percentage of memory used");
    public static final AttributeSensor<Double> AVERAGE_USED_MEMORY_PERCENT = Sensors.newDoubleSensor((String)"memory.used.percent.average", (String)"Average percentage of memory used across the cluster");
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    private MachineAttributes() {
    }

    public static void init() {
        if (initialized.getAndSet(true)) {
            return;
        }
        Function<Double, Long> longValue = new Function<Double, Long>(){

            public Long apply(@Nullable Double input) {
                if (input == null) {
                    return null;
                }
                return input.longValue();
            }
        };
        RendererHints.register(CPU_USAGE, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(AVERAGE_CPU_USAGE, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(USED_MEMORY_PERCENT, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(AVERAGE_USED_MEMORY_PERCENT, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(FREE_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)MathFunctions.times((long)1000L), (Function)ByteSizeStrings.metric())));
        RendererHints.register(TOTAL_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)MathFunctions.times((long)1000L), (Function)ByteSizeStrings.metric())));
        RendererHints.register(USED_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)MathFunctions.times((long)1000L), (Function)ByteSizeStrings.metric())));
        RendererHints.register(USED_MEMORY_DELTA_PER_SECOND_LAST, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)longValue, (Function)ByteSizeStrings.metric())));
        RendererHints.register(USED_MEMORY_DELTA_PER_SECOND_IN_WINDOW, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)longValue, (Function)ByteSizeStrings.metric())));
    }

    static {
        MachineAttributes.init();
    }
}

