/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import com.google.common.base.Function;
import java.lang.management.MemoryUsage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.openmbean.CompositeData;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.entity.java.UsesJavaMXBeans;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.policy.enricher.RollingTimeWindowMeanEnricher;
import org.apache.brooklyn.policy.enricher.TimeFractionDeltaEnricher;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.math.MathFunctions;
import org.apache.brooklyn.util.text.ByteSizeStrings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;

public class JavaAppUtils {
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    public static boolean isEntityMxBeanStatsEnabled(Entity entity) {
        return JavaGroovyEquivalents.groovyTruth((Object)entity.getConfig(UsesJavaMXBeans.MXBEAN_STATS_ENABLED));
    }

    @Nullable
    public static JmxFeed connectMXBeanSensors(Entity entity) {
        if (JavaAppUtils.isEntityMxBeanStatsEnabled(entity)) {
            return JavaAppUtils.getMxBeanSensorsBuilder(entity).build();
        }
        return null;
    }

    @Nullable
    public static JmxFeed connectMXBeanSensors(Entity entity, long jmxPollPeriodMs) {
        if (JavaAppUtils.isEntityMxBeanStatsEnabled(entity)) {
            return JavaAppUtils.getMxBeanSensorsBuilder(entity, jmxPollPeriodMs).build();
        }
        return null;
    }

    @Nullable
    public static JmxFeed connectMXBeanSensors(Entity entity, Duration jmxPollPeriod) {
        if (JavaAppUtils.isEntityMxBeanStatsEnabled(entity)) {
            return JavaAppUtils.getMxBeanSensorsBuilder(entity, jmxPollPeriod).build();
        }
        return null;
    }

    public static void connectJavaAppServerPolicies(Entity entity) {
        JavaAppUtils.connectJavaAppServerPolicies(entity, Duration.TEN_SECONDS);
    }

    public static void connectJavaAppServerPolicies(Entity entity, Duration windowPeriod) {
        entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(TimeFractionDeltaEnricher.class).configure((CharSequence)"producer", (Object)entity)).configure((CharSequence)"source", UsesJavaMXBeans.PROCESS_CPU_TIME)).configure((CharSequence)"target", UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_LAST)).configure((CharSequence)"durationPerOrigUnit", (Object)Duration.millis((Number)1)));
        entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(RollingTimeWindowMeanEnricher.class).configure((CharSequence)"producer", (Object)entity)).configure((CharSequence)"source", UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_LAST)).configure((CharSequence)"target", UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_IN_WINDOW)).configure((CharSequence)"timePeriod", (Object)windowPeriod));
    }

    @Nonnull
    public static JmxFeed.Builder getMxBeanSensorsBuilder(Entity entity) {
        return JavaAppUtils.getMxBeanSensorsBuilder(entity, Duration.TEN_SECONDS);
    }

    @Nonnull
    public static JmxFeed.Builder getMxBeanSensorsBuilder(Entity entity, long jmxPollPeriod) {
        return JavaAppUtils.getMxBeanSensorsBuilder(entity, Duration.millis((Number)jmxPollPeriod));
    }

    @Nonnull
    public static JmxFeed.Builder getMxBeanSensorsBuilder(Entity entity, Duration jmxPollPeriod) {
        JmxFeed.Builder builder = JmxFeed.builder().entity(entity).period(jmxPollPeriod);
        if (JavaAppUtils.isEntityMxBeanStatsEnabled(entity)) {
            builder.pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.USED_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getUsed());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.INIT_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getInit());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.COMMITTED_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getCommitted());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.MAX_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getMax());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.NON_HEAP_MEMORY_USAGE).objectName("java.lang:type=Memory").attributeName("NonHeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getUsed());
                }
            }))).pollAttribute(new JmxAttributePollConfig<Integer>(UsesJavaMXBeans.CURRENT_THREAD_COUNT).objectName("java.lang:type=Threading").attributeName("ThreadCount")).pollAttribute(new JmxAttributePollConfig<Integer>(UsesJavaMXBeans.PEAK_THREAD_COUNT).objectName("java.lang:type=Threading").attributeName("PeakThreadCount")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.START_TIME).objectName("java.lang:type=Runtime").period(60L, TimeUnit.SECONDS)).attributeName("StartTime")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.UP_TIME).objectName("java.lang:type=Runtime").period(60L, TimeUnit.SECONDS)).attributeName("Uptime")).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Double>(UsesJavaMXBeans.PROCESS_CPU_TIME).objectName("java.lang:type=OperatingSystem").attributeName("ProcessCpuTime").onSuccess(MathFunctions.times((double)1.0E-6))).pollAttribute(new JmxAttributePollConfig<Double>(UsesJavaMXBeans.SYSTEM_LOAD_AVERAGE).objectName("java.lang:type=OperatingSystem").attributeName("SystemLoadAverage")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Integer>(UsesJavaMXBeans.AVAILABLE_PROCESSORS).objectName("java.lang:type=OperatingSystem").period(60L, TimeUnit.SECONDS)).attributeName("AvailableProcessors")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.TOTAL_PHYSICAL_MEMORY_SIZE).objectName("java.lang:type=OperatingSystem").period(60L, TimeUnit.SECONDS)).attributeName("TotalPhysicalMemorySize")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.FREE_PHYSICAL_MEMORY_SIZE).objectName("java.lang:type=OperatingSystem").period(60L, TimeUnit.SECONDS)).attributeName("FreePhysicalMemorySize"));
        }
        return builder;
    }

    @Deprecated
    public static Function<Number, Double> times(double x) {
        return MathFunctions.times((double)x);
    }

    public static Function<CompositeData, MemoryUsage> compositeDataToMemoryUsage() {
        return new Function<CompositeData, MemoryUsage>(){

            public MemoryUsage apply(CompositeData input) {
                return input == null ? null : MemoryUsage.from(input);
            }
        };
    }

    public static void init() {
        if (initialized.getAndSet(true)) {
            return;
        }
        RendererHints.register(UsesJavaMXBeans.USED_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register(UsesJavaMXBeans.INIT_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register(UsesJavaMXBeans.MAX_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register(UsesJavaMXBeans.COMMITTED_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register(UsesJavaMXBeans.NON_HEAP_MEMORY_USAGE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register(UsesJavaMXBeans.TOTAL_PHYSICAL_MEMORY_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register(UsesJavaMXBeans.FREE_PHYSICAL_MEMORY_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        RendererHints.register(UsesJavaMXBeans.START_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Time.toDateString()));
        RendererHints.register(UsesJavaMXBeans.UP_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Duration.millisToStringRounded()));
        RendererHints.register(UsesJavaMXBeans.PROCESS_CPU_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Duration.millisToStringRounded()));
        RendererHints.register(UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_LAST, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)4)));
        RendererHints.register(UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_IN_WINDOW, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)4)));
    }

    static {
        JavaAppUtils.init();
    }
}

