/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserDataUuencodedOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(UserDataUuencodedOption.class);

    UserDataUuencodedOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        if (t instanceof EC2TemplateOptions) {
            byte[] bytes = this.toByteArray(v);
            ((EC2TemplateOptions)t).userData(bytes);
        } else if (t instanceof SoftLayerTemplateOptions) {
            ((SoftLayerTemplateOptions)t).userData(Strings.toString((Object)v));
        } else {
            LOG.info("ignoring userData({}) in VM creation because not supported for cloud/type ({})", v, t.getClass());
        }
    }

    private byte[] toByteArray(Object v) {
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        if (v instanceof CharSequence) {
            return v.toString().getBytes();
        }
        throw new IllegalArgumentException("Invalid type for byte[]: " + v + " of type " + v.getClass());
    }
}

