/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineLocationCustomizer;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationCustomizerDelegate
implements JcloudsLocationCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(LocationCustomizerDelegate.class);
    private Collection<JcloudsLocationCustomizer> customizers;
    private Collection<MachineLocationCustomizer> machineCustomizers;

    public static JcloudsLocationCustomizer newInstance(ManagementContext managementContext, ConfigBag setup) {
        return new LocationCustomizerDelegate(managementContext, setup);
    }

    @Deprecated
    public static JcloudsLocationCustomizer newInstance(Collection<JcloudsLocationCustomizer> customizers) {
        return new LocationCustomizerDelegate(customizers);
    }

    private LocationCustomizerDelegate(ManagementContext mgmt, ConfigBag setup) {
        this.customizers = LocationCustomizerDelegate.getCustomizers(mgmt, setup);
        this.machineCustomizers = LocationCustomizerDelegate.getMachineCustomizers(mgmt, setup);
    }

    private LocationCustomizerDelegate(Collection<JcloudsLocationCustomizer> customizers) {
        this.customizers = customizers;
        this.machineCustomizers = ImmutableList.of();
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, TemplateBuilder templateBuilder) {
        for (JcloudsLocationCustomizer customizer : this.customizers) {
            customizer.customize(location, computeService, templateBuilder);
        }
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, Template template) {
        for (JcloudsLocationCustomizer customizer : this.customizers) {
            customizer.customize(location, computeService, template);
        }
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, TemplateOptions templateOptions) {
        for (JcloudsLocationCustomizer customizer : this.customizers) {
            customizer.customize(location, computeService, templateOptions);
        }
    }

    @Override
    public void customize(JcloudsLocation location, NodeMetadata node, ConfigBag setup) {
        for (JcloudsLocationCustomizer customizer : this.customizers) {
            customizer.customize(location, node, setup);
        }
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machineLocation) {
        for (JcloudsLocationCustomizer jcloudsLocationCustomizer : this.customizers) {
            LOG.debug("Customizing machine {}, using customizer {}", (Object)machineLocation, (Object)jcloudsLocationCustomizer);
            jcloudsLocationCustomizer.customize(location, computeService, machineLocation);
        }
        for (MachineLocationCustomizer machineLocationCustomizer : this.machineCustomizers) {
            LOG.debug("Customizing machine {}, using customizer {}", (Object)machineLocation, (Object)machineLocationCustomizer);
            machineLocationCustomizer.customize((MachineLocation)machineLocation);
        }
    }

    @Override
    public void preRelease(JcloudsMachineLocation machine) {
        Exception tothrow = null;
        for (JcloudsLocationCustomizer jcloudsLocationCustomizer : this.customizers) {
            try {
                jcloudsLocationCustomizer.preRelease(machine);
            }
            catch (Exception e) {
                LOG.error("Problem invoking pre-release customizer " + jcloudsLocationCustomizer + " for machine " + machine + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) continue;
                tothrow = e;
            }
        }
        for (MachineLocationCustomizer machineLocationCustomizer : this.machineCustomizers) {
            try {
                machineLocationCustomizer.preRelease((MachineLocation)machine);
            }
            catch (Exception e) {
                LOG.error("Problem invoking pre-release machine customizer " + machineLocationCustomizer + " for machine " + machine + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) continue;
                tothrow = e;
            }
        }
        if (tothrow != null) {
            throw Exceptions.propagate(tothrow);
        }
    }

    @Override
    public void postRelease(JcloudsMachineLocation machine) {
        Exception tothrow = null;
        for (JcloudsLocationCustomizer customizer : this.customizers) {
            try {
                customizer.postRelease(machine);
            }
            catch (Exception e) {
                LOG.error("Problem invoking pre-release customizer " + customizer + " for machine " + machine + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) continue;
                tothrow = e;
            }
        }
        if (tothrow != null) {
            throw Exceptions.propagate(tothrow);
        }
    }

    @Override
    public void preReleaseOnObtainError(JcloudsLocation location, JcloudsMachineLocation machineLocation, Exception cause) {
        Exception tothrow = null;
        for (JcloudsLocationCustomizer customizer : this.customizers) {
            try {
                customizer.preReleaseOnObtainError(location, machineLocation, cause);
            }
            catch (Exception e) {
                LOG.error("Problem invoking customizer preReleaseOnObtainError for " + customizer + " for machine " + machineLocation + ", locaiton=" + location + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) continue;
                tothrow = e;
            }
        }
        if (tothrow != null) {
            throw Exceptions.propagate(tothrow);
        }
    }

    @Override
    public void postReleaseOnObtainError(JcloudsLocation location, JcloudsMachineLocation machineLocation, Exception cause) {
        Exception tothrow = null;
        for (JcloudsLocationCustomizer customizer : this.customizers) {
            try {
                customizer.postReleaseOnObtainError(location, machineLocation, cause);
            }
            catch (Exception e) {
                LOG.error("Problem invoking customizer postReleaseOnObtainError for " + customizer + " for machine " + machineLocation + ", locaiton=" + location + "; ignoring and continuing, " + (tothrow == null ? "will throw subsequently" : "swallowing due to previous error") + ": " + e, (Throwable)e);
                if (tothrow != null) continue;
                tothrow = e;
            }
        }
        if (tothrow != null) {
            throw Exceptions.propagate(tothrow);
        }
    }

    public static Collection<JcloudsLocationCustomizer> getCustomizers(ManagementContext mgmt, ConfigBag setup) {
        JcloudsLocationCustomizer customizer = (JcloudsLocationCustomizer)setup.get(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZER);
        Collection customizers = (Collection)setup.get(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS);
        String customizerType = (String)setup.get(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZER_TYPE);
        String customizersSupplierType = (String)setup.get(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS_SUPPLIER_TYPE);
        ClassLoader catalogClassLoader = mgmt.getCatalogClassLoader();
        ArrayList<JcloudsLocationCustomizer> result = new ArrayList<JcloudsLocationCustomizer>();
        if (customizer != null) {
            result.add(customizer);
        }
        if (customizers != null) {
            result.addAll(customizers);
        }
        if (Strings.isNonBlank((CharSequence)customizerType)) {
            Maybe customizerByType = Reflections.invokeConstructorFromArgs((ClassLoader)catalogClassLoader, JcloudsLocationCustomizer.class, (String)customizerType, (Object[])new Object[]{setup});
            if (customizerByType.isPresent()) {
                result.add((JcloudsLocationCustomizer)customizerByType.get());
            } else {
                customizerByType = Reflections.invokeConstructorFromArgs((ClassLoader)catalogClassLoader, JcloudsLocationCustomizer.class, (String)customizerType, (Object[])new Object[0]);
                if (customizerByType.isPresent()) {
                    result.add((JcloudsLocationCustomizer)customizerByType.get());
                } else {
                    throw new IllegalStateException("Failed to create JcloudsLocationCustomizer " + customizersSupplierType);
                }
            }
        }
        if (Strings.isNonBlank((CharSequence)customizersSupplierType)) {
            Maybe supplier = Reflections.invokeConstructorFromArgsUntyped((ClassLoader)catalogClassLoader, (String)customizersSupplierType, (Object[])new Object[]{setup});
            if (supplier.isPresent()) {
                result.addAll((Collection)((Supplier)supplier.get()).get());
            } else {
                supplier = Reflections.invokeConstructorFromArgsUntyped((ClassLoader)catalogClassLoader, (String)customizersSupplierType, (Object[])new Object[0]);
                if (supplier.isPresent()) {
                    result.addAll((Collection)((Supplier)supplier.get()).get());
                } else {
                    throw new IllegalStateException("Failed to create JcloudsLocationCustomizer supplier " + customizersSupplierType);
                }
            }
        }
        return result;
    }

    protected static Collection<MachineLocationCustomizer> getMachineCustomizers(ManagementContext mgmt, ConfigBag setup) {
        Collection customizers = (Collection)setup.get(JcloudsLocationConfig.MACHINE_LOCATION_CUSTOMIZERS);
        return customizers == null ? ImmutableList.of() : customizers;
    }
}

