/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.location.jclouds.BrooklynImageChooser;
import org.apache.brooklyn.location.jclouds.ComputeServiceRegistry;
import org.apache.brooklyn.location.jclouds.ComputeServiceRegistryImpl;
import org.apache.brooklyn.location.jclouds.ConnectivityResolver;
import org.apache.brooklyn.location.jclouds.DefaultConnectivityResolver;
import org.apache.brooklyn.location.jclouds.JcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.api.JcloudsLocationConfigPublic;
import org.apache.brooklyn.location.jclouds.networking.JcloudsPortForwarderExtension;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.domain.LoginCredentials;

public interface JcloudsLocationConfig
extends JcloudsLocationConfigPublic {
    public static final ConfigKey<LoginCredentials> CUSTOM_CREDENTIALS = new BasicConfigKey(LoginCredentials.class, "customCredentials", "Custom jclouds LoginCredentials object to be used to connect to the VM", null);
    public static final ConfigKey<TemplateBuilder> TEMPLATE_BUILDER = ConfigKeys.newConfigKey(TemplateBuilder.class, (String)"templateBuilder", (String)"A TemplateBuilder instance provided programmatically, to be used when creating a VM");
    @Deprecated
    public static final ConfigKey<JcloudsLocationCustomizer> JCLOUDS_LOCATION_CUSTOMIZER = ConfigKeys.newConfigKey(JcloudsLocationCustomizer.class, (String)"customizer", (String)"Optional location customizer");
    public static final ConfigKey<Collection<JcloudsLocationCustomizer>> JCLOUDS_LOCATION_CUSTOMIZERS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Collection<JcloudsLocationCustomizer>>(){}, (String)"customizers", (String)"Optional location customizers");
    @Deprecated
    public static final ConfigKey<String> JCLOUDS_LOCATION_CUSTOMIZER_TYPE = ConfigKeys.newStringConfigKey((String)"customizerType", (String)"Optional location customizer type (to be class-loaded and constructed with either a ConfigBag or no-arg constructor)");
    @Deprecated
    public static final ConfigKey<String> JCLOUDS_LOCATION_CUSTOMIZERS_SUPPLIER_TYPE = ConfigKeys.newStringConfigKey((String)"customizersSupplierType", (String)"Optional type of a Supplier<Collection<JcloudsLocationCustomizer>> (to be class-loaded and constructed with either a ConfigBag or no-arg constructor)");
    public static final ConfigKey<ConnectivityResolver> CONNECTIVITY_RESOLVER = ConfigKeys.newConfigKey(ConnectivityResolver.class, (String)"connectivityResolver", (String)("Optional instance of a ConnectivityResolver that the location will use in favour of " + DefaultConnectivityResolver.class.getSimpleName()));
    public static final ConfigKey<JcloudsPortForwarderExtension> PORT_FORWARDER = ConfigKeys.newConfigKey(JcloudsPortForwarderExtension.class, (String)"portforwarding.forwarder", (String)"The port-forwarder to use");
    public static final ConfigKey<Function<Iterable<? extends Image>, Image>> IMAGE_CHOOSER = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Function<Iterable<? extends Image>, Image>>(){}, (String)"imageChooser", (String)"An image chooser function to control which images are preferred", new BrooklynImageChooser().chooser());
    public static final ConfigKey<OsFamily> OS_FAMILY = ConfigKeys.newConfigKey(OsFamily.class, (String)"osFamily", (String)"OS family, e.g. CentOS, Debian, RHEL, Ubuntu");
    public static final ConfigKey<String> OS_VERSION_REGEX = ConfigKeys.newStringConfigKey((String)"osVersionRegex", (String)"Regular expression for the OS version to load");
    public static final ConfigKey<OsFamily> OS_FAMILY_OVERRIDE = ConfigKeys.newConfigKey(OsFamily.class, (String)"osFamilyOverride", (String)"OS family of VMs (ignores VM metadata from jclouds, and assumes this value)");
    public static final ConfigKey<ComputeServiceRegistry> COMPUTE_SERVICE_REGISTRY = ConfigKeys.newConfigKey(ComputeServiceRegistry.class, (String)"jclouds.computeServiceRegistry", (String)"Registry/Factory for creating jclouds ComputeService; default is almost always fine, except where tests want to customize behaviour", (Object)ComputeServiceRegistryImpl.INSTANCE);
}

