/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.mgmt.persist.DeserializingJcloudsRenamesProvider;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCloudsPropertiesBuilder
implements JcloudsLocationConfig {
    private ConfigBag conf;
    private Properties properties = new Properties();
    private static final Logger LOG = LoggerFactory.getLogger(JCloudsPropertiesBuilder.class);

    public JCloudsPropertiesBuilder(ConfigBag conf) {
        this.conf = conf;
    }

    public JCloudsPropertiesBuilder setCommonJcloudsProperties() {
        this.properties.setProperty("jclouds.trust-all-certs", Boolean.toString(true));
        this.properties.setProperty("jclouds.relax-hostname", Boolean.toString(true));
        this.properties.setProperty("jclouds.ssh.max-retries", this.conf.getStringKey("jclouds.ssh.max-retries") != null ? this.conf.getStringKey("jclouds.ssh.max-retries").toString() : "50");
        if (this.conf.get(OAUTH_ENDPOINT) != null) {
            this.properties.setProperty(OAUTH_ENDPOINT.getName(), (String)this.conf.get(OAUTH_ENDPOINT));
        }
        this.properties.setProperty("jclouds.retries-delay-start", "500");
        this.properties.setProperty("jclouds.max-retries", "6");
        return this;
    }

    public JCloudsPropertiesBuilder setAWSEC2Properties() {
        if (JavaGroovyEquivalents.groovyTruth((String)((String)this.conf.get(IMAGE_ID)))) {
            this.properties.setProperty("jclouds.ec2.ami-query", "");
            this.properties.setProperty("jclouds.ec2.cc-ami-query", "");
        } else if (JavaGroovyEquivalents.groovyTruth((Object)this.conf.getStringKey("imageOwner"))) {
            this.properties.setProperty("jclouds.ec2.ami-query", "owner-id=" + this.conf.getStringKey("imageOwner") + ";state=available;image-type=machine");
        } else if (JavaGroovyEquivalents.groovyTruth((Object)this.conf.getStringKey("anyOwner"))) {
            this.properties.setProperty("jclouds.ec2.ami-query", "state=available;image-type=machine");
        }
        String region = (String)this.conf.get(CLOUD_REGION_ID);
        if (Strings.isNonBlank((CharSequence)region)) {
            if (Character.isLetter(region.charAt(region.length() - 1))) {
                region = region.substring(0, region.length() - 1);
            }
            this.properties.setProperty("jclouds.regions", region);
        }
        this.properties.setProperty("jclouds.ec2.timeout.securitygroup-present", "" + Duration.seconds((Number)30).toMilliseconds());
        return this;
    }

    public JCloudsPropertiesBuilder setAzureComputeArmProperties() {
        String region = (String)this.conf.get(CloudLocationConfig.CLOUD_REGION_ID);
        if (Strings.isNonBlank((CharSequence)region)) {
            this.properties.setProperty("jclouds.regions", region);
        }
        return this;
    }

    public JCloudsPropertiesBuilder setCustomJcloudsProperties() {
        Map extra = Maps.filterKeys((Map)this.conf.getAllConfig(), (Predicate)Predicates.containsPattern((String)"^jclouds\\."));
        if (extra.size() > 0) {
            String provider = this.getProviderFromConfig(this.conf);
            LOG.debug("Configuring custom jclouds property overrides for {}: {}", (Object)provider, (Object)Sanitizer.sanitize((Map)extra));
        }
        this.properties.putAll((Map<?, ?>)Maps.filterValues((Map)extra, (Predicate)Predicates.notNull()));
        return this;
    }

    public JCloudsPropertiesBuilder setEndpointProperty() {
        String endpoint = (String)this.conf.get(CloudLocationConfig.CLOUD_ENDPOINT);
        if (!JavaGroovyEquivalents.groovyTruth((String)endpoint)) {
            endpoint = this.getDeprecatedProperty(this.conf, "jclouds.endpoint");
        }
        if (JavaGroovyEquivalents.groovyTruth((String)endpoint)) {
            this.properties.setProperty("jclouds.endpoint", endpoint);
        }
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    private String getDeprecatedProperty(ConfigBag conf, String key) {
        if (conf.containsKey(key)) {
            LOG.warn("Jclouds using deprecated brooklyn-jclouds property " + key + ": " + Sanitizer.sanitize((Map)conf.getAllConfig()));
            return (String)conf.getStringKey(key);
        }
        return null;
    }

    private String getProviderFromConfig(ConfigBag conf) {
        String rawProvider = (String)Preconditions.checkNotNull((Object)conf.get(CLOUD_PROVIDER), (Object)"provider must not be null");
        return DeserializingJcloudsRenamesProvider.INSTANCE.applyJcloudsRenames(rawProvider);
    }
}

