/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.binders;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.MapBinder;

public class BindManifestToJsonPayload
implements MapBinder {
    protected final Json jsonBinder;

    @Inject
    BindManifestToJsonPayload(Json jsonBinder) {
        this.jsonBinder = jsonBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        return this.bindToRequest(request, (Object)postParams);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        String json = this.jsonBinder.toJson(Preconditions.checkNotNull((Object)payload, (Object)"payload"));
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentLength(Long.valueOf(json.length()));
        return request;
    }
}

