/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.api.objs.HighlightTuple;
import org.apache.brooklyn.rest.domain.HasId;
import org.apache.brooklyn.rest.domain.HasName;
import org.apache.brooklyn.rest.domain.Status;

public class PolicySummary
implements HasName,
HasId,
Serializable {
    private static final long serialVersionUID = -5086680835225136768L;
    private final String id;
    private final String name;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String catalogItemId;
    private final Status state;
    private final Map<String, URI> links;
    private final Map<String, HighlightTuple> highlights;

    public PolicySummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="catalogItemId") String catalogItemId, @JsonProperty(value="state") Status state, @JsonProperty(value="highlights") Map<String, HighlightTuple> highlights, @JsonProperty(value="links") Map<String, URI> links) {
        this.id = id;
        this.name = name;
        this.catalogItemId = catalogItemId;
        this.state = state;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
        this.highlights = highlights == null ? ImmutableMap.of() : ImmutableMap.copyOf(highlights);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    public Status getState() {
        return this.state;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public Map<String, HighlightTuple> getHighlights() {
        return this.highlights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicySummary)) {
            return false;
        }
        PolicySummary that = (PolicySummary)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.catalogItemId, that.catalogItemId) && this.state == that.state && Objects.equals(this.highlights, that.highlights) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.catalogItemId, this.state, this.highlights, this.links});
    }

    public String toString() {
        return "PolicySummary{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", catalogItemId='" + this.catalogItemId + '\'' + ", state=" + (Object)((Object)this.state) + ", highlights=" + this.highlights + ", links=" + this.links + '}';
    }
}

