/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import com.google.common.annotations.Beta;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.ApplicationSummary;
import org.apache.brooklyn.rest.domain.EntityDetail;
import org.apache.brooklyn.rest.domain.EntitySummary;
import org.apache.brooklyn.rest.domain.TaskSummary;

@Path(value="/applications")
@Api(value="Applications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ApplicationApi {
    @GET
    @Path(value="/fetch")
    @ApiOperation(value="Fetch display details for all applications and optionally selected additional entities")
    public List<EntityDetail> fetch(@ApiParam(value="Selected additional entity ID's to include, comma-separated", required=false) @DefaultValue(value="") @QueryParam(value="items") String var1);

    @GET
    @ApiOperation(value="Fetch list of applications, as ApplicationSummary objects", response=ApplicationSummary.class)
    public List<ApplicationSummary> list(@ApiParam(value="Regular expression to filter by", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var1);

    @GET
    @Path(value="/{application}")
    @ApiOperation(value="Fetch a specific application", response=ApplicationSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Application not found")})
    public ApplicationSummary get(@ApiParam(value="ID or name of application whose details will be returned", required=true) @PathParam(value="application") String var1);

    @POST
    @Consumes(value={"application/x-yaml", "text/yaml", "text/x-yaml", "application/yaml"})
    @ApiOperation(value="Create and start a new application from YAML", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Undefined entity or location")})
    public Response createFromYaml(@ApiParam(name="applicationSpec", value="App spec in CAMP YAML format", required=true) String var1);

    @PUT
    @Path(value="/{application}")
    @Consumes(value={"application/x-yaml", "text/yaml", "text/x-yaml", "application/yaml"})
    @ApiOperation(value="[BETA] Create and start a new application from YAML, with the given id", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Undefined entity or location"), @ApiResponse(code=409, message="Application already registered")})
    @Beta
    public Response createFromYamlWithAppId(@ApiParam(name="applicationSpec", value="App spec in CAMP YAML format", required=true) String var1, @ApiParam(name="application", value="Application id", required=true) @PathParam(value="application") String var2);

    @POST
    @Consumes(value={"application/json", "application/octet-stream", "text/plain"})
    @ApiOperation(value="Create and start a new application from miscellaneous types, including JSON either new CAMP format or legacy AppSpec format", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Undefined entity or location")})
    public Response createPoly(@ApiParam(name="applicationSpec", value="App spec in JSON, YAML, or other (auto-detected) format", required=true) byte[] var1);

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Create and start a new application from form URL-encoded contents (underlying type autodetected)", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Undefined entity or location")})
    public Response createFromForm(@ApiParam(name="applicationSpec", value="App spec in form-encoded YAML, JSON, or other (auto-detected) format", required=true) @Valid String var1);

    @DELETE
    @Path(value="/{application}")
    @ApiOperation(value="Delete a specified application", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Application not found")})
    public Response delete(@ApiParam(name="application", value="Application name", required=true) @PathParam(value="application") String var1);

    @GET
    @Path(value="/{application}/descendants")
    @ApiOperation(value="Fetch entity info for all (or filtered) descendants", response=EntitySummary.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Application or entity missing")})
    public List<EntitySummary> getDescendants(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Regular expression for an entity type which must be matched", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var2);

    @GET
    @Path(value="/{application}/descendants/sensor/{sensor}")
    @ApiOperation(value="Fetch values of a given sensor for all (or filtered) descendants")
    @ApiResponses(value={@ApiResponse(code=404, message="Application or entity missing")})
    public Map<String, Object> getDescendantsSensor(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var2, @ApiParam(value="Regular expression for an entity type which must be matched", required=false) @DefaultValue(value=".*") @QueryParam(value="typeRegex") String var3);
}

