/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.osgi;

import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.core.BrooklynVersionService;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.BrooklynShutdownHooks;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.launcher.common.BasicLauncher;
import org.apache.brooklyn.launcher.common.BrooklynPropertiesFactoryHelper;
import org.apache.brooklyn.launcher.osgi.ConfigSupplier;
import org.apache.brooklyn.launcher.osgi.OsgiLauncher;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.provider.BrooklynUserWithRandomPasswordSecurityProvider;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.Threads;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiLauncherImpl
extends BasicLauncher<OsgiLauncherImpl>
implements OsgiLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiLauncherImpl.class);
    public static final String BROOKLYN_CONFIG_PID = "brooklyn";
    private Object reloadLock = new Object();
    private BrooklynVersionService brooklynVersion;
    private String globalBrooklynProperties;
    private String localBrooklynProperties;
    private String defaultCatalogLocation;
    private ConfigurationAdmin configAdmin;
    private ConfigSupplier configSupplier;

    public OsgiLauncherImpl startPartOne() {
        this.brooklynVersion.getVersion();
        Configuration brooklynConfig = this.getConfiguration(this.configAdmin, BROOKLYN_CONFIG_PID);
        if (brooklynConfig == null && Strings.isEmpty((CharSequence)this.globalBrooklynProperties) && Strings.isEmpty((CharSequence)this.localBrooklynProperties)) {
            LOG.warn("Config Admin PID 'brooklyn' not found, not using external configuration. Create a brooklyn.cfg file in etc folder.");
        }
        this.configSupplier = new ConfigSupplier(brooklynConfig);
        BrooklynPropertiesFactoryHelper helper = new BrooklynPropertiesFactoryHelper(this.globalBrooklynProperties, this.localBrooklynProperties, (Supplier)this.configSupplier);
        this.setBrooklynPropertiesBuilder(helper.createPropertiesBuilder());
        return (OsgiLauncherImpl)super.startPartOne();
    }

    private Configuration getConfiguration(ConfigurationAdmin configAdmin, String brooklynConfigPid) {
        Configuration[] configs;
        String filter = "(service.pid=" + brooklynConfigPid + ')';
        try {
            configs = configAdmin.listConfigurations(filter);
        }
        catch (IOException | InvalidSyntaxException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (configs != null && configs.length > 0) {
            return configs[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initOsgi() {
        Object object = this.reloadLock;
        synchronized (object) {
            Stopwatch startupTimer = Stopwatch.createStarted();
            BrooklynShutdownHooks.resetShutdownFlag();
            LOG.debug("OsgiLauncher init, catalog " + this.defaultCatalogLocation);
            this.catalogInitialization(new CatalogInitialization(String.format("file:%s", this.defaultCatalogLocation), false, null, false));
            this.startPartOne();
            startupTimer.stop();
            LOG.info("Brooklyn initialisation (part one) complete after {}", (Object)startupTimer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startOsgi() {
        Object object = this.reloadLock;
        synchronized (object) {
            Stopwatch startupTimer = Stopwatch.createStarted();
            LOG.debug("OsgiLauncher start");
            this.startPartTwo();
            startupTimer.stop();
            LOG.info("Brooklyn initialisation (part two) complete after {}", (Object)startupTimer.toString());
        }
    }

    @Override
    public void destroyOsgi() {
        LOG.debug("Notified of system shutdown, calling shutdown hooks");
        Threads.runShutdownHooks();
    }

    protected void startingUp() {
        super.startingUp();
        ManagementContext managementContext = this.getManagementContext();
        BrooklynProperties brooklynProperties = (BrooklynProperties)managementContext.getConfig();
        if (BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)brooklynProperties)) {
            LOG.info("No security provider options specified. Define a security provider or users to prevent a random password being created and logged.");
            brooklynProperties.put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)new BrooklynUserWithRandomPasswordSecurityProvider(managementContext));
            managementContext.getScratchpad().put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)new BrooklynUserWithRandomPasswordSecurityProvider(managementContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(Map<?, ?> props) {
        Object object = this.reloadLock;
        synchronized (object) {
            LOG.info("Updating brooklyn config because of config admin changes.");
            this.configSupplier.update(props);
            this.getManagementContext().reloadBrooklynProperties();
        }
    }

    public void setBrooklynVersion(BrooklynVersionService brooklynVersion) {
        this.brooklynVersion = brooklynVersion;
    }

    public void setPersistenceLocation(@Nullable String persistenceLocationSpec) {
        this.persistenceLocation(persistenceLocationSpec);
    }

    public void setBrooklynProperties(BrooklynProperties brooklynProperties) {
        this.brooklynProperties(brooklynProperties);
    }

    public void setIgnorePersistenceErrors(boolean ignorePersistenceErrors) {
        this.ignorePersistenceErrors(ignorePersistenceErrors);
    }

    public void setIgnoreCatalogErrors(boolean ignoreCatalogErrors) {
        this.ignoreCatalogErrors(ignoreCatalogErrors);
    }

    public void setIgnoreAppErrors(boolean ignoreAppErrors) {
        this.ignoreAppErrors(ignoreAppErrors);
    }

    public void setPersistMode(PersistMode persistMode) {
        this.persistMode(persistMode);
    }

    public void setHighAvailabilityMode(HighAvailabilityMode highAvailabilityMode) {
        this.highAvailabilityMode(highAvailabilityMode);
    }

    public void setPersistenceDir(@Nullable String persistenceDir) {
        this.persistenceDir(persistenceDir);
    }

    public void setPersistPeriod(String persistPeriod) {
        this.persistPeriod(Duration.parse((String)persistPeriod));
    }

    public void setHaHeartbeatTimeout(String val) {
        this.haHeartbeatTimeout(Duration.parse((String)val));
    }

    public void setStartBrooklynNode(boolean val) {
        this.startBrooklynNode(val);
    }

    public void setHaHeartbeatPeriod(String val) {
        this.haHeartbeatPeriod(Duration.parse((String)val));
    }

    public void setCopyPersistedState(String destinationDir) {
        this.copyPersistedState(destinationDir);
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setGlobalBrooklynProperties(String globalBrooklynProperties) {
        this.globalBrooklynProperties = globalBrooklynProperties;
    }

    public void setLocalBrooklynProperties(String localBrooklynProperties) {
        this.localBrooklynProperties = localBrooklynProperties;
    }

    public void setDefaultCatalogLocation(String defaultCatalogLocation) {
        this.defaultCatalogLocation = defaultCatalogLocation;
    }
}

