/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.loaders;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class DiskURIToImage
extends CacheLoader<URI, Optional<Image>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Resources resources;

    @Inject
    DiskURIToImage(Resources resources) {
        this.resources = resources;
    }

    public Optional<Image> load(URI key) throws ExecutionException {
        try {
            Disk disk = this.resources.disk(key);
            URI sourceImage = disk.sourceImage();
            Image image = sourceImage != null ? this.resources.image(sourceImage) : null;
            return Optional.fromNullable((Object)image);
        }
        catch (Exception e) {
            throw new ExecutionException(DiskURIToImage.message(key, e), e);
        }
    }

    public static String message(URI key, Exception e) {
        return String.format("could not find image for disk %s: %s", key.toString(), e.getMessage());
    }
}

