/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.base.Function;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.util.core.task.BasicTask;

public class TaskTags {
    public static final String INESSENTIAL_TASK = "inessential";
    public static final String SUB_TASK_TAG = "SUB-TASK";

    public static void addTagDynamically(TaskAdaptable<?> task, final Object tag) {
        ((BasicTask)task.asTask()).applyTagModifier(new Function<Set<Object>, Void>(){

            public Void apply(@Nullable Set<Object> input) {
                input.add(tag);
                return null;
            }
        });
    }

    public static void addTagsDynamically(TaskAdaptable<?> task, final Object tag1, final Object ... tags) {
        ((BasicTask)task.asTask()).applyTagModifier(new Function<Set<Object>, Void>(){

            public Void apply(@Nullable Set<Object> input) {
                input.add(tag1);
                for (Object tag : tags) {
                    input.add(tag);
                }
                return null;
            }
        });
    }

    public static boolean isInessential(Task<?> task) {
        return TaskTags.hasTag(task, INESSENTIAL_TASK);
    }

    public static boolean hasTag(Task<?> task, Object tag) {
        if (task == null) {
            return false;
        }
        return task.getTags().contains(tag);
    }

    public static <U, V extends TaskAdaptable<U>> V markInessential(V task) {
        TaskTags.addTagDynamically(task, INESSENTIAL_TASK);
        return task;
    }
}

