/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.ssh.sshj;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CountingOutputStream;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionChannel;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.InMemorySourceFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.util.core.internal.ssh.BackoffLimitedRetryHandler;
import org.apache.brooklyn.util.core.internal.ssh.ShellAbstractTool;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshAbstractTool;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.internal.ssh.sshj.SshjClientConnection;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeTimeoutException;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.stream.KnownSizeInputStream;
import org.apache.brooklyn.util.stream.StreamGobbler;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.io.input.ProxyInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshjTool
extends SshAbstractTool
implements SshTool {
    private static final Logger LOG = LoggerFactory.getLogger(SshjTool.class);
    protected final int sshTries;
    protected final long sshTriesTimeout;
    protected final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
    static final String TERM = "vt100";
    private final SshjClientConnection sshClientConnection;
    private final SshAbstractTool.SshAction<SFTPClient> sftpConnection = new SshAbstractTool.SshAction<SFTPClient>(){
        private SFTPClient sftp;

        @Override
        public void clear() {
            SshjTool.this.closeWhispering((Closeable)this.sftp, this);
            this.sftp = null;
        }

        @Override
        public SFTPClient create() throws IOException {
            SshjTool.this.checkConnected();
            this.sftp = ((SshjTool)SshjTool.this).sshClientConnection.ssh.newSFTPClient();
            return this.sftp;
        }

        public String toString() {
            return "SFTPClient()";
        }
    };

    public static SshjToolBuilder builder() {
        return new SshjToolBuilder();
    }

    public SshjTool(Map<String, ?> map) {
        this((Builder<?, ?>)SshjTool.builder().from((Map)map));
    }

    protected SshjTool(Builder<?, ?> builder) {
        super(builder);
        this.sshTries = builder.sshTries;
        this.sshTriesTimeout = builder.sshTriesTimeout;
        this.backoffLimitedRetryHandler = new BackoffLimitedRetryHandler(this.sshTries, builder.sshRetryDelay);
        this.sshClientConnection = SshjClientConnection.builder().hostAndPort(HostAndPort.fromParts((String)this.host, (int)this.port)).username(this.user).password(this.password).privateKeyPassphrase(this.privateKeyPassphrase).privateKeyData(this.privateKeyData).privateKeyFile(this.privateKeyFile).strictHostKeyChecking(this.strictHostKeyChecking).connectTimeout(builder.connectTimeout).sessionTimeout(builder.sessionTimeout).build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created SshTool {} ({})", (Object)this, (Object)System.identityHashCode(this));
        }
    }

    @Override
    public void connect() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Connecting SshjTool {} ({})", (Object)this, (Object)System.identityHashCode(this));
            }
            this.acquire(this.sshClientConnection);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.toString() + " failed to connect (rethrowing)", (Throwable)e);
            }
            throw this.propagate(e, "failed to connect");
        }
    }

    @Override
    @Deprecated
    public void connect(int maxAttempts) {
        this.connect();
    }

    @Override
    public void disconnect() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Disconnecting SshjTool {} ({})", (Object)this, (Object)System.identityHashCode(this));
        }
        try {
            Stopwatch perfStopwatch = Stopwatch.createStarted();
            this.sshClientConnection.clear();
            if (LOG.isTraceEnabled()) {
                LOG.trace("SSH Performance: {} disconnect took {}", (Object)this.sshClientConnection.getHostAndPort(), (Object)Time.makeTimeStringRounded((Stopwatch)perfStopwatch));
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.sshClientConnection.isConnected() && this.sshClientConnection.isAuthenticated();
    }

    @Override
    public int copyToServer(Map<String, ?> props, byte[] contents, String pathAndFileOnRemoteServer) {
        return this.copyToServer(props, this.newInputStreamSupplier(contents), contents.length, pathAndFileOnRemoteServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyToServer(Map<String, ?> props, InputStream contents, String pathAndFileOnRemoteServer) {
        if (contents instanceof KnownSizeInputStream) {
            return this.copyToServer(props, (Supplier<InputStream>)Suppliers.ofInstance((Object)contents), ((KnownSizeInputStream)contents).length(), pathAndFileOnRemoteServer);
        }
        File tempFile = this.writeTempFile(contents);
        try {
            int n = this.copyToServer(props, tempFile, pathAndFileOnRemoteServer);
            return n;
        }
        finally {
            tempFile.delete();
        }
    }

    @Override
    public int copyToServer(Map<String, ?> props, File localFile, String pathAndFileOnRemoteServer) {
        return this.copyToServer(props, this.newInputStreamSupplier(localFile), (int)localFile.length(), pathAndFileOnRemoteServer);
    }

    private int copyToServer(Map<String, ?> props, Supplier<InputStream> contentsSupplier, long length, String pathAndFileOnRemoteServer) {
        this.acquire(new PutFileAction(props, pathAndFileOnRemoteServer, contentsSupplier, length));
        return 0;
    }

    @Override
    public int copyFromServer(Map<String, ?> props, String pathAndFileOnRemoteServer, File localFile) {
        LocalDestFile localDestFile = (LocalDestFile)this.acquire(new GetFileAction(pathAndFileOnRemoteServer, localFile));
        return 0;
    }

    @Override
    public int execScript(Map<String, ?> props, final List<String> commands, final Map<String, ?> env) {
        Boolean execAsync = (Boolean)SshjTool.getOptionalVal(props, PROP_EXEC_ASYNC);
        if (Boolean.TRUE.equals(execAsync) && BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.ssh.asyncExec")) {
            return this.execScriptAsyncAndPoll(props, commands, env);
        }
        if (Boolean.TRUE.equals(execAsync) && LOG.isDebugEnabled()) {
            LOG.debug("Ignoring ssh exec-async configuration, because feature is disabled");
        }
        return new ShellAbstractTool.ToolAbstractExecScript(props){

            @Override
            public int run() {
                String scriptContents = SshjTool.this.toScript(this.props, commands, env);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running shell command at {} as script: {}", (Object)SshjTool.this.host, (Object)scriptContents);
                }
                SshjTool.this.copyToServer((Map<String, ?>)ImmutableMap.of((Object)"permissions", (Object)"0700"), scriptContents.getBytes(), this.scriptPath);
                return SshjTool.asInt((Integer)SshjTool.this.acquire(new ShellAction(this.buildRunScriptCommand(), this.out, this.err, this.execTimeout)), -1);
            }
        }.run();
    }

    protected int execScriptAsyncAndPoll(Map<String, ?> props, final List<String> commands, final Map<String, ?> env) {
        return new ShellAbstractTool.ToolAbstractAsyncExecScript(props){
            private int maxConsecutiveSshFailures;
            private Duration maxDelayBetweenPolls;
            private Duration pollTimeout;
            private int iteration;
            private int consecutiveSshFailures;
            private int stdoutCount;
            private int stderrCount;
            private Stopwatch timer;
            {
                super(SshjTool.this, props);
                this.maxConsecutiveSshFailures = 3;
                this.maxDelayBetweenPolls = Duration.seconds((Number)20);
                this.pollTimeout = (Duration)SshjTool.getOptionalVal(this.props, ShellTool.PROP_EXEC_ASYNC_POLLING_TIMEOUT, Duration.FIVE_MINUTES);
                this.iteration = 0;
                this.consecutiveSshFailures = 0;
                this.stdoutCount = 0;
                this.stderrCount = 0;
            }

            @Override
            public int run() {
                boolean uploadSuccess;
                this.timer = Stopwatch.createStarted();
                final String scriptContents = SshjTool.this.toScript(this.props, commands, env);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running shell command at {} as async script: {}", (Object)SshjTool.this.host, (Object)scriptContents);
                }
                if (!(uploadSuccess = Repeater.create((String)("async script upload on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")")).backoffTo(this.maxDelayBetweenPolls).limitIterationsTo(3).rethrowException().until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        iteration++;
                        if (LOG.isDebugEnabled()) {
                            String msg = "Uploading (iteration=" + iteration + ") for async script on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")";
                            if (iteration == 1) {
                                LOG.trace(msg);
                            } else {
                                LOG.debug(msg);
                            }
                        }
                        SshjTool.this.copyToServer((Map<String, ?>)ImmutableMap.of((Object)"permissions", (Object)"0700"), scriptContents.getBytes(), scriptPath);
                        return true;
                    }
                }).run())) {
                    String msg = "Unexpected state: repeated failure for async script upload on " + SshjTool.this.toString() + " (" + this.getSummary() + ")";
                    LOG.warn(msg + "; rethrowing");
                    throw new IllegalStateException(msg);
                }
                int execResult = SshjTool.asInt((Integer)SshjTool.this.acquire(new ShellAction(this.buildRunScriptCommand(), this.out, this.err, this.execTimeout)), -1);
                if (execResult != 0) {
                    return execResult;
                }
                try {
                    final AtomicReference result = new AtomicReference();
                    boolean success = Repeater.create((String)("async script long-poll on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")")).backoffTo(this.maxDelayBetweenPolls).limitTimeTo(this.execTimeout).until((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            iteration++;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Doing long-poll (iteration=" + iteration + ") for async script to complete on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                            }
                            Integer exitstatus = this.longPoll();
                            result.set(exitstatus);
                            return exitstatus != null;
                        }
                    }).run();
                    if (!success) {
                        String msg = "Timeout for async script to complete on " + SshjTool.this.toString() + " (" + this.getSummary() + ")";
                        LOG.warn(msg + "; rethrowing");
                        throw new TimeoutException(msg);
                    }
                    int n = (Integer)result.get();
                    return n;
                }
                catch (Exception e) {
                    LOG.debug("Problem polling for async script on " + SshjTool.this.toString() + " (for " + this.getSummary() + "); rethrowing after deleting temporary files", (Throwable)e);
                    throw Exceptions.propagate((Throwable)e);
                }
                finally {
                    try {
                        int execDeleteResult = SshjTool.asInt((Integer)SshjTool.this.acquire(new ShellAction(this.deleteTemporaryFilesCommand(), this.out, this.err, this.pollTimeout)), -1);
                        if (execDeleteResult != 0) {
                            LOG.debug("Problem deleting temporary files of async script on " + SshjTool.this.toString() + " (for " + this.getSummary() + "): exit status " + execDeleteResult);
                        }
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        LOG.debug("Problem deleting temporary files of async script on " + SshjTool.this.toString() + " (for " + this.getSummary() + "); continuing", (Throwable)e);
                    }
                }
            }

            Integer longPoll() throws IOException {
                Integer result;
                int longPollResult;
                Duration nextPollTimeout = Duration.min((Duration)this.pollTimeout, (Duration)Duration.millis((Number)(this.execTimeout.toMilliseconds() - this.timer.elapsed(TimeUnit.MILLISECONDS))));
                CountingOutputStream countingOut = this.out == null ? null : new CountingOutputStream(this.out);
                CountingOutputStream countingErr = this.err == null ? null : new CountingOutputStream(this.err);
                List<String> pollCommand = this.buildLongPollCommand(this.stdoutCount, this.stderrCount, nextPollTimeout);
                Duration sshJoinTimeout = nextPollTimeout.add(Duration.TEN_SECONDS);
                ShellAction action = new ShellAction(pollCommand, (OutputStream)countingOut, (OutputStream)countingErr, sshJoinTimeout);
                try {
                    longPollResult = SshjTool.asInt((Integer)SshjTool.this.acquire(action, 3, nextPollTimeout), -1);
                }
                catch (RuntimeTimeoutException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Long-poll timed out on " + SshjTool.this.toString() + " (for " + this.getSummary() + "): " + (Object)((Object)e));
                    }
                    return null;
                }
                this.stdoutCount = (int)((long)this.stdoutCount + (countingOut == null ? 0L : countingOut.getCount()));
                this.stderrCount = (int)((long)this.stderrCount + (countingErr == null ? 0L : countingErr.getCount()));
                if (longPollResult == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Long-poll succeeded (exit status 0) on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                    }
                    return longPollResult;
                }
                if (longPollResult == -1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Long-poll received exit status -1; will retry on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                    }
                    return null;
                }
                if (longPollResult == 125) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Long-poll received exit status " + longPollResult + "; most likely timeout; retrieving actual status on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                    }
                    return this.retrieveStatusCommand();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Long-poll received exit status " + longPollResult + "; retrieving actual status on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                }
                if ((result = this.retrieveStatusCommand()) != null) {
                    return result;
                }
                ++this.consecutiveSshFailures;
                if (this.consecutiveSshFailures > this.maxConsecutiveSshFailures) {
                    LOG.warn("Aborting on " + this.consecutiveSshFailures + " consecutive ssh connection errors (return -1) when polling for async script to complete on " + SshjTool.this.toString() + " (" + this.getSummary() + ")");
                    return -1;
                }
                LOG.info("Retrying after ssh connection error when polling for async script to complete on " + SshjTool.this.toString() + " (" + this.getSummary() + ")");
                return null;
            }

            Integer retrieveStatusCommand() throws IOException {
                ByteArrayOutputStream statusOut = new ByteArrayOutputStream();
                ByteArrayOutputStream statusErr = new ByteArrayOutputStream();
                int statusResult = SshjTool.asInt((Integer)SshjTool.this.acquire(new ShellAction(this.buildRetrieveStatusCommand(), statusOut, statusErr, this.execTimeout)), -1);
                if (statusResult == 0) {
                    String statusOutStr = new String(statusOut.toByteArray()).trim();
                    if (Strings.isEmpty((CharSequence)statusOutStr)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Long-poll retrieved status directly; command successful but no result available on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                        }
                        return null;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Long-poll retrieved status directly; returning '" + statusOutStr + "' on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                    }
                    int result = Integer.parseInt(statusOutStr);
                    return result;
                }
                if (statusResult == -1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Long-poll retrieving status directly received exit status -1; will retry on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                    }
                    return null;
                }
                if (this.out != null) {
                    this.out.write(SshjTool.this.toUTF8ByteArray("retrieving status failed with exit code " + statusResult + " (stdout follow)"));
                    this.out.write(statusOut.toByteArray());
                }
                if (this.err != null) {
                    this.err.write(SshjTool.this.toUTF8ByteArray("retrieving status failed with exit code " + statusResult + " (stderr follow)"));
                    this.err.write(statusErr.toByteArray());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Long-poll retrieving status failed; returning " + statusResult + " on " + SshjTool.this.toString() + " (for " + this.getSummary() + ")");
                }
                return statusResult;
            }
        }.run();
    }

    public int execShellDirect(Map<String, ?> props, List<String> commands, Map<String, ?> env) {
        OutputStream out = (OutputStream)SshjTool.getOptionalVal(props, PROP_OUT_STREAM);
        OutputStream err = (OutputStream)SshjTool.getOptionalVal(props, PROP_ERR_STREAM);
        Duration execTimeout = (Duration)SshjTool.getOptionalVal(props, PROP_EXEC_TIMEOUT);
        List<String> cmdSequence = this.toCommandSequence(commands, env);
        ImmutableList allcmds = ImmutableList.builder().add(SshjTool.getOptionalVal(props, PROP_DIRECT_HEADER)).addAll(cmdSequence).add((Object)"exit $?").build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Running shell command at {}: {}", (Object)this.host, (Object)allcmds);
        }
        Integer result = (Integer)this.acquire(new ShellAction((List<String>)allcmds, out, err, execTimeout));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Running shell command at {} completed: return status {}", (Object)this.host, (Object)result);
        }
        return SshjTool.asInt(result, -1);
    }

    @Override
    public int execCommands(Map<String, ?> props, List<String> commands, Map<String, ?> env) {
        if (Boolean.FALSE.equals(props.get("blocks"))) {
            throw new IllegalArgumentException("Cannot exec non-blocking: command=" + commands);
        }
        Boolean execAsync = (Boolean)SshjTool.getOptionalVal(props, PROP_EXEC_ASYNC);
        if (Boolean.TRUE.equals(execAsync) && BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.ssh.asyncExec")) {
            return this.execScriptAsyncAndPoll(props, commands, env);
        }
        OutputStream out = (OutputStream)SshjTool.getOptionalVal(props, PROP_OUT_STREAM);
        OutputStream err = (OutputStream)SshjTool.getOptionalVal(props, PROP_ERR_STREAM);
        String separator = (String)SshjTool.getOptionalVal(props, PROP_SEPARATOR);
        Duration execTimeout = (Duration)SshjTool.getOptionalVal(props, PROP_EXEC_TIMEOUT);
        List<String> allcmds = this.toCommandSequence(commands, env);
        String singlecmd = Joiner.on((String)separator).join(allcmds);
        if (Boolean.TRUE.equals(SshjTool.getOptionalVal(props, PROP_RUN_AS_ROOT))) {
            LOG.warn("Cannot run as root when executing as command; run as a script instead (will run as normal user): " + singlecmd);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Running command at {}: {}", (Object)this.host, (Object)singlecmd);
        }
        Session.Command result = (Session.Command)this.acquire(new ExecAction(singlecmd, out, err, execTimeout));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Running command at {} completed: exit code {}", (Object)this.host, (Object)result.getExitStatus());
        }
        if (result.getExitStatus() == null) {
            LOG.warn("Null exit status running at {}: {}", (Object)this.host, (Object)singlecmd);
        }
        return SshjTool.asInt(result.getExitStatus(), -1);
    }

    protected void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException(String.format("(%s) ssh not connected!", this.toString()));
        }
    }

    protected void backoffForAttempt(int retryAttempt, String message) {
        this.backoffLimitedRetryHandler.imposeBackoffExponentialDelay(retryAttempt, message);
    }

    protected <T, C extends SshAbstractTool.SshAction<T>> T acquire(C action) {
        return this.acquire(action, this.sshTries, this.sshTriesTimeout == 0L ? Duration.PRACTICALLY_FOREVER : Duration.millis((Number)this.sshTriesTimeout));
    }

    protected <T, C extends SshAbstractTool.SshAction<T>> T acquire(C action, int sshTries, Duration sshTriesTimeout) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (int i = 0; i < sshTries; ++i) {
            try {
                T returnVal;
                action.clear();
                if (LOG.isTraceEnabled()) {
                    LOG.trace(">> ({}) acquiring {}", (Object)this.toString(), action);
                }
                Stopwatch perfStopwatch = Stopwatch.createStarted();
                try {
                    returnVal = action.create();
                }
                catch (AssertionError e) {
                    throw new IllegalStateException("Problem in " + this.toString() + " for " + action, (Throwable)((Object)e));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("<< ({}) acquired {}", (Object)this.toString(), returnVal);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SSH Performance: {} {} took {}", new Object[]{this.sshClientConnection.getHostAndPort(), action.getClass().getSimpleName() != null ? action.getClass().getSimpleName() : action, Time.makeTimeStringRounded((Stopwatch)perfStopwatch)});
                }
                return returnVal;
            }
            catch (Exception e) {
                String errorMessage = String.format("(%s) error acquiring %s", this.toString(), action);
                String fullMessage = String.format("%s (attempt %s/%s, in time %s/%s)", errorMessage, i + 1, sshTries, Time.makeTimeStringRounded((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)), sshTriesTimeout.equals((Object)Duration.PRACTICALLY_FOREVER) ? "unlimited" : Time.makeTimeStringRounded((Duration)sshTriesTimeout));
                try {
                    this.disconnect();
                }
                catch (Exception e2) {
                    LOG.debug("<< (" + this.toString() + ") error closing connection: " + e + " / " + e2, (Throwable)e);
                }
                if (i + 1 == sshTries) {
                    LOG.debug("<< {} (rethrowing, out of retries): {}", (Object)fullMessage, (Object)e.getMessage());
                    throw this.propagate(e, fullMessage + "; out of retries");
                }
                if (sshTriesTimeout.isShorterThan(stopwatch)) {
                    LOG.debug("<< {} (rethrowing, out of time - max {}): {}", new Object[]{fullMessage, Time.makeTimeStringRounded((Duration)sshTriesTimeout), e.getMessage()});
                    throw new RuntimeTimeoutException(fullMessage + "; out of time", (Throwable)e);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<< {}: {}", (Object)fullMessage, (Object)e.getMessage());
                }
                this.backoffForAttempt(i + 1, errorMessage + ": " + e.getMessage());
                if (action == this.sshClientConnection) continue;
                this.connect();
                continue;
            }
        }
        assert (false) : "should not reach here";
        return null;
    }

    @VisibleForTesting
    Predicate<String> causalChainHasMessageContaining(final Exception from) {
        return new Predicate<String>(){

            public boolean apply(final String input) {
                return Iterables.any((Iterable)Throwables.getCausalChain((Throwable)from), (Predicate)new Predicate<Throwable>(){

                    public boolean apply(Throwable throwable) {
                        return throwable.toString().contains(input) || throwable.getMessage() != null && throwable.getMessage().contains(input);
                    }
                });
            }
        };
    }

    protected SshAbstractTool.SshAction<Session> newSessionAction() {
        return new SshAbstractTool.SshAction<Session>(){
            private Session session = null;

            @Override
            public void clear() throws TransportException, ConnectionException {
                SshjTool.this.closeWhispering((Closeable)this.session, this);
                this.session = null;
            }

            @Override
            public Session create() throws Exception {
                SshjTool.this.checkConnected();
                this.session = ((SshjTool)SshjTool.this).sshClientConnection.ssh.startSession();
                if (SshjTool.this.allocatePTY) {
                    this.session.allocatePTY(SshjTool.TERM, 80, 24, 0, 0, Collections.emptyMap());
                }
                return this.session;
            }

            public String toString() {
                return "Session()";
            }
        };
    }

    private byte[] toUTF8ByteArray(String string) {
        return org.bouncycastle.util.Strings.toUTF8ByteArray((String)string);
    }

    private Supplier<InputStream> newInputStreamSupplier(final byte[] contents) {
        return new Supplier<InputStream>(){

            public InputStream get() {
                return new ByteArrayInputStream(contents);
            }
        };
    }

    private Supplier<InputStream> newInputStreamSupplier(final File file) {
        return new Supplier<InputStream>(){

            public InputStream get() {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        };
    }

    class ShellAction
    implements SshAbstractTool.SshAction<Integer> {
        @VisibleForTesting
        final List<String> commands;
        @VisibleForTesting
        final OutputStream out;
        @VisibleForTesting
        final OutputStream err;
        private Session session;
        private Session.Shell shell;
        private StreamGobbler outgobbler;
        private StreamGobbler errgobbler;
        private Duration timeout;

        ShellAction(List<String> commands, OutputStream out, OutputStream err, Duration timeout) {
            this.commands = (List)Preconditions.checkNotNull(commands, (Object)"commands");
            this.out = out;
            this.err = err;
            Duration sessionTimeout = SshjTool.this.sshClientConnection.getSessionTimeout() == 0 ? Duration.PRACTICALLY_FOREVER : Duration.millis((Number)SshjTool.this.sshClientConnection.getSessionTimeout());
            this.timeout = timeout == null ? sessionTimeout : Duration.min((Duration)timeout, (Duration)sessionTimeout);
        }

        @Override
        public void clear() throws TransportException, ConnectionException {
            SshjTool.this.closeWhispering((Closeable)this.session, this);
            SshjTool.this.closeWhispering((Closeable)this.shell, this);
            SshjTool.this.closeWhispering((Closeable)this.outgobbler, this);
            SshjTool.this.closeWhispering((Closeable)this.errgobbler, this);
            this.session = null;
            this.shell = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Integer create() throws Exception {
            try {
                Integer n;
                this.session = (Session)SshjTool.this.acquire(SshjTool.this.newSessionAction());
                this.shell = this.session.startShell();
                if (this.out != null) {
                    InputStream outstream = this.shell.getInputStream();
                    this.outgobbler = new StreamGobbler(outstream, this.out, (Logger)null);
                    this.outgobbler.start();
                }
                if (this.err != null) {
                    InputStream errstream = this.shell.getErrorStream();
                    this.errgobbler = new StreamGobbler(errstream, this.err, (Logger)null);
                    this.errgobbler.start();
                }
                OutputStream output = this.shell.getOutputStream();
                for (CharSequence charSequence : this.commands) {
                    try {
                        output.write(SshjTool.this.toUTF8ByteArray(charSequence + "\n"));
                        output.flush();
                    }
                    catch (ConnectionException e) {
                        if (this.shell.isOpen()) throw e;
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("Shell closed to {} when executing {}", (Object)SshjTool.this.toString(), this.commands);
                        break;
                    }
                }
                SshjTool.this.closeWhispering(output, this);
                boolean timedOut = false;
                try {
                    long l = Math.min(this.timeout.toMilliseconds(), Integer.MAX_VALUE);
                    long timeoutEnd = System.currentTimeMillis() + l;
                    ConnectionException last = null;
                    while (this.shell.isOpen() || ((SessionChannel)this.session).getExitStatus() == null) {
                        boolean endBecauseReturned = !this.shell.isOpen() || ((SessionChannel)this.session).getExitStatus() != null;
                        try {
                            this.shell.join(1000L, TimeUnit.MILLISECONDS);
                        }
                        catch (ConnectionException e) {
                            last = e;
                        }
                        if (!endBecauseReturned && System.currentTimeMillis() < timeoutEnd) continue;
                    }
                    if (this.shell.isOpen() && ((SessionChannel)this.session).getExitStatus() == null) {
                        LOG.debug("Timeout ({}) in SSH shell to {}", (Object)this.timeout, (Object)this);
                        timedOut = true;
                        throw last != null ? last : new TimeoutException("Timeout after " + this.timeout + " executing " + this);
                    }
                    n = ((SessionChannel)this.session).getExitStatus();
                }
                catch (Throwable throwable) {
                    SshjTool.this.closeWhispering((Closeable)this.shell, this);
                    this.shell = null;
                    try {
                        long joinTimeout;
                        long l = joinTimeout = timedOut ? 1000L : 10000L;
                        if (this.outgobbler != null) {
                            this.outgobbler.join(joinTimeout);
                            this.outgobbler.close();
                        }
                        if (this.errgobbler == null) throw throwable;
                        this.errgobbler.join(joinTimeout);
                        this.errgobbler.close();
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted gobbling streams from ssh: " + this.commands, (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                SshjTool.this.closeWhispering((Closeable)this.shell, this);
                this.shell = null;
                try {
                    long joinTimeout;
                    long l = joinTimeout = timedOut ? 1000L : 10000L;
                    if (this.outgobbler != null) {
                        this.outgobbler.join(joinTimeout);
                        this.outgobbler.close();
                    }
                    if (this.errgobbler == null) return n;
                    this.errgobbler.join(joinTimeout);
                    this.errgobbler.close();
                    return n;
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted gobbling streams from ssh: " + this.commands, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                return n;
            }
            finally {
                this.clear();
            }
        }

        public String toString() {
            return "Shell(command=[" + this.commands + "])";
        }
    }

    class ExecAction
    implements SshAbstractTool.SshAction<Session.Command> {
        private final String command;
        private final OutputStream out;
        private final OutputStream err;
        private final Duration timeout;
        private Session session;
        private Session.Shell shell;
        private StreamGobbler outgobbler;
        private StreamGobbler errgobbler;

        ExecAction(String command, OutputStream out, OutputStream err, Duration timeout) {
            this.command = (String)Preconditions.checkNotNull((Object)command, (Object)"command");
            this.out = out;
            this.err = err;
            Duration sessionTimeout = SshjTool.this.sshClientConnection.getSessionTimeout() == 0 ? Duration.PRACTICALLY_FOREVER : Duration.millis((Number)SshjTool.this.sshClientConnection.getSessionTimeout());
            this.timeout = timeout == null ? sessionTimeout : Duration.min((Duration)timeout, (Duration)sessionTimeout);
        }

        @Override
        public void clear() throws TransportException, ConnectionException {
            SshjTool.this.closeWhispering((Closeable)this.session, this);
            SshjTool.this.closeWhispering((Closeable)this.shell, this);
            SshjTool.this.closeWhispering((Closeable)this.outgobbler, this);
            SshjTool.this.closeWhispering((Closeable)this.errgobbler, this);
            this.session = null;
            this.shell = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Session.Command create() throws Exception {
            try {
                Session.Command command;
                this.session = (Session)SshjTool.this.acquire(SshjTool.this.newSessionAction());
                Session.Command output = this.session.exec((String)Preconditions.checkNotNull((Object)this.command, (Object)"command"));
                if (this.out != null) {
                    this.outgobbler = new StreamGobbler(output.getInputStream(), this.out, (Logger)null);
                    this.outgobbler.start();
                }
                if (this.err != null) {
                    this.errgobbler = new StreamGobbler(output.getErrorStream(), this.err, (Logger)null);
                    this.errgobbler.start();
                }
                try {
                    output.join((long)((int)Math.min(this.timeout.toMilliseconds(), Integer.MAX_VALUE)), TimeUnit.MILLISECONDS);
                    command = output;
                }
                catch (Throwable throwable) {
                    try {
                        long joinTimeout = 10000L;
                        if (this.outgobbler != null) {
                            this.outgobbler.join(joinTimeout);
                        }
                        if (this.errgobbler == null) throw throwable;
                        this.errgobbler.join(joinTimeout);
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted gobbling streams from ssh: " + this.command, (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                try {
                    long joinTimeout = 10000L;
                    if (this.outgobbler != null) {
                        this.outgobbler.join(joinTimeout);
                    }
                    if (this.errgobbler == null) return command;
                    this.errgobbler.join(joinTimeout);
                    return command;
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted gobbling streams from ssh: " + this.command, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                return command;
            }
            finally {
                this.clear();
            }
        }

        public String toString() {
            return "Exec(command=[" + this.command + "])";
        }
    }

    private class PutFileAction
    implements SshAbstractTool.SshAction<Void> {
        private SFTPClient sftp;
        private final String path;
        private final int permissionsMask;
        private final long lastModificationDate;
        private final long lastAccessDate;
        private final int uid;
        private final Supplier<InputStream> contentsSupplier;
        private final Integer length;

        PutFileAction(Map<String, ?> props, String path, Supplier<InputStream> contentsSupplier, long length) {
            String permissions = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_PERMISSIONS);
            long lastModificationDateVal = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_LAST_MODIFICATION_DATE);
            long lastAccessDateVal = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_LAST_ACCESS_DATE);
            if (lastAccessDateVal <= 0L ^ lastModificationDateVal <= 0L) {
                lastAccessDateVal = Math.max(lastAccessDateVal, lastModificationDateVal);
                lastModificationDateVal = Math.max(lastAccessDateVal, lastModificationDateVal);
            }
            this.permissionsMask = Integer.parseInt(permissions, 8);
            this.lastAccessDate = lastAccessDateVal;
            this.lastModificationDate = lastModificationDateVal;
            this.uid = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_OWNER_UID);
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.contentsSupplier = (Supplier)Preconditions.checkNotNull(contentsSupplier, (Object)"contents");
            this.length = Ints.checkedCast((long)((Long)Preconditions.checkNotNull((Object)length, (Object)"size")));
        }

        @Override
        public void clear() {
            SshjTool.this.closeWhispering((Closeable)this.sftp, this);
            this.sftp = null;
        }

        @Override
        public Void create() throws Exception {
            final AtomicReference inputStreamRef = new AtomicReference();
            this.sftp = (SFTPClient)SshjTool.this.acquire(SshjTool.this.sftpConnection);
            try {
                this.sftp.put((LocalSourceFile)new InMemorySourceFile(){

                    public String getName() {
                        return PutFileAction.this.path;
                    }

                    public long getLength() {
                        return PutFileAction.this.length.intValue();
                    }

                    public InputStream getInputStream() throws IOException {
                        InputStream contents = (InputStream)PutFileAction.this.contentsSupplier.get();
                        inputStreamRef.set(contents);
                        return contents;
                    }
                }, this.path);
                this.sftp.chmod(this.path, this.permissionsMask);
                if (this.uid != -1) {
                    this.sftp.chown(this.path, this.uid);
                }
                if (this.lastAccessDate > 0L) {
                    this.sftp.setattr(this.path, new FileAttributes.Builder().withAtimeMtime(this.lastAccessDate, this.lastModificationDate).build());
                }
            }
            finally {
                SshjTool.this.closeWhispering((Closeable)inputStreamRef.get(), this);
            }
            return null;
        }

        public String toString() {
            return "Put(path=[" + this.path + " " + this.length + "])";
        }
    }

    private class GetFileAction
    implements SshAbstractTool.SshAction<LocalDestFile> {
        private final String path;
        private final File localFile;
        private SFTPClient sftp;

        public GetFileAction(String path, File localFile) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.localFile = (File)Preconditions.checkNotNull((Object)localFile, (Object)"localFile");
        }

        @Override
        public void clear() throws IOException {
            SshjTool.this.closeWhispering((Closeable)this.sftp, this);
            this.sftp = null;
        }

        @Override
        public LocalDestFile create() throws Exception {
            this.sftp = (SFTPClient)SshjTool.this.acquire(SshjTool.this.sftpConnection);
            FileSystemFile localDestFile = new FileSystemFile(this.localFile);
            this.sftp.get(this.path, (LocalDestFile)localDestFile);
            return localDestFile;
        }

        public String toString() {
            return "Payload(path=[" + this.path + "])";
        }
    }

    public static class Builder<T extends SshjTool, B extends Builder<T, B>>
    extends SshAbstractTool.AbstractSshToolBuilder<T, B> {
        protected long connectTimeout;
        protected long sessionTimeout;
        protected int sshTries = 4;
        protected long sshTriesTimeout = 120000L;
        protected long sshRetryDelay = 50L;

        @Override
        public B from(Map<String, ?> props) {
            super.from(props);
            this.sshTries = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_SSH_TRIES);
            this.sshTriesTimeout = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_SSH_TRIES_TIMEOUT);
            this.sshRetryDelay = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_SSH_RETRY_DELAY);
            this.connectTimeout = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_CONNECT_TIMEOUT);
            this.sessionTimeout = ShellAbstractTool.getOptionalVal(props, SshTool.PROP_SESSION_TIMEOUT);
            return (B)((Builder)this.self());
        }

        public B connectTimeout(int val) {
            this.connectTimeout = val;
            return (B)((Builder)this.self());
        }

        public B sessionTimeout(int val) {
            this.sessionTimeout = val;
            return (B)((Builder)this.self());
        }

        public B sshRetries(int val) {
            this.sshTries = val;
            return (B)((Builder)this.self());
        }

        public B sshRetriesTimeout(int val) {
            this.sshTriesTimeout = val;
            return (B)((Builder)this.self());
        }

        public B sshRetryDelay(long val) {
            this.sshRetryDelay = val;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new SshjTool(this);
        }
    }

    public static class SshjToolBuilder
    extends Builder<SshjTool, SshjToolBuilder> {
    }

    private class CloseFtpChannelOnCloseInputStream
    extends ProxyInputStream {
        private final SFTPClient sftp;

        private CloseFtpChannelOnCloseInputStream(InputStream proxy, SFTPClient sftp) {
            super(proxy);
            this.sftp = sftp;
        }

        public void close() throws IOException {
            super.close();
            SshjTool.this.closeWhispering((Closeable)this.sftp, (Object)this);
        }
    }
}

