/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.ssh;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.time.Duration;

public interface SshTool
extends ShellTool {
    public static final String BROOKLYN_CONFIG_KEY_PREFIX = "brooklyn.ssh.config.";
    @Deprecated
    public static final ConfigKey<String> PROP_TOOL_CLASS = ConfigKeys.newStringConfigKey("tool.class", "SshTool implementation to use (Deprecated - see SshMachineLocation's sshToolClass)", null);
    public static final ConfigKey<String> PROP_HOST = ConfigKeys.newStringConfigKey("host", "Host to connect to (required)", null);
    public static final ConfigKey<Integer> PROP_PORT = ConfigKeys.newConfigKey("port", "Port on host to connect to", 22);
    public static final ConfigKey<String> PROP_USER = ConfigKeys.newConfigKey("user", "User to connect as", System.getProperty("user.name"));
    public static final ConfigKey<String> PROP_PRIVATE_KEY_FILE = ConfigKeys.newStringConfigKey("privateKeyFile", "the path of an ssh private key file; leave blank to use defaults (i.e. ~/.ssh/id_rsa and id_dsa)", null);
    public static final ConfigKey<String> PROP_PRIVATE_KEY_DATA = ConfigKeys.newStringConfigKey("privateKeyData", "the private ssh key (e.g. contents of an id_rsa or id_dsa file)", null);
    public static final ConfigKey<String> PROP_PRIVATE_KEY_PASSPHRASE = ConfigKeys.newStringConfigKey("privateKeyPassphrase", "the passphrase for the ssh private key", null);
    public static final ConfigKey<Boolean> PROP_STRICT_HOST_KEY_CHECKING = ConfigKeys.newConfigKey("strictHostKeyChecking", "whether to check the remote host's identification; defaults to false", false);
    public static final ConfigKey<Boolean> PROP_ALLOCATE_PTY = ConfigKeys.newConfigKey("allocatePTY", "whether to allocate PTY (vt100); if true then stderr is sent to stdout, but sometimes required for sudo'ing due to requiretty", false);
    public static final ConfigKey<Long> PROP_CONNECT_TIMEOUT = ConfigKeys.newConfigKey("connectTimeout", "Timeout in millis when establishing an SSH connection; if 0 then uses default (usually 30s)", 0L);
    public static final ConfigKey<Long> PROP_SESSION_TIMEOUT = ConfigKeys.newConfigKey("sessionTimeout", "Timeout in millis for an ssh session; if 0 then uses default", 0L);
    public static final ConfigKey<Integer> PROP_SSH_TRIES = ConfigKeys.newConfigKey("sshTries", "Max number of times to attempt ssh operations", 4);
    public static final ConfigKey<Long> PROP_SSH_TRIES_TIMEOUT = ConfigKeys.newConfigKey("sshTriesTimeout", "Time limit for attempting retries; will not interrupt tasks, but stops retrying after a total amount of elapsed time", Duration.TWO_MINUTES.toMilliseconds());
    public static final ConfigKey<Long> PROP_SSH_RETRY_DELAY = ConfigKeys.newConfigKey("sshRetryDelay", "Time (in milliseconds) before first ssh-retry, after which it will do exponential backoff", 50L);
    public static final ConfigKey<String> PROP_PERMISSIONS = ConfigKeys.newConfigKey("permissions", "Default permissions for files copied/created on remote machine; must be four-digit octal string, default '0644'", "0644");
    public static final ConfigKey<Long> PROP_LAST_MODIFICATION_DATE = ConfigKeys.newConfigKey("lastModificationDate", "Last-modification-date to be set on files copied/created (should be UTC/1000, ie seconds since 1970; default 0 usually means current)", 0L);
    public static final ConfigKey<Long> PROP_LAST_ACCESS_DATE = ConfigKeys.newConfigKey("lastAccessDate", "Last-access-date to be set on files copied/created (should be UTC/1000, ie seconds since 1970; default 0 usually means lastModificationDate)", 0L);
    public static final ConfigKey<Integer> PROP_OWNER_UID = ConfigKeys.newConfigKey("ownerUid", "Default owner UID (not username) for files created on remote machine; default is unset", -1);
    public static final ConfigKey<String> ADDITIONAL_CONNECTION_METADATA = ConfigKeys.newStringConfigKey("additional.connection.metadata", "Can be used to pass additional custom data to the SshTool, which is especially useful if writing a bespoke tool implementation");

    public void connect();

    @Deprecated
    public void connect(int var1);

    public void disconnect();

    public boolean isConnected();

    @Override
    public int execScript(Map<String, ?> var1, List<String> var2, Map<String, ?> var3);

    @Override
    public int execScript(Map<String, ?> var1, List<String> var2);

    @Override
    public int execCommands(Map<String, ?> var1, List<String> var2, Map<String, ?> var3);

    @Override
    public int execCommands(Map<String, ?> var1, List<String> var2);

    public int copyToServer(Map<String, ?> var1, File var2, String var3);

    public int copyToServer(Map<String, ?> var1, InputStream var2, String var3);

    public int copyToServer(Map<String, ?> var1, byte[] var2, String var3);

    public int copyFromServer(Map<String, ?> var1, String var2, File var3);
}

