/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.flags;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;

public class MethodCoercions {
    public static Predicate<Method> matchSingleParameterMethod(final String methodName, final Object argument) {
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Preconditions.checkNotNull((Object)argument, (Object)"argument");
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                if (input == null) {
                    return false;
                }
                if (!input.getName().equals(methodName)) {
                    return false;
                }
                Type[] parameterTypes = input.getGenericParameterTypes();
                return parameterTypes.length == 1 && TypeCoercions.tryCoerce(argument, TypeToken.of((Type)parameterTypes[0])).isPresentAndNonNull();
            }
        };
    }

    public static Maybe<?> tryFindAndInvokeSingleParameterMethod(Object instance, String methodName, Object argument) {
        Class<?> clazz = instance.getClass();
        List<Method> methods = Arrays.asList(clazz.getMethods());
        Optional matchingMethod = Iterables.tryFind(methods, MethodCoercions.matchSingleParameterMethod(methodName, argument));
        if (matchingMethod.isPresent()) {
            Method method = (Method)matchingMethod.get();
            Method accessibleMethod = (Method)Reflections.findAccessibleMethod((Method)method).get();
            try {
                Type paramType = method.getGenericParameterTypes()[0];
                Object coercedArgument = TypeCoercions.coerce(argument, TypeToken.of((Type)paramType));
                return Maybe.of((Object)accessibleMethod.invoke(instance, coercedArgument));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return Maybe.absent();
    }

    public static Predicate<Method> matchMultiParameterMethod(String methodName, List<?> arguments) {
        return Predicates.and(MethodCoercions.matchMethodByName(methodName), MethodCoercions.matchMultiParameterMethod(arguments));
    }

    public static Predicate<Method> matchMethodByName(final String methodName) {
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                return input != null && input.getName().equals(methodName);
            }
        };
    }

    public static Predicate<Method> matchMultiParameterMethod(final List<?> arguments) {
        Preconditions.checkNotNull(arguments, (Object)"arguments");
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                if (input == null) {
                    return false;
                }
                int numOptionParams = arguments.size();
                Type[] parameterTypes = input.getGenericParameterTypes();
                if (parameterTypes.length != numOptionParams) {
                    return false;
                }
                for (int paramCount = 0; paramCount < numOptionParams; ++paramCount) {
                    if (TypeCoercions.tryCoerce(arguments.get(paramCount), TypeToken.of((Type)parameterTypes[paramCount])).isPresent()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Maybe<?> tryFindAndInvokeMultiParameterMethod(Object instanceOrClazz, Iterable<Method> methods, List<?> arguments) {
        Optional matchingMethod = Iterables.tryFind(methods, MethodCoercions.matchMultiParameterMethod(arguments));
        if (matchingMethod.isPresent()) {
            Method method = (Method)matchingMethod.get();
            Method accessibleMethod = (Method)Reflections.findAccessibleMethod((Method)method).get();
            try {
                int numOptionParams = arguments.size();
                Object[] coercedArguments = new Object[numOptionParams];
                for (int paramCount = 0; paramCount < numOptionParams; ++paramCount) {
                    Object argument = arguments.get(paramCount);
                    Type paramType = method.getGenericParameterTypes()[paramCount];
                    coercedArguments[paramCount] = TypeCoercions.coerce(argument, TypeToken.of((Type)paramType));
                }
                return Maybe.of((Object)accessibleMethod.invoke(instanceOrClazz, coercedArguments));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return Maybe.absent();
    }

    public static Maybe<?> tryFindAndInvokeMultiParameterMethod(Object instance, String methodName, List<?> arguments) {
        Class<?> clazz = instance.getClass();
        Iterable methods = Iterables.filter(Arrays.asList(clazz.getMethods()), MethodCoercions.matchMethodByName(methodName));
        return MethodCoercions.tryFindAndInvokeMultiParameterMethod(instance, methods, arguments);
    }

    public static Maybe<?> tryFindAndInvokeBestMatchingMethod(Object instance, String methodName, Object argument) {
        if (argument instanceof List) {
            List arguments = (List)argument;
            Maybe<?> maybe = MethodCoercions.tryFindAndInvokeMultiParameterMethod(instance, methodName, arguments);
            if (maybe.isAbsent()) {
                maybe = MethodCoercions.tryFindAndInvokeSingleParameterMethod(instance, methodName, argument);
            }
            return maybe;
        }
        return MethodCoercions.tryFindAndInvokeSingleParameterMethod(instance, methodName, argument);
    }
}

