/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock.reducer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.sensor.SensorPredicates;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.text.StringFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Reducer", description="Applies a transformation to a sensor")
public class Reducer
extends AbstractEnricher
implements SensorEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(Reducer.class);
    @SetFromFlag(value="producer")
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity with the trigger sensor (defaults to the enricher's entity)");
    public static final ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor", "The sensor to be set on the associated entity with the value computed here");
    public static final ConfigKey<List<? extends AttributeSensor<?>>> SOURCE_SENSORS = ConfigKeys.newConfigKey(new TypeToken<List<? extends AttributeSensor<?>>>(){}, "enricher.sourceSensors", "The sensors whose change triggers re-evaluation of the target value");
    public static final ConfigKey<Function<List<?>, ?>> REDUCER_FUNCTION = ConfigKeys.newConfigKey(new TypeToken<Function<List<?>, ?>>(){}, "enricher.reducerFunction", "The function to execute to evaluate the target sensor value");
    @SetFromFlag(value="transformation")
    public static final ConfigKey<String> REDUCER_FUNCTION_TRANSFORMATION = ConfigKeys.newStringConfigKey("enricher.reducerFunction.transformation", "A string matching a pre-defined named reducer function, such as joiner, formatString, etc");
    public static final ConfigKey<Map<String, Object>> PARAMETERS = ConfigKeys.newConfigKey(new TypeToken<Map<String, Object>>(){}, "enricher.reducerFunction.parameters", "A map of parameters to pass into the reducer function");
    protected Entity producer;
    protected List<AttributeSensor<?>> subscribedSensors;
    protected Sensor<?> targetSensor;
    protected Function<Iterable<?>, ?> reducerFunction;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Preconditions.checkNotNull(this.getConfig(SOURCE_SENSORS), (Object)"source sensors");
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        ArrayList sensorListTemp = Lists.newArrayList();
        for (AttributeSensor<?> sensorO : this.getConfig(SOURCE_SENSORS)) {
            AttributeSensor sensor = Tasks.resolving(sensorO).as(AttributeSensor.class).immediately(true).context(this.producer).get();
            Optional foundSensor = Iterables.tryFind((Iterable)sensorListTemp, SensorPredicates.nameEqualTo(sensor.getName()));
            if (foundSensor.isPresent()) continue;
            sensorListTemp.add(sensor);
        }
        String reducerName = (String)this.config().get(REDUCER_FUNCTION_TRANSFORMATION);
        Function<Iterable<?>, ?> reducerFunction = (Function<Iterable<?>, ?>)this.config().get(REDUCER_FUNCTION);
        if (reducerFunction == null) {
            Map parameters = (Map)this.config().get(PARAMETERS);
            reducerFunction = this.createReducerFunction(reducerName, parameters);
        }
        this.reducerFunction = reducerFunction;
        Preconditions.checkState((sensorListTemp.size() > 0 ? 1 : 0) != 0, (Object)"Nothing to reduce");
        for (Sensor sensor : sensorListTemp) {
            this.subscribe(this.producer, sensor, this);
        }
        this.subscribedSensors = ImmutableList.copyOf((Collection)sensorListTemp);
        this.highlightTriggers(this.subscribedSensors, (Object)this.producer);
    }

    protected Function<Iterable<?>, ?> createReducerFunction(String reducerName, Map<String, ?> parameters) {
        if (Objects.equals(reducerName, "joiner")) {
            String separator = (String)parameters.get("separator");
            return StringFunctions.joiner((String)(separator == null ? ", " : separator));
        }
        if (Objects.equals(reducerName, "formatString")) {
            String format = (String)Preconditions.checkNotNull((Object)((String)parameters.get("format")), (Object)"format");
            return StringFunctions.formatterForIterable((String)format);
        }
        throw new IllegalStateException("unknown function: " + reducerName);
    }

    public void onEvent(SensorEvent<Object> event) {
        Sensor<?> destinationSensor = this.getConfig(TARGET_SENSOR);
        ArrayList values = Lists.newArrayList();
        for (AttributeSensor<?> sourceSensor : this.subscribedSensors) {
            Object resolvedSensorValue = this.entity.sensors().get(sourceSensor);
            values.add(resolvedSensorValue);
        }
        Object result = this.reducerFunction.apply((Object)values);
        if (LOG.isTraceEnabled()) {
            LOG.trace("enricher {} got {}, propagating via {} as {}", new Object[]{this, event, this.entity, this.reducerFunction, destinationSensor});
        }
        this.emit(destinationSensor, result);
    }
}

