/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogItemBuilder;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.BasicTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.ReferencedUnresolvedTypeException;
import org.apache.brooklyn.core.typereg.RegisteredTypeKindVisitor;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.TypePlanTransformers;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicBrooklynTypeRegistry
implements BrooklynTypeRegistry {
    private static final Logger log = LoggerFactory.getLogger(BasicBrooklynTypeRegistry.class);
    private ManagementContext mgmt;
    private Map<String, RegisteredType> localRegisteredTypes = MutableMap.of();

    public BasicBrooklynTypeRegistry(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public Iterable<RegisteredType> getAll() {
        return this.getMatching((Predicate<? super RegisteredType>)Predicates.alwaysTrue());
    }

    private Iterable<RegisteredType> getAllWithoutCatalog(Predicate<? super RegisteredType> filter) {
        return Iterables.filter(this.localRegisteredTypes.values(), filter);
    }

    private Maybe<RegisteredType> getExactWithoutLegacyCatalog(String symbolicName, String version, RegisteredTypeLoadingContext constraint) {
        RegisteredType item = this.localRegisteredTypes.get(symbolicName + ":" + version);
        return RegisteredTypes.tryValidate(item, constraint);
    }

    public Iterable<RegisteredType> getMatching(Predicate<? super RegisteredType> filter) {
        MutableMap result = MutableMap.of();
        for (RegisteredType rt : this.getAllWithoutCatalog(filter)) {
            result.put(rt.getId(), rt);
        }
        for (RegisteredType rt : Iterables.filter((Iterable)Iterables.transform((Iterable)this.mgmt.getCatalog().getCatalogItemsLegacy(), RegisteredTypes.CI_TO_RT), filter)) {
            if (result.containsKey(rt.getId())) continue;
            result.put(rt.getId(), rt);
        }
        return result.values();
    }

    private Maybe<RegisteredType> getSingle(String symbolicNameOrAliasIfNoVersion, String versionFinal, RegisteredTypeLoadingContext contextFinal) {
        CatalogItem item;
        Maybe<RegisteredType> type;
        String version;
        RegisteredTypeLoadingContext context = contextFinal;
        if (context == null) {
            context = RegisteredTypeLoadingContexts.any();
        }
        if (Strings.isBlank((CharSequence)(version = versionFinal))) {
            version = "0.0.0_DEFAULT_VERSION";
        }
        if (!"0.0.0_DEFAULT_VERSION".equals(version) && (type = this.getExactWithoutLegacyCatalog(symbolicNameOrAliasIfNoVersion, version, context)).isPresent()) {
            return type;
        }
        if ("0.0.0_DEFAULT_VERSION".equals(version)) {
            RegisteredType type2;
            Iterable<RegisteredType> types = this.getMatching((Predicate<? super RegisteredType>)Predicates.and(RegisteredTypePredicates.symbolicName(symbolicNameOrAliasIfNoVersion), RegisteredTypePredicates.satisfies(context)));
            if (Iterables.isEmpty(types)) {
                types = this.getMatching((Predicate<? super RegisteredType>)Predicates.and(RegisteredTypePredicates.alias(symbolicNameOrAliasIfNoVersion), RegisteredTypePredicates.satisfies(context)));
                MutableSet uniqueSymbolicNames = MutableSet.of();
                for (RegisteredType t : types) {
                    uniqueSymbolicNames.add(t.getSymbolicName());
                }
                if (uniqueSymbolicNames.size() > 1) {
                    String message = "Multiple matches found for alias '" + symbolicNameOrAliasIfNoVersion + "': " + uniqueSymbolicNames + "; refusing to select any.";
                    log.warn(message);
                    return Maybe.absent((String)message);
                }
            }
            if (!Iterables.isEmpty(types) && (type2 = RegisteredTypes.getBestVersion(types)) != null) {
                return Maybe.of((Object)type2);
            }
        }
        if ((item = this.mgmt.getCatalog().getCatalogItemLegacy(symbolicNameOrAliasIfNoVersion, version)) != null) {
            return Maybe.of((Object)RegisteredTypes.CI_TO_RT.apply((Object)item));
        }
        return Maybe.absent((String)("No matches for " + symbolicNameOrAliasIfNoVersion + (Strings.isNonBlank((CharSequence)versionFinal) ? ":" + versionFinal : "") + (contextFinal != null ? " (" + contextFinal + ")" : "")));
    }

    public RegisteredType get(String symbolicName, String version) {
        return (RegisteredType)this.getSingle(symbolicName, version, null).orNull();
    }

    public RegisteredType get(String symbolicNameWithOptionalVersion, RegisteredTypeLoadingContext context) {
        return (RegisteredType)this.getMaybe(symbolicNameWithOptionalVersion, context).orNull();
    }

    public Maybe<RegisteredType> getMaybe(String symbolicNameWithOptionalVersion, RegisteredTypeLoadingContext context) {
        String version;
        String symbolicName;
        Maybe<RegisteredType> r1 = null;
        if ((RegisteredTypeNaming.isUsableTypeColonVersion(symbolicNameWithOptionalVersion) || CatalogUtils.looksLikeVersionedId(symbolicNameWithOptionalVersion)) && (r1 = this.getSingle(symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(symbolicNameWithOptionalVersion), version = CatalogUtils.getVersionFromVersionedId(symbolicNameWithOptionalVersion), context)).isPresent()) {
            return r1;
        }
        Maybe<RegisteredType> r2 = this.getSingle(symbolicNameWithOptionalVersion, "0.0.0_DEFAULT_VERSION", context);
        if (r2.isPresent() || r1 == null) {
            return r2;
        }
        return r1;
    }

    public RegisteredType get(String symbolicNameWithOptionalVersion) {
        return this.get(symbolicNameWithOptionalVersion, (RegisteredTypeLoadingContext)null);
    }

    public <SpecT extends AbstractBrooklynObjectSpec<?, ?>> SpecT createSpec(RegisteredType type, @Nullable RegisteredTypeLoadingContext constraint, @Nullable Class<SpecT> specSuperType) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        if (type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
            return this.createSpec(type, type.getPlan(), type.getSymbolicName(), type.getVersion(), type.getSuperTypes(), constraint, specSuperType);
        }
        if (type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
            if (constraint != null && constraint.getAlreadyEncounteredTypes().contains(type.getSymbolicName())) {
                throw new UnsupportedTypePlanException("Cannot create spec from type " + type + " (kind " + type.getKind() + "), recursive reference following " + constraint.getAlreadyEncounteredTypes());
            }
            Collection validationErrors = this.mgmt.getCatalog().validateType(type, constraint);
            if (!validationErrors.isEmpty()) {
                throw new ReferencedUnresolvedTypeException(type, true, Exceptions.create((Iterable)validationErrors));
            }
            type = this.mgmt.getTypeRegistry().get(type.getSymbolicName(), type.getVersion());
            if (type == null || type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
                throw new ReferencedUnresolvedTypeException(type);
            }
            return this.createSpec(type, constraint, specSuperType);
        }
        throw new UnsupportedTypePlanException("Cannot create spec from type " + type + " (kind " + type.getKind() + ")");
    }

    private <SpecT extends AbstractBrooklynObjectSpec<?, ?>> SpecT createSpec(RegisteredType type, RegisteredType.TypeImplementationPlan plan, @Nullable String symbolicName, @Nullable String version, Set<Object> superTypes, @Nullable RegisteredTypeLoadingContext constraint, @Nullable Class<SpecT> specSuperType) {
        Object item;
        Maybe<Object> result;
        if (constraint != null) {
            if (constraint.getExpectedKind() != null && constraint.getExpectedKind() != BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
                throw new IllegalStateException("Cannot create spec with constraint " + constraint);
            }
            if (symbolicName == null || constraint.getAlreadyEncounteredTypes().contains(symbolicName)) {
                // empty if block
            }
        }
        if ((result = TypePlanTransformers.transform(this.mgmt, type, constraint = RegisteredTypeLoadingContexts.withSpecSuperType(constraint, specSuperType))).isPresent()) {
            return (SpecT)((AbstractBrooklynObjectSpec)result.get());
        }
        CatalogItem catalogItem = item = symbolicName != null ? this.mgmt.getCatalog().getCatalogItemLegacy(symbolicName, version) : null;
        if (item == null) {
            CatalogItem.CatalogItemType ciType = CatalogItem.CatalogItemType.ofTargetClass((Class)constraint.getExpectedJavaSuperType());
            if (ciType == null) {
                result.get();
            }
            item = CatalogItemBuilder.newItem(ciType, symbolicName != null ? symbolicName : Identifiers.makeRandomId((int)8), version != null ? version : "0.0.0_DEFAULT_VERSION").plan((String)plan.getPlanData()).build();
        }
        try {
            return BasicBrooklynCatalog.internalCreateSpecLegacy(this.mgmt, item, constraint.getAlreadyEncounteredTypes(), false);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            try {
                result.get();
                throw new IllegalStateException("should have failed getting type resolution for " + symbolicName);
            }
            catch (Exception e0) {
                MutableSet exceptionsInOrder = MutableSet.of();
                if (e0.toString().indexOf("none of the available transformers") >= 0) {
                    exceptionsInOrder.add(e);
                    exceptionsInOrder.add(e0);
                } else {
                    exceptionsInOrder.add(e0);
                    exceptionsInOrder.add(e);
                }
                throw Exceptions.create((String)("Unable to instantiate " + (symbolicName == null ? "item" : symbolicName)), (Iterable)exceptionsInOrder);
            }
        }
    }

    public <SpecT extends AbstractBrooklynObjectSpec<?, ?>> SpecT createSpecFromPlan(@Nullable String planFormat, Object planData, @Nullable RegisteredTypeLoadingContext optionalConstraint, @Nullable Class<SpecT> optionalSpecSuperType) {
        return this.createSpec(RegisteredTypes.anonymousRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, new BasicTypeImplementationPlan(planFormat, planData)), optionalConstraint, optionalSpecSuperType);
    }

    public <T> T createBean(RegisteredType type, @Nullable RegisteredTypeLoadingContext constraint, @Nullable Class<T> optionalResultSuperType) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        if (type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.BEAN) {
            if (type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
                throw new ReferencedUnresolvedTypeException(type);
            }
            throw new UnsupportedTypePlanException("Cannot create bean from type " + type + " (kind " + type.getKind() + ")");
        }
        if (constraint != null) {
            if (constraint.getExpectedKind() != null && constraint.getExpectedKind() != BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
                throw new IllegalStateException("Cannot create bean with constraint " + constraint);
            }
            if (constraint.getAlreadyEncounteredTypes().contains(type.getSymbolicName())) {
                // empty if block
            }
        }
        constraint = RegisteredTypeLoadingContexts.withBeanSuperType(constraint, optionalResultSuperType);
        Object result = TypePlanTransformers.transform(this.mgmt, type, constraint).get();
        return (T)result;
    }

    public <T> T createBeanFromPlan(String planFormat, Object planData, @Nullable RegisteredTypeLoadingContext optionalConstraint, @Nullable Class<T> optionalSuperType) {
        return this.createBean(RegisteredTypes.anonymousRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind.BEAN, new BasicTypeImplementationPlan(planFormat, planData)), optionalConstraint, optionalSuperType);
    }

    public <T> T create(final RegisteredType type, final @Nullable RegisteredTypeLoadingContext constraint, final @Nullable Class<T> optionalResultSuperType) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        return new RegisteredTypeKindVisitor<T>(){

            @Override
            protected T visitBean() {
                return BasicBrooklynTypeRegistry.this.createBean(type, constraint, optionalResultSuperType);
            }

            @Override
            protected T visitSpec() {
                return BasicBrooklynTypeRegistry.this.createSpec(type, constraint, optionalResultSuperType);
            }

            @Override
            protected T visitUnresolved() {
                try {
                    log.debug("Request for " + this + " to create UNRESOLVED kind " + type + "; trying as spec");
                    Object result = this.visitSpec();
                    log.warn("Request to use " + this + " from UNRESOLVED state succeeded treating is as a spec");
                    log.debug("Trace for request to use " + this + " in UNRESOLVED state succeeding", new Throwable("Location of request to use " + this + " in UNRESOLVED state"));
                    return result;
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    throw new IllegalArgumentException("Kind-agnostic create method only intended for used when the registered type declares its kind, which " + type + " does not, and failed treating it as a spec: " + e, e);
                }
            }
        }.visit(type.getKind());
    }

    public <T> T createFromPlan(Class<T> requiredSuperTypeHint, @Nullable String planFormat, Object planData, @Nullable RegisteredTypeLoadingContext optionalConstraint) {
        if (AbstractBrooklynObjectSpec.class.isAssignableFrom(requiredSuperTypeHint)) {
            T result = this.createSpecFromPlan(planFormat, planData, optionalConstraint, requiredSuperTypeHint);
            return result;
        }
        return this.createBeanFromPlan(planFormat, planData, optionalConstraint, requiredSuperTypeHint);
    }

    @Beta
    public void addToLocalUnpersistedTypeRegistry(RegisteredType type, boolean canForce) {
        RegisteredType oldType;
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)type.getSymbolicName());
        Preconditions.checkNotNull((Object)type.getVersion());
        Preconditions.checkNotNull((Object)type.getId());
        if (!type.getId().equals(type.getSymbolicName() + ":" + type.getVersion())) {
            Asserts.fail((String)("Registered type " + type + " has ID / symname mismatch"));
        }
        if ((oldType = this.mgmt.getTypeRegistry().get(type.getId())) == null || canForce || BrooklynVersionSyntax.isSnapshot((String)oldType.getVersion())) {
            log.debug("Inserting " + type + " into " + this);
            this.localRegisteredTypes.put(type.getId(), type);
        } else {
            this.assertSameEnoughToAllowReplacing(oldType, type);
        }
    }

    private boolean assertSameEnoughToAllowReplacing(RegisteredType oldType, RegisteredType type) {
        if (!oldType.getVersionedName().equals((Object)type.getVersionedName())) {
            throw new IllegalStateException("Cannot add " + type + " to catalog; different " + oldType + " is already present");
        }
        if (Objects.equals(oldType.getContainingBundle(), type.getContainingBundle())) {
            if (!this.samePlan(oldType, type)) {
                String msg = "Cannot add " + type + " to catalog; different plan in " + oldType + " from same bundle " + type.getContainingBundle() + " is already present";
                log.debug(msg + "\nPlan being added is:\n" + type.getPlan() + "\nPlan already present is:\n" + oldType.getPlan());
                throw new IllegalStateException(msg);
            }
            if (oldType.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && !Objects.equals(oldType.getKind(), type.getKind())) {
                throw new IllegalStateException("Cannot add " + type + " to catalog; different kind in " + oldType + " from same bundle is already present");
            }
            return true;
        }
        if (!this.samePlan(oldType, type)) {
            String msg = "Cannot add " + type + " in " + type.getContainingBundle() + " to catalog; different plan in " + oldType + " from bundle " + oldType.getContainingBundle() + " is already present (throwing)";
            log.debug(msg + "\nPlan being added from " + type.getContainingBundle() + " is:\n" + type.getPlan() + "\nPlan already present from " + oldType.getContainingBundle() + " is:\n" + oldType.getPlan());
            throw new IllegalStateException(msg);
        }
        if (oldType.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && !Objects.equals(oldType.getKind(), type.getKind())) {
            throw new IllegalStateException("Cannot add " + type + " in " + type.getContainingBundle() + " to catalog; different kind in " + oldType + " from bundle " + oldType.getContainingBundle() + " is already present");
        }
        if (oldType.getContainingBundle() == null) {
            return true;
        }
        OsgiManager osgi = (OsgiManager)((ManagementContextInternal)this.mgmt).getOsgiManager().orNull();
        if (osgi == null) {
            return true;
        }
        if (BasicBrooklynCatalog.isNoBundleOrSimpleWrappingBundle(this.mgmt, osgi.getManagedBundle(VersionedName.fromString((String)oldType.getContainingBundle())))) {
            return true;
        }
        throw new IllegalStateException("Cannot add " + type + " in " + type.getContainingBundle() + " to catalog; item  is already present in different bundle " + oldType.getContainingBundle());
    }

    private boolean samePlan(RegisteredType oldType, RegisteredType type) {
        return RegisteredTypes.arePlansEquivalent(oldType, type);
    }

    @Beta
    public void delete(VersionedName type) {
        RegisteredType registeredTypeRemoved = this.localRegisteredTypes.remove(type.toString());
        if (registeredTypeRemoved != null) {
            return;
        }
        this.mgmt.getCatalog().deleteCatalogItem(type.getSymbolicName(), type.getVersionString());
    }

    public void delete(RegisteredType type) {
        this.delete(type.getVersionedName());
    }

    @Beta
    public void delete(String id) {
        this.delete(VersionedName.fromString((String)id));
    }
}

