/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.AddSensor;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshValueFunctions;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SshCommandSensor<T>
extends AddSensor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommandSensor.class);
    public static final ConfigKey<String> SENSOR_COMMAND = ConfigKeys.newStringConfigKey("command", "SSH command to execute for sensor");
    public static final ConfigKey<String> SENSOR_EXECUTION_DIR = ConfigKeys.newStringConfigKey("executionDir", "Directory where the command should run; if not supplied, executes in the entity's run dir (or home dir if no run dir is defined); use '~' to always execute in the home dir, or 'custom-feed/' to execute in a custom-feed dir relative to the run dir");
    public static final MapConfigKey<Object> SENSOR_SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    public static final ConfigKey<Boolean> SUPPRESS_DUPLICATES = ConfigKeys.newBooleanConfigKey("suppressDuplicates", "Whether to publish the sensor value again, if it is the same as the previous value", Boolean.FALSE);
    protected final String command;
    protected final String executionDir;
    protected final Map<String, Object> sensorEnv;

    public SshCommandSensor(ConfigBag params) {
        super(params);
        this.command = (String)Preconditions.checkNotNull((Object)params.get(SENSOR_COMMAND), (Object)"SSH command must be supplied when defining this sensor");
        this.executionDir = params.get(SENSOR_EXECUTION_DIR);
        this.sensorEnv = (Map)params.get(SENSOR_SHELL_ENVIRONMENT);
    }

    @Override
    public void apply(final EntityLocal entity) {
        super.apply(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding SSH sensor {} to {}", (Object)this.name, (Object)entity);
        }
        Boolean suppressDuplicates = EntityInitializers.resolve(this.params, SUPPRESS_DUPLICATES);
        Supplier<Map<String, String>> envSupplier = new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                Object env = MutableMap.copyOf((Map)((Map)entity.getConfig(BrooklynConfigKeys.SHELL_ENVIRONMENT)));
                if (SshCommandSensor.this.sensorEnv != null) {
                    env.putAll(SshCommandSensor.this.sensorEnv);
                }
                try {
                    env = (Map)Tasks.resolveDeepValue(env, Object.class, ((EntityInternal)entity).getExecutionContext());
                }
                catch (InterruptedException | ExecutionException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
                ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(((EntityInternal)entity).getManagementContext());
                return serializer.serialize((Map<?, ?>)env);
            }
        };
        Supplier<String> commandSupplier = new Supplier<String>(){

            public String get() {
                return SshCommandSensor.makeCommandExecutingInDirectory(SshCommandSensor.this.command, SshCommandSensor.this.executionDir, (Entity)entity);
            }
        };
        CommandPollConfig pollConfig = (CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)new CommandPollConfig(this.sensor).period(this.period)).env(envSupplier).command(commandSupplier).suppressDuplicates(Boolean.TRUE.equals(suppressDuplicates))).checkSuccess(SshValueFunctions.exitStatusEquals(0))).onFailureOrException(Functions.constant(null))).onSuccess(Functions.compose((Function)new Function<String, T>(){

            public T apply(String input) {
                return TypeCoercions.coerce((Object)Strings.trimEnd((String)input), SshCommandSensor.this.sensor.getType());
            }
        }, SshValueFunctions.stdout()));
        SshFeed feed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)entity)).onlyIfServiceUp()).poll(pollConfig).build();
        entity.addFeed((Feed)feed);
    }

    @Beta
    public static String makeCommandExecutingInDirectory(String command, String executionDir, Entity entity) {
        String runDir;
        String finalCommand = command;
        String execDir = executionDir;
        if (Strings.isBlank((CharSequence)execDir)) {
            execDir = (String)entity.getAttribute(BrooklynConfigKeys.RUN_DIR);
            if (Strings.isBlank((CharSequence)execDir)) {
                execDir = "~";
            }
        } else if (!Os.isAbsolutish((String)execDir) && !Strings.isBlank((CharSequence)(runDir = (String)entity.getAttribute(BrooklynConfigKeys.RUN_DIR)))) {
            execDir = Os.mergePaths((String[])new String[]{runDir, execDir});
        }
        if (!"~".equals(execDir)) {
            finalCommand = "mkdir -p '" + execDir + "' && cd '" + execDir + "' && " + finalCommand;
        }
        return finalCommand;
    }
}

