/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Predicate;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.mgmt.internal.LocalSubscriptionManager;
import org.apache.brooklyn.util.text.Identifiers;

class Subscription<T>
implements SubscriptionHandle {
    public final String id = Identifiers.makeRandomId((int)8);
    public Object subscriber;
    public Object subscriberExecutionManagerTag;
    public boolean subscriberExecutionManagerTagSupplied;
    public Iterable<?> subscriberExtraExecTags;
    public final Entity producer;
    public final Sensor<T> sensor;
    public final SensorEventListener<? super T> listener;
    public final AtomicInteger eventCount = new AtomicInteger();
    public Map<String, Object> flags;
    public Predicate<SensorEvent<T>> eventFilter;

    public Subscription(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        this.producer = producer;
        this.sensor = sensor;
        this.listener = listener;
    }

    public boolean equals(Object other) {
        return other instanceof Subscription && ((Subscription)other).id == this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Subscription[" + this.id + ";" + this.subscriber + "@" + LocalSubscriptionManager.makeEntitySensorToken(this.producer, this.sensor) + "]";
    }
}

