/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.internal.AbstractSubscriptionManager;
import org.apache.brooklyn.core.mgmt.internal.Subscription;
import org.apache.brooklyn.core.sensor.BasicSensorEvent;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.SingleThreadedScheduler;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSubscriptionManager
extends AbstractSubscriptionManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSubscriptionManager.class);
    protected final ExecutionManager em;
    private final String tostring = "SubscriptionContext(" + Identifiers.getBase64IdFromValue((long)System.identityHashCode(this), (int)5) + ")";
    private final AtomicLong totalEventsPublishedCount = new AtomicLong();
    private final AtomicLong totalEventsDeliveredCount = new AtomicLong();
    protected final ConcurrentMap<String, Subscription> allSubscriptions = new ConcurrentHashMap<String, Subscription>();
    protected final ConcurrentMap<Object, Set<Subscription>> subscriptionsBySubscriber = new ConcurrentHashMap<Object, Set<Subscription>>();
    protected final ConcurrentMap<Object, Set<Subscription>> subscriptionsByToken = new ConcurrentHashMap<Object, Set<Subscription>>();

    public LocalSubscriptionManager(ExecutionManager m) {
        this.em = m;
    }

    public long getNumSubscriptions() {
        return this.allSubscriptions.size();
    }

    public long getTotalEventsPublished() {
        return this.totalEventsPublishedCount.get();
    }

    public long getTotalEventsDelivered() {
        return this.totalEventsDeliveredCount.get();
    }

    @Override
    protected synchronized <T> SubscriptionHandle subscribe(Map<String, Object> flags, Subscription<T> s) {
        Entity producer = s.producer;
        Sensor sensor = s.sensor;
        s.subscriber = this.getSubscriber(flags, s);
        if (flags.containsKey("tags") || flags.containsKey("tag")) {
            Iterable tags = (Iterable)flags.get("tags");
            Object tag = flags.get("tag");
            Iterable iterable = tag == null ? tags : (s.subscriberExtraExecTags = tags == null ? ImmutableList.of((Object)tag) : MutableList.builder().addAll(tags).add(tag).build());
        }
        if (flags.containsKey("subscriberExecutionManagerTag")) {
            s.subscriberExecutionManagerTag = flags.remove("subscriberExecutionManagerTag");
            s.subscriberExecutionManagerTagSupplied = true;
        } else {
            s.subscriberExecutionManagerTag = s.subscriber instanceof Entity ? "subscription-delivery-entity-" + ((Entity)s.subscriber).getId() : (s.subscriber instanceof String ? "subscription-delivery-string[" + s.subscriber + "]" : "subscription-delivery-object[" + s.subscriber + "]");
            s.subscriberExecutionManagerTagSupplied = false;
        }
        s.eventFilter = (Predicate)flags.remove("eventFilter");
        boolean notifyOfInitialValue = Boolean.TRUE.equals(flags.remove("notifyOfInitialValue"));
        s.flags = flags;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating subscription {} for {} on {} {} in {}", new Object[]{s.id, s.subscriber, producer, sensor, this});
        }
        this.allSubscriptions.put(s.id, s);
        LocalSubscriptionManager.addToMapOfSets(this.subscriptionsByToken, LocalSubscriptionManager.makeEntitySensorToken(s.producer, s.sensor), s);
        if (s.subscriber != null) {
            LocalSubscriptionManager.addToMapOfSets(this.subscriptionsBySubscriber, s.subscriber, s);
        }
        if (!s.subscriberExecutionManagerTagSupplied && s.subscriberExecutionManagerTag != null) {
            ((BasicExecutionManager)this.em).setTaskSchedulerForTag(s.subscriberExecutionManagerTag, SingleThreadedScheduler.class);
        }
        if (notifyOfInitialValue) {
            if (producer == null) {
                LOG.warn("Cannot notifyOfInitialValue for subscription with wildcard producer: " + s);
            } else if (sensor == null) {
                LOG.warn("Cannot notifyOfInitialValue for subscription with wilcard sensor: " + s);
            } else if (!(sensor instanceof AttributeSensor)) {
                LOG.warn("Cannot notifyOfInitialValue for subscription with non-attribute sensor: " + s);
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("sending initial value of {} -> {} to {}", new Object[]{s.producer, s.sensor, s});
                }
                Object val = s.producer.getAttribute((AttributeSensor)s.sensor);
                this.submitPublishEvent(s, new BasicSensorEvent<Object>(s.sensor, s.producer, val), true);
            }
        }
        return s;
    }

    public Set<SubscriptionHandle> getSubscriptionsForSubscriber(Object subscriber) {
        return (Set)JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsBySubscriber.get(subscriber)), Collections.emptySet());
    }

    public synchronized Set<SubscriptionHandle> getSubscriptionsForEntitySensor(Entity source, Sensor<?> sensor) {
        LinkedHashSet<SubscriptionHandle> subscriptions = new LinkedHashSet<SubscriptionHandle>();
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(source, sensor))), Collections.emptySet()));
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(null, sensor))), Collections.emptySet()));
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(source, null))), Collections.emptySet()));
        subscriptions.addAll(JavaGroovyEquivalents.elvis((Collection)((Collection)this.subscriptionsByToken.get(LocalSubscriptionManager.makeEntitySensorToken(null, null))), Collections.emptySet()));
        return subscriptions;
    }

    public synchronized boolean unsubscribe(SubscriptionHandle sh) {
        if (!(sh instanceof Subscription)) {
            throw new IllegalArgumentException("Only subscription handles of type Subscription supported: sh=" + sh + "; type=" + (sh != null ? sh.getClass().getCanonicalName() : null));
        }
        Subscription s = (Subscription)sh;
        boolean result = this.allSubscriptions.remove(s.id) != null;
        boolean b2 = LocalSubscriptionManager.removeFromMapOfCollections(this.subscriptionsByToken, LocalSubscriptionManager.makeEntitySensorToken(s.producer, s.sensor), s);
        assert (result == b2);
        if (s.subscriber != null) {
            boolean b3 = LocalSubscriptionManager.removeFromMapOfCollections(this.subscriptionsBySubscriber, s.subscriber, s);
            assert (b3 == b2);
        }
        ((BasicExecutionManager)this.em).setTaskSchedulerForTag(s.subscriberExecutionManagerTag, SingleThreadedScheduler.class);
        return result;
    }

    @Override
    public <T> void publish(SensorEvent<T> event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} got event {}", (Object)this, event);
        }
        this.totalEventsPublishedCount.incrementAndGet();
        Set<SubscriptionHandle> subs = this.getSubscriptionsForEntitySensor(event.getSource(), event.getSensor());
        if (JavaGroovyEquivalents.groovyTruth(subs)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("sending {}, {} to {}", new Object[]{event.getSensor().getName(), event, JavaGroovyEquivalents.join(subs, (String)",")});
            }
            for (Subscription subscription : subs) {
                this.submitPublishEvent(subscription, event, false);
                this.totalEventsDeliveredCount.incrementAndGet();
            }
        }
    }

    private void submitPublishEvent(final Subscription s, final SensorEvent<?> event, final boolean isInitial) {
        String sourceName;
        if (s.eventFilter != null && !s.eventFilter.apply(event)) {
            return;
        }
        List tags = MutableList.builder().addAll((Iterable)(s.subscriberExtraExecTags == null ? ImmutableList.of() : s.subscriberExtraExecTags)).add(s.subscriberExecutionManagerTag).add((Object)"SENSOR").build().asUnmodifiable();
        StringBuilder name = new StringBuilder("sensor ");
        StringBuilder description = new StringBuilder("Sensor ");
        String sensorName = s.sensor == null ? "<null-sensor>" : s.sensor.getName();
        String string = sourceName = event.getSource() == null ? null : event.getSource().getId();
        if (Strings.isNonBlank((CharSequence)sourceName)) {
            name.append(sourceName);
            name.append(":");
        }
        name.append(sensorName);
        description.append(sensorName);
        description.append(" on ");
        description.append(sourceName == null ? "<null-source>" : sourceName);
        description.append(" publishing to ");
        description.append(s.subscriber instanceof Entity ? ((Entity)s.subscriber).getId() : s.subscriber);
        if (this.includeDescriptionForSensorTask(event)) {
            name.append(" ");
            name.append(event.getValue());
            description.append(", value: ");
            description.append(event.getValue());
        }
        MutableMap execFlags = MutableMap.of((Object)"tags", (Object)tags, (Object)"displayName", (Object)name.toString(), (Object)"description", (Object)description.toString());
        this.em.submit((Map)execFlags, new Runnable(){

            public String toString() {
                if (isInitial) {
                    return "LSM.publishInitial(" + event + ")";
                }
                return "LSM.publish(" + event + ")";
            }

            @Override
            public void run() {
                try {
                    int count = s.eventCount.incrementAndGet();
                    if (count > 0 && count % 1000 == 0) {
                        LOG.debug("{} events for subscriber {}", (Object)count, (Object)s);
                    }
                    s.listener.onEvent(event);
                }
                catch (Throwable t) {
                    if (event != null && event.getSource() != null && Entities.isNoLongerManaged(event.getSource())) {
                        LOG.debug("Error processing subscriptions to " + this + ", after entity unmanaged: " + t, t);
                    }
                    LOG.warn("Error processing subscriptions to " + this + ": " + t, t);
                }
            }
        });
    }

    protected boolean includeDescriptionForSensorTask(SensorEvent<?> event) {
        if (event.getValue() == null) {
            return true;
        }
        Class<?> clazz = event.getValue().getClass();
        return clazz.isEnum() || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz.equals(String.class);
    }

    public String toString() {
        return this.tostring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static <K, V> Set<V> addToMapOfSets(Map<K, Set<V>> map, K key, V valueInCollection) {
        Set<V> coll;
        Object object = map;
        synchronized (object) {
            coll = map.get(key);
            if (coll == null) {
                coll = new LinkedHashSet<V>();
                map.put(key, coll);
            }
            if (coll.isEmpty()) {
                Set<V> set = coll;
                synchronized (set) {
                    coll.add(valueInCollection);
                }
                return coll;
            }
        }
        object = coll;
        synchronized (object) {
            if (!coll.isEmpty()) {
                coll.add(valueInCollection);
                return coll;
            }
        }
        return LocalSubscriptionManager.addToMapOfSets(map, key, valueInCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static <K, V> boolean removeFromMapOfCollections(Map<K, ? extends Collection<V>> map, K key, V valueInCollection) {
        boolean result;
        Collection<V> coll;
        Map<K, Collection<V>> map2 = map;
        synchronized (map2) {
            coll = map.get(key);
            if (coll == null) {
                return false;
            }
        }
        Object object = coll;
        synchronized (object) {
            result = coll.remove(valueInCollection);
        }
        if (coll.isEmpty()) {
            object = map;
            synchronized (object) {
                Collection<V> collection = coll;
                synchronized (collection) {
                    if (coll.isEmpty() && map.get(key) == coll) {
                        map.remove(key);
                    }
                }
            }
        }
        return result;
    }
}

