/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.effector.BasicParameterType;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.EntityManagementSupport;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.CanSkipInContext;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectorUtils {
    private static final Logger log = LoggerFactory.getLogger(EffectorUtils.class);

    public static Object[] prepareArgsForEffector(Effector<?> eff, Object[] args) {
        return EffectorUtils.prepareArgsForEffectorFromArray(eff, args);
    }

    public static Object[] prepareArgsForEffector(Effector<?> eff, Map<?, ?> args) {
        return EffectorUtils.prepareArgsForEffectorFromMap(eff, args);
    }

    @Deprecated
    public static Object[] prepareArgsForEffector(Effector<?> eff, Object args) {
        if (args != null && args.getClass().isArray()) {
            return EffectorUtils.prepareArgsForEffectorFromArray(eff, (Object[])args);
        }
        if (args instanceof Map) {
            return EffectorUtils.prepareArgsForEffectorFromMap(eff, (Map)args);
        }
        log.warn("Deprecated effector invocation style for call to " + eff + ", expecting a map or an array, got: " + (args == null ? null : args.getClass().getName()));
        if (log.isDebugEnabled()) {
            log.debug("Deprecated effector invocation style for call to " + eff + ", expecting a map or an array, got: " + (args == null ? null : args.getClass().getName()), new Throwable("Trace for deprecated effector invocation style"));
        }
        return EffectorUtils.oldPrepareArgsForEffector(eff, args);
    }

    private static Object[] prepareArgsForEffectorFromArray(Effector<?> eff, Object[] args) {
        int newArgsNeeded = eff.getParameters().size();
        if (args.length == 1 && args[0] instanceof Map && (newArgsNeeded != 1 || !((ParameterType)eff.getParameters().get(0)).getParameterClass().isAssignableFrom(args[0].getClass()))) {
            return EffectorUtils.prepareArgsForEffectorFromMap(eff, (Map)args[0]);
        }
        return EffectorUtils.prepareArgsForEffectorAsMapFromArray(eff, args).values().toArray(new Object[0]);
    }

    public static Map prepareArgsForEffectorAsMapFromArray(Effector<?> eff, Object[] args) {
        int newArgsNeeded = eff.getParameters().size();
        ArrayList l = Lists.newArrayList();
        l.addAll(Arrays.asList(args));
        LinkedHashMap<String, Object> newArgs = new LinkedHashMap<String, Object>();
        for (int index = 0; index < eff.getParameters().size(); ++index) {
            ParameterType it = (ParameterType)eff.getParameters().get(index);
            if (l.size() >= newArgsNeeded) {
                newArgs.put(it.getName(), l.remove(0));
            } else if (!l.isEmpty() && it.getParameterClass().isInstance(l.get(0))) {
                newArgs.put(it.getName(), l.remove(0));
            } else if (it instanceof BasicParameterType && ((BasicParameterType)it).hasDefaultValue()) {
                newArgs.put(it.getName(), ((BasicParameterType)it).getDefaultValue());
            } else {
                throw new IllegalArgumentException("Invalid arguments (count mismatch) for effector " + eff + ": " + args.length + " args");
            }
            --newArgsNeeded;
        }
        if (newArgsNeeded > 0) {
            throw new IllegalArgumentException("Invalid arguments (missing " + newArgsNeeded + ") for effector " + eff + ": " + args.length + " args");
        }
        if (!l.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments (" + l.size() + " extra) for effector " + eff + ": " + args.length + " args");
        }
        return newArgs;
    }

    private static Object[] prepareArgsForEffectorFromMap(Effector<?> eff, Map m) {
        m = Maps.newLinkedHashMap((Map)m);
        ArrayList newArgs = Lists.newArrayList();
        int newArgsNeeded = eff.getParameters().size();
        for (int index = 0; index < eff.getParameters().size(); ++index) {
            Object v;
            ParameterType it = (ParameterType)eff.getParameters().get(index);
            if (JavaGroovyEquivalents.groovyTruth((String)it.getName()) && m.containsKey(it.getName())) {
                v = m.remove(it.getName());
            } else if (it instanceof BasicParameterType && ((BasicParameterType)it).hasDefaultValue()) {
                v = ((BasicParameterType)it).getDefaultValue();
            } else {
                throw new IllegalArgumentException("Invalid arguments (missing argument " + it + ") for effector " + eff + ": " + Sanitizer.sanitize(m));
            }
            newArgs.add(TypeCoercions.coerce(v, it.getParameterClass()));
            --newArgsNeeded;
        }
        if (newArgsNeeded > 0) {
            throw new IllegalArgumentException("Invalid arguments (missing " + newArgsNeeded + ") for effector " + eff + ": " + Sanitizer.sanitize(m));
        }
        if (!m.isEmpty()) {
            log.warn("Unsupported parameter to " + eff + " (ignoring): " + Sanitizer.sanitize(m));
        }
        return newArgs.toArray(new Object[newArgs.size()]);
    }

    public static Object[] oldPrepareArgsForEffector(Effector<?> eff, Object args) {
        Object[] argsArray = args == null ? new Object[]{} : (args.getClass().isArray() ? (Object[])args : (args instanceof Collection ? ((Collection)args).toArray(new Object[((Collection)args).size()]) : new Object[]{args}));
        ArrayList l = Lists.newArrayList();
        l.addAll(Arrays.asList(argsArray));
        LinkedHashMap m = argsArray.length > 0 && argsArray[0] instanceof Map ? Maps.newLinkedHashMap((Map)((Map)l.remove(0))) : null;
        ArrayList newArgs = Lists.newArrayList();
        int newArgsNeeded = eff.getParameters().size();
        boolean mapUsed = false;
        for (int index = 0; index < eff.getParameters().size(); ++index) {
            ParameterType it = (ParameterType)eff.getParameters().get(index);
            if (l.size() >= newArgsNeeded) {
                newArgs.add(l.remove(0));
            } else if (JavaGroovyEquivalents.groovyTruth((Object)m) && JavaGroovyEquivalents.groovyTruth((String)it.getName()) && m.containsKey(it.getName())) {
                newArgs.add(m.remove(it.getName()));
            } else if (index == 0 && Map.class.isAssignableFrom(it.getParameterClass())) {
                newArgs.add(m);
                mapUsed = true;
            } else if (!l.isEmpty() && it.getParameterClass().isInstance(l.get(0))) {
                newArgs.add(l.remove(0));
            } else if (it instanceof BasicParameterType && ((BasicParameterType)it).hasDefaultValue()) {
                newArgs.add(((BasicParameterType)it).getDefaultValue());
            } else {
                throw new IllegalArgumentException("Invalid arguments (count mismatch) for effector " + eff + ": " + argsArray.length + " args");
            }
            --newArgsNeeded;
        }
        if (newArgsNeeded > 0) {
            throw new IllegalArgumentException("Invalid arguments (missing " + newArgsNeeded + ") for effector " + eff + ": " + argsArray.length + " args");
        }
        if (!l.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments (" + l.size() + " extra) for effector " + eff + ": " + argsArray.length + " args");
        }
        if (JavaGroovyEquivalents.groovyTruth((Object)m) && !mapUsed) {
            throw new IllegalArgumentException("Invalid arguments (" + m.size() + " extra named) for effector " + eff + ": " + argsArray.length + " args");
        }
        return newArgs.toArray(new Object[newArgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T invokeMethodEffector(Entity entity, Effector<T> eff, Map<String, ?> args) {
        Object[] parametersArray = EffectorUtils.prepareArgsForEffector(eff, args);
        String name = eff.getName();
        try {
            EntityManagementSupport mgmtSupport;
            if (log.isDebugEnabled()) {
                log.debug("Invoking effector {} on {}", new Object[]{name, entity});
            }
            if (log.isTraceEnabled()) {
                log.trace("Invoking effector {} on {} with args {}", new Object[]{name, entity, Sanitizer.sanitize(args)});
            }
            if (!(mgmtSupport = ((EntityInternal)entity).getManagementSupport()).isDeployed()) {
                mgmtSupport.attemptLegacyAutodeployment(name);
            }
            ManagementContextInternal mgmtContext = (ManagementContextInternal)((EntityInternal)entity).getManagementContext();
            mgmtSupport.getEntityChangeListener().onEffectorStarting(eff, parametersArray);
            try {
                T t = mgmtContext.invokeEffectorMethodSync(entity, eff, args);
                return t;
            }
            finally {
                mgmtSupport.getEntityChangeListener().onEffectorCompleted(eff);
            }
        }
        catch (Exception e) {
            throw EffectorUtils.handleEffectorException(entity, eff, e);
        }
    }

    public static RuntimeException handleEffectorException(Entity entity, Effector<?> effector, Throwable throwable) {
        throw EffectorCallPropagatedRuntimeException.propagate(entity, effector, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Task<T> invokeEffectorAsync(Entity entity, Effector<T> eff, Map<String, ?> parameters) {
        EntityManagementSupport mgmtSupport;
        String name = eff.getName();
        if (log.isDebugEnabled()) {
            log.debug("Invoking-async effector {} on {}", new Object[]{name, entity});
        }
        if (log.isTraceEnabled()) {
            log.trace("Invoking-async effector {} on {} with args {}", new Object[]{name, entity, Sanitizer.sanitize(parameters)});
        }
        if (!(mgmtSupport = ((EntityInternal)entity).getManagementSupport()).isDeployed()) {
            mgmtSupport.attemptLegacyAutodeployment(name);
        }
        ManagementContextInternal mgmtContext = (ManagementContextInternal)((EntityInternal)entity).getManagementContext();
        mgmtSupport.getEntityChangeListener().onEffectorStarting(eff, parameters);
        try {
            Task<T> task = mgmtContext.invokeEffector(entity, eff, parameters);
            return task;
        }
        finally {
            mgmtSupport.getEntityChangeListener().onEffectorCompleted(eff);
        }
    }

    public static Maybe<Effector<?>> findEffector(Collection<? extends Effector<?>> effectors, String effectorName) {
        for (Effector<?> effector : effectors) {
            if (!effector.getName().equals(effectorName)) continue;
            return Maybe.of(effector);
        }
        return Maybe.absent((Throwable)new NoSuchElementException("No effector with name " + effectorName + " (contenders " + effectors + ")"));
    }

    public static Maybe<Effector<?>> findEffectorDeclared(Entity entity, String effectorName) {
        return EffectorUtils.findEffector(entity.getEntityType().getEffectors(), effectorName);
    }

    public static Map<Object, Object> getTaskFlagsForEffectorInvocation(Entity entity, Effector<?> effector, ConfigBag parameters) {
        MutableList tags = MutableList.of((Object)"EFFECTOR", (Object)BrooklynTaskTags.tagForEffectorCall(entity, effector.getName(), parameters), (Object[])new Object[]{BrooklynTaskTags.tagForTargetEntity(entity)});
        if (Entitlements.getEntitlementContext() != null) {
            tags.add(BrooklynTaskTags.tagForEntitlement(Entitlements.getEntitlementContext()));
        }
        return MutableMap.builder().put((Object)"description", (Object)("Invoking effector " + effector.getName() + " on " + entity.getDisplayName() + (parameters != null ? " with parameters " + Sanitizer.sanitize(parameters.getAllConfig()) : ""))).put((Object)"displayName", (Object)effector.getName()).put((Object)"tags", (Object)tags).build();
    }

    static class EffectorCallPropagatedRuntimeException
    extends PropagatedRuntimeException
    implements CanSkipInContext {
        private static final long serialVersionUID = 6146890711493851848L;
        private String entityId;
        private String effectorName;

        EffectorCallPropagatedRuntimeException(Entity entity, Effector<?> effector, Throwable throwable) {
            super(EffectorCallPropagatedRuntimeException.makeMessage(entity, effector), throwable);
            this.entityId = entity.getId();
            this.effectorName = effector.getName();
        }

        public boolean canSkipInContext(Object context) {
            if (context instanceof Task) {
                Entity entity = BrooklynTaskTags.getContextEntity((Task)context);
                if (entity == null || !Objects.equal((Object)this.entityId, (Object)entity.getId())) {
                    return false;
                }
                return Objects.equal((Object)this.effectorName, (Object)BrooklynTaskTags.getEffectorName((Task)context));
            }
            return false;
        }

        private static String makeMessage(Entity entity, Effector<?> effector) {
            return "Error invoking " + effector.getName() + " at " + entity;
        }

        private static RuntimeException propagate(Entity entity, Effector<?> effector, Throwable throwable) {
            if (throwable instanceof EffectorCallPropagatedRuntimeException && Objects.equal((Object)EffectorCallPropagatedRuntimeException.makeMessage(entity, effector), (Object)throwable.getMessage())) {
                throw (EffectorCallPropagatedRuntimeException)((Object)throwable);
            }
            EffectorCallPropagatedRuntimeException result = new EffectorCallPropagatedRuntimeException(entity, effector, throwable);
            log.warn(Exceptions.collapseText((Throwable)((Object)result)));
            log.debug(EffectorCallPropagatedRuntimeException.makeMessage(entity, effector), throwable);
            throw result;
        }
    }
}

