/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.BasicLocationDefinition;
import org.apache.brooklyn.core.location.CatalogLocationResolver;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.location.localhost.LocalhostLocationResolver;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.WildcardGlobs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLocationRegistry
implements LocationRegistry {
    public static final Logger log = LoggerFactory.getLogger(BasicLocationRegistry.class);
    private final ManagementContext mgmt;
    private final Map<String, LocationDefinition> definedLocations = new LinkedHashMap<String, LocationDefinition>();
    protected final Map<String, LocationResolver> resolvers = new LinkedHashMap<String, LocationResolver>();
    private final Set<String> specsWarnedOnException = Sets.newConcurrentHashSet();
    protected ThreadLocal<Set<String>> specsSeen = new ThreadLocal();

    public static List<String> expandCommaSeparateLocations(String locations) {
        return WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + locations + "}"), (boolean)false, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.INTERIOR_NOT_EXPANDABLE, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.INTERIOR_NOT_EXPANDABLE);
    }

    public BasicLocationRegistry(ManagementContext mgmt) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.findServices();
        this.updateDefinedLocations();
    }

    protected void findServices() {
        MutableList loadedResolvers;
        Iterable loader = FrameworkLookup.lookupAll(LocationResolver.class, (ClassLoader)this.mgmt.getCatalogClassLoader());
        try {
            loadedResolvers = MutableList.copyOf((Iterable)loader);
        }
        catch (Throwable e) {
            log.warn("Error loading resolvers (rethrowing): " + e);
            throw Exceptions.propagate((Throwable)e);
        }
        for (LocationResolver r : loadedResolvers) {
            this.registerResolver(r);
        }
        if (log.isDebugEnabled()) {
            log.debug("Location resolvers are: " + this.resolvers);
        }
        if (this.resolvers.isEmpty()) {
            log.warn("No location resolvers detected: is src/main/resources correctly included?");
        }
    }

    public boolean registerResolver(LocationResolver r) {
        r.init(this.mgmt);
        if (!r.isEnabled()) {
            return false;
        }
        this.resolvers.put(r.getPrefix(), r);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, LocationDefinition> getDefinedLocations(boolean includeThingsWeAreFacadeFor) {
        MutableMap result = MutableMap.of();
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            result.putAll(this.definedLocations);
        }
        for (RegisteredType rt : this.mgmt.getTypeRegistry().getMatching(RegisteredTypePredicates.IS_LOCATION)) {
            result.put(rt.getId(), this.newDefinedLocation(rt));
        }
        return result;
    }

    @Deprecated
    public Map<String, LocationDefinition> getDefinedLocations() {
        return this.getDefinedLocations(true);
    }

    public LocationDefinition getDefinedLocationById(String id) {
        return this.getDefinedLocation(id, true);
    }

    public LocationDefinition getDefinedLocationByName(String name) {
        return this.getDefinedLocation(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocationDefinition getDefinedLocation(String nameOrId, boolean isId) {
        RegisteredType lt = this.mgmt.getTypeRegistry().get(nameOrId, RegisteredTypeLoadingContexts.withSpecSuperType(null, LocationSpec.class));
        if (lt != null) {
            return this.newDefinedLocation(lt);
        }
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            if (isId) {
                LocationDefinition ld = this.definedLocations.get(nameOrId);
                if (ld != null) {
                    return ld;
                }
            } else {
                for (LocationDefinition l : this.definedLocations.values()) {
                    if (!l.getName().equals(nameOrId)) continue;
                    return l;
                }
            }
        }
        lt = this.mgmt.getTypeRegistry().get(nameOrId);
        if (lt != null && lt.getSuperTypes().isEmpty()) {
            if (lt.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
                log.warn("Location registry only found " + nameOrId + " when ignoring supertypes; check it is correctly resolved.");
            }
            return this.newDefinedLocation(lt);
        }
        return null;
    }

    @Deprecated
    public void updateDefinedLocation(LocationDefinition l) {
        this.updateDefinedLocationNonPersisted(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinedLocationNonPersisted(LocationDefinition l) {
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            this.definedLocations.put(l.getId(), l);
        }
    }

    @Deprecated
    public void updateDefinedLocation(CatalogItem<Location, LocationSpec<?>> item) {
        String id = item.getCatalogItemId();
        String symbolicName = item.getSymbolicName();
        String spec = CatalogLocationResolver.createLegacyWrappedReference(id);
        ImmutableMap config = ImmutableMap.of();
        BasicLocationDefinition locDefinition = new BasicLocationDefinition(symbolicName, symbolicName, spec, (Map<String, ?>)config);
        this.updateDefinedLocation(locDefinition);
    }

    @Deprecated
    public void updateDefinedLocation(RegisteredType item) {
        BasicLocationDefinition locDefinition = this.newDefinedLocation(item);
        this.updateDefinedLocation(locDefinition);
    }

    protected BasicLocationDefinition newDefinedLocation(RegisteredType item) {
        String id = item.getId();
        String spec = CatalogLocationResolver.createLegacyWrappedReference(id);
        return new BasicLocationDefinition(id, item.getSymbolicName(), spec, (Map<String, ?>)ImmutableMap.of());
    }

    @Deprecated
    public void removeDefinedLocation(CatalogItem<Location, LocationSpec<?>> item) {
        this.removeDefinedLocation(item.getSymbolicName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefinedLocation(String id) {
        LocationDefinition removed;
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            removed = this.definedLocations.remove(id);
        }
        if (removed == null && log.isDebugEnabled()) {
            log.debug("{} was asked to remove location with id {} but no such location was registered", (Object)this, (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinedLocations() {
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            int count = 0;
            String NAMED_LOCATION_PREFIX = "brooklyn.location.named.";
            StringConfigMap namedLocationProps = this.mgmt.getConfig().submap(ConfigPredicates.nameStartsWith(NAMED_LOCATION_PREFIX));
            for (String k : namedLocationProps.asMapWithStringKeys().keySet()) {
                String name = k.substring(NAMED_LOCATION_PREFIX.length());
                if (name.contains(".")) continue;
                String spec = (String)namedLocationProps.asMapWithStringKeys().get(k);
                String id = Identifiers.makeRandomId((int)8);
                BrooklynProperties config = ConfigUtils.filterForPrefixAndStrip(namedLocationProps.asMapWithStringKeys(), k + ".");
                this.definedLocations.put(id, new BasicLocationDefinition(id, name, spec, config.asMapWithStringKeys()));
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + count + " defined locations from properties (*.named.* syntax): " + this.definedLocations.values());
            }
        }
    }

    private static BasicLocationDefinition localhost(String id) {
        return new BasicLocationDefinition(id, "localhost", "localhost", null);
    }

    @Deprecated
    public boolean canMaybeResolve(String spec) {
        return this.getSpecResolver(spec) != null;
    }

    @Deprecated
    public final Location resolve(String spec) {
        return (Location)this.resolve(spec, (Boolean)true, null).get();
    }

    @Deprecated
    public Maybe<Location> resolve(String spec, Boolean manage, Map locationFlags) {
        Maybe<LocationSpec<? extends Location>> lSpec;
        if (manage != null) {
            locationFlags = MutableMap.copyOf((Map)locationFlags);
            locationFlags.put(LocalLocationManager.CREATE_UNMANAGED, manage == false);
        }
        if ((lSpec = this.getLocationSpec(spec, locationFlags)).isAbsent()) {
            return lSpec;
        }
        return Maybe.of((Object)this.mgmt.getLocationManager().createLocation((LocationSpec)lSpec.get()));
    }

    public Location getLocationManaged(String spec) {
        return this.mgmt.getLocationManager().createLocation((LocationSpec)this.getLocationSpec(spec).get());
    }

    public final Location getLocationManaged(String spec, Map locationFlags) {
        return this.mgmt.getLocationManager().createLocation((LocationSpec)this.getLocationSpec(spec, locationFlags).get());
    }

    public Maybe<LocationSpec<? extends Location>> getLocationSpec(LocationDefinition ld) {
        return this.getLocationSpec(ld, (Map)MutableMap.of());
    }

    public Maybe<LocationSpec<? extends Location>> getLocationSpec(LocationDefinition ld, Map locationFlags) {
        ConfigBag newLocationFlags = ConfigBag.newInstance(ld.getConfig()).putAll(locationFlags).putIfAbsentAndNotNull(LocationInternal.NAMED_SPEC_NAME, ld.getName()).putIfAbsentAndNotNull(LocationInternal.ORIGINAL_SPEC, ld.getName());
        Maybe<LocationSpec<? extends Location>> result = this.getLocationSpec(ld.getSpec(), newLocationFlags.getAllConfigRaw());
        if (result.isPresent()) {
            ((LocationSpec)result.get()).configure(LocationInternal.NAMED_SPEC_NAME, (Object)ld.getName());
            ((LocationSpec)result.get()).configure(LocationInternal.ORIGINAL_SPEC, (Object)ld.getName());
        }
        return result;
    }

    public Maybe<LocationSpec<? extends Location>> getLocationSpec(String spec) {
        return this.getLocationSpec(spec, (Map)MutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Maybe<LocationSpec<? extends Location>> getLocationSpec(String spec, Map locationFlags) {
        try {
            locationFlags = MutableMap.copyOf((Map)locationFlags);
            Set<String> seenSoFar = this.specsSeen.get();
            if (seenSoFar == null) {
                seenSoFar = new LinkedHashSet<String>();
                this.specsSeen.set(seenSoFar);
            }
            if (seenSoFar.contains(spec)) {
                Maybe maybe = Maybe.absent((Supplier)Suppliers.ofInstance((Object)new IllegalStateException("Circular reference in definition of location '" + spec + "' (" + seenSoFar + ")")));
                return maybe;
            }
            seenSoFar.add(spec);
            LocationResolver resolver = this.getSpecResolver(spec);
            if (resolver != null) {
                try {
                    LocationSpec specO = resolver.newLocationSpecFromString(spec, locationFlags, (LocationRegistry)this);
                    specO.configure(LocationInternal.ORIGINAL_SPEC, (Object)spec);
                    specO.configure(LocationInternal.NAMED_SPEC_NAME, (Object)spec);
                    Maybe maybe = Maybe.of((Object)specO);
                    return maybe;
                }
                catch (RuntimeException e) {
                    Maybe maybe = Maybe.absent((Supplier)Suppliers.ofInstance((Object)e));
                    this.specsSeen.remove();
                    return maybe;
                }
            }
            String errmsg = "Unknown location '" + spec + "'";
            ConfigBag cfg = ConfigBag.newInstance(locationFlags);
            String orig = cfg.get(LocationInternal.ORIGINAL_SPEC);
            String named = cfg.get(LocationInternal.NAMED_SPEC_NAME);
            if (Strings.isNonBlank((CharSequence)named) && !named.equals(spec) && !named.equals(orig)) {
                errmsg = errmsg + " when looking up '" + named + "'";
            }
            if (Strings.isNonBlank((CharSequence)orig) && !orig.equals(spec)) {
                errmsg = errmsg + " when resolving '" + orig + "'";
            }
            if (spec == null || this.specsWarnedOnException.add(spec)) {
                if (this.resolvers.get("id") == null || this.resolvers.get("named") == null) {
                    log.error("Standard location resolvers not installed, location resolution will fail shortly. This usually indicates a classpath problem, such as when running from an IDE which has not properly copied META-INF/services from src/main/resources. " + errmsg + ". Known resolvers are: " + this.resolvers.keySet());
                    errmsg = errmsg + ": Problem detected with location resolver configuration; " + this.resolvers.keySet() + " are the only available location resolvers. More information can be found in the logs.";
                } else if (log.isDebugEnabled()) {
                    log.debug(errmsg + " (if this is being loaded it will fail shortly): known resolvers are: " + this.resolvers.keySet());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(errmsg + "(with retry, already warned)");
                }
                errmsg = errmsg + " (with retry)";
            }
            Maybe maybe = Maybe.absent((Supplier)Suppliers.ofInstance((Object)new NoSuchElementException(errmsg)));
            return maybe;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.specsSeen.remove();
        }
    }

    @Deprecated
    public final Location resolve(String spec, Map locationFlags) {
        return (Location)this.resolve(spec, null, locationFlags).get();
    }

    protected LocationResolver getSpecResolver(String spec) {
        int colonIndex = spec.indexOf(58);
        int bracketIndex = spec.indexOf("(");
        int dividerIndex = colonIndex < 0 ? bracketIndex : (bracketIndex < 0 ? colonIndex : Math.min(bracketIndex, colonIndex));
        String prefix = dividerIndex >= 0 ? spec.substring(0, dividerIndex) : spec;
        LocationResolver resolver = this.resolvers.get(prefix);
        if (resolver == null) {
            resolver = this.getSpecDefaultResolver(spec);
        }
        return resolver;
    }

    protected LocationResolver getSpecDefaultResolver(String spec) {
        return this.getSpecFirstResolver(spec, "id", "named", "jclouds");
    }

    protected LocationResolver getSpecFirstResolver(String spec, String ... resolversToCheck) {
        for (String resolverId : resolversToCheck) {
            LocationResolver resolver = this.resolvers.get(resolverId);
            if (resolver == null || !resolver.accepts(spec, (LocationRegistry)this)) continue;
            return resolver;
        }
        return null;
    }

    public static boolean isResolverPrefixForSpec(LocationResolver resolver, String spec, boolean argumentRequired) {
        if (spec == null) {
            return false;
        }
        if (spec.startsWith(resolver.getPrefix() + ":")) {
            return true;
        }
        return !argumentRequired && spec.equals(resolver.getPrefix());
    }

    @Deprecated
    public List<Location> resolve(Iterable<?> spec) {
        return this.getFromIterableListOfLocationsManaged(spec);
    }

    private List<Location> getFromIterableListOfLocationsManaged(Iterable<?> spec) {
        ArrayList<Location> result = new ArrayList<Location>();
        for (Object id : spec) {
            if (id == null) {
                // empty if block
            }
            if (id instanceof String) {
                result.add(this.getLocationManaged((String)id));
                continue;
            }
            if (id instanceof Location) {
                result.add((Location)id);
                continue;
            }
            if (id instanceof Iterable) {
                throw new IllegalArgumentException("Cannot resolve '" + id + "' to a location; collections of collections not allowed");
            }
            throw new IllegalArgumentException("Cannot resolve '" + id + "' to a location; unsupported type " + (id == null ? "null" : id.getClass().getName()));
        }
        return result;
    }

    @Deprecated
    public List<Location> resolveList(Object l) {
        return this.getListOfLocationsManaged(l);
    }

    public List<Location> getListOfLocationsManaged(Object l) {
        if (l == null) {
            l = Collections.emptyList();
        }
        if (l instanceof String) {
            l = StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible((String)((String)((Object)l)));
        }
        if (l instanceof Iterable) {
            return this.getFromIterableListOfLocationsManaged(l);
        }
        throw new IllegalArgumentException("Location list must be supplied as a collection or a string, not " + JavaClassNames.simpleClassName((Object)l) + "/" + l);
    }

    @Deprecated
    public Location resolve(LocationDefinition ld) {
        return (Location)this.resolve(ld, null, null).get();
    }

    @Deprecated
    public Maybe<Location> resolve(LocationDefinition ld, Boolean manage, Map locationFlags) {
        ConfigBag newLocationFlags = ConfigBag.newInstance(ld.getConfig()).putAll(locationFlags).putIfAbsentAndNotNull(LocationInternal.NAMED_SPEC_NAME, ld.getName()).putIfAbsentAndNotNull(LocationInternal.ORIGINAL_SPEC, ld.getName());
        Maybe<Location> result = this.resolve(ld.getSpec(), manage, newLocationFlags.getAllConfigRaw());
        if (result.isPresent()) {
            return result;
        }
        throw new IllegalStateException("Cannot instantiate location '" + ld + "' pointing at " + ld.getSpec(), Maybe.getException(result));
    }

    public Map getProperties() {
        return this.mgmt.getConfig().asMapWithStringKeys();
    }

    @VisibleForTesting
    public void putProperties(Map<String, ?> vals) {
        ((ManagementContextInternal)this.mgmt).getBrooklynProperties().putAll(vals);
    }

    @VisibleForTesting
    public static void addNamedLocationLocalhost(ManagementContext mgmt) {
        if (!((Boolean)mgmt.getConfig().getConfig(LocalhostLocationResolver.LOCALHOST_ENABLED)).booleanValue()) {
            throw new IllegalStateException("Localhost is disabled.");
        }
        LocationDefinition l = mgmt.getLocationRegistry().getDefinedLocationByName("localhost");
        if (l == null) {
            mgmt.getLocationRegistry().updateDefinedLocation((LocationDefinition)BasicLocationRegistry.localhost(Identifiers.makeRandomId((int)8)));
        }
    }
}

