/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.feed;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.feed.FeedConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.time.Duration;

public class PollConfig<V, T, F extends PollConfig<V, T, F>>
extends FeedConfig<V, T, F> {
    private long period = -1L;
    private String description;

    public PollConfig(AttributeSensor<T> sensor) {
        super(sensor);
    }

    public PollConfig(PollConfig<V, T, F> other) {
        super(other);
        this.period = other.period;
    }

    public long getPeriod() {
        return this.period;
    }

    public F period(Duration val) {
        Preconditions.checkArgument((val.toMilliseconds() >= 0L ? 1 : 0) != 0, (Object)"period must be greater than or equal to zero");
        this.period = val.toMilliseconds();
        return (F)((PollConfig)this.self());
    }

    public F period(long val) {
        Preconditions.checkArgument((val >= 0L ? 1 : 0) != 0, (Object)"period must be greater than or equal to zero");
        this.period = val;
        return (F)((PollConfig)this.self());
    }

    public F period(long val, TimeUnit units) {
        Preconditions.checkArgument((val >= 0L ? 1 : 0) != 0, (Object)"period must be greater than or equal to zero");
        return this.period(units.toMillis(val));
    }

    public F description(String description) {
        this.description = description;
        return (F)((PollConfig)this.self());
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    protected MutableList<Object> toStringOtherFields() {
        return super.toStringOtherFields().appendIfNotNull((Object)this.description);
    }

    @Override
    protected MutableList<Object> equalsFields() {
        return super.equalsFields().appendIfNotNull((Object)this.period);
    }
}

