/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityType;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.EntityManager;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.SubscriptionContext;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigConstraints;
import org.apache.brooklyn.core.config.internal.AbstractConfigMapImpl;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.internal.ConfigUtilsInternal;
import org.apache.brooklyn.core.entity.internal.EntityConfigMap;
import org.apache.brooklyn.core.entity.lifecycle.PolicyDescriptor;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.internal.BrooklynInitialization;
import org.apache.brooklyn.core.internal.storage.BrooklynStorage;
import org.apache.brooklyn.core.internal.storage.Reference;
import org.apache.brooklyn.core.internal.storage.impl.BasicReference;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.core.mgmt.internal.EntityManagementSupport;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.internal.SubscriptionTracker;
import org.apache.brooklyn.core.mgmt.rebind.BasicEntityRebindSupport;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.AbstractConfigurationSupportInternal;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.AttributeMap;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.BasicNotificationSensor;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Equals;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntity
extends AbstractBrooklynObject
implements EntityInternal {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntity.class);
    public static final ConfigKey<String> DEFAULT_DISPLAY_NAME;
    public static final BasicNotificationSensor<Location> LOCATION_ADDED;
    public static final BasicNotificationSensor<Location> LOCATION_REMOVED;
    public static final BasicNotificationSensor<Sensor> SENSOR_ADDED;
    public static final BasicNotificationSensor<Sensor> SENSOR_REMOVED;
    public static final BasicNotificationSensor<String> EFFECTOR_ADDED;
    public static final BasicNotificationSensor<String> EFFECTOR_REMOVED;
    public static final BasicNotificationSensor<String> EFFECTOR_CHANGED;
    public static final BasicNotificationSensor<ConfigKey> CONFIG_KEY_ADDED;
    public static final BasicNotificationSensor<ConfigKey> CONFIG_KEY_REMOVED;
    public static final BasicNotificationSensor<PolicyDescriptor> POLICY_ADDED;
    public static final BasicNotificationSensor<PolicyDescriptor> POLICY_REMOVED;
    public static final BasicNotificationSensor<Entity> CHILD_ADDED;
    public static final BasicNotificationSensor<Entity> CHILD_REMOVED;
    public static final BasicNotificationSensor<Group> GROUP_ADDED;
    public static final BasicNotificationSensor<Group> GROUP_REMOVED;
    public static final AttributeSensor<String> ENTITY_ID;
    public static final AttributeSensor<String> APPLICATION_ID;
    public static final AttributeSensor<String> CATALOG_ID;
    private boolean displayNameAutoGenerated = true;
    private Entity selfProxy;
    private volatile Application application;
    private Reference<Entity> parent = new BasicReference<Entity>();
    private Set<Entity> children = Collections.synchronizedSet(Sets.newLinkedHashSet());
    private Set<Group> groupsInternal = Collections.synchronizedSet(Sets.newLinkedHashSet());
    private Reference<List<Location>> locations = new BasicReference<ImmutableList>(ImmutableList.of());
    private Reference<Long> creationTimeUtc = new BasicReference<Long>(System.currentTimeMillis());
    private Reference<String> displayName = new BasicReference<String>();
    private Collection<AbstractPolicy> policiesInternal = Lists.newCopyOnWriteArrayList();
    private Collection<AbstractEnricher> enrichersInternal = Lists.newCopyOnWriteArrayList();
    private Collection<Feed> feedsInternal = Lists.newCopyOnWriteArrayList();
    private boolean previouslyOwned = false;
    private boolean inConstruction = true;
    private final EntityDynamicType entityType;
    protected final EntityManagementSupport managementSupport = new EntityManagementSupport(this);
    private final BasicConfigurationSupport config = new BasicConfigurationSupport();
    private final BasicSensorSupport sensors = new BasicSensorSupport();
    private final BasicSubscriptionSupport subscriptions = new BasicSubscriptionSupport();
    private final BasicPolicySupport policies = new BasicPolicySupport();
    private final BasicEnricherSupport enrichers = new BasicEnricherSupport();
    private final BasicGroupSupport groups = new BasicGroupSupport();
    private final BasicFeedSupport feeds = new BasicFeedSupport();
    private EntityConfigMap configsInternal = new EntityConfigMap(this);
    private AttributeMap attributesInternal = new AttributeMap(this);
    @Deprecated
    protected final Map<String, Object> tempWorkings = Maps.newLinkedHashMap();
    protected volatile transient SubscriptionTracker _subscriptionTracker;
    static Set<String> WARNED_READ_ONLY_ATTRIBUTES;

    public AbstractEntity() {
        this(Maps.newLinkedHashMap(), null);
    }

    @Deprecated
    public AbstractEntity(Map flags) {
        this(flags, null);
    }

    @Deprecated
    public AbstractEntity(Entity parent) {
        this(Maps.newLinkedHashMap(), parent);
    }

    @Deprecated
    public AbstractEntity(Map flags, Entity parent) {
        super(AbstractEntity.checkConstructorFlags(flags, parent));
        this.entityType = new EntityDynamicType(this);
        if (this.isLegacyConstruction()) {
            boolean deferConstructionChecks;
            AbstractEntity checkWeGetThis = this.configure(flags);
            assert (this.equals(checkWeGetThis)) : this + " configure method does not return itself; returns " + checkWeGetThis + " instead of " + this;
            boolean bl = deferConstructionChecks = flags.containsKey("deferConstructionChecks") && TypeCoercions.coerce(flags.get("deferConstructionChecks"), Boolean.class) != false;
            if (!deferConstructionChecks) {
                FlagUtils.checkRequiredFields(this);
            }
        }
    }

    private static Map<?, ?> checkConstructorFlags(Map flags, Entity parent) {
        if (flags == null) {
            throw new IllegalArgumentException("Flags passed to entity must not be null (try no-arguments or empty map)");
        }
        if (flags.get("parent") != null && parent != null && flags.get("parent") != parent) {
            throw new IllegalArgumentException("Multiple parents supplied, " + flags.get("parent") + " and " + parent);
        }
        if (flags.get("owner") != null && parent != null && flags.get("owner") != parent) {
            throw new IllegalArgumentException("Multiple parents supplied with flags.parent, " + flags.get("owner") + " and " + parent);
        }
        if (flags.get("parent") != null && flags.get("owner") != null && flags.get("parent") != flags.get("owner")) {
            throw new IllegalArgumentException("Multiple parents supplied with flags.parent and flags.owner, " + flags.get("parent") + " and " + flags.get("owner"));
        }
        if (parent != null) {
            flags.put("parent", parent);
        }
        if (flags.get("owner") != null) {
            LOG.warn("Use of deprecated \"flags.owner\" instead of \"flags.parent\" for entity");
            flags.put("parent", flags.get("owner"));
            flags.remove("owner");
        }
        return flags;
    }

    @Override
    @Deprecated
    public AbstractEntity configure(Map flags) {
        Map suppliedOwnConfig;
        Entity suppliedParent;
        if (!this.inConstruction && this.getManagementSupport().isDeployed()) {
            LOG.warn("bulk/flag configuration being made to {} after deployment: may not be supported in future versions ({})", new Object[]{this, flags});
        }
        if ((suppliedParent = (Entity)flags.remove("parent")) != null) {
            suppliedParent.addChild(this.getProxyIfAvailable());
        }
        if ((suppliedOwnConfig = (Map)flags.remove("config")) != null) {
            for (Map.Entry<Object, Object> entry : suppliedOwnConfig.entrySet()) {
                this.setConfigEvenIfOwned((ConfigKey)entry.getKey(), entry.getValue());
            }
        }
        if (flags.get("displayName") != null) {
            this.displayName.set((String)flags.remove("displayName"));
            this.displayNameAutoGenerated = false;
        } else if (flags.get("name") != null) {
            this.displayName.set((String)flags.remove("name"));
            this.displayNameAutoGenerated = false;
        } else if (this.isLegacyConstruction()) {
            this.displayName.set(this.getClass().getSimpleName() + ":" + Strings.maxlen((String)this.getId(), (int)4));
            this.displayNameAutoGenerated = true;
        }
        if (flags.get(BrooklynConfigKeys.ICON_URL.getName()) != null) {
            this.tags().addTag((Object)BrooklynTags.newIconUrlTag((String)flags.remove(BrooklynConfigKeys.ICON_URL.getName())));
        }
        if ((flags = ConfigUtilsInternal.setAllConfigKeys(flags, this.getEntityType().getConfigKeys(), (Configurable)this)).size() > 0) {
            FlagUtils.setFieldsFromFlags(flags, this);
            flags = FlagUtils.setAllConfigKeys(flags, (Configurable)this, false);
        }
        Iterator<Map.Entry<?, ?>> fi = flags.entrySet().iterator();
        while (fi.hasNext()) {
            Map.Entry<Object, Object> entry;
            entry = fi.next();
            Object k = entry.getKey();
            if (k instanceof ConfigKey.HasConfigKey) {
                k = ((ConfigKey.HasConfigKey)k).getConfigKey();
            }
            if (!(k instanceof ConfigKey)) continue;
            this.setConfigEvenIfOwned((ConfigKey)k, entry.getValue());
            fi.remove();
        }
        if (!flags.isEmpty()) {
            LOG.warn("Unsupported flags when configuring {}; storing: {}", (Object)this, flags);
            this.configsInternal.putAll(flags);
        }
        return this;
    }

    public void configure(Iterable<ConfigKey<?>> configKeys) {
        this.entityType.addConfigKeys(configKeys);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && (o == this || o == this.selfProxy || o instanceof Entity && Objects.equal((Object)this.getId(), (Object)((Entity)o).getId()));
    }

    @Beta
    public void setProxy(Entity proxy) {
        if (this.selfProxy != null) {
            throw new IllegalStateException("Proxy is already set; cannot reset proxy for " + this.toString());
        }
        this.resetProxy(proxy);
    }

    @Beta
    public void resetProxy(Entity proxy) {
        this.selfProxy = (Entity)Preconditions.checkNotNull((Object)proxy, (Object)"proxy");
    }

    public Entity getProxy() {
        return this.selfProxy;
    }

    @Beta
    public Entity getProxyIfAvailable() {
        return this.getProxy() != null ? this.getProxy() : this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey<T> key, T value) {
        this.setConfig(key, value);
        return this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey<T> key, String value) {
        this.config().set(key, value);
        return this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey.HasConfigKey<T> key, T value) {
        this.config().set(key, value);
        return this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey.HasConfigKey<T> key, String value) {
        this.config().set((ConfigKey)key, value);
        return this;
    }

    @Override
    public void setManagementContext(ManagementContextInternal managementContext) {
        super.setManagementContext(managementContext);
        this.getManagementSupport().setManagementContext(managementContext);
        this.entityType.setName(this.getEntityTypeName());
        if (this.displayNameAutoGenerated) {
            this.displayName.set(this.getEntityType().getSimpleName() + ":" + Strings.maxlen((String)this.getId(), (int)4));
        }
    }

    protected Object getAttributesSynchObjectInternal() {
        return this.attributesInternal.getSynchObjectInternal();
    }

    @Override
    public Map<String, String> toMetadataRecord() {
        return ImmutableMap.of();
    }

    public long getCreationTime() {
        return this.creationTimeUtc.get();
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    @Deprecated
    public String getIconUrl() {
        return RegisteredTypes.getIconUrl(this);
    }

    @Override
    public void setDisplayName(String newDisplayName) {
        this.displayName.set(newDisplayName);
        this.displayNameAutoGenerated = false;
        this.getManagementSupport().getEntityChangeListener().onChanged();
    }

    protected void setDefaultDisplayName(String displayNameIfDefault) {
        if (this.displayNameAutoGenerated) {
            this.displayName.set(displayNameIfDefault);
        }
    }

    protected String getEntityTypeName() {
        try {
            Class typeClazz = this.getManagementContext().getEntityManager().getEntityTypeRegistry().getEntityTypeOf(this.getClass());
            String typeName = typeClazz.getCanonicalName();
            if (typeName == null) {
                typeName = typeClazz.getName();
            }
            return typeName;
        }
        catch (IllegalArgumentException e) {
            String typeName = this.getClass().getCanonicalName();
            if (typeName == null) {
                typeName = this.getClass().getName();
            }
            LOG.debug("Entity type interface not found for entity " + this + "; instead using " + typeName + " as entity type name");
            return typeName;
        }
    }

    public AbstractEntity setParent(Entity entity) {
        if (!this.parent.isNull()) {
            if (this.parent.contains(entity)) {
                return this;
            }
            if (entity == null) {
                this.clearParent();
                return this;
            }
            throw new UnsupportedOperationException("Cannot change parent of " + this + " from " + this.parent + " to " + entity + " (parent change not supported)");
        }
        if (this.previouslyOwned && entity != null) {
            throw new UnsupportedOperationException("Cannot set a parent of " + this + " as " + entity + " because it has previously had a parent");
        }
        if (this.equals(entity)) {
            throw new IllegalStateException("entity " + this + " cannot own itself");
        }
        if (Entities.isDescendant((Entity)this, entity)) {
            throw new IllegalStateException("loop detected trying to set parent of " + this + " as " + entity + ", which is already a descendent");
        }
        this.parent.set(entity);
        entity.addChild(this.getProxyIfAvailable());
        this.config().refreshInheritedConfig();
        this.previouslyOwned = true;
        this.getApplication();
        return this;
    }

    public void clearParent() {
        if (this.parent.isNull()) {
            return;
        }
        Entity oldParent = this.parent.get();
        this.parent.clear();
        if (oldParent != null && !Entities.isNoLongerManaged(oldParent)) {
            oldParent.removeChild(this.getProxyIfAvailable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> T addChild(T child) {
        Preconditions.checkNotNull(child, (String)"child must not be null (for entity %s)", (Object[])new Object[]{this});
        CatalogUtils.setCatalogItemIdOnAddition((Entity)this, child);
        Object object = this.getAttributesSynchObjectInternal();
        synchronized (object) {
            Set<Entity> set = this.children;
            synchronized (set) {
                if (Entities.isAncestor((Entity)this, child)) {
                    throw new IllegalStateException("loop detected trying to add child " + child + " to " + this + "; it is already an ancestor");
                }
                child.setParent(this.getProxyIfAvailable());
                boolean changed = this.children.add(child);
                this.getManagementSupport().getEntityChangeListener().onChildrenChanged();
                if (changed) {
                    this.sensors().emit(CHILD_ADDED, child);
                }
            }
        }
        return child;
    }

    public <T extends Entity> T addChild(EntitySpec<T> spec) {
        if (spec.getParent() == null) {
            spec = EntitySpec.create(spec).parent(this.getProxyIfAvailable());
        }
        if (!this.equals(spec.getParent())) {
            throw new IllegalArgumentException("Attempt to create child of " + this + " with entity spec " + spec + " failed because spec has different parent: " + spec.getParent());
        }
        return (T)this.getEntityManager().createEntity(spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Entity child) {
        Object object = this.getAttributesSynchObjectInternal();
        synchronized (object) {
            Set<Entity> set = this.children;
            synchronized (set) {
                boolean changed = this.children.remove(child);
                child.clearParent();
                if (changed) {
                    this.getManagementSupport().getEntityChangeListener().onChildrenChanged();
                }
                if (changed) {
                    this.sensors().emit(CHILD_REMOVED, child);
                }
                return changed;
            }
        }
    }

    @Override
    @Beta
    public BasicGroupSupport groups() {
        return this.groups;
    }

    @Deprecated
    public void addGroup(Group group) {
        this.groups().add(group);
    }

    @Deprecated
    public void removeGroup(Group group) {
        this.groups().remove(group);
    }

    @Deprecated
    public Collection<Group> getGroups() {
        return this.groups().asList();
    }

    public Entity getParent() {
        return this.parent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity> getChildren() {
        Set<Entity> set = this.children;
        synchronized (set) {
            return ImmutableList.copyOf(this.children);
        }
    }

    public Application getApplication() {
        Application app;
        if (this.application != null) {
            return this.application;
        }
        Entity parent = this.getParent();
        Application application = app = parent != null ? parent.getApplication() : null;
        if (app != null && this.getManagementSupport().isFullyManaged()) {
            this.setApplication(app);
        }
        return app;
    }

    @Deprecated
    protected synchronized void setApplication(Application app) {
        if (this.application != null && this.application.getId() != app.getId()) {
            throw new IllegalStateException("Cannot change application of entity (attempted for " + this + " from " + this.getApplication() + " to " + app);
        }
        this.application = app;
    }

    public String getApplicationId() {
        Application app = this.getApplication();
        return app == null ? null : app.getId();
    }

    @Override
    public ManagementContext getManagementContext() {
        return this.getManagementSupport().getManagementContext();
    }

    protected EntityManager getEntityManager() {
        return this.getManagementContext().getEntityManager();
    }

    public EntityType getEntityType() {
        if (this.entityType == null) {
            return null;
        }
        return this.entityType.getSnapshot();
    }

    @Override
    public EntityDynamicType getMutableEntityType() {
        return this.entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Location> getLocations() {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            return ImmutableList.copyOf((Collection)this.locations.get());
        }
    }

    @Override
    public void addLocations(Collection<? extends Location> newLocations) {
        this.addLocationsImpl(newLocations, true);
    }

    @Override
    @Beta
    public void addLocationsWithoutPublishing(Collection<? extends Location> newLocations) {
        this.addLocationsImpl(newLocations, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    protected void addLocationsImpl(Collection<? extends Location> newLocations, boolean publish) {
        if (newLocations == null || newLocations.isEmpty()) {
            return;
        }
        for (Location location : newLocations) {
            BrooklynTags.NamedStringTag ownerEntityTag = BrooklynTags.findFirst("owner_entity_id", location.tags().getTags());
            if (ownerEntityTag == null || this.getId().equals(ownerEntityTag.getContents())) continue;
            LOG.info("Adding location {} to entity {}, which is already owned by another entity {}. Locations owned by a specific entity will be unmanaged together with their owner, regardless of other references to them. Therefore care should be taken if sharing the location with other entities.", new Object[]{location, this, ownerEntityTag.getContents()});
        }
        Iterator<? extends Location> iterator = this.locations;
        synchronized (iterator) {
            List<Location> list = this.locations.get();
            LinkedHashSet trulyNewLocations = Sets.newLinkedHashSet(newLocations);
            trulyNewLocations.removeAll(list);
            if (trulyNewLocations.size() > 0) {
                this.locations.set((List<Location>)ImmutableList.builder().addAll(list).addAll((Iterable)trulyNewLocations).build());
            }
            if (publish) {
                for (Location loc : trulyNewLocations) {
                    this.sensors().emit(LOCATION_ADDED, loc);
                }
            }
        }
        if (publish && this.getManagementSupport().isDeployed()) {
            for (Location location : newLocations) {
                Locations.manage(location, this.getManagementContext());
            }
        }
        this.getManagementSupport().getEntityChangeListener().onLocationsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocations(Collection<? extends Location> removedLocations) {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            List<Location> oldLocations = this.locations.get();
            Sets.SetView trulyRemovedLocations = Sets.intersection((Set)ImmutableSet.copyOf(removedLocations), (Set)ImmutableSet.copyOf(oldLocations));
            this.locations.set((List<Location>)MutableList.builder().addAll(oldLocations).removeAll(removedLocations).buildImmutable());
            for (Location loc : trulyRemovedLocations) {
                this.sensors().emit(LOCATION_REMOVED, loc);
            }
        }
        this.getManagementSupport().getEntityChangeListener().onLocationsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLocations() {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            this.locations.set((List<Location>)ImmutableList.of());
        }
        this.getManagementSupport().getEntityChangeListener().onLocationsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location firstLocation() {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            return (Location)Iterables.get((Iterable)this.locations.get(), (int)0);
        }
    }

    @Override
    public void destroy() {
    }

    public <T> T getAttribute(AttributeSensor<T> attribute) {
        return this.sensors().get(attribute);
    }

    @Deprecated
    public <T> T getAttributeByNameParts(List<String> nameParts) {
        return (T)this.attributesInternal.getValue(nameParts);
    }

    @Deprecated
    public <T> T setAttribute(AttributeSensor<T> attribute, T val) {
        return this.sensors().set(attribute, val);
    }

    @Override
    @Deprecated
    public <T> T setAttributeWithoutPublishing(AttributeSensor<T> attribute, T val) {
        return this.sensors().setWithoutPublishing(attribute, val);
    }

    @Deprecated
    @Beta
    public <T> T modifyAttribute(AttributeSensor<T> attribute, Function<? super T, Maybe<T>> modifier) {
        return this.sensors().modify(attribute, modifier);
    }

    @Override
    @Deprecated
    public void removeAttribute(AttributeSensor<?> attribute) {
        this.sensors().remove(attribute);
    }

    @Deprecated
    public <T> T setAttribute(AttributeSensorAndConfigKey<?, T> configuredSensor) {
        T v = this.getAttribute(configuredSensor);
        if (v != null) {
            return v;
        }
        v = configuredSensor.getAsSensorValue((Entity)this);
        if (v != null) {
            return this.setAttribute(configuredSensor, v);
        }
        return null;
    }

    @Override
    @Deprecated
    public Map<AttributeSensor, Object> getAllAttributes() {
        return Collections.unmodifiableMap(this.sensors().getAll());
    }

    @Override
    @Beta
    public BasicConfigurationSupport config() {
        return this.config;
    }

    @Override
    @Beta
    public BasicSensorSupport sensors() {
        return this.sensors;
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return this.config().get(key);
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return this.config().get(key);
    }

    protected <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        T result = this.configsInternal.getConfig(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, T val) {
        return this.config().set(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, Task<T> val) {
        return this.config().set(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey.HasConfigKey<T> key, T val) {
        return this.config().set(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey.HasConfigKey<T> key, Task<T> val) {
        return (T)this.config().set(key, val);
    }

    public <T> T setConfigEvenIfOwned(ConfigKey<T> key, T val) {
        return (T)this.configsInternal.setConfig(key, val);
    }

    public <T> T setConfigEvenIfOwned(ConfigKey.HasConfigKey<T> key, T val) {
        return this.setConfigEvenIfOwned(key.getConfigKey(), val);
    }

    @Deprecated
    protected void setConfigIfValNonNull(ConfigKey key, Object val) {
        if (val != null) {
            this.config().set(key, val);
        }
    }

    @Deprecated
    protected void setConfigIfValNonNull(ConfigKey.HasConfigKey key, Object val) {
        if (val != null) {
            this.config().set(key, val);
        }
    }

    @Override
    @Beta
    public BasicSubscriptionSupport subscriptions() {
        return this.subscriptions;
    }

    @Deprecated
    public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscriptions().subscribe(producer, sensor, listener);
    }

    @Deprecated
    public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscriptions().subscribeToChildren(parent, sensor, listener);
    }

    @Deprecated
    public <T> SubscriptionHandle subscribeToMembers(Group group, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscriptions().subscribeToMembers(group, sensor, listener);
    }

    @Deprecated
    public boolean unsubscribe(Entity producer) {
        return this.subscriptions().unsubscribe(producer);
    }

    @Deprecated
    public boolean unsubscribe(Entity producer, SubscriptionHandle handle) {
        return this.subscriptions().unsubscribe(producer, handle);
    }

    @Deprecated
    protected SubscriptionTracker getSubscriptionTracker() {
        return this.subscriptions().getSubscriptionTracker();
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.getManagementSupport().getExecutionContext();
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId());
    }

    @Override
    public void init() {
        super.init();
        this.initEnrichers();
        if (Strings.isNonBlank((CharSequence)this.getConfig(DEFAULT_DISPLAY_NAME))) {
            this.setDefaultDisplayName(this.getConfig(DEFAULT_DISPLAY_NAME));
        }
        this.sensors().set(ENTITY_ID, this.getId());
        this.sensors().set(APPLICATION_ID, this.getApplicationId());
        this.sensors().set(CATALOG_ID, this.getCatalogItemId());
    }

    protected void initEnrichers() {
        this.enrichers().add(ServiceStateLogic.ServiceNotUpLogic.newEnricherForServiceUpIfNotUpIndicatorsEmpty());
        this.enrichers().add(ServiceStateLogic.newEnricherForServiceStateFromProblemsAndUp());
    }

    @Override
    @Beta
    public BasicPolicySupport policies() {
        return this.policies;
    }

    @Override
    @Beta
    public BasicEnricherSupport enrichers() {
        return this.enrichers;
    }

    @Deprecated
    public Collection<Policy> getPolicies() {
        return this.policies().asList();
    }

    @Deprecated
    public void addPolicy(Policy policy) {
        this.policies().add(policy);
    }

    @Deprecated
    public <T extends Policy> T addPolicy(PolicySpec<T> spec) {
        return this.policies().add(spec);
    }

    @Deprecated
    public <T extends Enricher> T addEnricher(EnricherSpec<T> spec) {
        return this.enrichers().add(spec);
    }

    @Deprecated
    public boolean removePolicy(Policy policy) {
        return this.policies().remove(policy);
    }

    @Deprecated
    public boolean removeAllPolicies() {
        return this.policies().removeAllPolicies();
    }

    @Deprecated
    public Collection<Enricher> getEnrichers() {
        return this.enrichers().asList();
    }

    @Deprecated
    public void addEnricher(Enricher enricher) {
        this.enrichers().add(enricher);
    }

    private <T extends EntityAdjunct> T findApparentlyEqualAndWarnIfNotSameUniqueTag(Collection<? extends T> items, T newItem) {
        T oldItem = this.findApparentlyEqual(items, newItem, true);
        if (oldItem != null) {
            String oldItemTag = oldItem.getUniqueTag();
            String newItemTag = newItem.getUniqueTag();
            if (oldItemTag != null || newItemTag != null) {
                if (Objects.equal((Object)oldItemTag, (Object)newItemTag)) {
                    return oldItem;
                }
                T tagged = oldItemTag != null ? oldItem : newItem;
                T tagless = oldItemTag != null ? newItem : oldItem;
                LOG.warn("Apparently equal items " + oldItem + " and " + newItem + "; but one has a unique tag " + tagged.getUniqueTag() + "; applying to the other");
                ((AbstractEntityAdjunct.AdjunctTagSupport)tagless.tags()).setUniqueTag(tagged.getUniqueTag());
            }
            if (this.isRebinding()) {
                LOG.warn("Adding to " + this + ", " + newItem + " appears identical to existing " + oldItem + "; will replace. Underlying addition should be modified so it is not added twice during rebind or unique tag should be used to indicate it is identical.");
                return oldItem;
            }
            LOG.warn("Adding to " + this + ", " + newItem + " appears identical to existing " + oldItem + "; may get removed on rebind. Underlying addition should be modified so it is not added twice.");
            return null;
        }
        return null;
    }

    private <T extends EntityAdjunct> T findApparentlyEqual(Collection<? extends T> itemsCopy, T newItem, boolean transferUniqueTag) {
        Class<?> beforeEntityAdjunct = newItem.getClass();
        while (beforeEntityAdjunct.getSuperclass() != null && !beforeEntityAdjunct.getSuperclass().equals(AbstractEntityAdjunct.class)) {
            beforeEntityAdjunct = beforeEntityAdjunct.getSuperclass();
        }
        String newItemTag = newItem.getUniqueTag();
        for (EntityAdjunct oldItem : itemsCopy) {
            String oldItemTag = oldItem.getUniqueTag();
            if (!(oldItemTag != null && newItemTag != null ? oldItemTag.equals(newItemTag) : oldItem.getClass().equals(newItem.getClass()) && EqualsBuilder.reflectionEquals((Object)oldItem, newItem, (boolean)false, beforeEntityAdjunct, (String[])new String[]{"transformation", "values", "timestamps", "lastAverage", "poller", "pollerStateMutex"}))) continue;
            return (T)oldItem;
        }
        return null;
    }

    @Deprecated
    public boolean removeEnricher(Enricher enricher) {
        return this.enrichers().remove(enricher);
    }

    @Deprecated
    public boolean removeAllEnrichers() {
        return this.enrichers().removeAll();
    }

    public <T extends Feed> T addFeed(T feed) {
        return this.feeds().add(feed);
    }

    @Override
    public EntityInternal.FeedSupport feeds() {
        return this.feeds;
    }

    @Override
    @Deprecated
    public EntityInternal.FeedSupport getFeedSupport() {
        return this.feeds();
    }

    @Deprecated
    public <T> void emit(Sensor<T> sensor, T val) {
        this.sensors().emit(sensor, val);
    }

    public <T> void emitInternal(Sensor<T> sensor, T val) {
        this.sensors().emitInternal(sensor, val);
    }

    @Override
    public Effector<?> getEffector(String effectorName) {
        return this.entityType.getEffector(effectorName);
    }

    public <T> Task<T> invoke(Effector<T> eff) {
        return this.invoke((Map)MutableMap.of(), eff);
    }

    public <T> Task<T> invoke(Map parameters, Effector<T> eff) {
        return this.invoke(eff, parameters);
    }

    public <T> Task<T> invoke(Effector<T> eff, Map<String, ?> parameters) {
        return EffectorUtils.invokeEffectorAsync((Entity)this, eff, parameters);
    }

    public void onManagementStarting() {
        if (this.isLegacyConstruction()) {
            this.entityType.setName(this.getEntityTypeName());
            if (this.displayNameAutoGenerated) {
                this.displayName.set(this.getEntityType().getSimpleName() + ":" + Strings.maxlen((String)this.getId(), (int)4));
            }
        }
    }

    public void onManagementStarted() {
    }

    @Deprecated
    public void onManagementBecomingMaster() {
    }

    @Deprecated
    public void onManagementNoLongerMaster() {
    }

    public void onManagementStopped() {
        if (this.getManagementContext().isRunning()) {
            BrooklynStorage storage = ((ManagementContextInternal)this.getManagementContext()).getStorage();
            storage.remove(this.getId() + "-parent");
            storage.remove(this.getId() + "-groups");
            storage.remove(this.getId() + "-children");
            storage.remove(this.getId() + "-locations");
            storage.remove(this.getId() + "-creationTime");
            storage.remove(this.getId() + "-displayName");
            storage.remove(this.getId() + "-config");
            storage.remove(this.getId() + "-attributes");
        }
    }

    public void invalidateReferences() {
        this.application = null;
    }

    @Override
    public EntityManagementSupport getManagementSupport() {
        return this.managementSupport;
    }

    @Override
    public void requestPersist() {
        this.getManagementSupport().getEntityChangeListener().onChanged();
    }

    @Override
    @Beta
    public RebindSupport<EntityMemento> getRebindSupport() {
        return new BasicEntityRebindSupport(this);
    }

    @Override
    protected void onTagsChanged() {
        super.onTagsChanged();
        this.getManagementSupport().getEntityChangeListener().onTagsChanged();
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<Entity> relations() {
        return super.relations();
    }

    static {
        BrooklynInitialization.initAll();
        DEFAULT_DISPLAY_NAME = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)BasicConfigKey.builder(String.class).name("defaultDisplayName")).description("Optional default display name to use (rather than auto-generating, if no name is explicitly supplied)")).runtimeInheritance(BasicConfigInheritance.NEVER_INHERITED)).build();
        LOCATION_ADDED = new BasicNotificationSensor<Location>(Location.class, "entity.location.added", "Location dynamically added to entity");
        LOCATION_REMOVED = new BasicNotificationSensor<Location>(Location.class, "entity.location.removed", "Location dynamically removed from entity");
        SENSOR_ADDED = new BasicNotificationSensor<Sensor>(Sensor.class, "entity.sensor.added", "Sensor dynamically added to entity");
        SENSOR_REMOVED = new BasicNotificationSensor<Sensor>(Sensor.class, "entity.sensor.removed", "Sensor dynamically removed from entity");
        EFFECTOR_ADDED = new BasicNotificationSensor<String>(String.class, "entity.effector.added", "Effector dynamically added to entity");
        EFFECTOR_REMOVED = new BasicNotificationSensor<String>(String.class, "entity.effector.removed", "Effector dynamically removed from entity");
        EFFECTOR_CHANGED = new BasicNotificationSensor<String>(String.class, "entity.effector.changed", "Effector dynamically changed on entity");
        CONFIG_KEY_ADDED = new BasicNotificationSensor<ConfigKey>(ConfigKey.class, "entity.config_key.added", "ConfigKey dynamically added to entity");
        CONFIG_KEY_REMOVED = new BasicNotificationSensor<ConfigKey>(ConfigKey.class, "entity.config_key.removed", "ConfigKey dynamically removed from entity");
        POLICY_ADDED = new BasicNotificationSensor<PolicyDescriptor>(PolicyDescriptor.class, "entity.policy.added", "Policy dynamically added to entity");
        POLICY_REMOVED = new BasicNotificationSensor<PolicyDescriptor>(PolicyDescriptor.class, "entity.policy.removed", "Policy dynamically removed from entity");
        CHILD_ADDED = new BasicNotificationSensor<Entity>(Entity.class, "entity.children.added", "Child dynamically added to entity");
        CHILD_REMOVED = new BasicNotificationSensor<Entity>(Entity.class, "entity.children.removed", "Child dynamically removed from entity");
        GROUP_ADDED = new BasicNotificationSensor<Group>(Group.class, "entity.group.added", "Group dynamically added to entity");
        GROUP_REMOVED = new BasicNotificationSensor<Group>(Group.class, "entity.group.removed", "Group dynamically removed from entity");
        ENTITY_ID = Attributes.ENTITY_ID;
        APPLICATION_ID = Attributes.APPLICATION_ID;
        CATALOG_ID = Attributes.CATALOG_ID;
        RendererHints.register(Entity.class, RendererHints.displayValue(EntityFunctions.displayName()));
        WARNED_READ_ONLY_ATTRIBUTES = Collections.synchronizedSet(MutableSet.of());
    }

    protected class BasicFeedSupport
    implements EntityInternal.FeedSupport {
        protected BasicFeedSupport() {
        }

        @Override
        public Collection<Feed> getFeeds() {
            return ImmutableList.copyOf((Collection)AbstractEntity.this.feedsInternal);
        }

        @Override
        public <T extends Feed> T add(T feed) {
            return this.addFeed(feed);
        }

        @Override
        public <T extends Feed> T addFeed(T feed) {
            Feed old = (Feed)AbstractEntity.this.findApparentlyEqualAndWarnIfNotSameUniqueTag(AbstractEntity.this.feedsInternal, feed);
            if (old != null) {
                if (old == feed) {
                    if (!BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.feedRegistration")) {
                        LOG.debug("Feed " + feed + " already added, not adding a second time.");
                    }
                    return feed;
                }
                LOG.debug("Removing " + old + " when adding " + feed + " to " + this);
                this.removeFeed(old);
            }
            CatalogUtils.setCatalogItemIdOnAddition((Entity)AbstractEntity.this, feed);
            AbstractEntity.this.feedsInternal.add(feed);
            if (!AbstractEntity.this.equals(((AbstractFeed)feed).getEntity())) {
                ((AbstractFeed)feed).setEntity(AbstractEntity.this);
            }
            AbstractEntity.this.getManagementContext().getRebindManager().getChangeListener().onManaged(feed);
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onFeedAdded(feed);
            return feed;
        }

        @Override
        public boolean remove(Feed feed) {
            return this.removeFeed(feed);
        }

        @Override
        public boolean removeFeed(Feed feed) {
            feed.stop();
            boolean changed = AbstractEntity.this.feedsInternal.remove(feed);
            if (changed) {
                AbstractEntity.this.getManagementContext().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)feed);
                AbstractEntity.this.getManagementSupport().getEntityChangeListener().onFeedRemoved(feed);
            }
            return changed;
        }

        @Override
        public boolean removeAll() {
            return this.removeAllFeeds();
        }

        @Override
        public boolean removeAllFeeds() {
            boolean changed = false;
            for (Feed feed : AbstractEntity.this.feedsInternal) {
                changed = this.removeFeed(feed) || changed;
            }
            return changed;
        }
    }

    @Beta
    public class BasicEnricherSupport
    implements EntityInternal.EnricherSupportInternal {
        public Iterator<Enricher> iterator() {
            return this.asList().iterator();
        }

        public int size() {
            return AbstractEntity.this.enrichersInternal.size();
        }

        public boolean isEmpty() {
            return AbstractEntity.this.enrichersInternal.isEmpty();
        }

        public List<Enricher> asList() {
            return ImmutableList.copyOf((Collection)AbstractEntity.this.enrichersInternal);
        }

        public <T extends Enricher> T add(EnricherSpec<T> spec) {
            Enricher enricher = AbstractEntity.this.getManagementContext().getEntityManager().createEnricher(spec);
            this.add(enricher);
            return (T)enricher;
        }

        public void add(Enricher enricher) {
            Enricher old = (Enricher)AbstractEntity.this.findApparentlyEqualAndWarnIfNotSameUniqueTag(AbstractEntity.this.enrichersInternal, (EntityAdjunct)enricher);
            if (old != null) {
                LOG.debug("Removing " + old + " when adding " + enricher + " to " + AbstractEntity.this);
                this.remove(old);
            }
            CatalogUtils.setCatalogItemIdOnAddition((Entity)AbstractEntity.this, (BrooklynObject)enricher);
            AbstractEntity.this.enrichersInternal.add((AbstractEnricher)enricher);
            ((AbstractEnricher)enricher).setEntity(AbstractEntity.this);
            ConfigConstraints.assertValid((EntityAdjunct)enricher);
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onEnricherAdded(enricher);
        }

        public boolean remove(Enricher enricher) {
            ((AbstractEnricher)enricher).destroy();
            boolean changed = AbstractEntity.this.enrichersInternal.remove(enricher);
            if (changed) {
                AbstractEntity.this.getManagementSupport().getEntityChangeListener().onEnricherRemoved(enricher);
            }
            return changed;
        }

        @Override
        public boolean removeAll() {
            boolean changed = false;
            for (AbstractEnricher enricher : AbstractEntity.this.enrichersInternal) {
                changed = this.remove(enricher) || changed;
            }
            return changed;
        }
    }

    @Beta
    public class BasicPolicySupport
    implements EntityInternal.PolicySupportInternal {
        public Iterator<Policy> iterator() {
            return this.asList().iterator();
        }

        public int size() {
            return AbstractEntity.this.policiesInternal.size();
        }

        public boolean isEmpty() {
            return AbstractEntity.this.policiesInternal.isEmpty();
        }

        public List<Policy> asList() {
            return ImmutableList.copyOf((Collection)AbstractEntity.this.policiesInternal);
        }

        public void add(Policy policy) {
            Policy old = (Policy)AbstractEntity.this.findApparentlyEqualAndWarnIfNotSameUniqueTag(AbstractEntity.this.policiesInternal, (EntityAdjunct)policy);
            if (old != null) {
                LOG.debug("Removing " + old + " when adding " + policy + " to " + AbstractEntity.this);
                this.remove(old);
            }
            CatalogUtils.setCatalogItemIdOnAddition((Entity)AbstractEntity.this, (BrooklynObject)policy);
            AbstractEntity.this.policiesInternal.add((AbstractPolicy)policy);
            ((AbstractPolicy)policy).setEntity(AbstractEntity.this);
            ConfigConstraints.assertValid((EntityAdjunct)policy);
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onPolicyAdded(policy);
            AbstractEntity.this.sensors().emit(POLICY_ADDED, new PolicyDescriptor(policy));
        }

        public <T extends Policy> T add(PolicySpec<T> spec) {
            Policy policy = AbstractEntity.this.getManagementContext().getEntityManager().createPolicy(spec);
            this.add(policy);
            return (T)policy;
        }

        public boolean remove(Policy policy) {
            ((AbstractPolicy)policy).destroy();
            boolean changed = AbstractEntity.this.policiesInternal.remove(policy);
            if (changed) {
                AbstractEntity.this.getManagementSupport().getEntityChangeListener().onPolicyRemoved(policy);
                AbstractEntity.this.sensors().emit(POLICY_REMOVED, new PolicyDescriptor(policy));
            }
            return changed;
        }

        @Override
        public boolean removeAllPolicies() {
            boolean changed = false;
            for (Policy policy : AbstractEntity.this.policiesInternal) {
                this.remove(policy);
                changed = true;
            }
            return changed;
        }
    }

    @Beta
    public class BasicSubscriptionSupport
    implements EntityInternal.EntitySubscriptionSupportInternal {
        public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribe(producer, sensor, listener);
        }

        public <T> SubscriptionHandle subscribe(Map<String, ?> flags, Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribe(flags, producer, sensor, listener);
        }

        public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribeToChildren(parent, sensor, listener);
        }

        public <T> SubscriptionHandle subscribeToMembers(Group group, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            return this.getSubscriptionTracker().subscribeToMembers(group, sensor, listener);
        }

        public boolean unsubscribe(Entity producer) {
            return this.getSubscriptionTracker().unsubscribe(producer);
        }

        public boolean unsubscribe(Entity producer, SubscriptionHandle handle) {
            return this.getSubscriptionTracker().unsubscribe(producer, handle);
        }

        public boolean unsubscribe(SubscriptionHandle handle) {
            return this.getSubscriptionTracker().unsubscribe(handle);
        }

        @Override
        public void unsubscribeAll() {
            this.getSubscriptionTracker().unsubscribeAll();
        }

        @Override
        public SubscriptionContext getSubscriptionContext() {
            return AbstractEntity.this.getManagementSupport().getSubscriptionContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SubscriptionTracker getSubscriptionTracker() {
            if (AbstractEntity.this._subscriptionTracker != null) {
                return AbstractEntity.this._subscriptionTracker;
            }
            SubscriptionContext subscriptionContext = this.getSubscriptionContext();
            AbstractEntity abstractEntity = AbstractEntity.this;
            synchronized (abstractEntity) {
                if (AbstractEntity.this._subscriptionTracker == null) {
                    AbstractEntity.this._subscriptionTracker = new SubscriptionTracker(subscriptionContext);
                }
                return AbstractEntity.this._subscriptionTracker;
            }
        }
    }

    @Beta
    public class BasicConfigurationSupport
    extends AbstractConfigurationSupportInternal {
        @Override
        protected <T> void assertValid(ConfigKey<T> key, T val) {
            ConfigConstraints.assertValid((Entity)AbstractEntity.this, key, val);
        }

        protected AbstractConfigMapImpl<?> getConfigsInternal() {
            return AbstractEntity.this.configsInternal;
        }

        @Override
        public void refreshInheritedConfig() {
            this.refreshInheritedConfigOfChildren();
        }

        @Override
        public void refreshInheritedConfigOfChildren() {
            for (Entity it : AbstractEntity.this.getChildren()) {
                ((EntityInternal)it).config().refreshInheritedConfig();
            }
        }

        @Override
        protected <T> void onConfigChanging(ConfigKey<T> key, Object val) {
            if (!AbstractEntity.this.inConstruction && AbstractEntity.this.getManagementSupport().isDeployed()) {
                LOG.debug("configuration being made to {} after deployment: {} = {}; change may not be visible in other contexts", new Object[]{this.getContainer(), key, val});
            }
        }

        @Override
        protected <T> void onConfigChanged(ConfigKey<T> key, Object val) {
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onConfigChanged(key);
        }

        @Override
        protected BrooklynObject getContainer() {
            return AbstractEntity.this;
        }

        @Override
        protected ExecutionContext getContext() {
            return AbstractEntity.this.getExecutionContext();
        }
    }

    @Beta
    public class BasicSensorSupport
    implements EntityInternal.SensorSupportInternal {
        public <T> T get(AttributeSensor<T> attribute) {
            return AbstractEntity.this.attributesInternal.getValue(attribute);
        }

        public <T> T set(AttributeSensor<T> attribute, T val) {
            T result;
            T oldVal;
            if (LOG.isTraceEnabled()) {
                LOG.trace("" + AbstractEntity.this + " setAttribute " + attribute + " " + val);
            }
            if (Boolean.TRUE.equals(AbstractEntity.this.getManagementSupport().isReadOnlyRaw()) && !Equals.approximately(val, oldVal = AbstractEntity.this.getAttribute(attribute))) {
                String message = AbstractEntity.this + " setting " + attribute + " = " + val + " (was " + oldVal + ") in read only mode; will have very little effect";
                if (!AbstractEntity.this.getManagementSupport().isDeployed()) {
                    message = AbstractEntity.this.getManagementSupport().wasDeployed() ? message + " (no longer deployed)" : message + " (not yet deployed)";
                }
                if (WARNED_READ_ONLY_ATTRIBUTES.add(attribute.getName())) {
                    LOG.warn(message + " (future messages for this sensor logged at trace)");
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace(message);
                }
            }
            if ((result = AbstractEntity.this.attributesInternal.update(attribute, val)) == null) {
                AbstractEntity.this.entityType.addSensorIfAbsent((Sensor<?>)attribute);
            }
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onAttributeChanged(attribute);
            return result;
        }

        @Override
        public <T> T setWithoutPublishing(AttributeSensor<T> attribute, T val) {
            T result;
            if (LOG.isTraceEnabled()) {
                LOG.trace("" + AbstractEntity.this + " setAttributeWithoutPublishing " + attribute + " " + val);
            }
            if ((result = AbstractEntity.this.attributesInternal.updateWithoutPublishing(attribute, val)) == null) {
                AbstractEntity.this.entityType.addSensorIfAbsentWithoutPublishing((Sensor<?>)attribute);
            }
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onAttributeChanged(attribute);
            return result;
        }

        @Beta
        public <T> T modify(AttributeSensor<T> attribute, Function<? super T, Maybe<T>> modifier) {
            T result;
            if (LOG.isTraceEnabled()) {
                LOG.trace("" + AbstractEntity.this + " modifyAttribute " + attribute + " " + modifier);
            }
            if (Boolean.TRUE.equals(AbstractEntity.this.getManagementSupport().isReadOnlyRaw())) {
                String message = AbstractEntity.this + " modifying " + attribute + " = " + modifier + " in read only mode; will have very little effect";
                if (!AbstractEntity.this.getManagementSupport().isDeployed()) {
                    message = AbstractEntity.this.getManagementSupport().wasDeployed() ? message + " (no longer deployed)" : message + " (not yet deployed)";
                }
                if (WARNED_READ_ONLY_ATTRIBUTES.add(attribute.getName())) {
                    LOG.warn(message + " (future messages for this sensor logged at trace)");
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace(message);
                }
            }
            if ((result = AbstractEntity.this.attributesInternal.modify(attribute, modifier)) == null) {
                AbstractEntity.this.entityType.addSensorIfAbsent((Sensor<?>)attribute);
            }
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onAttributeChanged(attribute);
            return result;
        }

        @Override
        public void remove(AttributeSensor<?> attribute) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("" + AbstractEntity.this + " removeAttribute " + attribute);
            }
            AbstractEntity.this.attributesInternal.remove(attribute);
            AbstractEntity.this.entityType.removeSensor((Sensor<?>)attribute);
        }

        @Override
        public Map<AttributeSensor<?>, Object> getAll() {
            LinkedHashMap result = Maps.newLinkedHashMap();
            Map<String, Object> attribs = AbstractEntity.this.attributesInternal.asMap();
            for (Map.Entry<String, Object> entry : attribs.entrySet()) {
                AttributeSensor<Object> attribKey = (AttributeSensor<Object>)AbstractEntity.this.entityType.getSensor(entry.getKey());
                if (attribKey == null) {
                    LOG.warn("When retrieving all attributes of {}, no AttributeSensor for attribute {} (creating synthetic)", (Object)AbstractEntity.this, (Object)entry.getKey());
                    attribKey = Sensors.newSensor(Object.class, entry.getKey());
                }
                result.put(attribKey, entry.getValue());
            }
            return result;
        }

        public <T> void emit(Sensor<T> sensor, T val) {
            if (sensor instanceof AttributeSensor) {
                LOG.warn("Strongly discouraged use of emit with attribute sensor " + sensor + " " + val + "; use setAttribute instead!", new Throwable("location of discouraged attribute " + sensor + " emit"));
            }
            if (val instanceof SensorEvent) {
                LOG.warn("Strongly discouraged use of emit with sensor event as value " + sensor + " " + val + "; value should be unpacked!", new Throwable("location of discouraged event " + sensor + " emit"));
            }
            BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly((Entity)AbstractEntity.this), "Emitting sensor notification {} value {} on {}", sensor.getName(), val, AbstractEntity.this);
            this.emitInternal(sensor, val);
        }

        public <T> void emitInternal(Sensor<T> sensor, T val) {
            if (AbstractEntity.this.getManagementSupport().isNoLongerManaged()) {
                throw new IllegalStateException("Entity " + AbstractEntity.this + " is no longer managed, when trying to publish " + sensor + " " + val);
            }
            SubscriptionContext subsContext = AbstractEntity.this.subscriptions().getSubscriptionContext();
            if (subsContext != null) {
                subsContext.publish(sensor.newEvent(AbstractEntity.this.getProxyIfAvailable(), val));
            }
        }
    }

    @Beta
    public class BasicGroupSupport
    implements EntityInternal.GroupSupportInternal {
        public Iterator<Group> iterator() {
            return this.asList().iterator();
        }

        public int size() {
            return this.asList().size();
        }

        public boolean isEmpty() {
            return this.asList().isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<Group> asList() {
            Set set = AbstractEntity.this.groupsInternal;
            synchronized (set) {
                return ImmutableList.copyOf((Collection)AbstractEntity.this.groupsInternal);
            }
        }

        @Override
        public void add(Group group) {
            boolean changed = AbstractEntity.this.groupsInternal.add(group);
            AbstractEntity.this.getApplication();
            if (changed) {
                AbstractEntity.this.sensors().emit(GROUP_ADDED, group);
            }
        }

        @Override
        public void remove(Group group) {
            boolean changed = AbstractEntity.this.groupsInternal.remove(group);
            AbstractEntity.this.getApplication();
            if (changed) {
                AbstractEntity.this.sensors().emit(GROUP_REMOVED, group);
            }
        }
    }
}

