/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.BasicParameterType;
import org.apache.brooklyn.core.effector.EffectorAndBody;
import org.apache.brooklyn.core.effector.EffectorBase;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.EffectorWithBody;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Effectors {
    private static final Logger log = LoggerFactory.getLogger(Effectors.class);

    public static <T> EffectorBuilder<T> effector(Class<T> returnType, String effectorName) {
        return new EffectorBuilder(returnType, effectorName);
    }

    public static <T> EffectorBuilder<T> effector(Effector<T> base) {
        EffectorBuilder builder = new EffectorBuilder(base.getReturnType(), base.getName());
        for (ParameterType p : base.getParameters()) {
            builder.parameter(p);
        }
        builder.description(base.getDescription());
        if (base instanceof EffectorWithBody) {
            builder.impl(((EffectorWithBody)base).getBody());
        }
        return builder;
    }

    public static <T> TaskAdaptable<T> invocation(Entity entity, Effector<T> eff, ConfigBag parameters) {
        return Effectors.invocation(entity, eff, parameters == null ? ImmutableMap.of() : parameters.getAllConfig());
    }

    public static <T> TaskAdaptable<T> invocation(Entity entity, Effector<T> eff, @Nullable Map<?, ?> parameters) {
        Effector<?> eff2 = ((EntityInternal)entity).getEffector(eff.getName());
        if (log.isTraceEnabled()) {
            String eff1Body = eff instanceof EffectorWithBody ? ((EffectorWithBody)eff).getBody() : "bodyless";
            String message = String.format("Invoking %s/%s on entity %s", eff, eff1Body, entity);
            if (eff != eff2) {
                String eff2Body = eff2 instanceof EffectorWithBody ? ((EffectorWithBody)eff2).getBody() : "bodyless";
                message = message + String.format(" (actually %s/%s)", eff2, eff2Body);
            }
            log.trace(message);
        }
        if (eff2 != null) {
            if (eff2 != eff) {
                if (eff2 instanceof EffectorWithBody) {
                    log.debug("Replacing invocation of {} on {} with {} which is the impl defined at that entity", new Object[]{eff, entity, eff2});
                    return ((EffectorWithBody)eff2).getBody().newTask(entity, eff2, ConfigBag.newInstance().putAll(parameters));
                }
                log.warn("Effector {} defined on {} has no body; invoking caller-supplied {} instead", new Object[]{eff2, entity, eff});
            }
        } else {
            log.debug("Effector {} does not exist on {}; attempting to invoke anyway", new Object[]{eff, entity});
        }
        if (eff instanceof EffectorWithBody) {
            return ((EffectorWithBody)eff).getBody().newTask(entity, eff, ConfigBag.newInstance().putAll(parameters));
        }
        throw new UnsupportedOperationException("No implementation registered for effector " + eff + " on " + entity);
    }

    public static <V> ParameterType<V> asParameterType(ConfigKey<V> key) {
        return key.hasDefaultValue() ? new BasicParameterType<Object>(key.getName(), key.getType(), key.getDescription(), key.getDefaultValue()) : new BasicParameterType(key.getName(), key.getType(), key.getDescription());
    }

    public static <V> ConfigKey<V> asConfigKey(ParameterType<V> paramType) {
        return ConfigKeys.newConfigKey(paramType.getParameterClass(), paramType.getName(), paramType.getDescription(), paramType.getDefaultValue());
    }

    public static TaskAdaptable<List<?>> invocation(Effector<?> eff, Map<?, ?> params, Iterable<? extends Entity> entities) {
        return Effectors.invocationParallel(eff, params, entities);
    }

    public static TaskAdaptable<List<?>> invocationParallel(Effector<?> eff, Map<?, ?> params, Iterable<? extends Entity> entities) {
        ArrayList tasks = new ArrayList();
        for (Entity entity : entities) {
            tasks.add(Effectors.invocation(entity, eff, params));
        }
        return Tasks.parallel("invoking " + eff + " on " + tasks.size() + " node" + Strings.s((int)tasks.size()), tasks.toArray(new TaskAdaptable[tasks.size()]));
    }

    public static TaskAdaptable<List<?>> invocationSequential(Effector<?> eff, Map<?, ?> params, Iterable<? extends Entity> entities) {
        ArrayList tasks = new ArrayList();
        for (Entity entity : entities) {
            tasks.add(Effectors.invocation(entity, eff, params));
        }
        return Tasks.sequential("invoking " + eff + " on " + tasks.size() + " node" + Strings.s((int)tasks.size()), tasks.toArray(new TaskAdaptable[tasks.size()]));
    }

    public static TaskAdaptable<List<?>> invocation(Effector<?> eff, MutableMap<?, ?> params, Entity ... entities) {
        return Effectors.invocation(eff, params, Arrays.asList(entities));
    }

    public static boolean sameSignature(Effector<?> e1, Effector<?> e2) {
        return Objects.equal((Object)e1.getName(), (Object)e2.getName()) && Objects.equal((Object)e1.getParameters(), (Object)e2.getParameters()) && Objects.equal((Object)e1.getReturnType(), (Object)e2.getReturnType());
    }

    public static boolean sameInstance(Effector<?> e1, Effector<?> e2) {
        return e1 == e2;
    }

    public static class EffectorBuilder<T> {
        private Class<T> returnType;
        private String effectorName;
        private String description;
        private Map<String, ParameterType<?>> parameters = new LinkedHashMap();
        private EffectorTasks.EffectorTaskFactory<T> impl;

        private EffectorBuilder(Class<T> returnType, String effectorName) {
            this.returnType = returnType;
            this.effectorName = effectorName;
        }

        public EffectorBuilder<T> name(String name) {
            this.effectorName = name;
            return this;
        }

        public EffectorBuilder<T> description(String description) {
            this.description = description;
            return this;
        }

        public EffectorBuilder<T> parameter(Class<?> paramType, String paramName) {
            return this.parameter(paramType, paramName, null, null);
        }

        public EffectorBuilder<T> parameter(Class<?> paramType, String paramName, String paramDescription) {
            return this.parameter(paramType, paramName, paramDescription, null);
        }

        public <V> EffectorBuilder<T> parameter(Class<V> paramType, String paramName, String paramDescription, V defaultValue) {
            return this.parameter(new BasicParameterType<V>(paramName, paramType, paramDescription, defaultValue));
        }

        public <V> EffectorBuilder<T> parameter(ConfigKey<V> key) {
            return this.parameter(Effectors.asParameterType(key));
        }

        public EffectorBuilder<T> parameter(ParameterType<?> p) {
            this.parameters.put(p.getName(), p);
            return this;
        }

        public EffectorBuilder<T> impl(EffectorTasks.EffectorTaskFactory<T> taskFactory) {
            this.impl = new EffectorTasks.EffectorMarkingTaskFactory<T>(taskFactory);
            return this;
        }

        public EffectorBuilder<T> impl(EffectorBody<T> effectorBody) {
            this.impl = new EffectorTasks.EffectorBodyTaskFactory<T>(effectorBody);
            return this;
        }

        public Effector<T> build() {
            Preconditions.checkNotNull(this.impl, (String)"Cannot create effector %s with no impl (did you forget impl? or did you mean to buildAbstract?)", (Object[])new Object[]{this.effectorName});
            return new EffectorAndBody<T>(this.effectorName, this.returnType, (List<ParameterType<?>>)ImmutableList.copyOf(this.parameters.values()), this.description, this.impl);
        }

        public Effector<T> buildAbstract() {
            Preconditions.checkArgument((this.impl == null ? 1 : 0) != 0, (String)"Cannot create abstract effector {} as an impl is defined", (Object[])new Object[]{this.effectorName});
            return new EffectorBase<T>(this.effectorName, this.returnType, (List<ParameterType<?>>)ImmutableList.copyOf(this.parameters.values()), this.description);
        }
    }
}

