/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineInstance;
import org.jclouds.azurecompute.arm.domain.Status;
import org.jclouds.azurecompute.arm.domain.VirtualMachineProperties;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.util.Predicates2;

public abstract class VirtualMachineInstance {
    public static final String PROVISIONING_STATE_PREFIX = "ProvisioningState/";
    public static final String POWER_STATE_PREFIX = "PowerState/";

    @Nullable
    public abstract String platformUpdateDomain();

    @Nullable
    public abstract String platformFaultDomain();

    @Nullable
    public abstract List<Status> statuses();

    public VirtualMachineProperties.ProvisioningState provisioningState() {
        return VirtualMachineProperties.ProvisioningState.fromValue(this.firstStatus(PROVISIONING_STATE_PREFIX));
    }

    public PowerState powerState() {
        return PowerState.fromValue(this.firstStatus(POWER_STATE_PREFIX));
    }

    private String firstStatus(final String type) {
        return (String)Iterables.getFirst((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform(this.statuses(), (Function)new Function<Status, String>(){

            public String apply(Status input) {
                return input.code();
            }
        }), (Predicate)Predicates2.startsWith((String)type)), (Function)new Function<String, String>(){

            public String apply(String input) {
                return input.substring(type.length());
            }
        }), null);
    }

    @SerializedNames(value={"platformUpdateDomain", "platformFaultDomain", "statuses"})
    public static VirtualMachineInstance create(String platformUpdateDomain, String platformFaultDomain, List<Status> statuses) {
        return new AutoValue_VirtualMachineInstance(platformUpdateDomain, platformFaultDomain, (List<Status>)(statuses == null ? null : ImmutableList.copyOf(statuses)));
    }

    public static enum PowerState {
        RUNNING,
        STOPPED,
        UNRECOGNIZED;


        public static PowerState fromValue(String text) {
            return (PowerState)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }
}

