/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import org.jclouds.azurecompute.arm.domain.NetworkSecurityRuleProperties;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_NetworkSecurityRuleProperties
extends NetworkSecurityRuleProperties {
    private final String description;
    private final NetworkSecurityRuleProperties.Protocol protocol;
    private final String sourcePortRange;
    private final String destinationPortRange;
    private final String sourceAddressPrefix;
    private final String destinationAddressPrefix;
    private final NetworkSecurityRuleProperties.Access access;
    private final Integer priority;
    private final NetworkSecurityRuleProperties.Direction direction;

    private AutoValue_NetworkSecurityRuleProperties(@Nullable String description, NetworkSecurityRuleProperties.Protocol protocol, @Nullable String sourcePortRange, @Nullable String destinationPortRange, String sourceAddressPrefix, String destinationAddressPrefix, NetworkSecurityRuleProperties.Access access, @Nullable Integer priority, NetworkSecurityRuleProperties.Direction direction) {
        this.description = description;
        if (protocol == null) {
            throw new NullPointerException("Null protocol");
        }
        this.protocol = protocol;
        this.sourcePortRange = sourcePortRange;
        this.destinationPortRange = destinationPortRange;
        if (sourceAddressPrefix == null) {
            throw new NullPointerException("Null sourceAddressPrefix");
        }
        this.sourceAddressPrefix = sourceAddressPrefix;
        if (destinationAddressPrefix == null) {
            throw new NullPointerException("Null destinationAddressPrefix");
        }
        this.destinationAddressPrefix = destinationAddressPrefix;
        if (access == null) {
            throw new NullPointerException("Null access");
        }
        this.access = access;
        this.priority = priority;
        if (direction == null) {
            throw new NullPointerException("Null direction");
        }
        this.direction = direction;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    public NetworkSecurityRuleProperties.Protocol protocol() {
        return this.protocol;
    }

    @Override
    @Nullable
    public String sourcePortRange() {
        return this.sourcePortRange;
    }

    @Override
    @Nullable
    public String destinationPortRange() {
        return this.destinationPortRange;
    }

    @Override
    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    @Override
    public String destinationAddressPrefix() {
        return this.destinationAddressPrefix;
    }

    @Override
    public NetworkSecurityRuleProperties.Access access() {
        return this.access;
    }

    @Override
    @Nullable
    public Integer priority() {
        return this.priority;
    }

    @Override
    public NetworkSecurityRuleProperties.Direction direction() {
        return this.direction;
    }

    public String toString() {
        return "NetworkSecurityRuleProperties{description=" + this.description + ", " + "protocol=" + (Object)((Object)this.protocol) + ", " + "sourcePortRange=" + this.sourcePortRange + ", " + "destinationPortRange=" + this.destinationPortRange + ", " + "sourceAddressPrefix=" + this.sourceAddressPrefix + ", " + "destinationAddressPrefix=" + this.destinationAddressPrefix + ", " + "access=" + (Object)((Object)this.access) + ", " + "priority=" + this.priority + ", " + "direction=" + (Object)((Object)this.direction) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkSecurityRuleProperties) {
            NetworkSecurityRuleProperties that = (NetworkSecurityRuleProperties)o;
            return (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.protocol.equals((Object)that.protocol()) && (this.sourcePortRange == null ? that.sourcePortRange() == null : this.sourcePortRange.equals(that.sourcePortRange())) && (this.destinationPortRange == null ? that.destinationPortRange() == null : this.destinationPortRange.equals(that.destinationPortRange())) && this.sourceAddressPrefix.equals(that.sourceAddressPrefix()) && this.destinationAddressPrefix.equals(that.destinationAddressPrefix()) && this.access.equals((Object)that.access()) && (this.priority == null ? that.priority() == null : this.priority.equals(that.priority())) && this.direction.equals((Object)that.direction());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.protocol.hashCode();
        h *= 1000003;
        h ^= this.sourcePortRange == null ? 0 : this.sourcePortRange.hashCode();
        h *= 1000003;
        h ^= this.destinationPortRange == null ? 0 : this.destinationPortRange.hashCode();
        h *= 1000003;
        h ^= this.sourceAddressPrefix.hashCode();
        h *= 1000003;
        h ^= this.destinationAddressPrefix.hashCode();
        h *= 1000003;
        h ^= this.access.hashCode();
        h *= 1000003;
        h ^= this.priority == null ? 0 : this.priority.hashCode();
        h *= 1000003;
        return h ^= this.direction.hashCode();
    }

    @Override
    public NetworkSecurityRuleProperties.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends NetworkSecurityRuleProperties.Builder {
        private String description;
        private NetworkSecurityRuleProperties.Protocol protocol;
        private String sourcePortRange;
        private String destinationPortRange;
        private String sourceAddressPrefix;
        private String destinationAddressPrefix;
        private NetworkSecurityRuleProperties.Access access;
        private Integer priority;
        private NetworkSecurityRuleProperties.Direction direction;

        Builder() {
        }

        Builder(NetworkSecurityRuleProperties source) {
            this.description = source.description();
            this.protocol = source.protocol();
            this.sourcePortRange = source.sourcePortRange();
            this.destinationPortRange = source.destinationPortRange();
            this.sourceAddressPrefix = source.sourceAddressPrefix();
            this.destinationAddressPrefix = source.destinationAddressPrefix();
            this.access = source.access();
            this.priority = source.priority();
            this.direction = source.direction();
        }

        @Override
        public NetworkSecurityRuleProperties.Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder protocol(NetworkSecurityRuleProperties.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder sourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder destinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder sourceAddressPrefix(String sourceAddressPrefix) {
            this.sourceAddressPrefix = sourceAddressPrefix;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder destinationAddressPrefix(String destinationAddressPrefix) {
            this.destinationAddressPrefix = destinationAddressPrefix;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder access(NetworkSecurityRuleProperties.Access access) {
            this.access = access;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties.Builder direction(NetworkSecurityRuleProperties.Direction direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public NetworkSecurityRuleProperties build() {
            String missing = "";
            if (this.protocol == null) {
                missing = missing + " protocol";
            }
            if (this.sourceAddressPrefix == null) {
                missing = missing + " sourceAddressPrefix";
            }
            if (this.destinationAddressPrefix == null) {
                missing = missing + " destinationAddressPrefix";
            }
            if (this.access == null) {
                missing = missing + " access";
            }
            if (this.direction == null) {
                missing = missing + " direction";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_NetworkSecurityRuleProperties(this.description, this.protocol, this.sourcePortRange, this.destinationPortRange, this.sourceAddressPrefix, this.destinationAddressPrefix, this.access, this.priority, this.direction);
        }
    }
}

