/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServiceModel;
import org.ops4j.pax.web.service.whiteboard.ErrorPageMapping;
import org.ops4j.pax.web.service.whiteboard.ServletMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardElement;
import org.ops4j.pax.web.service.whiteboard.WhiteboardErrorPage;
import org.ops4j.pax.web.service.whiteboard.WhiteboardFilter;
import org.ops4j.pax.web.service.whiteboard.WhiteboardHttpContext;
import org.ops4j.pax.web.service.whiteboard.WhiteboardJspMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardListener;
import org.ops4j.pax.web.service.whiteboard.WhiteboardResource;
import org.ops4j.pax.web.service.whiteboard.WhiteboardServlet;
import org.ops4j.pax.web.service.whiteboard.WhiteboardWelcomeFile;
import org.osgi.dto.DTO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;

@Component(immediate=true, service={WhiteboardDtoService.class})
public class WhiteboardDtoService {
    private volatile Map<ServiceReference<ServletContext>, ServletContext> servletContexts = new ConcurrentHashMap<ServiceReference<ServletContext>, ServletContext>(5);
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private boolean compareContextroot(ServletContext servletContext, String httpServicePath) {
        String servletContextPath = servletContext.getContextPath();
        if (servletContextPath == null || servletContextPath.trim().length() == 0) {
            servletContextPath = "/";
        }
        if (httpServicePath == null || httpServicePath.trim().length() == 0) {
            httpServicePath = "/";
        } else if (!httpServicePath.startsWith("/")) {
            httpServicePath = "/" + httpServicePath;
        }
        return servletContextPath.equals(httpServicePath);
    }

    RuntimeDTO createWhiteboardRuntimeDTO(Iterator<WhiteboardElement> iterator, ServerModel serverModel, ServiceModel serviceModel) {
        RuntimeDTO runtimeDto = new RuntimeDTO();
        ArrayList servletContextDTOs = new ArrayList();
        ArrayList failedServletContextDTOs = new ArrayList();
        ArrayList servletDTOs = new ArrayList();
        ArrayList failedServletDTOs = new ArrayList();
        ArrayList filterDTOs = new ArrayList();
        ArrayList failedFilterDTOs = new ArrayList();
        ArrayList errorPageDTOs = new ArrayList();
        ArrayList failedErrorPageDTOs = new ArrayList();
        ArrayList listenerDTOs = new ArrayList();
        ArrayList failedListenerDTOs = new ArrayList();
        ArrayList resourceDTOs = new ArrayList();
        ArrayList failedResourceDTOs = new ArrayList();
        iterator.forEachRemaining(element -> {
            if (element instanceof WhiteboardHttpContext) {
                WhiteboardHttpContext whiteboardHttpContext = (WhiteboardHttpContext)element;
                Optional<Map.Entry> matchingServletContextEntry = this.servletContexts.entrySet().stream().filter(entry -> this.compareContextroot((ServletContext)entry.getValue(), whiteboardHttpContext.getHttpContextMapping().getPath())).findFirst();
                if (!whiteboardHttpContext.isValid()) {
                    FailedServletContextDTO dto = new FailedServletContextDTO();
                    dto.failureReason = 6;
                    dto.serviceId = whiteboardHttpContext.getServiceID();
                    dto.contextPath = whiteboardHttpContext.getHttpContextMapping().getPath();
                    failedServletContextDTOs.add(dto);
                } else if (!matchingServletContextEntry.isPresent()) {
                    FailedServletContextDTO dto = new FailedServletContextDTO();
                    dto.failureReason = 4;
                    dto.serviceId = whiteboardHttpContext.getServiceID();
                    dto.contextPath = whiteboardHttpContext.getHttpContextMapping().getPath();
                    failedServletContextDTOs.add(dto);
                } else {
                    servletContextDTOs.add(this.mapServletContext(matchingServletContextEntry.get()));
                }
            } else if (element instanceof WhiteboardServlet && (((WhiteboardServlet)element).getErrorPageMappings() == null || ((WhiteboardServlet)element).getErrorPageMappings().isEmpty())) {
                this.mapServlet((WhiteboardServlet)element, servletDTOs, failedServletDTOs);
            } else if (element instanceof WhiteboardServlet && ((WhiteboardServlet)element).getErrorPageMappings() != null && !((WhiteboardServlet)element).getErrorPageMappings().isEmpty()) {
                this.mapErrorPage((WhiteboardServlet)element, errorPageDTOs, failedErrorPageDTOs);
            } else if (element instanceof WhiteboardFilter) {
                this.mapFilter((WhiteboardFilter)element, filterDTOs, failedFilterDTOs);
            } else if (element instanceof WhiteboardListener) {
                this.mapListener((WhiteboardListener)element, listenerDTOs, failedListenerDTOs);
            } else if (element instanceof WhiteboardResource) {
                this.mapResource((WhiteboardResource)element, resourceDTOs, failedResourceDTOs);
            } else if (!(element instanceof WhiteboardWelcomeFile)) {
                if (element instanceof WhiteboardErrorPage) {
                    if (element.isValid()) {
                        errorPageDTOs.add(this.mapServlet((WhiteboardErrorPage)element));
                    } else {
                        failedErrorPageDTOs.add(this.transformToDTOFailed((WhiteboardErrorPage)element));
                    }
                } else if (element instanceof WhiteboardJspMapping && !element.isValid()) {
                    failedServletDTOs.add(this.transformToDTOFailed((WhiteboardJspMapping)element));
                }
            }
        });
        if (!servletContextDTOs.stream().anyMatch(servletContextDTO -> "/".equals(servletContextDTO.contextPath))) {
            servletContextDTOs.addAll(this.servletContexts.entrySet().stream().filter(entry -> WebContainerContext.DefaultContextIds.DEFAULT.getValue().equals(((ServletContext)entry.getValue()).getServletContextName()) || WebContainerContext.DefaultContextIds.SHARED.getValue().equals(((ServletContext)entry.getValue()).getServletContextName())).map(this::mapServletContext).collect(Collectors.toList()));
        }
        runtimeDto.servletContextDTOs = servletContextDTOs.toArray(new ServletContextDTO[servletContextDTOs.size()]);
        runtimeDto.failedServletContextDTOs = failedServletContextDTOs.toArray(new FailedServletContextDTO[servletContextDTOs.size()]);
        Arrays.stream(runtimeDto.servletContextDTOs).forEach(servletContextDTO -> {
            servletContextDTO.servletDTOs = (ServletDTO[])servletDTOs.stream().filter(servletDTO -> servletDTO.servletContextId == servletContextDTO.serviceId).toArray(ServletDTO[]::new);
            servletContextDTO.filterDTOs = (FilterDTO[])filterDTOs.stream().filter(filterDTO -> filterDTO.servletContextId == servletContextDTO.serviceId).toArray(FilterDTO[]::new);
            servletContextDTO.errorPageDTOs = (ErrorPageDTO[])errorPageDTOs.stream().filter(errorPageDTO -> errorPageDTO.servletContextId == servletContextDTO.serviceId).toArray(ErrorPageDTO[]::new);
            servletContextDTO.listenerDTOs = (ListenerDTO[])listenerDTOs.stream().filter(listenerDTO -> listenerDTO.servletContextId == servletContextDTO.serviceId).toArray(ListenerDTO[]::new);
            servletContextDTO.resourceDTOs = (ResourceDTO[])resourceDTOs.stream().filter(resourceDTO -> resourceDTO.servletContextId == servletContextDTO.serviceId).toArray(ResourceDTO[]::new);
        });
        runtimeDto.failedServletContextDTOs = (FailedServletContextDTO[])failedServletContextDTOs.stream().toArray(FailedServletContextDTO[]::new);
        runtimeDto.failedServletDTOs = (FailedServletDTO[])failedServletDTOs.stream().toArray(FailedServletDTO[]::new);
        runtimeDto.failedFilterDTOs = (FailedFilterDTO[])failedFilterDTOs.stream().toArray(FailedFilterDTO[]::new);
        runtimeDto.failedErrorPageDTOs = (FailedErrorPageDTO[])failedErrorPageDTOs.stream().toArray(FailedErrorPageDTO[]::new);
        runtimeDto.failedListenerDTOs = (FailedListenerDTO[])failedListenerDTOs.stream().toArray(FailedListenerDTO[]::new);
        runtimeDto.failedResourceDTOs = (FailedResourceDTO[])failedResourceDTOs.stream().toArray(FailedResourceDTO[]::new);
        return runtimeDto;
    }

    RequestInfoDTO calculateRequestInfoDTO(String path, Iterator<WhiteboardElement> iterator, ServerModel serverModel, ServiceModel serviceModel) {
        RequestInfoDTO dto = new RequestInfoDTO();
        dto.path = path;
        ContextModel contextModel = serverModel.matchPathToContext(path);
        if (contextModel != null) {
            Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> matchingServletContextEntry = this.findMatchingServletContext(contextModel.getHttpContext().getContextId());
            if (matchingServletContextEntry.isPresent()) {
                dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
            }
            ArrayList servletDTOs = new ArrayList();
            ArrayList filterDTOs = new ArrayList();
            ArrayList resourceDTOs = new ArrayList();
            iterator.forEachRemaining(element -> {
                if (element instanceof WhiteboardServlet && (((WhiteboardServlet)element).getErrorPageMappings() == null || ((WhiteboardServlet)element).getErrorPageMappings().isEmpty())) {
                    if (this.isContextModelMatchedByContextId(contextModel, ((WhiteboardServlet)element).getServletMapping().getHttpContextId())) {
                        this.mapServlet((WhiteboardServlet)element, servletDTOs, new ArrayList<FailedServletDTO>());
                    }
                } else if (element instanceof WhiteboardFilter) {
                    if (this.isContextModelMatchedByContextId(contextModel, ((WhiteboardFilter)element).getFilterMapping().getHttpContextId())) {
                        this.mapFilter((WhiteboardFilter)element, filterDTOs, new ArrayList<FailedFilterDTO>());
                    }
                } else if (element instanceof WhiteboardResource && this.isContextModelMatchedByContextId(contextModel, ((WhiteboardResource)element).getResourceMapping().getHttpContextId())) {
                    this.mapResource((WhiteboardResource)element, resourceDTOs, new ArrayList<FailedResourceDTO>());
                }
            });
            if (!servletDTOs.isEmpty()) {
                dto.servletDTO = (ServletDTO)servletDTOs.get(0);
            }
            if (!resourceDTOs.isEmpty()) {
                dto.resourceDTO = (ResourceDTO)resourceDTOs.get(0);
            }
            dto.filterDTOs = (FilterDTO[])filterDTOs.stream().toArray(FilterDTO[]::new);
        }
        return dto;
    }

    private boolean isContextModelMatchedByContextId(ContextModel model, String contextId) {
        String modelId = model.getHttpContext().getContextId();
        return Objects.equals(contextId, modelId) || contextId == null && Objects.equals(modelId, WebContainerContext.DefaultContextIds.DEFAULT.getValue());
    }

    private ServletContextDTO mapServletContext(Map.Entry<ServiceReference<ServletContext>, ServletContext> mapEntry) {
        ServiceReference<ServletContext> ref = mapEntry.getKey();
        ServletContext servletContext = mapEntry.getValue();
        ServletContextDTO dto = new ServletContextDTO();
        dto.serviceId = (Long)ref.getProperty("service.id");
        dto.contextPath = servletContext.getContextPath().trim().length() == 0 ? "/" : servletContext.getContextPath();
        dto.name = servletContext.getServletContextName();
        dto.attributes = Collections.list(servletContext.getAttributeNames()).stream().map(name -> new AbstractMap.SimpleEntry<String, Object>((String)name, servletContext.getAttribute(name))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        dto.initParams = Collections.list(servletContext.getInitParameterNames()).stream().map(name -> new AbstractMap.SimpleEntry<String, String>((String)name, servletContext.getInitParameter(name))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        return dto;
    }

    private void mapServlet(WhiteboardServlet whiteBoardServlet, List<ServletDTO> servletDTOs, List<FailedServletDTO> failedServletDTOs) {
        ServletDTO dto = new ServletDTO();
        ServletMapping servletMapping = whiteBoardServlet.getServletMapping();
        dto.serviceId = whiteBoardServlet.getServiceID();
        dto.name = servletMapping.getServletName();
        dto.initParams = servletMapping.getInitParams();
        dto.patterns = servletMapping.getUrlPatterns();
        dto.servletInfo = servletMapping.getServlet().getServletInfo();
        dto.asyncSupported = servletMapping.getAsyncSupported() != null ? servletMapping.getAsyncSupported() : false;
        Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> matchingServletContextEntry = this.findMatchingServletContext(servletMapping.getHttpContextId());
        if (matchingServletContextEntry.isPresent()) {
            dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
        }
        if (!whiteBoardServlet.isValid()) {
            failedServletDTOs.add(this.transformToFailedDTO(dto, FailedServletDTO.class, 6));
        } else if (!matchingServletContextEntry.isPresent()) {
            failedServletDTOs.add(this.transformToFailedDTO(dto, FailedServletDTO.class, 1));
        } else {
            servletDTOs.add(dto);
        }
    }

    private void mapErrorPage(WhiteboardServlet whiteboardErrorPage, List<ErrorPageDTO> errorPageDTOs, List<FailedErrorPageDTO> failedErrorPageDTOs) {
        ErrorPageDTO dto = new ErrorPageDTO();
        ServletMapping servletMapping = whiteboardErrorPage.getServletMapping();
        Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> matchingServletContextEntry = this.findMatchingServletContext(servletMapping.getHttpContextId());
        if (matchingServletContextEntry.isPresent()) {
            dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
        }
        dto.serviceId = whiteboardErrorPage.getServiceID();
        dto.name = servletMapping.getServletName();
        dto.initParams = servletMapping.getInitParams();
        dto.exceptions = (String[])whiteboardErrorPage.getErrorPageMappings().stream().map(ErrorPageMapping::getError).toArray(String[]::new);
        if (matchingServletContextEntry.isPresent()) {
            dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
        }
        if (!whiteboardErrorPage.isValid()) {
            failedErrorPageDTOs.add(this.transformToFailedDTO(dto, FailedErrorPageDTO.class, 6));
        } else if (!matchingServletContextEntry.isPresent()) {
            failedErrorPageDTOs.add(this.transformToFailedDTO(dto, FailedErrorPageDTO.class, 1));
        } else {
            errorPageDTOs.add(dto);
        }
    }

    private void mapFilter(WhiteboardFilter whiteboardFilter, List<FilterDTO> filterDTOs, List<FailedFilterDTO> failedFilterDTOs) {
        FilterDTO dto = new FilterDTO();
        dto.name = whiteboardFilter.getFilterMapping().getName();
        dto.asyncSupported = whiteboardFilter.getFilterMapping().getAsyncSupported();
        dto.initParams = whiteboardFilter.getFilterMapping().getInitParams();
        dto.patterns = whiteboardFilter.getFilterMapping().getUrlPatterns();
        dto.servletNames = whiteboardFilter.getFilterMapping().getServletNames();
        dto.serviceId = whiteboardFilter.getServiceID();
        dto.dispatcher = (String[])Arrays.stream(whiteboardFilter.getFilterMapping().getDispatcherType()).map(Enum::toString).toArray(String[]::new);
        Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> matchingServletContextEntry = this.findMatchingServletContext(whiteboardFilter.getFilterMapping().getHttpContextId());
        if (matchingServletContextEntry.isPresent()) {
            dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
        }
        if (!whiteboardFilter.isValid()) {
            failedFilterDTOs.add(this.transformToFailedDTO(dto, FailedFilterDTO.class, 6));
        } else if (!matchingServletContextEntry.isPresent()) {
            failedFilterDTOs.add(this.transformToFailedDTO(dto, FailedFilterDTO.class, 1));
        } else {
            filterDTOs.add(dto);
        }
    }

    private void mapListener(WhiteboardListener whiteboardLister, List<ListenerDTO> listenerDTOs, List<FailedListenerDTO> failedListenerDTOs) {
        ListenerDTO dto = new ListenerDTO();
        dto.serviceId = whiteboardLister.getServiceID();
        dto.types = (String[])Arrays.stream(whiteboardLister.getListenerMapping().getListener().getClass().getInterfaces()).filter(EventListener.class::isAssignableFrom).map(Class::getName).toArray(String[]::new);
        Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> matchingServletContextEntry = this.findMatchingServletContext(whiteboardLister.getListenerMapping().getHttpContextId());
        if (matchingServletContextEntry.isPresent()) {
            dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
        }
        if (!whiteboardLister.isValid()) {
            failedListenerDTOs.add(this.transformToFailedDTO(dto, FailedListenerDTO.class, 6));
        } else if (!matchingServletContextEntry.isPresent()) {
            failedListenerDTOs.add(this.transformToFailedDTO(dto, FailedListenerDTO.class, 1));
        } else {
            listenerDTOs.add(dto);
        }
    }

    private void mapResource(WhiteboardResource whiteboardResource, List<ResourceDTO> resourceDTOs, List<FailedResourceDTO> failedResourceDTOs) {
        ResourceDTO dto = new ResourceDTO();
        dto.serviceId = whiteboardResource.getServiceID();
        dto.prefix = whiteboardResource.getResourceMapping().getPath();
        dto.patterns = new String[]{whiteboardResource.getResourceMapping().getAlias()};
        Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> matchingServletContextEntry = this.findMatchingServletContext(whiteboardResource.getResourceMapping().getHttpContextId());
        if (matchingServletContextEntry.isPresent()) {
            dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
        }
        if (!whiteboardResource.isValid()) {
            failedResourceDTOs.add(this.transformToFailedDTO(dto, FailedResourceDTO.class, 6));
        } else if (!matchingServletContextEntry.isPresent()) {
            failedResourceDTOs.add(this.transformToFailedDTO(dto, FailedResourceDTO.class, 1));
        } else {
            resourceDTOs.add(dto);
        }
    }

    private ErrorPageDTO mapServlet(WhiteboardErrorPage whiteboardErrorPage) {
        ErrorPageDTO dto = new ErrorPageDTO();
        try {
            long code = Long.parseLong(whiteboardErrorPage.getErrorPageMapping().getError());
            dto.errorCodes = new long[]{code};
        }
        catch (NumberFormatException nfe) {
            dto.exceptions = new String[]{whiteboardErrorPage.getErrorPageMapping().getError()};
        }
        dto.serviceId = whiteboardErrorPage.getServiceID();
        Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> matchingServletContextEntry = this.findMatchingServletContext(whiteboardErrorPage.getErrorPageMapping().getHttpContextId());
        if (matchingServletContextEntry.isPresent()) {
            dto.servletContextId = (Long)matchingServletContextEntry.get().getKey().getProperty("service.id");
        }
        return dto;
    }

    private FailedErrorPageDTO transformToDTOFailed(WhiteboardErrorPage whiteboardErrorPage) {
        FailedErrorPageDTO dto = new FailedErrorPageDTO();
        dto.serviceId = whiteboardErrorPage.getServiceID();
        dto.failureReason = 6;
        return dto;
    }

    private FailedListenerDTO transformToDTOFailed(WhiteboardListener whiteboardListener) {
        FailedListenerDTO dto = new FailedListenerDTO();
        dto.serviceId = whiteboardListener.getServiceID();
        dto.failureReason = 6;
        return dto;
    }

    private FailedServletDTO transformToDTOFailed(WhiteboardJspMapping whiteboardJspMapping) {
        FailedServletDTO dto = new FailedServletDTO();
        dto.serviceId = whiteboardJspMapping.getServiceID();
        dto.failureReason = 6;
        return dto;
    }

    private Optional<Map.Entry<ServiceReference<ServletContext>, ServletContext>> findMatchingServletContext(String httpContextId) {
        String name = httpContextId == null || httpContextId.trim().length() == 0 ? WebContainerContext.DefaultContextIds.DEFAULT.getValue() : httpContextId;
        return this.servletContexts.entrySet().stream().filter(entry -> Objects.equals(((ServletContext)entry.getValue()).getServletContextName(), name)).findFirst();
    }

    private <T extends DTO, R extends DTO> R transformToFailedDTO(T dto, Class<R> type, int failureReason) {
        DTO result;
        if (dto instanceof ServletContextDTO) {
            ServletContextDTO servletContextDTO = (ServletContextDTO)dto;
            FailedServletContextDTO failedServletContextDTO = new FailedServletContextDTO();
            failedServletContextDTO.failureReason = failureReason;
            failedServletContextDTO.serviceId = servletContextDTO.serviceId;
            failedServletContextDTO.name = servletContextDTO.name;
            failedServletContextDTO.initParams = servletContextDTO.initParams;
            failedServletContextDTO.contextPath = servletContextDTO.contextPath;
            failedServletContextDTO.attributes = servletContextDTO.attributes;
            failedServletContextDTO.errorPageDTOs = servletContextDTO.errorPageDTOs;
            failedServletContextDTO.servletDTOs = servletContextDTO.servletDTOs;
            failedServletContextDTO.listenerDTOs = servletContextDTO.listenerDTOs;
            failedServletContextDTO.filterDTOs = servletContextDTO.filterDTOs;
            failedServletContextDTO.resourceDTOs = servletContextDTO.resourceDTOs;
            result = (DTO)type.cast(failedServletContextDTO);
        } else if (dto instanceof ServletDTO) {
            ServletDTO servletDTO = (ServletDTO)dto;
            FailedServletDTO failedServletDTO = new FailedServletDTO();
            failedServletDTO.failureReason = failureReason;
            failedServletDTO.serviceId = servletDTO.serviceId;
            failedServletDTO.servletContextId = servletDTO.servletContextId;
            failedServletDTO.asyncSupported = servletDTO.asyncSupported;
            failedServletDTO.patterns = servletDTO.patterns;
            failedServletDTO.name = servletDTO.name;
            failedServletDTO.initParams = servletDTO.initParams;
            failedServletDTO.servletInfo = servletDTO.servletInfo;
            result = (DTO)type.cast(failedServletDTO);
        } else if (dto instanceof ErrorPageDTO) {
            ErrorPageDTO errorPageDTO = (ErrorPageDTO)dto;
            FailedErrorPageDTO failedErrorPageDTO = new FailedErrorPageDTO();
            failedErrorPageDTO.failureReason = failureReason;
            failedErrorPageDTO.serviceId = errorPageDTO.serviceId;
            failedErrorPageDTO.servletContextId = errorPageDTO.servletContextId;
            failedErrorPageDTO.errorCodes = errorPageDTO.errorCodes;
            failedErrorPageDTO.exceptions = errorPageDTO.exceptions;
            failedErrorPageDTO.asyncSupported = errorPageDTO.asyncSupported;
            failedErrorPageDTO.name = errorPageDTO.name;
            failedErrorPageDTO.initParams = errorPageDTO.initParams;
            failedErrorPageDTO.servletInfo = errorPageDTO.servletInfo;
            result = (DTO)type.cast(failedErrorPageDTO);
        } else if (dto instanceof ListenerDTO) {
            ListenerDTO listenerDTO = (ListenerDTO)dto;
            FailedListenerDTO failedListenerDTO = new FailedListenerDTO();
            failedListenerDTO.failureReason = failureReason;
            failedListenerDTO.serviceId = listenerDTO.serviceId;
            failedListenerDTO.servletContextId = listenerDTO.servletContextId;
            failedListenerDTO.types = listenerDTO.types;
            result = (DTO)type.cast(failedListenerDTO);
        } else if (dto instanceof FilterDTO) {
            FilterDTO filterDTO = (FilterDTO)dto;
            FailedFilterDTO failedFilterDTO = new FailedFilterDTO();
            failedFilterDTO.failureReason = failureReason;
            failedFilterDTO.serviceId = filterDTO.serviceId;
            failedFilterDTO.servletContextId = filterDTO.servletContextId;
            failedFilterDTO.asyncSupported = filterDTO.asyncSupported;
            failedFilterDTO.patterns = filterDTO.patterns;
            failedFilterDTO.name = filterDTO.name;
            failedFilterDTO.dispatcher = filterDTO.dispatcher;
            failedFilterDTO.initParams = filterDTO.initParams;
            failedFilterDTO.servletNames = filterDTO.servletNames;
            failedFilterDTO.regexs = filterDTO.regexs;
            result = (DTO)type.cast(failedFilterDTO);
        } else if (dto instanceof ResourceDTO) {
            ResourceDTO resourceDTO = (ResourceDTO)dto;
            FailedResourceDTO failedResourceDTO = new FailedResourceDTO();
            failedResourceDTO.failureReason = failureReason;
            failedResourceDTO.serviceId = resourceDTO.serviceId;
            failedResourceDTO.servletContextId = resourceDTO.servletContextId;
            failedResourceDTO.patterns = resourceDTO.patterns;
            failedResourceDTO.prefix = resourceDTO.prefix;
            result = (DTO)type.cast(failedResourceDTO);
        } else {
            throw new IllegalArgumentException(dto.getClass().getName() + " not handled!");
        }
        return (R)result;
    }

    @Reference(unbind="removeServletContext", service=ServletContext.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addServletContext(ServiceReference<ServletContext> ref, ServletContext servletContext) {
        this.servletContexts.put(ref, servletContext);
    }

    protected void removeServletContext(ServiceReference<ServletContext> ref, ServletContext servletContext) {
        this.servletContexts.remove(ref);
    }
}

