/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseUserMetadataFromHeaders
implements Function<HttpResponse, UserMetadata> {
    private static final Set<String> SYS_KEYS = ImmutableSet.of((Object)"atime", (Object)"ctime", (Object)"gid", (Object)"itime", (Object)"mtime", (Object)"nlink", (Object[])new String[]{"policyname", "size", "uid", "content-md5", "objectid", "objname", "type"});

    public UserMetadata apply(HttpResponse from) {
        Preconditions.checkNotNull((Object)from, (Object)"http response");
        Map meta = Maps.filterKeys(ParseUserMetadataFromHeaders.getMetaMap((String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("x-emc-meta"), (Object)"x-emc-meta")), (Predicate)Predicates.not((Predicate)Predicates.in(SYS_KEYS)));
        ImmutableMap listableMeta = from.getFirstHeaderOrNull("x-emc-listable-meta") != null ? ParseUserMetadataFromHeaders.getMetaMap(from.getFirstHeaderOrNull("x-emc-listable-meta")) : ImmutableMap.of();
        ImmutableSet tags = from.getFirstHeaderOrNull("x-emc-tags") != null ? Splitter.on((String)", ").split((CharSequence)from.getFirstHeaderOrNull("x-emc-tags")) : ImmutableSet.of();
        ImmutableSet listableTags = from.getFirstHeaderOrNull("x-emc-listable-tags") != null ? Splitter.on((String)", ").split((CharSequence)from.getFirstHeaderOrNull("x-emc-listable-tags")) : ImmutableSet.of();
        return new UserMetadata(meta, (Map<String, String>)listableMeta, (Iterable<String>)tags, (Iterable<String>)listableTags);
    }

    private static Map<String, String> getMetaMap(String meta) {
        return Splitter.on((String)", ").withKeyValueSeparator('=').split((CharSequence)meta);
    }
}

