/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.objs;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.ManagedBundle;

@Beta
public enum BrooklynObjectType {
    ENTITY(Entity.class, EntitySpec.class, "entities"),
    LOCATION(Location.class, LocationSpec.class, "locations"),
    POLICY(Policy.class, PolicySpec.class, "policies"),
    ENRICHER(Enricher.class, EnricherSpec.class, "enrichers"),
    FEED(Feed.class, null, "feeds"),
    CATALOG_ITEM(CatalogItem.class, null, "catalog"),
    MANAGED_BUNDLE(ManagedBundle.class, null, "bundles"),
    UNKNOWN(null, null, "unknown");

    private final Class<? extends BrooklynObject> interfaceType;
    private final Class<? extends AbstractBrooklynObjectSpec<?, ?>> specType;
    private final String subPathName;

    private <T extends BrooklynObject, K extends AbstractBrooklynObjectSpec<T, K>> BrooklynObjectType(Class<T> interfaceType, Class<K> specType, String subPathName) {
        this.interfaceType = interfaceType;
        this.specType = specType;
        this.subPathName = subPathName;
    }

    public String toCamelCase() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    public String getSubPathName() {
        return this.subPathName;
    }

    public Class<? extends BrooklynObject> getInterfaceType() {
        return this.interfaceType;
    }

    public Class<? extends AbstractBrooklynObjectSpec<?, ?>> getSpecType() {
        return this.specType;
    }

    public static BrooklynObjectType of(BrooklynObject instance) {
        if (instance != null) {
            for (BrooklynObjectType t : BrooklynObjectType.values()) {
                if (t.getInterfaceType() == null || !t.getInterfaceType().isInstance(instance)) continue;
                return t;
            }
        }
        return UNKNOWN;
    }

    public static BrooklynObjectType of(Class<?> objectTypeOrSpecType) {
        if (objectTypeOrSpecType != null) {
            for (BrooklynObjectType t : BrooklynObjectType.values()) {
                if (t.getInterfaceType() != null && t.getInterfaceType().isAssignableFrom(objectTypeOrSpecType)) {
                    return t;
                }
                if (t.getSpecType() == null || !t.getSpecType().isAssignableFrom(objectTypeOrSpecType)) continue;
                return t;
            }
        }
        return UNKNOWN;
    }

    public static BrooklynObjectType of(CatalogItem.CatalogItemType t) {
        if (t == null) {
            return null;
        }
        switch (t) {
            case ENRICHER: {
                return ENRICHER;
            }
            case ENTITY: {
                return ENTITY;
            }
            case LOCATION: {
                return LOCATION;
            }
            case POLICY: {
                return POLICY;
            }
            case TEMPLATE: {
                return ENTITY;
            }
        }
        return UNKNOWN;
    }
}

