/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.time;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Time;

public class Duration
implements Comparable<Duration>,
Serializable {
    private static final long serialVersionUID = -2303909964519279617L;
    public static final Duration ZERO = Duration.of(0L, null);
    public static final Duration ONE_MILLISECOND = Duration.of(1L, TimeUnit.MILLISECONDS);
    public static final Duration ONE_SECOND = Duration.of(1L, TimeUnit.SECONDS);
    public static final Duration FIVE_SECONDS = Duration.of(5L, TimeUnit.SECONDS);
    public static final Duration TEN_SECONDS = Duration.of(10L, TimeUnit.SECONDS);
    public static final Duration THIRTY_SECONDS = Duration.of(30L, TimeUnit.SECONDS);
    public static final Duration ONE_MINUTE = Duration.of(1L, TimeUnit.MINUTES);
    public static final Duration TWO_MINUTES = Duration.of(2L, TimeUnit.MINUTES);
    public static final Duration FIVE_MINUTES = Duration.of(5L, TimeUnit.MINUTES);
    public static final Duration ONE_HOUR = Duration.of(1L, TimeUnit.HOURS);
    public static final Duration ONE_DAY = Duration.of(1L, TimeUnit.DAYS);
    public static final Duration PRACTICALLY_FOREVER = Duration.of(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    private final long nanos;
    private static Function<Number, String> millisToStringRounded = new Function<Number, String>(){

        @Nullable
        public String apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return Duration.millis(input).toStringRounded();
        }
    };
    private static Function<Number, String> secondsToStringRounded = new Function<Number, String>(){

        @Nullable
        public String apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return Duration.seconds(input).toStringRounded();
        }
    };

    public Duration(long value, TimeUnit unit) {
        if (value != 0L) {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"Cannot accept null timeunit (unless value is 0)");
        } else {
            unit = TimeUnit.MILLISECONDS;
        }
        this.nanos = TimeUnit.NANOSECONDS.convert(value, unit);
    }

    @Override
    public int compareTo(Duration o) {
        return Long.valueOf(this.toNanoseconds()).compareTo(o.toNanoseconds());
    }

    public String toString() {
        return Time.makeTimeStringExact(this);
    }

    public String toStringRounded() {
        return Time.makeTimeStringRounded(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Duration)) {
            return false;
        }
        return this.toMilliseconds() == ((Duration)o).toMilliseconds();
    }

    public int hashCode() {
        return Long.valueOf(this.toMilliseconds()).hashCode();
    }

    public long toUnit(TimeUnit unit) {
        return unit.convert(this.nanos, TimeUnit.NANOSECONDS);
    }

    public long toUnit(TimeUnit unit, RoundingMode rounding) {
        long result = unit.convert(this.nanos, TimeUnit.NANOSECONDS);
        long check = TimeUnit.NANOSECONDS.convert(result, unit);
        if (check == this.nanos || rounding == null || rounding == RoundingMode.UNNECESSARY) {
            return result;
        }
        return new BigDecimal(this.nanos).divide(new BigDecimal(unit.toNanos(1L)), rounding).longValue();
    }

    public long toUnitRoundingUp(TimeUnit unit) {
        return this.toUnit(unit, RoundingMode.UP);
    }

    public long toMilliseconds() {
        return this.toUnit(TimeUnit.MILLISECONDS);
    }

    public long toMillisecondsRoundingUp() {
        return this.toUnitRoundingUp(TimeUnit.MILLISECONDS);
    }

    public long toNanoseconds() {
        return this.nanos;
    }

    public long toSeconds() {
        return this.toUnit(TimeUnit.SECONDS);
    }

    public long nanos() {
        return this.nanos;
    }

    public static Duration parse(String textualDescription) {
        if (Strings.isBlank(textualDescription)) {
            return null;
        }
        if ("null".equalsIgnoreCase(textualDescription)) {
            return null;
        }
        if ("forever".equalsIgnoreCase(textualDescription)) {
            return PRACTICALLY_FOREVER;
        }
        if ("practicallyforever".equalsIgnoreCase(textualDescription)) {
            return PRACTICALLY_FOREVER;
        }
        if ("practically_forever".equalsIgnoreCase(textualDescription)) {
            return PRACTICALLY_FOREVER;
        }
        return new Duration((long)Time.parseElapsedTimeAsDouble(textualDescription), TimeUnit.MILLISECONDS);
    }

    public static Duration days(Number n) {
        return new Duration((long)(n.doubleValue() * (double)TimeUnit.DAYS.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    public static Duration hours(Number n) {
        return new Duration((long)(n.doubleValue() * (double)TimeUnit.HOURS.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    public static Duration minutes(Number n) {
        return new Duration((long)(n.doubleValue() * (double)TimeUnit.MINUTES.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    public static Duration seconds(Number n) {
        return new Duration((long)(n.doubleValue() * (double)TimeUnit.SECONDS.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    public static Duration millis(Number n) {
        return new Duration((long)(n.doubleValue() * (double)TimeUnit.MILLISECONDS.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    public static Duration micros(Number n) {
        return new Duration((long)(n.doubleValue() * (double)TimeUnit.MICROSECONDS.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    public static Duration nanos(Number n) {
        return new Duration(n.longValue(), TimeUnit.NANOSECONDS);
    }

    public static Function<Number, String> millisToStringRounded() {
        return millisToStringRounded;
    }

    public static Function<Number, String> secondsToStringRounded() {
        return secondsToStringRounded;
    }

    public static Duration of(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Duration) {
            return (Duration)o;
        }
        if (o instanceof String) {
            return Duration.parse((String)o);
        }
        if (o instanceof Number) {
            return Duration.millis((Number)o);
        }
        if (o instanceof Stopwatch) {
            return Duration.millis(((Stopwatch)o).elapsed(TimeUnit.MILLISECONDS));
        }
        try {
            Method millisMethod = o.getClass().getMethod("toMilliseconds", new Class[0]);
            return Duration.millis((Long)millisMethod.invoke(o, new Object[0]));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot convert " + o + " (type " + o.getClass() + ") to a duration");
        }
    }

    public static Duration of(long value, TimeUnit unit) {
        return new Duration(value, unit);
    }

    public static Duration max(Duration first, Duration second) {
        return ((Duration)Preconditions.checkNotNull((Object)first, (Object)"first")).nanos >= ((Duration)Preconditions.checkNotNull((Object)second, (Object)"second")).nanos ? first : second;
    }

    public static Duration min(Duration first, Duration second) {
        return ((Duration)Preconditions.checkNotNull((Object)first, (Object)"first")).nanos <= ((Duration)Preconditions.checkNotNull((Object)second, (Object)"second")).nanos ? first : second;
    }

    public static Duration untilUtc(long millisSinceEpoch) {
        return Duration.millis(millisSinceEpoch - System.currentTimeMillis());
    }

    public static Duration sinceUtc(long millisSinceEpoch) {
        return Duration.millis(System.currentTimeMillis() - millisSinceEpoch);
    }

    public Duration add(Duration other) {
        return Duration.nanos(this.nanos() + other.nanos());
    }

    public Duration subtract(Duration other) {
        return Duration.nanos(this.nanos() - other.nanos());
    }

    public Duration multiply(long x) {
        return Duration.nanos(this.nanos() * x);
    }

    @Deprecated
    public Duration times(long x) {
        return this.multiply(x);
    }

    public Duration multiply(double d) {
        return Duration.nanos((double)this.nanos() * d);
    }

    public Duration half() {
        return this.multiply(0.5);
    }

    public static void sleep(Duration duration) {
        Time.sleep(duration);
    }

    public CountdownTimer countdownTimer() {
        return CountdownTimer.newInstanceStarted(this);
    }

    public boolean isPositive() {
        return this.nanos() > 0L;
    }

    public boolean isNegative() {
        return this.nanos() < 0L;
    }

    public boolean isLongerThan(Duration x) {
        return this.compareTo(x) > 0;
    }

    public boolean isLongerThan(Stopwatch stopwatch) {
        return this.isLongerThan(Duration.millis(stopwatch.elapsed(TimeUnit.MILLISECONDS)));
    }

    public boolean isShorterThan(Duration x) {
        return this.compareTo(x) < 0;
    }

    public boolean isShorterThan(Stopwatch stopwatch) {
        return this.isShorterThan(Duration.millis(stopwatch.elapsed(TimeUnit.MILLISECONDS)));
    }

    public Duration lowerBound(Duration alternateMinimumValue) {
        if (this.isShorterThan(alternateMinimumValue)) {
            return alternateMinimumValue;
        }
        return this;
    }

    public Duration upperBound(Duration alternateMaximumValue) {
        if (this.isLongerThan(alternateMaximumValue)) {
            return alternateMaximumValue;
        }
        return this;
    }

    @Deprecated
    public Duration minimum(Duration alternateMinimumValue) {
        return this.lowerBound(alternateMinimumValue);
    }

    @Deprecated
    public Duration maximum(Duration alternateMaximumValue) {
        return this.upperBound(alternateMaximumValue);
    }
}

