/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.guava.Maybe;

@Beta
public class CollectionMerger {
    protected final int depth;
    protected final boolean mergeNestedMaps;
    protected final boolean mergeNestedLists;

    public static Builder builder() {
        return new Builder();
    }

    protected CollectionMerger(Builder builder) {
        this.depth = builder.depth;
        this.mergeNestedMaps = builder.mergeNestedMaps;
        this.mergeNestedLists = builder.mergeNestedLists;
    }

    public Map<?, ?> merge(Map<?, ?> map1, Map<?, ?> map2) {
        Preconditions.checkNotNull(map1, (Object)"map1");
        Preconditions.checkNotNull(map2, (Object)"map2");
        return (Map)this.mergeImpl(Maybe.of(map1), Maybe.of(map2), this.depth, new Visited());
    }

    protected Object mergeImpl(Maybe<?> val1, Maybe<?> val2, int depthRemaining, Visited visited) {
        if (visited.isVisited(val1.orNull())) {
            throw new IllegalStateException("Recursive self-reference, " + val1.get().getClass() + ": " + val1.get());
        }
        if (visited.isVisited(val2.orNull())) {
            throw new IllegalStateException("Recursive self-reference, " + val2.get().getClass() + ": " + val2.get());
        }
        visited.recordVisit(val1.orNull());
        visited.recordVisit(val2.orNull());
        if (depthRemaining < 0) {
            throw new IllegalStateException("Invalid depth " + depthRemaining);
        }
        if (val2.isAbsent() || val2.isNull()) {
            return val1.isPresent() ? val1.get() : null;
        }
        if (val1.isAbsent()) {
            return val2.isPresent() ? val2.get() : null;
        }
        if (val1.isNull()) {
            return val1.get();
        }
        if (val1.get() instanceof Map) {
            Map map1 = (Map)val1.get();
            if (val2.get() instanceof Map) {
                return this.mergeMapsImpl(map1, (Map)val2.get(), depthRemaining, visited);
            }
            return val1.get();
        }
        if (val1.get() instanceof Iterable) {
            if (!this.mergeNestedLists) {
                return val1.get();
            }
            Iterable iter1 = (Iterable)val1.get();
            if (val2.get() instanceof Iterable) {
                return this.mergeIterablesImpl(iter1, (Iterable)val2.get(), depthRemaining, visited);
            }
            return val1.get();
        }
        return val1.get();
    }

    private Map<?, ?> mergeMapsImpl(Map<?, ?> val1, Map<?, ?> val2, int depthRemaining, Visited visited) {
        if (depthRemaining < 1) {
            return val1;
        }
        MutableMap result = MutableMap.of();
        for (Object key : Sets.union(val1.keySet(), val2.keySet())) {
            Maybe sub1 = val1.containsKey(key) ? Maybe.of(val1.get(key)) : Maybe.absent();
            Maybe sub2 = val2.containsKey(key) ? Maybe.of(val2.get(key)) : Maybe.absent();
            result.put(key, this.mergeImpl(sub1, sub2, depthRemaining - 1, visited));
        }
        return result;
    }

    private Iterable<?> mergeIterablesImpl(Iterable<?> val1, Iterable<?> val2, int depthRemaining, Visited visited) {
        if (depthRemaining < 1) {
            return val1;
        }
        if (val1 instanceof Set) {
            return this.mergeSetsImpl((Set)val1, MutableSet.copyOf(val2), depthRemaining, visited);
        }
        return this.mergeListsImpl(MutableList.copyOf(val1), val2, depthRemaining, visited);
    }

    private Set<?> mergeSetsImpl(Set<?> val1, Set<?> val2, int depthRemaining, Visited visited) {
        return MutableSet.builder().addAll(val1).addAll(val2).build();
    }

    private List<?> mergeListsImpl(List<?> val1, Iterable<?> val2, int depthRemaining, Visited visited) {
        return MutableList.builder().addAll(val1).addAll(val2).build();
    }

    protected static class Visited {
        private static final Set<Class<?>> TRIVIAL_CLASSES = ImmutableSet.of(Integer.class, Long.class, Boolean.class, Byte.class, Double.class, Float.class, (Object[])new Class[]{Character.class, Short.class, String.class, BigInteger.class, BigDecimal.class, Date.class});
        protected final Set<Ref> visited = Sets.newLinkedHashSet();

        protected Visited() {
        }

        public boolean isVisited(Object o) {
            if (this.isTrivial(o)) {
                return false;
            }
            return this.visited.contains(new Ref(o));
        }

        public void recordVisit(Object o) {
            if (this.isTrivial(o)) {
                return;
            }
            this.visited.add(new Ref(o));
        }

        protected boolean isTrivial(Object o) {
            if (o == null) {
                return true;
            }
            if (o instanceof Map && ((Map)o).isEmpty()) {
                return true;
            }
            if (o instanceof Iterable && Iterables.isEmpty((Iterable)((Iterable)o))) {
                return true;
            }
            Class<?> clazz = o.getClass();
            return clazz.isEnum() || clazz.isPrimitive() || TRIVIAL_CLASSES.contains(clazz);
        }

        protected static class Ref {
            protected final Object obj;

            protected Ref(Object obj) {
                this.obj = Preconditions.checkNotNull((Object)obj, (Object)"ref");
            }

            public boolean equals(Object o) {
                if (!(o instanceof Ref)) {
                    return false;
                }
                return this.obj == ((Ref)o).obj;
            }

            public int hashCode() {
                return System.identityHashCode(this.obj);
            }

            public String toString() {
                return "Ref[" + this.obj + "]";
            }
        }
    }

    public static class Builder {
        protected int depth = Integer.MAX_VALUE;
        protected boolean mergeNestedMaps = true;
        protected boolean mergeNestedLists = false;

        public Builder deep(boolean val) {
            return this.depth(val ? Integer.MAX_VALUE : 1);
        }

        public Builder depth(int val) {
            Preconditions.checkArgument((val > 0 ? 1 : 0) != 0, (String)"val %s must be positive", (Object[])new Object[]{val});
            this.depth = val;
            return this;
        }

        public Builder mergeNestedMaps(boolean val) {
            this.mergeNestedMaps = val;
            return this;
        }

        public Builder mergeNestedLists(boolean val) {
            this.mergeNestedLists = val;
            return this;
        }

        public CollectionMerger build() {
            return new CollectionMerger(this);
        }
    }
}

