/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import java.util.Arrays;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.CommandLine;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrActionSupport
implements Action {
    @Option(name="-s", aliases={"--show-hidden"}, description="Show all Components including the System Components (hidden by default)", required=false, multiValued=false)
    boolean showHidden = false;
    public static final String SHOW_ALL_OPTION = "-s";
    public static final String SHOW_ALL_ALIAS = "--show-hidden";
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private ServiceComponentRuntime serviceComponentRuntime;
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        if (this.serviceComponentRuntime == null) {
            String msg = "ServiceComponentRuntime is unavailable";
            System.out.println(msg);
            this.logger.warn(msg);
        } else {
            this.doScrAction(this.serviceComponentRuntime);
        }
        return null;
    }

    protected abstract Object doScrAction(ServiceComponentRuntime var1) throws Exception;

    public static boolean showHiddenComponent(CommandLine commandLine) {
        List<String> arguments = Arrays.asList(commandLine.getArguments());
        return arguments.contains(SHOW_ALL_OPTION) || arguments.contains(SHOW_ALL_ALIAS);
    }

    public static boolean isHiddenComponent(ComponentConfigurationDTO config) {
        boolean answer = false;
        if (config.properties != null) {
            String value = (String)config.properties.get("hidden.component");
            answer = Boolean.parseBoolean(value);
        }
        return answer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ServiceComponentRuntime getServiceComponentRuntime() {
        return this.serviceComponentRuntime;
    }

    public void setServiceComponentRuntime(ServiceComponentRuntime serviceComponentRuntime) {
        this.serviceComponentRuntime = serviceComponentRuntime;
    }
}

