/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.spi.pdp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.camp.spi.pdp.Artifact;
import org.apache.brooklyn.camp.spi.pdp.Service;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DeploymentPlan {
    String name;
    String origin;
    String description;
    String sourceCode;
    List<Artifact> artifacts;
    List<Service> services;
    Map<String, Object> customAttributes;

    @Deprecated
    public static DeploymentPlan of(Map<String, Object> root) {
        return DeploymentPlan.of(root, null);
    }

    public static DeploymentPlan of(Map<String, Object> root, String optionalSourceCode) {
        MutableMap attrs = MutableMap.copyOf(root);
        DeploymentPlan result = new DeploymentPlan();
        result.name = (String)attrs.remove("name");
        result.description = (String)attrs.remove("description");
        result.origin = (String)attrs.remove("origin");
        result.sourceCode = optionalSourceCode;
        result.services = new ArrayList<Service>();
        Object services = attrs.remove("services");
        if (services instanceof Iterable) {
            for (Object service : (Iterable)services) {
                if (service instanceof Map) {
                    result.services.add(Service.of((Map)service));
                    continue;
                }
                throw new UserFacingException("Services list should have a map for each entry, not " + JavaClassNames.superSimpleClassName(service));
            }
        } else if (services != null) {
            throw new UserFacingException("Services block should be a list, not " + JavaClassNames.superSimpleClassName(services));
        }
        result.artifacts = new ArrayList<Artifact>();
        Object artifacts = attrs.remove("artifacts");
        if (artifacts instanceof Iterable) {
            for (Object artifact : (Iterable)artifacts) {
                if (artifact instanceof Map) {
                    result.artifacts.add(Artifact.of((Map)artifact));
                    continue;
                }
                throw new UserFacingException("Artifacts list should contain map items, not " + JavaClassNames.superSimpleClassName(artifact));
            }
        } else if (artifacts != null) {
            throw new UserFacingException("Artifacts block should contain a list, not " + JavaClassNames.superSimpleClassName(artifacts));
        }
        result.customAttributes = attrs;
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public List<Artifact> getArtifacts() {
        return MutableList.copyOf(this.artifacts).asUnmodifiable();
    }

    public List<Service> getServices() {
        return MutableList.copyOf(this.services).asUnmodifiable();
    }

    public Map<String, Object> getCustomAttributes() {
        return MutableMap.copyOf(this.customAttributes).asUnmodifiable();
    }

    public <T> Maybe<T> getCustomAttribute(String attributeName, Class<T> type, boolean throwIfTypeMismatch) {
        Object attribute = this.customAttributes.get(attributeName);
        if (attribute == null) {
            return Maybe.absent((String)("Custom attributes does not contain " + attributeName));
        }
        if (!type.isAssignableFrom(attribute.getClass())) {
            String message = "Custom attribute " + attributeName + " is not of expected type: expected=" + type.getName() + " actual=" + attribute.getClass().getName();
            if (throwIfTypeMismatch) {
                throw new IllegalArgumentException(message);
            }
            return Maybe.absent((String)message);
        }
        return Maybe.of((Object)attribute);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

