/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class ClassUtils {
    private static final String PACKAGEADMIN_CLASS = "org.osgi.service.packageadmin.PackageAdmin";
    private static final Class<?> OBJECT_CLASS = Object.class;
    public static final Class<?> SERVICE_REFERENCE_CLASS = ServiceReference.class;
    public static final Class<?> COMPONENTS_SERVICE_OBJECTS_CLASS = ComponentServiceObjects.class;
    public static final Class<?> MAP_CLASS = Map.class;
    public static final Class<?> MAP_ENTRY_CLASS = Map.Entry.class;
    public static final Class<?> COLLECTION_CLASS = Collection.class;
    public static final Class<?> LIST_CLASS = List.class;
    private static BundleContext m_context;
    public static volatile ServiceTracker<?, ?> m_packageAdmin;

    public static Class<?> getClassFromComponentClassLoader(Class<?> componentClass, String className, SimpleLogger logger) {
        if (logger.isLogEnabled(4)) {
            logger.log(4, "getReferenceClass: Looking for interface class {0} through loader of {1}", new Object[]{className, componentClass.getName()}, null);
        }
        try {
            ClassLoader loader = componentClass.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> referenceClass = loader.loadClass(className);
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: Found class {0}", new Object[]{referenceClass.getName()}, null);
            }
            return referenceClass;
        }
        catch (ClassNotFoundException loader) {
            PackageAdmin pa;
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: Not found through component class, using PackageAdmin service", null);
            }
            if ((pa = (PackageAdmin)ClassUtils.getPackageAdmin()) != null) {
                String referenceClassPackage = className.substring(0, className.lastIndexOf(46));
                ExportedPackage[] pkg = pa.getExportedPackages(referenceClassPackage);
                if (pkg != null) {
                    for (int i = 0; i < pkg.length; ++i) {
                        try {
                            if (logger.isLogEnabled(4)) {
                                logger.log(4, "getParameterClass: Checking Bundle {0}/{1}", new Object[]{pkg[i].getExportingBundle().getSymbolicName(), pkg[i].getExportingBundle().getBundleId()}, null);
                            }
                            Class referenceClass = pkg[i].getExportingBundle().loadClass(className);
                            if (logger.isLogEnabled(4)) {
                                logger.log(4, "getParameterClass: Found class {0}", new Object[]{referenceClass.getName()}, null);
                            }
                            return referenceClass;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            continue;
                        }
                    }
                } else if (logger.isLogEnabled(4)) {
                    logger.log(4, "getParameterClass: No bundles exporting package {0} found", new Object[]{referenceClassPackage}, null);
                }
            } else if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: PackageAdmin service not available, cannot find class", null);
            }
            if (logger.isLogEnabled(4)) {
                logger.log(4, "getParameterClass: No class found, falling back to class Object", null);
            }
            return OBJECT_CLASS;
        }
    }

    public static void setBundleContext(BundleContext bundleContext) {
        m_context = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getPackageAdmin() {
        if (m_packageAdmin != null) return m_packageAdmin.getService();
        Class<ClassUtils> clazz = ClassUtils.class;
        synchronized (ClassUtils.class) {
            if (m_packageAdmin != null) return m_packageAdmin.getService();
            m_packageAdmin = new ServiceTracker(m_context, PACKAGEADMIN_CLASS, null);
            m_packageAdmin.open();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_packageAdmin.getService();
        }
    }

    public static void close() {
        if (m_packageAdmin != null) {
            m_packageAdmin.close();
            m_packageAdmin = null;
        }
        m_context = null;
    }
}

