/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.azurecompute.domain.NetworkConfiguration;
import org.jclouds.azurecompute.xml.VirtualNetworkSiteHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class VirtualNetworkConfigurationHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<NetworkConfiguration.VirtualNetworkConfiguration> {
    private String dns;
    private List<NetworkConfiguration.VirtualNetworkSite> virtualNetworkSites = Lists.newArrayList();
    private boolean inVirtualNetworkSite;
    private final VirtualNetworkSiteHandler virtualNetworkSiteHandler = new VirtualNetworkSiteHandler();
    private final StringBuilder currentText = new StringBuilder();

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("VirtualNetworkSite")) {
            this.inVirtualNetworkSite = true;
        }
        if (this.inVirtualNetworkSite) {
            this.virtualNetworkSiteHandler.startElement(url, name, qName, attributes);
        }
    }

    public NetworkConfiguration.VirtualNetworkConfiguration getResult() {
        return NetworkConfiguration.VirtualNetworkConfiguration.create(this.dns, this.virtualNetworkSites);
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Dns")) {
            this.dns = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("VirtualNetworkSites")) {
            this.inVirtualNetworkSite = false;
        } else if (qName.equals("VirtualNetworkSite")) {
            this.virtualNetworkSites.add(this.virtualNetworkSiteHandler.getResult());
        } else if (this.inVirtualNetworkSite) {
            this.virtualNetworkSiteHandler.endElement(ignoredUri, ignoredName, qName);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inVirtualNetworkSite) {
            this.virtualNetworkSiteHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

