/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class VirtualIPHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Deployment.VirtualIP> {
    private String address;
    private Boolean isDnsProgrammed;
    private String name;
    private StringBuilder currentText = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
    }

    public Deployment.VirtualIP getResult() {
        Deployment.VirtualIP result = Deployment.VirtualIP.create(this.address, this.isDnsProgrammed, this.name);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.address = null;
        this.name = null;
        this.isDnsProgrammed = null;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Address")) {
            this.address = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("IsDnsProgrammed")) {
            String dnsProgrammed = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (dnsProgrammed != null) {
                this.isDnsProgrammed = Boolean.valueOf(dnsProgrammed);
            }
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

