/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

final class RoleSizeHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<RoleSize> {
    private RoleSize.Type name;
    private String label;
    private Integer cores;
    private Integer memoryInMb;
    private Boolean supportedByWebWorkerRoles;
    private Boolean supportedByVirtualMachines;
    private Integer maxDataDiskCount;
    private Integer webWorkerResourceDiskSizeInMb;
    private Integer virtualMachineResourceDiskSizeInMb;
    private final StringBuilder currentText = new StringBuilder();

    RoleSizeHandler() {
    }

    public RoleSize getResult() {
        return RoleSize.create(this.name, this.label, this.cores, this.memoryInMb, this.supportedByWebWorkerRoles, this.supportedByVirtualMachines, this.maxDataDiskCount, this.webWorkerResourceDiskSizeInMb, this.virtualMachineResourceDiskSizeInMb);
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        String virtualMachineResourceDiskSizeInMbString;
        if (qName.equals("Name")) {
            String type = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.name = RoleSize.Type.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText).toUpperCase());
        } else if (qName.equals("Label")) {
            this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Cores")) {
            String coresString = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (coresString != null) {
                this.cores = Integer.parseInt(coresString);
            }
        } else if (qName.equals("MemoryInMb")) {
            String memoryInMbString = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (memoryInMbString != null) {
                this.memoryInMb = Integer.parseInt(memoryInMbString);
            }
        } else if (qName.equals("SupportedByWebWorkerRoles")) {
            String supportedByWebWorkerRolesString = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (supportedByWebWorkerRolesString != null) {
                this.supportedByWebWorkerRoles = Boolean.valueOf(supportedByWebWorkerRolesString);
            }
        } else if (qName.equals("SupportedByVirtualMachines")) {
            String supportedByVirtualMachinesString = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (supportedByVirtualMachinesString != null) {
                this.supportedByVirtualMachines = Boolean.valueOf(supportedByVirtualMachinesString);
            }
        } else if (qName.equals("MaxDataDiskCount")) {
            String maxDataDiskCountString = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (maxDataDiskCountString != null) {
                this.maxDataDiskCount = Integer.parseInt(maxDataDiskCountString);
            }
        } else if (qName.equals("WebWorkerResourceDiskSizeInMb")) {
            String webWorkerResourceDiskSizeInMbString = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (webWorkerResourceDiskSizeInMbString != null) {
                this.webWorkerResourceDiskSizeInMb = Integer.parseInt(webWorkerResourceDiskSizeInMbString);
            }
        } else if (qName.equals("VirtualMachineResourceDiskSizeInMb") && (virtualMachineResourceDiskSizeInMbString = SaxUtils.currentOrNull((StringBuilder)this.currentText)) != null) {
            this.virtualMachineResourceDiskSizeInMb = Integer.parseInt(virtualMachineResourceDiskSizeInMbString);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

